/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.order;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.BatXBillHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.common.utils.PartitionUtils;
import kd.scmc.pm.business.custom.ext.bizextplugin.XSPurOrderSynOrderStatusImpl;
import kd.scmc.pm.business.helper.BatXPurOrderBillOpHelper;
import kd.scmc.pm.business.helper.PurOrderBillHelper;
import kd.scmc.pm.utils.CommonUtils;
import kd.scmc.pm.validation.order.BatXPurOrderBillSrcBillValidator;
import kd.scmc.pm.validation.order.BatXPurOrderBillValidValidator;
import kd.sdk.scmc.pm.extpoint.IPurBatChangeCasePlugin;
import kd.sdk.scmc.pm.extpoint.IXPurOrderCasePlugin;

public class BatXPurOrderBillValidOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(BatXPurOrderBillValidOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("changedate");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("h_operatorgroup");
        e.getFieldKeys().add("CONFIRMSTATUS");
        e.getFieldKeys().add("afterqty");
        e.getFieldKeys().add("afterbaseqty");
        e.getFieldKeys().add("afterdeliverdate");
        e.getFieldKeys().add("xsbillid");
        e.getFieldKeys().add("xsbillentryid");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("unit");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("changestatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BatXPurOrderBillValidValidator());
        e.addValidator((AbstractValidator)new BatXPurOrderBillSrcBillValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        block30: {
            try {
                Set selectRows = BatXBillHelper.getSelectRows((OperateOption)this.getOption());
                DynamicObject[] bills = e.getDataEntities();
                if (bills == null || bills.length == 0) {
                    return;
                }
                DynamicObject changeModel = ChangeModelHelper.getChangeModel4BatchXBill((String)this.billEntityType.getName());
                if (changeModel != null) {
                    String props = BatXBillHelper.getSrcFieldsByChangeModel((DynamicObject)changeModel);
                    props = String.join((CharSequence)",", props, BatXPurOrderBillOpHelper.getSrcBillProps());
                    props = String.join((CharSequence)",", props, "purbillentry_pay.pretimepoint,purbillentry_pay.payamount,purbillentry_pay.isprepay");
                    try {
                        PluginProxy pluginProxy = PluginProxy.create(null, IPurBatChangeCasePlugin.class, (String)"SCMC_PM_PURORDERBCBILL_ACTIVE_MODIFYSRCBILL", null);
                        List results = pluginProxy.callReplace(p -> p.addSrcBillProps());
                        if (results != null && results.size() > 0) {
                            props = String.join((CharSequence)",", props, String.join((CharSequence)",", (Iterable)results.get(0)));
                        }
                    }
                    catch (Exception e1) {
                        String msg = ResManager.loadKDString((String)"\u5ba2\u6237\u5316\u573a\u666f[%1$s]\u63d2\u4ef6\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5ba2\u6237\u5316\u63d2\u4ef6\u3002", (String)"BatXPurOrderBillValidOp_3", (String)"scmc-pm-opplugin", (Object[])new Object[0]);
                        msg = String.format(msg, "SCMC_PM_PURORDERBCBILL_ACTIVE_MODIFYSRCBILL");
                        String msgTotal = msg + e;
                        log.info(msgTotal);
                        throw new KDBizException(msgTotal);
                    }
                    HashSet<Long> srcBillIds = new HashSet<Long>(8);
                    HashMap<Long, DynamicObject> changeEntryMap = new HashMap<Long, DynamicObject>(8);
                    Iterator it = e.getValidExtDataEntities().iterator();
                    while (it.hasNext()) {
                        ExtendedDataEntity entity = (ExtendedDataEntity)it.next();
                        DynamicObject bill = entity.getDataEntity();
                        srcBillIds.clear();
                        changeEntryMap.clear();
                        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
                        if (entrys == null) continue;
                        for (DynamicObject entry : entrys) {
                            long srcBillEntryId;
                            if (selectRows != null && selectRows.size() != 0 && !selectRows.contains((Long)entry.getPkValue())) continue;
                            long srcBillId = entry.getLong("xsbillid");
                            if (srcBillId != 0L) {
                                srcBillIds.add(srcBillId);
                            }
                            if ((srcBillEntryId = entry.getLong("xsbillentryid")) == 0L) continue;
                            changeEntryMap.put(srcBillEntryId, entry);
                        }
                        List sidPartitions = PartitionUtils.partition(new ArrayList(srcBillIds), (int)100);
                        if (!srcBillIds.isEmpty()) {
                            this.getOption().setVariableValue("purorderbillid", SerializationUtils.toJsonString(new HashSet(srcBillIds)));
                        }
                        ArrayList<String> errMsgs = new ArrayList<String>();
                        for (List sids : sidPartitions) {
                            Object srcBill2;
                            DynamicObject[] sbills = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)props, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)sids)});
                            List srcBills = Arrays.asList(sbills);
                            PurOrderBillHelper.getPrePayAmountSum((DynamicObject[])sbills, (OperateOption)this.getOption());
                            ArrayList<DynamicObject> cloneBills = new ArrayList<DynamicObject>(srcBills.size());
                            for (Object srcBill2 : srcBills) {
                                DynamicObject newData = (DynamicObject)new CloneUtils(false, false).clone((IDataEntityBase)srcBill2);
                                cloneBills.add(newData);
                            }
                            List errMsg = BatXPurOrderBillOpHelper.modifySrcData(changeEntryMap, srcBills);
                            if (errMsg != null && errMsg.size() > 0) {
                                errMsgs.addAll(errMsg);
                                continue;
                            }
                            srcBill2 = srcBills.iterator();
                            while (srcBill2.hasNext()) {
                                DynamicObject srcBill3 = (DynamicObject)srcBill2.next();
                                XSPurOrderSynOrderStatusImpl impl = new XSPurOrderSynOrderStatusImpl();
                                PluginProxy pluginProxy = PluginProxy.create((Object)impl, IXPurOrderCasePlugin.class, (String)"SCMC_PM_XSPURORDERBILL_ACTIVE_SYNCSTATUS", null);
                                pluginProxy.callReplaceIfPresent(p -> p.activeSynOrderBillStatus(srcBill3));
                            }
                            try {
                                PluginProxy pluginProxy = PluginProxy.create(null, IPurBatChangeCasePlugin.class, (String)"SCMC_PM_PURORDERBCBILL_ACTIVE_MODIFYSRCBILL", null);
                                List finalSrcBills = srcBills;
                                Set selectEntryIds = changeEntryMap.keySet();
                                List results = pluginProxy.callReplace(p -> p.modifySrcBills(finalSrcBills, selectEntryIds));
                                if (results != null && results.size() > 0) {
                                    srcBills = (List)results.get(results.size() - 1);
                                }
                            }
                            catch (Exception e1) {
                                String msg = ResManager.loadKDString((String)"\u5ba2\u6237\u5316\u573a\u666f[%1$s]\u63d2\u4ef6\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5ba2\u6237\u5316\u63d2\u4ef6\u3002", (String)"BatXPurOrderBillValidOp_3", (String)"scmc-pm-opplugin", (Object[])new Object[0]);
                                msg = String.format(msg, "SCMC_PM_PURORDERBCBILL_ACTIVE_MODIFYSRCBILL");
                                String msgTotal = msg + e1.getMessage();
                                log.info(msgTotal);
                                throw new KDBizException(msgTotal);
                            }
                            TXHandle tx = TX.requiresNew();
                            Throwable throwable = null;
                            try {
                                try {
                                    BatXBillHelper.recChangeLog(cloneBills, (List)srcBills, (DynamicObject)bill);
                                    SaveServiceHelper.save((DynamicObject[])srcBills.toArray(new DynamicObject[0]));
                                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
                                }
                                catch (Exception e1) {
                                    tx.markRollback();
                                    throw e1;
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (tx == null) continue;
                                if (throwable != null) {
                                    try {
                                        tx.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                tx.close();
                            }
                        }
                        if (errMsgs.size() <= 0) continue;
                        this.addErrMessage(entity, errMsgs);
                        it.remove();
                    }
                    break block30;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u53d8\u66f4\u65b9\u6848\u3002", (String)"BatXPurOrderBillValidOp_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]));
            }
            catch (Exception e1) {
                log.error((Throwable)e1);
                throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6548\u5931\u8d25\u3002", (String)"BatXPurOrderBillValidOp_4", (String)"scmc-pm-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void addErrMessage(ExtendedDataEntity dataEntity, List<String> errMsgs) {
        Object pkId = dataEntity.getDataEntity().getPkValue();
        int dataIndex = dataEntity.getDataEntityIndex();
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        for (String errMsg : errMsgs) {
            ValidationErrorInfo errInfo = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "beforeExecuteOperationTransaction", ResManager.loadKDString((String)"\u751f\u6548", (String)"BatXPurOrderBillValidOp_5", (String)"scmc-pm-opplugin", (Object[])new Object[0]), errMsg, errorLevel);
            this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (CommonUtils.isNull((Object)e.getDataEntities())) {
            return;
        }
        String srcbillidStr = this.getOption().getVariableValue("purorderbillid", null);
        if (StringUtils.isBlank((CharSequence)srcbillidStr)) {
            return;
        }
        HashSet srcBillIds = (HashSet)SerializationUtils.fromJsonString((String)srcbillidStr, HashSet.class);
        PurOrderBillHelper.compareAndExcuteEvent((HashSet)srcBillIds, (String)"pm_purorderbill", (OperateOption)this.getOption());
    }
}

