/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.order;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.opplugin.AmountPlanValidator;
import kd.scmc.pm.business.helper.PurOrderBillHelper;
import kd.scmc.pm.validation.order.CanPurControlValidator;
import kd.scmc.pm.validation.order.NeedRequestValidator;
import kd.scmc.pm.validation.order.PurOrderBillDeliverValidator;
import kd.scmc.pm.validation.order.PurOrderBillExpenseItemValidator;
import kd.scmc.pm.validation.order.PurOrderBillMftSupplierValidator;
import kd.scmc.pm.validation.order.PurOrderBillSettleOrgValidator;
import kd.scmc.pm.validation.order.PurOrderSupplierPurChaseHoldValidator;

public class PurOrderBillSubmitOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(PurOrderBillSubmitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("biztime");
        keys.add("operator");
        keys.add("operatorgroup");
        keys.add("dept");
        keys.add("billno");
        keys.add("supplier");
        keys.add("paycondition");
        keys.add("totalallamount");
        keys.add("purbillentry_pay");
        keys.add("payrate");
        keys.add("payamount");
        keys.add("payentrychangetype");
        keys.add("isprepay");
        keys.add("billentry");
        keys.add("qty");
        keys.add("material");
        keys.add("deliverdate");
        keys.add("expenseitem");
        keys.add("srcbillid");
        keys.add("salbillid");
        keys.add("entrychangetype");
        keys.add("expenseitem");
        keys.add("iscontrolamountup");
        keys.add("amountup");
        keys.add("entryreqdept");
        keys.add("ecostcenter");
        keys.add("ispresent");
        keys.add("entrysettleorg");
        keys.add("purbillentry_deliver");
        keys.add("planqty");
        keys.add("plandeliverdate");
        keys.add("delentrychangetype");
        keys.add("totalamount");
        keys.add("totaltaxamount");
        keys.add("amount");
        keys.add("taxamount");
        keys.add("amountandtax");
        keys.add("amountup");
        keys.add("ispayrate");
        keys.add("settlecurrency");
        keys.add("isvirtualbill");
        keys.add("mftdirect");
        keys.add("mftsupplier");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PurOrderBillDeliverValidator());
        e.addValidator((AbstractValidator)new NeedRequestValidator());
        e.addValidator((AbstractValidator)new PurOrderBillExpenseItemValidator());
        e.addValidator((AbstractValidator)new PurOrderSupplierPurChaseHoldValidator());
        e.addValidator((AbstractValidator)new CanPurControlValidator());
        AmountPlanValidator amountPlanValidator = new AmountPlanValidator();
        amountPlanValidator.setValidation(new HashMap(PurOrderBillHelper.getPlanCommonFieldMapping()));
        e.addValidator((AbstractValidator)amountPlanValidator);
        e.addValidator((AbstractValidator)new PurOrderBillSettleOrgValidator());
        e.addValidator((AbstractValidator)new PurOrderBillMftSupplierValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length < 1) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection billEntrys = dataEntity.getDynamicObjectCollection("billentry");
            if (billEntrys == null || billEntrys.isEmpty()) continue;
            for (DynamicObject entry : billEntrys) {
                BigDecimal amountAndTax = entry.getBigDecimal("amountandtax");
                BigDecimal amountUp = entry.getBigDecimal("amountup");
                boolean isControlAmountUp = entry.getBoolean("iscontrolamountup");
                if (amountAndTax == null || amountUp == null || isControlAmountUp || amountUp.compareTo(amountAndTax) == 0) continue;
                entry.set("amountup", (Object)amountAndTax);
            }
        }
    }
}

