/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.order;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.business.helper.AmountPlanHelper;
import kd.mpscmm.msbd.common.context.CommonContext;
import kd.scmc.pm.business.helper.PurOrderBillHelper;
import kd.scmc.pm.enums.ChangeTypeEnum;

public class PurOrderBillVerifyHeadAmountOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(PurOrderBillVerifyHeadAmountOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("entrychangetype");
        keys.add("amount");
        keys.add("taxamount");
        keys.add("amountandtax");
        keys.add("totalamount");
        keys.add("totaltaxamount");
        keys.add("totalallamount");
        keys.add("billentry");
        keys.add("settlecurrency");
        keys.add("payrate");
        keys.add("payamount");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        for (DynamicObject bill : dataEntities) {
            Map<String, BigDecimal> entrySumCount;
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
            if (entry == null || entry.isEmpty() || (entrySumCount = PurOrderBillVerifyHeadAmountOp.getEntrySumCount(bill, "amount", "taxamount", "amountandtax")).isEmpty()) continue;
            Boolean updatePayPlan = Boolean.FALSE;
            if (entrySumCount.get("amountandtax").compareTo(bill.getBigDecimal("totalallamount")) != 0) {
                updatePayPlan = Boolean.TRUE;
            }
            this.setHeadIfNoEqual("totalamount", "amount", bill, entrySumCount);
            this.setHeadIfNoEqual("totaltaxamount", "taxamount", bill, entrySumCount);
            this.setHeadIfNoEqual("totalallamount", "amountandtax", bill, entrySumCount);
            if (!updatePayPlan.booleanValue()) continue;
            AmountPlanHelper.calAmountPlanForDynamicObject((CommonContext)PurOrderBillHelper.getPayPlanCommonText((String)"pm_purorderbill"), (DynamicObject)bill);
        }
    }

    public static Map<String, BigDecimal> getEntrySumCount(DynamicObject bill, String ... entryKey) {
        ConcurrentHashMap<String, BigDecimal> sumMap = new ConcurrentHashMap<String, BigDecimal>(8);
        if (bill == null || entryKey == null || entryKey.length == 0) {
            return sumMap;
        }
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        if (entry == null || entry.isEmpty()) {
            return sumMap;
        }
        for (String key : entryKey) {
            sumMap.put(key, BigDecimal.ZERO);
        }
        for (DynamicObject row : entry) {
            if (ChangeTypeEnum.CANCEL.getValue().equals(row.getString("entrychangetype"))) continue;
            for (Map.Entry e : sumMap.entrySet()) {
                sumMap.put((String)e.getKey(), ((BigDecimal)e.getValue()).add(row.getBigDecimal((String)e.getKey())));
            }
        }
        return sumMap;
    }

    private void setHeadIfNoEqual(String headKey, String entryKey, DynamicObject bill, Map<String, BigDecimal> entrySum) {
        if (entrySum.get(entryKey).compareTo(bill.getBigDecimal(headKey)) == 0) {
            return;
        }
        bill.set(headKey, (Object)entrySum.get(entryKey));
    }
}

