/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.order;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.pm.business.custom.ext.bizextplugin.XSPurOrderSynOrderStatusImpl;
import kd.scmc.pm.business.helper.PurOrderBillHelper;
import kd.scmc.pm.enums.ActiveStatusEnum;
import kd.scmc.pm.enums.BizCancelStatusEnum;
import kd.scmc.pm.enums.ChangeStatusEnum;
import kd.scmc.pm.enums.ChangeTypeEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.utils.CommonUtils;
import kd.scmc.pm.validation.order.XPurorderBillActiveValidator;
import kd.sdk.scmc.pm.extpoint.IXPurOrderCasePlugin;

public class XPurOrderBillActiveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("billno");
        keys.add("org");
        keys.add("cancelstatus");
        keys.add("activestatus");
        keys.add("billstatus");
        keys.add("linkmanphone");
        keys.add("sourceid");
        keys.add("totalallamount");
        keys.add("paidallamount");
        keys.add("billentry");
        keys.add("qty");
        keys.add("auxqty");
        keys.add("receivebaseqtyup");
        keys.add("entrychangetype");
        keys.add("purbillentry_pay");
        keys.add("payamount");
        keys.add("payentrychangetype");
        keys.add("sourcepayentryid");
        keys.add("isprepay");
        keys.add("payrate");
        keys.add("sourceno");
        keys.add("sourceentryid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new XPurorderBillActiveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        if ("active".equals(e.getOperationKey()) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            DynamicObject[] bills = e.getDataEntities();
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject bill = bills[i];
                if (ActiveStatusEnum.UNACTIVE.getValue().equals(bill.get("activestatus")) && BizCancelStatusEnum.UNCANCEL.getValue().equals(bill.get("cancelstatus")) && StatusEnum.AUDIT.getValue().equals(bill.get("billstatus"))) continue;
                e.cancel = true;
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u53d8\u66f4\u5355\u201c%1$s\u201d\u4e0d\u662f\u6709\u6548\u5355\u636e\uff0c\u4e0d\u80fd\u751f\u6548\u3002", (String)"XPurOrderBillActiveOp_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), bill.get("billno")));
                return;
            }
            PluginProxy pluginProxy = PluginProxy.create(null, IXPurOrderCasePlugin.class, (String)"SCMC_PM_XSPURORDERBILL_ACTIVE_SYNCBILL", null);
            ArrayList<Long> billIDS = new ArrayList<Long>(bills.length);
            for (DynamicObject bill : bills) {
                billIDS.add((Long)bill.getPkValue());
            }
            pluginProxy.callReplace(p -> p.activeSynBillInfo(billIDS, this.billEntityType.getName()));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        if ("active".equals(e.getOperationKey()) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            DynamicObject[] bills = e.getDataEntities();
            HashSet<Long> srcBillIds = new HashSet<Long>(10);
            for (int i = 0; i < bills.length; ++i) {
                QFilter qFilter2;
                boolean isAddNewEntry = false;
                DynamicObject bill = bills[i];
                bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)bill.getDynamicObjectType().getName());
                String srcBillNo = bill.getString("sourceno");
                Long orgId = (Long)bill.getDynamicObject("org").getPkValue();
                QFilter qFilter1 = new QFilter("org", "=", (Object)orgId);
                DynamicObject srcBillPre = BusinessDataServiceHelper.loadSingle((String)"pm_purorderbill", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2 = new QFilter("billno", "=", (Object)srcBillNo)});
                if (srcBillPre == null) continue;
                DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)srcBillPre.getPkValue(), (String)"pm_purorderbill");
                srcBillIds.add((Long)srcBill.getPkValue());
                srcBill.set("comment", bill.get("comment"));
                srcBill.set("operatorgroup", bill.get("operatorgroup"));
                srcBill.set("operator", bill.get("operator"));
                srcBill.set("dept", bill.get("dept"));
                srcBill.set("linkman", bill.get("linkman"));
                srcBill.set("provideraddress", bill.get("provideraddress"));
                srcBill.set("providerlinkman", bill.get("providerlinkman"));
                srcBill.set("totalallamount", bill.get("totalallamount"));
                srcBill.set("totalamount", bill.get("totalamount"));
                srcBill.set("totaltaxamount", bill.get("totaltaxamount"));
                srcBill.set("address", bill.get("address"));
                String version = bill.getString("version");
                if (version == null || version.equals("0") || version.equals("1.0")) {
                    version = "1";
                }
                srcBill.set("version", (Object)(Integer.parseInt(version) + 1));
                srcBill.set("changestatus", (Object)ChangeStatusEnum.CHANGED.getValue());
                srcBill.set("changer", (Object)BusinessDataServiceHelper.loadSingle((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user"));
                srcBill.set("changedate", (Object)new Date(System.currentTimeMillis()));
                DynamicObjectCollection billEntrys = srcBill.getDynamicObjectCollection("billentry");
                DynamicObjectCollection xBillEntrys = bill.getDynamicObjectCollection("billentry");
                if (!CommonUtils.isNull((Object)xBillEntrys)) {
                    Long billEntryID;
                    DynamicObject billEntry;
                    int i3;
                    Long xSrcBillEntryID;
                    DynamicObject xBillEntry;
                    int i2;
                    block1: for (i2 = 0; i2 < xBillEntrys.size(); ++i2) {
                        xBillEntry = (DynamicObject)xBillEntrys.get(i2);
                        xSrcBillEntryID = xBillEntry.getLong("sourceentryid");
                        if (!ChangeTypeEnum.UPDATE.getValue().equals(xBillEntry.get("entrychangetype"))) continue;
                        for (i3 = 0; i3 < billEntrys.size(); ++i3) {
                            billEntry = (DynamicObject)billEntrys.get(i3);
                            billEntryID = (Long)billEntry.getPkValue();
                            if (xSrcBillEntryID.longValue() != billEntryID.longValue()) continue;
                            billEntry.set("qty", xBillEntry.get("qty"));
                            billEntry.set("baseqty", xBillEntry.get("baseqty"));
                            billEntry.set("auxqty", xBillEntry.get("auxqty"));
                            billEntry.set("price", xBillEntry.get("price"));
                            billEntry.set("priceandtax", xBillEntry.get("priceandtax"));
                            billEntry.set("taxrate", xBillEntry.get("taxrate"));
                            billEntry.set("taxrateid", xBillEntry.get("taxrateid"));
                            billEntry.set("amount", xBillEntry.get("amount"));
                            billEntry.set("amountandtax", xBillEntry.get("amountandtax"));
                            billEntry.set("curamount", xBillEntry.get("curamount"));
                            billEntry.set("curamountandtax", xBillEntry.get("curamountandtax"));
                            billEntry.set("curtaxamount", xBillEntry.get("curtaxamount"));
                            billEntry.set("discountamount", xBillEntry.get("discountamount"));
                            billEntry.set("taxamount", xBillEntry.get("taxamount"));
                            billEntry.set("entrycomment", xBillEntry.get("entrycomment"));
                            billEntry.set("iscontrolqty", xBillEntry.get("iscontrolqty"));
                            billEntry.set("receiveqtydown", xBillEntry.get("receiveqtydown"));
                            billEntry.set("receiveqtyup", xBillEntry.get("receiveqtyup"));
                            billEntry.set("receivebaseqtyup", xBillEntry.get("receivebaseqtyup"));
                            billEntry.set("receivebaseqtydown", xBillEntry.get("receivebaseqtydown"));
                            billEntry.set("receiveratedown", xBillEntry.get("receiveratedown"));
                            billEntry.set("receiverateup", xBillEntry.get("receiverateup"));
                            continue block1;
                        }
                    }
                    block3: for (i2 = xBillEntrys.size() - 1; i2 >= 0; --i2) {
                        xBillEntry = (DynamicObject)xBillEntrys.get(i2);
                        xSrcBillEntryID = xBillEntry.getLong("sourceentryid");
                        if (!ChangeTypeEnum.CANCEL.getValue().equals(xBillEntry.get("entrychangetype"))) continue;
                        for (i3 = billEntrys.size() - 1; i3 >= 0; --i3) {
                            billEntry = (DynamicObject)billEntrys.get(i3);
                            billEntryID = (Long)billEntry.getPkValue();
                            if (xSrcBillEntryID.longValue() != billEntryID.longValue()) continue;
                            DynamicObjectCollection deliverBillEntrys = billEntry.getDynamicObjectCollection("purbillentry_deliver");
                            if (!CommonUtils.isNull((Object)deliverBillEntrys)) {
                                deliverBillEntrys.clear();
                            }
                            billEntrys.remove((Object)billEntry);
                            continue block3;
                        }
                    }
                    for (i2 = 0; i2 < xBillEntrys.size(); ++i2) {
                        xBillEntry = (DynamicObject)xBillEntrys.get(i2);
                        if (!ChangeTypeEnum.ADDNEW.getValue().equals(xBillEntry.get("entrychangetype"))) continue;
                        DynamicObject billEntry2 = billEntrys.addNew();
                        for (int ii = 0; ii < billEntry2.getDataEntityType().getProperties().size(); ++ii) {
                            IDataEntityProperty entityProperty = (IDataEntityProperty)billEntry2.getDataEntityType().getProperties().get(ii);
                            if (entityProperty instanceof EntryProp || entityProperty instanceof LinkEntryProp) continue;
                            billEntry2.set(entityProperty.getName(), xBillEntry.get(entityProperty.getName()));
                            if (!"id".equals(entityProperty.getName())) continue;
                            isAddNewEntry = true;
                            xBillEntry.set("sourceentryid", billEntry2.getPkValue());
                        }
                    }
                }
                DynamicObjectCollection payBillEntrys = srcBill.getDynamicObjectCollection("purbillentry_pay");
                DynamicObjectCollection xPayBillEntrys = bill.getDynamicObjectCollection("purbillentry_pay");
                PurOrderBillHelper.getPrePayAmountSum((DynamicObject[])new DynamicObject[]{srcBill}, (OperateOption)this.operateOption);
                if (!CommonUtils.isNull((Object)xPayBillEntrys)) {
                    Long billEntryID;
                    DynamicObject payBillEntry;
                    Long xSrcBillEntryID;
                    int i2;
                    block7: for (i2 = 0; i2 < xPayBillEntrys.size(); ++i2) {
                        DynamicObject xPayBillEntry = (DynamicObject)xPayBillEntrys.get(i2);
                        xSrcBillEntryID = xPayBillEntry.getLong("sourcepayentryid");
                        if (!ChangeTypeEnum.UPDATE.getValue().equals(xPayBillEntry.get("payentrychangetype"))) continue;
                        for (int i3 = 0; i3 < payBillEntrys.size(); ++i3) {
                            payBillEntry = (DynamicObject)payBillEntrys.get(i3);
                            billEntryID = (Long)payBillEntry.getPkValue();
                            if (xSrcBillEntryID.longValue() != billEntryID.longValue()) continue;
                            payBillEntry.set("payname", xPayBillEntry.get("payname"));
                            payBillEntry.set("paydate", xPayBillEntry.get("paydate"));
                            payBillEntry.set("payrate", xPayBillEntry.get("payrate"));
                            payBillEntry.set("payamount", xPayBillEntry.get("payamount"));
                            payBillEntry.set("isprepay", xPayBillEntry.get("isprepay"));
                            payBillEntry.set("paidamount", xPayBillEntry.get("paidamount"));
                            continue block7;
                        }
                    }
                    block9: for (i2 = xPayBillEntrys.size() - 1; i2 >= 0; --i2) {
                        DynamicObject xPayBillEntry = (DynamicObject)xPayBillEntrys.get(i2);
                        xSrcBillEntryID = xPayBillEntry.getLong("sourcepayentryid");
                        if (!ChangeTypeEnum.CANCEL.getValue().equals(xPayBillEntry.get("payentrychangetype"))) continue;
                        for (int i3 = payBillEntrys.size() - 1; i3 >= 0; --i3) {
                            payBillEntry = (DynamicObject)payBillEntrys.get(i3);
                            billEntryID = (Long)payBillEntry.getPkValue();
                            if (xSrcBillEntryID.longValue() != billEntryID.longValue()) continue;
                            payBillEntrys.remove((Object)payBillEntry);
                            continue block9;
                        }
                    }
                    for (i2 = 0; i2 < xPayBillEntrys.size(); ++i2) {
                        DynamicObject xPayBillEntry = (DynamicObject)xPayBillEntrys.get(i2);
                        if (!ChangeTypeEnum.ADDNEW.getValue().equals(xPayBillEntry.get("payentrychangetype"))) continue;
                        DynamicObject payBillEntry2 = payBillEntrys.addNew();
                        for (int ii = 0; ii < payBillEntry2.getDataEntityType().getProperties().size(); ++ii) {
                            IDataEntityProperty entityProperty = (IDataEntityProperty)payBillEntry2.getDataEntityType().getProperties().get(ii);
                            if (xPayBillEntry.get(entityProperty.getName()) instanceof EntryProp || xPayBillEntry.get(entityProperty.getName()) instanceof LinkEntryProp) continue;
                            payBillEntry2.set(entityProperty.getName(), xPayBillEntry.get(entityProperty.getName()));
                        }
                    }
                }
                XSPurOrderSynOrderStatusImpl impl = new XSPurOrderSynOrderStatusImpl();
                PluginProxy pluginProxy = PluginProxy.create((Object)impl, IXPurOrderCasePlugin.class, (String)"SCMC_PM_XSPURORDERBILL_ACTIVE_SYNCSTATUS", null);
                pluginProxy.callReplaceIfPresent(p -> p.activeSynOrderBillStatus(srcBill));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{srcBill});
                if (!isAddNewEntry) continue;
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            }
            if (!srcBillIds.isEmpty()) {
                this.getOption().setVariableValue("purorderbillid", SerializationUtils.toJsonString(srcBillIds));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (!"active".equals(e.getOperationKey()) || CommonUtils.isNull((Object)e.getDataEntities())) {
            return;
        }
        String srcbillidStr = this.getOption().getVariableValue("purorderbillid", null);
        if (StringUtils.isBlank((CharSequence)srcbillidStr)) {
            return;
        }
        HashSet srcBillIds = (HashSet)SerializationUtils.fromJsonString((String)srcbillidStr, HashSet.class);
        PurOrderBillHelper.compareAndExcuteEvent((HashSet)srcBillIds, (String)"pm_purorderbill", (OperateOption)this.getOption());
    }
}

