/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.order;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.pm.enums.ChangeStatusEnum;
import kd.scmc.pm.utils.CommonUtils;

public class XPurOrderBillDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("sourceid");
        keys.add("changedate");
        keys.add("changer");
        keys.add("changestatus");
        keys.add("srcbillid");
        keys.add("xbillid");
        keys.add("srcbillversion");
        keys.add("version");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if ("delete".equals(e.getOperationKey()) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            DynamicObject[] bills = e.getDataEntities();
            ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>();
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject bill = bills[i];
                String srcBillID = bill.getString("sourceid");
                DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)srcBillID, (String)"pm_purorderbill");
                if (srcBill != null) {
                    if (null == srcBill.get("changedate") && null == srcBill.get("changer")) {
                        srcBill.set("changestatus", (Object)ChangeStatusEnum.UNCHANGE.getValue());
                    } else {
                        srcBill.set("changestatus", (Object)ChangeStatusEnum.CHANGED.getValue());
                    }
                }
                srcBills.add(srcBill);
            }
            if (srcBills.size() != 0) {
                SaveServiceHelper.save((DynamicObject[])srcBills.toArray(new DynamicObject[0]));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if ("delete".equals(e.getOperationKey()) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            DynamicObject[] bills = e.getDataEntities();
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject bill = bills[i];
                DynamicObject srcBill = BusinessDataServiceHelper.loadSingleFromCache((Object)bill.get("sourceid"), (String)"pm_purorderbill");
                QFilter qFilter1 = new QFilter("srcbillid", "=", srcBill.getPkValue());
                QFilter qFilter2 = new QFilter("xbillid", "=", bill.getPkValue());
                QFilter qFilter3 = new QFilter("srcbillversion", "=", (Object)srcBill.getString("version"));
                DeleteServiceHelper.delete((String)"pm_xpurorderbilllog", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
            }
        }
    }
}

