/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.order;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.pm.business.helper.PurOrderBillLogHelper;
import kd.scmc.pm.enums.ChangeStatusEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.utils.CommonUtils;
import kd.scmc.pm.validation.order.XPurOrderBillQtyAmountValidator;
import kd.scmc.pm.validation.order.XPurorderSubmitValidator;

public class XPurOrderBillSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("sourceid");
        keys.add("sourceno");
        keys.add("org");
        keys.add("reason");
        keys.add("totalallamount");
        keys.add("entrychangetype");
        keys.add("billentry");
        keys.add("qty");
        keys.add("joinqty");
        keys.add("joinpayablepriceqty");
        keys.add("joinbaseqty");
        keys.add("returnbaseqty");
        keys.add("returnreceiptbaseqty");
        keys.add("seq");
        keys.add("amountup");
        keys.add("joinamount");
        keys.add("performamount");
        keys.add("purbillentry_deliver");
        keys.add("delentrychangetype");
        keys.add("planqty");
        keys.add("planreceiveqty");
        keys.add("seq");
        keys.add("purbillentry_pay");
        keys.add("payamount");
        keys.add("joinpayamount");
        keys.add("payentrychangetype");
        keys.add("seq");
        keys.add("billno");
        keys.add("isprepay");
        keys.add("paysrcbillentity");
        keys.add("pretimepoint");
        keys.add("sourcebillid");
        keys.add("sourcebillentity");
        keys.add("entrysrcid");
        keys.add("srcbillentity");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new XPurOrderBillQtyAmountValidator());
        e.addValidator((AbstractValidator)new XPurorderSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        if (("save".equals(e.getOperationKey()) || "submit".equals(e.getOperationKey())) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            DynamicObject[] bills = e.getDataEntities();
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject bill = bills[i];
                if (BusinessDataServiceHelper.loadSingleFromCache((Object)bill.getPkValue(), (String)bill.getDynamicObjectType().getName(), (String)"id") != null) continue;
                String srcBillNo = bill.getString("sourceno");
                Long srcBillID = bill.getLong("sourceid");
                DynamicObject srcBill = BusinessDataServiceHelper.loadSingleFromCache((Object)srcBillID, (String)"pm_purorderbill");
                if (ChangeStatusEnum.CHANGING.getValue().equals(srcBill.get("changestatus"))) {
                    e.cancel = true;
                    String message = String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u201c%1$s\u201d\u6b63\u5728\u53d8\u66f4\u4e2d\uff0c\u4e0d\u80fd\u91cd\u590d\u53d8\u66f4\u3002", (String)"XPurOrderBillSaveOp_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), srcBillNo);
                    e.setCancelMessage(message);
                    return;
                }
                if (StatusEnum.AUDIT.getValue().equals(srcBill.get("billstatus"))) continue;
                e.cancel = true;
                String message = String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355%1$s\u5fc5\u987b\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u624d\u80fd\u53d8\u66f4\u3002", (String)"XPurOrderBillSaveOp_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), srcBillNo);
                e.setCancelMessage(message);
                return;
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        if (("save".equals(e.getOperationKey()) || "submit".equals(e.getOperationKey())) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            DynamicObject[] srcBills;
            DynamicObject[] bills = e.getDataEntities();
            if (bills == null || bills.length == 0) {
                return;
            }
            ArrayList<Long> srcBillIDs = new ArrayList<Long>(16);
            for (DynamicObject bill : bills) {
                srcBillIDs.add(bill.getLong("sourceid"));
            }
            for (DynamicObject srcBill : srcBills = BusinessDataServiceHelper.load((Object[])srcBillIDs.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"pm_purorderbill").getDynamicObjectType())) {
                if (srcBill == null) continue;
                srcBill.set("changestatus", (Object)ChangeStatusEnum.CHANGING.getValue());
            }
            if (srcBills.length != 0) {
                SaveServiceHelper.save((DynamicObject[])srcBills);
            }
            ArrayList<DynamicObject> xBillLogs = new ArrayList<DynamicObject>();
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject bill = bills[i];
                Long srcBillID = bill.getLong("sourceid");
                DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)srcBillID, (String)"pm_purorderbill");
                MainEntityType xlogdt = MetadataServiceHelper.getDataEntityType((String)"pm_xpurorderbilllog");
                DynamicObject xBill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)"pm_xpurorderbill");
                QFilter qFilter1 = new QFilter("srcbillid", "=", srcBill.getPkValue());
                QFilter qFilter2 = new QFilter("xbillid", "=", bill.getPkValue());
                QFilter qFilter3 = new QFilter("srcbillversion", "=", (Object)srcBill.getString("version"));
                DeleteServiceHelper.delete((String)"pm_xpurorderbilllog", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
                DynamicObject xBillLog = new DynamicObject((DynamicObjectType)xlogdt);
                xBillLog.set("srcbillid", srcBill.getPkValue());
                xBillLog.set("srcbillno", (Object)srcBill.getString("billno"));
                xBillLog.set("srcbillversion", (Object)srcBill.getString("version"));
                xBillLog.set("xbillid", bill.getPkValue());
                xBillLog.set("xbillno", (Object)bill.getString("billno"));
                xBillLog.set("creator", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user"));
                xBillLog.set("biztime", (Object)bill.getDate("biztime"));
                xBillLog.set("xreason", (Object)bill.getString("reason"));
                Map map = PurOrderBillLogHelper.compareOrderBillNXOrderBill((DynamicObject)srcBill, (DynamicObject)xBill);
                String xmdlog = (String)map.get("pm_purorderbill") + (String)map.get("billentry") + (String)map.get("purbillentry_pay");
                xBillLog.set("xmdjson_tag", (Object)xmdlog);
                xBillLogs.add(xBillLog);
            }
            if (xBillLogs.size() != 0) {
                SaveServiceHelper.save((DynamicObject[])xBillLogs.toArray(new DynamicObject[0]));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] bills;
        if (!(!"save".equals(e.getOperationKey()) && !"submit".equals(e.getOperationKey()) || CommonUtils.isNull((Object)e.getDataEntities()) || (bills = e.getDataEntities()) != null && bills.length != 0)) {
            return;
        }
    }
}

