/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.business.custom.ext.bizextplugin.XSPurOrderSynOrderStatusImpl;
import kd.scmc.pm.business.helper.BillParameterHelper;
import kd.scmc.pm.business.helper.PurOrderBillHelper;
import kd.scmc.pm.enums.ChangeTypeEnum;
import kd.scmc.pm.validation.order.XSPurOrderBillChangePrePayRateValidator;
import kd.sdk.scmc.pm.extpoint.IXPurOrderCasePlugin;

public class XSPurOrderBillActiveOp
extends AbstractOperationServicePlugIn {
    private static final String BIZVALID = "bizvalid";
    private static final Log logger = LogFactory.getLog(XSPurOrderBillActiveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("isprepay");
        e.getFieldKeys().add("payamount");
        e.getFieldKeys().add("payrate");
        e.getFieldKeys().add("payentrysrcid");
        e.getFieldKeys().add("purbillentry_pay");
        e.getFieldKeys().add("pretimepoint");
        e.getFieldKeys().add("totalallamount");
        e.getFieldKeys().add("changebillno");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new XSPurOrderBillChangePrePayRateValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        PluginProxy pluginProxy = PluginProxy.create(null, IXPurOrderCasePlugin.class, (String)"SCMC_PM_XSPURORDERBILL_ACTIVE_SYNCBILL", null);
        DynamicObject[] bills = e.getDataEntities();
        ArrayList<Long> billIDS = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            billIDS.add((Long)bill.getPkValue());
        }
        pluginProxy.callReplace(p -> p.activeSynBillInfo(billIDS, this.billEntityType.getName()));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if (BIZVALID.equals(e.getOperationKey()) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            DynamicObject[] bills = e.getDataEntities();
            DynamicObject bill = bills[0];
            bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)bill.getDynamicObjectType().getName());
            String sourceBillEntity = bill.getString("sourcebillentity");
            Long sourceBillId = bill.getLong("sourcebillid");
            if (sourceBillId == null || sourceBillEntity == null) {
                return;
            }
            DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)sourceBillEntity);
            if (CommonUtils.isNull((Object)srcBill)) {
                return;
            }
            DynamicObjectCollection billEntry = srcBill.getDynamicObjectCollection("billentry");
            Boolean deleteLine = BillParameterHelper.getIsEnableDeleteLine((String)"pm_xspurorderbill");
            if (deleteLine != null && deleteLine.booleanValue()) {
                BigDecimal totalAllAmount = bill.getBigDecimal("totalallamount");
                if (totalAllAmount == null || BigDecimal.ZERO.compareTo(totalAllAmount) == 0) {
                    DynamicObjectCollection purBillEntryPay = srcBill.getDynamicObjectCollection("purbillentry_pay");
                    int size = purBillEntryPay.size();
                    for (int i = size - 1; i >= 0; --i) {
                        purBillEntryPay.remove(i);
                    }
                }
                DynamicObjectCollection xBillEntry = bill.getDynamicObjectCollection("billentry");
                String[] enableEntryPropertys = ChangeModelHelper.getCanWritebackProperty((IDataEntityType)bill.getDynamicObjectType(), (String)"billentry");
                block1: for (DynamicObject xRow : xBillEntry) {
                    String entryChangeType = xRow.getString("entrychangetype");
                    if (!ChangeTypeEnum.CANCEL.getValue().equals(entryChangeType)) continue;
                    for (DynamicObject row : billEntry) {
                        if (row.getLong("id") != xRow.getLong("entrysrcid")) continue;
                        for (String entryProperty : enableEntryPropertys) {
                            row.set(entryProperty, xRow.get(entryProperty));
                        }
                        DynamicObjectCollection deliverPlan = row.getDynamicObjectCollection("purbillentry_deliver");
                        int size = deliverPlan.size();
                        for (int i = size - 1; i >= 0; --i) {
                            deliverPlan.remove(i);
                        }
                        continue block1;
                    }
                }
            }
            XSPurOrderSynOrderStatusImpl impl = new XSPurOrderSynOrderStatusImpl();
            PluginProxy pluginProxy = PluginProxy.create((Object)impl, IXPurOrderCasePlugin.class, (String)"SCMC_PM_XSPURORDERBILL_ACTIVE_SYNCSTATUS", null);
            pluginProxy.callReplaceIfPresent(p -> p.activeSynOrderBillStatus(srcBill));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{srcBill});
            logger.info("\u91c7\u8d2d\u8ba2\u5355\uff0c\u4e8c\u6b21\u5b9a\u7248\u6210\u529f.");
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (!BIZVALID.equals(e.getOperationKey()) || CommonUtils.isNull((Object)e.getDataEntities())) {
            return;
        }
        HashSet<Long> srcBillIds = new HashSet<Long>(10);
        String srcEntity = null;
        for (DynamicObject bill : e.getDataEntities()) {
            String sourceBillEntity = bill.getString("sourcebillentity");
            Long sourceBillId = bill.getLong("sourcebillid");
            if (StringUtils.isBlank(srcEntity) && StringUtils.isNotBlank((CharSequence)sourceBillEntity)) {
                srcEntity = sourceBillEntity;
            }
            if (sourceBillId == null || sourceBillId == 0L) continue;
            srcBillIds.add(sourceBillId);
        }
        PurOrderBillHelper.compareAndExcuteEvent(srcBillIds, srcEntity, (OperateOption)this.getOption());
    }
}

