/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.accept;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;

public class PurAcceptBillSubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject bill = entity.getDataEntity();
            Boolean isallocbyper = bill.getBoolean("isallocbyper");
            Boolean isexpensealloc = bill.getBoolean("isexpensealloc");
            BigDecimal totalAmount = bill.getBigDecimal("totalamount");
            if (isexpensealloc.booleanValue()) {
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("allocationentry");
                if (entrys.size() != 0) {
                    BigDecimal totalAllocationamt = BigDecimal.ZERO;
                    BigDecimal totalAllocationper = BigDecimal.ZERO;
                    int count = 0;
                    for (DynamicObject entry : entrys) {
                        ++count;
                        boolean result = false;
                        if (isallocbyper.booleanValue()) {
                            BigDecimal a_allocationper = entry.getBigDecimal("a_allocationper");
                            totalAllocationper = totalAllocationper.add(a_allocationper);
                            result = this.compareZero(a_allocationper);
                        } else {
                            BigDecimal a_allocationamt = entry.getBigDecimal("a_allocationamt");
                            totalAllocationamt = totalAllocationamt.add(a_allocationamt);
                            result = this.compareZero(a_allocationamt);
                        }
                        if (!result) continue;
                        this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u5206\u644a\u660e\u7ec6\u4e2d\u7b2c%s\u884c\u5206\u914d\u6bd4\u4f8b(%%)\u6216\u5206\u914d\u91d1\u989d\u4e3a\u7a7a\u3002", (String)"PurAcceptBillSubmitValidator_4", (String)"scmc-pm-opplugin", (Object[])new Object[0]), count), ErrorLevel.Error);
                    }
                    if (totalAllocationper.compareTo(new BigDecimal(100)) != 0 && isallocbyper.booleanValue()) {
                        this.addMessage(entity, ResManager.loadKDString((String)"\u5206\u644a\u660e\u7ec6\u4e2d\u5206\u914d\u6bd4\u4f8b(%)\u5408\u8ba1\u5fc5\u987b\u4e3a100%\u3002", (String)"PurAcceptBillSubmitValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    } else if (totalAllocationamt.compareTo(totalAmount) != 0 && !isallocbyper.booleanValue()) {
                        this.addMessage(entity, ResManager.loadKDString((String)"\u5206\u644a\u660e\u7ec6\u4e2d\u5206\u914d\u91d1\u989d\u5408\u8ba1\u5fc5\u987b\u7b49\u4e8e\u5355\u636e\u5934\u91d1\u989d\u3002", (String)"PurAcceptBillSubmitValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    }
                } else {
                    this.addMessage(entity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5206\u644a\u660e\u7ec6\u201d\u3002", (String)"PurAcceptBillSubmitValidator_3", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date bookdate = bill.getDate("bookdate");
            Date biztime = bill.getDate("biztime");
            if (bookdate == null || biztime == null || !bookdate.before(biztime)) continue;
            this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u5f53\u524d\u8bb0\u8d26\u65e5\u671f\u201c%1$s\u201d\u5c0f\u4e8e\u9a8c\u6536\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u3002", (String)"PurAcceptBillSubmitValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), simpleDateFormat.format(bookdate), simpleDateFormat.format(biztime)), ErrorLevel.Error);
        }
    }

    private boolean compareZero(BigDecimal allocation) {
        return allocation != null && allocation.compareTo(BigDecimal.ZERO) == 0;
    }
}

