/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.basedata;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.pm.business.helper.QuotaHelper;

public class QuotaAssignSaveValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> purOrgIds = new HashSet<Long>(10);
        HashSet<Long> materialIds = new HashSet<Long>(10);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject baseDate = dataEntity.getDataEntity();
            DynamicObject org = (DynamicObject)baseDate.get("org");
            DynamicObject material = (DynamicObject)baseDate.get("material");
            DynamicObjectCollection mulMaterial = baseDate.getDynamicObjectCollection("mulmaterial");
            if (material == null || mulMaterial == null || mulMaterial.isEmpty()) continue;
            materialIds.add((Long)material.getPkValue());
            Long purOrgId = (Long)org.getPkValue();
            purOrgIds.add(purOrgId);
            for (DynamicObject materialFake : mulMaterial) {
                Long materialId = (Long)((DynamicObject)materialFake.get("fbasedataid")).getPkValue();
                materialIds.add(materialId);
            }
        }
        Map uniqueKeyAndPkMap = QuotaHelper.queryQuotaAssignFromDB(purOrgIds, materialIds);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject baseDate = dataEntity.getDataEntity();
            DynamicObject org = (DynamicObject)baseDate.get("org");
            DynamicObject headMaterial = (DynamicObject)baseDate.get("material");
            DynamicObjectCollection mulMaterial = (DynamicObjectCollection)baseDate.get("mulmaterial");
            Object pkValue = baseDate.getPkValue();
            if (headMaterial == null || mulMaterial == null || mulMaterial.isEmpty()) continue;
            for (DynamicObject materialFake : mulMaterial) {
                DynamicObject material = (DynamicObject)materialFake.get("fbasedataid");
                String materialNo = material.getString("masterid.number");
                String uniqueKey = QuotaHelper.getUniqueKey((DynamicObject)org, (DynamicObject)material);
                Long pkId = (Long)uniqueKeyAndPkMap.get(uniqueKey);
                if (pkId == null) continue;
                Long pk = pkId;
                if (pkValue == null || pkValue.equals(pk)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u91c7\u8d2d\u7ec4\u7ec7\u4e0e\u5f53\u524d\u7269\u6599\u7f16\u7801\u7684\u7ec4\u5408\u503c\u4e0e\u5176\u4ed6\u8868\u5355\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"QuotaAssignSaveValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), materialNo));
            }
        }
    }
}

