/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.basedata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.pm.business.helper.QuotaHelper;

public class QuotaMaterialValidator
extends AbstractValidator {
    public void validate() {
        DynamicObject material;
        HashSet<String> purOrgAndMaterialIdSet = new HashSet<String>(10);
        ArrayList<ExtendedDataEntity> currentUniqueDataEntity = new ArrayList<ExtendedDataEntity>(10);
        HashSet<Long> purOrgIds = new HashSet<Long>(10);
        HashSet<Long> materialIds = new HashSet<Long>(10);
        for (ExtendedDataEntity data : this.dataEntities) {
            Long materialId;
            DynamicObject quota = data.getDataEntity();
            material = (DynamicObject)quota.get("material");
            DynamicObject org = quota.getDynamicObject("org");
            if (material == null || org == null) continue;
            Long orgId = (Long)org.getPkValue();
            String uniqueKey = QuotaHelper.getUniqueKey((Long)orgId, (Long)(materialId = (Long)material.getPkValue()));
            if (purOrgAndMaterialIdSet.contains(uniqueKey)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u4e0e\u5f53\u524d\u9002\u7528\u7269\u6599\u7684\u7ec4\u5408\u503c\u5df2\u5b58\u5728\u914d\u989d\u5206\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"QuotaMaterialValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]));
                continue;
            }
            purOrgAndMaterialIdSet.add(uniqueKey);
            currentUniqueDataEntity.add(data);
            purOrgIds.add(orgId);
            materialIds.add(materialId);
        }
        Map uniqueKeyAndPkMap = QuotaHelper.queryQuotaAssignFromDB(purOrgIds, materialIds);
        for (ExtendedDataEntity dataEntity : currentUniqueDataEntity) {
            DynamicObject quota = dataEntity.getDataEntity();
            DynamicObject org = (DynamicObject)quota.get("org");
            material = (DynamicObject)quota.get("material");
            if (material == null) continue;
            boolean isQuotaCOntrol = material.getBoolean("isquotacontrol");
            if (!isQuotaCOntrol) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9002\u7528\u7269\u6599\u672a\u5f00\u542f\u914d\u989d\u63a7\u5236\uff0c\u8bf7\u4fee\u6539\u3002", (String)"QuotaMaterialValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]));
                continue;
            }
            String uniqueKey = QuotaHelper.getUniqueKey((DynamicObject)org, (DynamicObject)material);
            if (!uniqueKeyAndPkMap.containsKey(uniqueKey)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u4e0e\u5f53\u524d\u9002\u7528\u7269\u6599\u7684\u7ec4\u5408\u503c\u5df2\u5b58\u5728\u914d\u989d\u5206\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"QuotaMaterialValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]));
        }
    }
}

