/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.basedata;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.pm.enums.SourceListTypeEnum;

public class SourceListIsEmptyValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject baseData = data.getDataEntity();
            DynamicObjectCollection entrys = baseData.getDynamicObjectCollection("entryentity");
            if (entrys == null || entrys.size() <= 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject materialsort;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                String type = entry.getString("type");
                int index = i + 1;
                if (type.equals(SourceListTypeEnum.MATERIAL.getValue())) {
                    DynamicObject material = entry.getDynamicObject("material");
                    if (material == null) {
                        this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u3002", (String)"SourceListIsEmptyValidator_4", (String)"scmc-pm-opplugin", (Object[])new Object[0]), index));
                    }
                    BigDecimal maxbillqty = entry.getBigDecimal("maxbillqty");
                    BigDecimal minbillqty = entry.getBigDecimal("minbillqty");
                    if (BigDecimal.ZERO.compareTo(maxbillqty) == 0 || BigDecimal.ZERO.compareTo(minbillqty) == 0 || maxbillqty.compareTo(minbillqty) >= 0) continue;
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6700\u5927\u8ba2\u5355\u91cf\u5e94\u5927\u4e8e\u7b49\u4e8e\u6700\u5c0f\u8ba2\u5355\u91cf\u3002", (String)"SourceListIsEmptyValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), index));
                    continue;
                }
                if (!type.equals(SourceListTypeEnum.MATERIALGROUP.getValue()) || (materialsort = entry.getDynamicObject("materialsort")) != null) continue;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7c7b\u522b\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u3002", (String)"SourceListIsEmptyValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), index));
            }
        }
    }
}

