/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.common.enums.EnableStatusEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.common.utils.MetadataUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;
import kd.scmc.pm.business.helper.BizCategoryHelper;

public class MaterialValidator
extends AbstractValidator {
    public static String PARA_ISCHECKSOURCECTRL = "ischecksourcectrl";

    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("billstatus");
        preparePropertys.add("billtype");
        preparePropertys.add("biztype");
        preparePropertys.add("material");
        return preparePropertys;
    }

    public void validate() {
        String customparameter = (String)this.getValidation().get("customparameter");
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObjectCollection entrys;
            DynamicObject bill = data.getDataEntity();
            String billStatus = bill.getString("billstatus");
            DynamicObject org = bill.getDynamicObject("org");
            Date bizTime = bill.getDate("biztime");
            DynamicObject billType = bill.getDynamicObject("billtype");
            if (billType == null) continue;
            Boolean isFarm = Boolean.FALSE;
            if (1436815416587466752L == (Long)billType.getPkValue() || 1436821757829877760L == (Long)billType.getPkValue() || 1436826169843421184L == (Long)billType.getPkValue() || 1436822188291274752L == (Long)billType.getPkValue() || 1436823955376715776L == (Long)billType.getPkValue()) {
                isFarm = Boolean.TRUE;
            }
            Boolean isVmi = Boolean.FALSE;
            DynamicObject bizType = bill.getDynamicObject("biztype");
            if (bizType != null) {
                isVmi = BizCategoryHelper.isVMI((Long)((Long)bizType.getPkValue()));
            }
            if ((entrys = bill.getDynamicObjectCollection("billentry")) == null) continue;
            ArrayList<Long> sourceCtrlmaterialIds = new ArrayList<Long>(entrys.size());
            ArrayList<Long> sourceCtrlmaterialGroupIds = new ArrayList<Long>(entrys.size());
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject group;
                DynamicObject masterMaterial;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                DynamicObject material = entry.getDynamicObject("material");
                if (material == null || (masterMaterial = material.getDynamicObject("masterid")) == null) continue;
                if (isFarm.booleanValue() || isVmi.booleanValue()) {
                    QFilter idFilter = new QFilter("id", "=", masterMaterial.getPkValue());
                    masterMaterial = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (String)"id,farmproducts,enablevmi", (QFilter[])new QFilter[]{idFilter});
                    if (isFarm.booleanValue() && !masterMaterial.getBoolean("farmproducts")) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u201c\u5355\u636e\u7c7b\u578b\u201d\u4e3a\u201c\u519c\u4ea7\u54c1\u91c7\u8d2d\u8ba2\u5355\u201d\uff0c\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\u7684\u519c\u4ea7\u54c1\u4e0d\u4e3a\u201c\u662f\u201d\u3002", (String)"MaterialValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1, masterMaterial.getString("name")), ErrorLevel.Error);
                    }
                    if (isVmi.booleanValue() && !masterMaterial.getBoolean("enablevmi")) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\u9886\u57df\u4e3aVMI\uff0c\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\u7684\u53efVMI\u4e0d\u4e3a\u201c\u662f\u201d\u3002", (String)"MaterialValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1, masterMaterial.getString("name")), ErrorLevel.Error);
                    }
                }
                if (!StatusEnum.AUDIT.getValue().equals(billStatus) && !StatusEnum.SUBMIT.getValue().equals(billStatus) || !"true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKSOURCECTRL)) || material == null || !material.getBoolean("isapprovedsupplier")) continue;
                sourceCtrlmaterialIds.add((Long)material.getPkValue());
                DynamicObject master = material.getDynamicObject("masterid");
                if (master == null || (group = master.getDynamicObject("group")) == null) continue;
                sourceCtrlmaterialGroupIds.add((Long)group.getPkValue());
            }
            if (!StatusEnum.AUDIT.getValue().equals(billStatus) && !StatusEnum.SUBMIT.getValue().equals(billStatus) || !"true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKSOURCECTRL)) || !MetadataUtils.checkProperty((DynamicObject)bill, (String)"supplier")) continue;
            DynamicObject supplier = bill.getDynamicObject("supplier");
            if (org == null || supplier == null || bizTime == null || entrys == null || entrys.isEmpty() || sourceCtrlmaterialIds.isEmpty()) continue;
            QFilter q1 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
            QFilter q2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
            QFilter q3 = new QFilter("org", "=", org.getPkValue());
            QFilter q4 = new QFilter("supplier", "=", supplier.getPkValue());
            QFilter q5 = new QFilter("entryentity.effectdate", "<=", (Object)bizTime);
            QFilter q6 = new QFilter("entryentity.expirydate", ">=", (Object)bizTime);
            QFilter q7 = null;
            QFilter q71 = new QFilter("entryentity.type", "=", (Object)"A");
            QFilter q72 = new QFilter("entryentity.material", "in", sourceCtrlmaterialIds);
            if (sourceCtrlmaterialGroupIds.isEmpty()) {
                q7 = q71.and(q72);
            } else {
                QFilter q73 = new QFilter("entryentity.type", "=", (Object)"B");
                QFilter q74 = new QFilter("entryentity.materialsort", "in", sourceCtrlmaterialGroupIds);
                q7 = q71.and(q72).or(q73.and(q74));
            }
            DynamicObjectCollection query = QueryServiceHelper.query((String)"pm_sourcelist", (String)"id,org,supplier,status,enable,entryentity.type type,entryentity.material material,entryentity.materialsort materialsort,entryentity.effectdate,entryentity.expirydate", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6, q7});
            ArrayList<Long> materials = null;
            ArrayList<Long> materialsorts = null;
            if (query != null && !query.isEmpty()) {
                int size = query.size();
                materials = new ArrayList<Long>(size);
                materialsorts = new ArrayList<Long>(size);
                for (DynamicObject dyn : query) {
                    Long id;
                    String type = dyn.getString("type");
                    if ("A".equals(type)) {
                        id = dyn.getLong("material");
                        if (id == null) continue;
                        materials.add(id);
                        continue;
                    }
                    if (!"B".equals(type) || (id = Long.valueOf(dyn.getLong("materialsort"))) == null) continue;
                    materialsorts.add(id);
                }
            }
            for (int j = 0; j < entrys.size(); ++j) {
                DynamicObject group;
                DynamicObject entry = (DynamicObject)entrys.get(j);
                DynamicObject material = entry.getDynamicObject("material");
                if (material == null || !material.getBoolean("isapprovedsupplier")) continue;
                Object pkValue = material.getPkValue();
                if (materials != null && materials.contains(pkValue)) continue;
                DynamicObject master = material.getDynamicObject("masterid");
                if (master != null && (group = master.getDynamicObject("group")) != null) {
                    Object pkValue2 = group.getPkValue();
                    if (materialsorts != null && materialsorts.contains(pkValue2)) continue;
                }
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u660e\u7ec6\u4e0d\u6ee1\u8db3\u8d27\u6e90\u63a7\u5236\u3002", (String)"MaterialValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), j + 1), ErrorLevel.Error);
            }
        }
    }
}

