/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.core.order;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class OwnerValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("org");
        preparePropertys.add("billno");
        preparePropertys.add("supplier");
        preparePropertys.add("ownertype");
        preparePropertys.add("owner");
        preparePropertys.add("entryrecorg");
        preparePropertys.add("entryrecorg");
        return preparePropertys;
    }

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObject supplier = bill.getDynamicObject("supplier");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            HashMap<String, Set<Long>> cacheMap = new HashMap<String, Set<Long>>(8);
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                String ownertype = entry.getString("ownertype");
                DynamicObject owner = entry.getDynamicObject("owner");
                if (owner == null) continue;
                if ("bd_supplier".equals(ownertype) && supplier != null && !owner.getPkValue().equals(supplier.getPkValue())) {
                    String tipMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u8d27\u4e3b\u4e0e\u8ba2\u8d27\u4f9b\u5e94\u5546\u5e94\u8be5\u4e00\u81f4\u3002", (String)"OwnerValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                    this.addMessage(data, tipMsg, ErrorLevel.Error);
                }
                if (!"bos_org".equals(ownertype)) continue;
                DynamicObject entryRecOrg = (DynamicObject)entry.get("entryrecorg");
                HashSet ownerIds = new HashSet(8);
                if (entryRecOrg == null) continue;
                Long entryRecOrgId = (Long)entryRecOrg.getPkValue();
                String ownerCacheKey = entryRecOrgId + "owner";
                if (OwnerValidator.isCache(cacheMap, ownerCacheKey)) {
                    ownerIds.addAll((Collection)cacheMap.get(ownerCacheKey));
                } else {
                    Map orgRelation = OrgHelper.getOrgRelation((Long)entryRecOrgId, (String)"10", (String)"05", (String)"fromorg");
                    if (orgRelation != null) {
                        ownerIds.addAll((List)orgRelation.get("orgId"));
                        cacheMap.put(ownerCacheKey, ownerIds);
                    }
                }
                if (ownerIds.contains(owner.getPkValue())) continue;
                String tipMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u8d27\u4e3b\u4e0d\u662f\u6ee1\u8db3\u6761\u4ef6\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"OwnerValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                this.addMessage(data, tipMsg, ErrorLevel.Error);
            }
        }
    }

    private static boolean isCache(Map<String, Set<Long>> map, String key) {
        return map.containsKey(key);
    }
}

