/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.order;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.mpscmm.msbd.changemodel.business.helper.BatXBillHelper;
import kd.mpscmm.msbd.changemodel.common.enums.BatChangeStatusEnum;
import kd.mpscmm.msbd.common.enums.BillStatusEnum;
import kd.mpscmm.msbd.common.enums.ChangeStatusEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.pojo.AmountInfo;
import kd.scmc.pm.business.pojo.AmountPropertyKey;
import kd.scmc.pm.business.pojo.SourceListInfo;
import kd.scmc.pm.enums.BizCancelStatusEnum;
import kd.scmc.pm.enums.BizCloseStatusEnum;
import kd.scmc.pm.enums.EnableStatusEnum;
import kd.scmc.pm.enums.ExchangeTypeEnum;
import kd.scmc.pm.enums.FrozenStatusEnum;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.scmc.pm.enums.SourceListTypeEnum;
import kd.scmc.pm.enums.StatusEnum;

public class BatXPurOrderBillSrcBillValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(BatXPurOrderBillSrcBillValidator.class);
    private static final String[] selectedProps = new String[]{"org", "billstatus", "operatorgroup", "changestatus", "cancelstatus", "closestatus", "isvirtualbill", "exchangerate", "exchangetype", "settlecurrency.amtprecision settlePricePrecision", "settlecurrency.amtprecision settleAmtPrecision", "currency.amtprecision currencyAmtPrecision", "istax", "biztime", "inputamount", "billentry.id entryid", "billentry.material material", "billentry.unit unit", "billentry.qty qty", "billentry.baseqty baseqty", "billentry.baseunit.precision baseunit_precision", "billentry.baseunit.precisionaccount baseunit_precisionaccount", "billentry.price price", "billentry.taxrate taxrate", "billentry.priceandtax priceandtax", "billentry.discounttype discounttype", "billentry.discountrate discountrate", "billentry.discountamount discountamount", "billentry.rowclosestatus rowclosestatus", "billentry.iscontrolqty iscontrolqty", "billentry.receiverateup receiverateup", "billentry.receivebaseqtyup receivebaseqtyup", "billentry.joinbaseqty joinbaseqty", "billentry.joinpayablepriceqty joinpayablepriceqty", "billentry.iscontrolamountup iscontrolamountup", "billentry.amountup amountup", "billentry.joinamount joinamount", "billentry.performamount performamount", "billentry.amountandtax amountandtax", "billentry.purbillentry_deliver.planqty planqty", "billentry.purbillentry_deliver.planreceiveqty planreceiveqty"};
    private static final String[] selectedFields = new String[]{"org", "billstatus", "operatorgroup", "changestatus", "cancelstatus", "closestatus", "isvirtualbill", "exchangerate", "exchangetype", "settlePricePrecision", "settleAmtPrecision", "currencyAmtPrecision", "istax", "biztime", "inputamount", "entryid", "material", "unit", "qty", "baseqty", "baseunit_precision", "baseunit_precisionaccount", "price", "taxrate", "priceandtax", "discounttype", "discountrate", "discountamount", "rowclosestatus", "iscontrolqty", "receiverateup", "receivebaseqtyup", "joinbaseqty", "joinamount", "joinpayablepriceqty", "iscontrolamountup", "amountup", "performamount", "amountandtax"};

    public void validate() {
        try {
            HashMap<Long, HashMap<String, Object>> PurOrderDeliverData;
            HashMap<Long, Map<String, Object>> PurOrderData;
            HashSet<Long> orgIds;
            HashSet<Long> allNeedValidSBEntryIds;
            Set selectRows;
            block65: {
                Iterator iterator;
                Object entrys;
                Object bill;
                selectRows = BatXBillHelper.getSelectRows((OperateOption)this.getOption());
                allNeedValidSBEntryIds = new HashSet<Long>();
                orgIds = new HashSet<Long>(10);
                for (ExtendedDataEntity extend : this.dataEntities) {
                    bill = extend.getDataEntity();
                    DynamicObject org = bill.getDynamicObject("org");
                    if (org != null) {
                        orgIds.add((Long)org.getPkValue());
                    }
                    if ((entrys = bill.getDynamicObjectCollection("entryentity")) == null) continue;
                    iterator = entrys.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject entry = (DynamicObject)iterator.next();
                        if (selectRows != null && selectRows.size() != 0 && !selectRows.contains((Long)entry.getPkValue())) continue;
                        String entryChangeStatus = entry.getString("changestatus");
                        if (!BatChangeStatusEnum.NORMAL.getValue().equals(entryChangeStatus)) continue;
                        allNeedValidSBEntryIds.add(entry.getLong("xsbillentryid"));
                    }
                }
                if (allNeedValidSBEntryIds.size() == 0) {
                    return;
                }
                PurOrderData = new HashMap<Long, Map<String, Object>>(8);
                PurOrderDeliverData = new HashMap<Long, HashMap<String, Object>>(8);
                QFilter q = new QFilter("billentry.id", "in", allNeedValidSBEntryIds);
                DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill", (String)String.join((CharSequence)",", selectedProps), (QFilter[])new QFilter[]{q}, null);
                bill = null;
                try {
                    if (ds == null) break block65;
                    DataSet copy = ds.copy().select(selectedFields).distinct();
                    entrys = null;
                    try {
                        iterator = copy.iterator();
                        while (iterator.hasNext()) {
                            Row row = (Row)iterator.next();
                            Long entryid = row.getLong("entryid");
                            HashMap<String, Object> data = new HashMap<String, Object>(row.size());
                            for (String field : selectedFields) {
                                data.put(field, row.get(field));
                            }
                            PurOrderData.put(entryid, data);
                        }
                    }
                    catch (Throwable throwable) {
                        entrys = throwable;
                        throw throwable;
                    }
                    finally {
                        if (copy != null) {
                            if (entrys != null) {
                                try {
                                    copy.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)entrys).addSuppressed(throwable);
                                }
                            } else {
                                copy.close();
                            }
                        }
                    }
                    for (Row row : ds) {
                        Long entryid = row.getLong("entryid");
                        HashMap<String, Object> data = (HashMap<String, Object>)PurOrderDeliverData.get(entryid);
                        if (data != null) {
                            List planqtys = (List)data.computeIfAbsent("planqty", k -> new ArrayList());
                            if (BigDecimalUtil.isZero((BigDecimal)row.getBigDecimal("planqty"))) continue;
                            planqtys.add(row.getBigDecimal("planqty"));
                            List planreceiveqtys = (List)data.computeIfAbsent("planreceiveqty", k -> new ArrayList());
                            planreceiveqtys.add(row.getBigDecimal("planreceiveqty"));
                            continue;
                        }
                        BigDecimal planqty = row.getBigDecimal("planqty");
                        if (planqty == null || BigDecimalUtil.isZero((BigDecimal)planqty)) continue;
                        data = new HashMap<String, Object>(8);
                        data.put("qty", row.getBigDecimal("qty"));
                        List planqtys = (List)data.computeIfAbsent("planqty", k -> new ArrayList());
                        planqtys.add(row.getBigDecimal("planqty"));
                        List planreceiveqtys = (List)data.computeIfAbsent("planreceiveqty", k -> new ArrayList());
                        planreceiveqtys.add(row.getBigDecimal("planreceiveqty"));
                        PurOrderDeliverData.put(entryid, data);
                    }
                }
                catch (Throwable copy) {
                    bill = copy;
                    throw copy;
                }
                finally {
                    if (ds != null) {
                        if (bill != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable copy) {
                                ((Throwable)bill).addSuppressed(copy);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
            }
            AppParam appParam = new AppParam("/JJVO8XV9MVB", "02", null, Long.valueOf(0L));
            Map map = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)appParam, new ArrayList(orgIds));
            Map<Long, String> valiLevelMap = this.getParamByKey(orgIds, map, "purbatchcontrol", "A");
            Map<Long, String> valiSourceMap = this.getParamByKey(orgIds, map, "batchcontrolsource", "B");
            HashSet allSrcBillIds = new HashSet(8);
            HashSet<Long> srcBillIds = new HashSet<Long>(8);
            for (ExtendedDataEntity extend : this.dataEntities) {
                DynamicObject batXBill = extend.getDataEntity();
                Map<String, List<SourceListInfo>> sourceListInfoMap = this.querySourceListInfo(batXBill, PurOrderData, valiLevelMap, valiSourceMap, allNeedValidSBEntryIds);
                DynamicObject org = batXBill.getDynamicObject("org");
                DynamicObject operatorGrp = batXBill.getDynamicObject("h_operatorgroup");
                Object operatorGroupIsolate = SysParamHelper.getSysParam4pm((Long)((Long)org.getPkValue()), (String)"foperatorgroupisolate");
                String billStatus = batXBill.getString("billstatus");
                DynamicObjectCollection entrys = batXBill.getDynamicObjectCollection("entryentity");
                srcBillIds.clear();
                if (entrys == null) continue;
                block26: for (int i = 0; i < entrys.size(); ++i) {
                    String errMsg;
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    if (selectRows != null && selectRows.size() != 0 && !selectRows.contains((Long)entry.getPkValue())) continue;
                    long xsBillId = entry.getLong("xsbillid");
                    long xsBillEntryId = entry.getLong("xsbillentryid");
                    if (xsBillId == 0L || xsBillEntryId == 0L || !allNeedValidSBEntryIds.contains(xsBillEntryId)) continue;
                    Map data = (Map)PurOrderData.get(xsBillEntryId);
                    if (data != null && data.size() > 0) {
                        String errMsg2;
                        if (org != null && !org.getPkValue().equals(data.get("org"))) {
                            errMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u91c7\u8d2d\u8ba2\u5355\u201c\u91c7\u8d2d\u7ec4\u7ec7\u201d\u4e0e\u6279\u91cf\u53d8\u66f4\u5355\u201c\u91c7\u8d2d\u7ec4\u7ec7\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BatXPurOrderBillSrcBillValidator_19", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend, errMsg, ErrorLevel.Error);
                        }
                        if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue() && operatorGrp != null && !operatorGrp.getPkValue().equals(data.get("operatorgroup"))) {
                            errMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4e1a\u52a1\u7ec4\u9694\u79bb\u5f00\u542f\uff0c\u91c7\u8d2d\u8ba2\u5355\u201c\u91c7\u8d2d\u7ec4\u201d\u4e0e\u6279\u91cf\u53d8\u66f4\u5355\u201c\u91c7\u8d2d\u7ec4\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BatXPurOrderBillSrcBillValidator_20", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend, errMsg, ErrorLevel.Error);
                        }
                        if (Boolean.TRUE.equals(data.get("inputamount"))) {
                            errMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u91c7\u8d2d\u8ba2\u5355\u201c\u5f55\u5165\u91d1\u989d\u201d\u4e3a\u201c\u662f\u201d\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurOrderBillSrcBillValidator_10", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend, errMsg, ErrorLevel.Error);
                        }
                        if (!BillStatusEnum.AUDIT.getValue().equals(data.get("billstatus"))) {
                            errMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurOrderBillSrcBillValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend, errMsg, ErrorLevel.Error);
                        }
                        if (BillStatusEnum.SAVE.getValue().equals(billStatus)) {
                            if ("submit".equals(this.getOperateKey())) {
                                if (allSrcBillIds.contains(xsBillId)) {
                                    errMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5176\u4ed6\u6279\u91cf\u53d8\u66f4\u5355\u4e2d\u5df2\u5b58\u5728\u540c\u4e00\u91c7\u8d2d\u8ba2\u5355\uff0c\u65e0\u6cd5\u540c\u65f6\u63d0\u4ea4\u3002", (String)"BatXPurOrderBillSrcBillValidator_16", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                                    this.addMessage(extend, errMsg, ErrorLevel.Error);
                                } else {
                                    srcBillIds.add(xsBillId);
                                }
                            }
                            if (ChangeStatusEnum.CHANGING.getValue().equals(data.get("changestatus")) || ChangeStatusEnum.REVISING.getValue().equals(data.get("changestatus"))) {
                                errMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u91c7\u8d2d\u8ba2\u5355\u53d8\u66f4\u72b6\u6001\u4e3a\u201c\u53d8\u66f4\u4e2d\u201d\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurOrderBillSrcBillValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                                this.addMessage(extend, errMsg, ErrorLevel.Error);
                            }
                        }
                        if (BizCancelStatusEnum.CANCEL.getValue().equals(data.get("cancelstatus"))) {
                            errMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u91c7\u8d2d\u8ba2\u5355\u4f5c\u5e9f\u72b6\u6001\u4e3a\u201c\u5df2\u4f5c\u5e9f\u201d\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurOrderBillSrcBillValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend, errMsg, ErrorLevel.Error);
                        }
                        if (BizCloseStatusEnum.CLOSE.getValue().equals(data.get("closestatus"))) {
                            errMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u91c7\u8d2d\u8ba2\u5355\u5173\u95ed\u72b6\u6001\u4e3a\u201c\u5df2\u5173\u95ed\u201d\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurOrderBillSrcBillValidator_3", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend, errMsg, ErrorLevel.Error);
                        }
                        if (((Boolean)data.get("isvirtualbill")).booleanValue()) {
                            errMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u91c7\u8d2d\u8ba2\u5355\u662f\u5426\u865a\u5355\u4e3a\u201c\u662f\u201d\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurOrderBillSrcBillValidator_4", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend, errMsg, ErrorLevel.Error);
                        }
                        if (RowCloseStatusEnum.ROWCLOSE.getValue().equals(data.get("rowclosestatus"))) {
                            errMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u91c7\u8d2d\u8ba2\u5355\u884c\u5173\u95ed\u72b6\u6001\u4e3a\u201c\u5df2\u5173\u95ed\u201d\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurOrderBillSrcBillValidator_5", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend, errMsg, ErrorLevel.Error);
                        }
                        DynamicObject unit = entry.getDynamicObject("unit");
                        Object srcUnit = data.get("unit");
                        if (unit != null && !unit.getPkValue().equals(srcUnit)) {
                            String errMsg3 = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4e0e\u91c7\u8d2d\u8ba2\u5355\u884c\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurOrderBillSrcBillValidator_13", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend, errMsg3, ErrorLevel.Error);
                        }
                        DynamicObject material = entry.getDynamicObject("material");
                        Object srcMaterial = data.get("material");
                        if (material != null && !material.getPkValue().equals(srcMaterial)) {
                            String errMsg4 = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4e0e\u91c7\u8d2d\u8ba2\u5355\u884c\u201c\u7269\u6599\u7f16\u7801\u201d\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurOrderBillSrcBillValidator_14", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend, errMsg4, ErrorLevel.Error);
                        }
                        BigDecimal qty = entry.getBigDecimal("qty");
                        BigDecimal srcQty = (BigDecimal)data.get("qty");
                        if (qty != null && qty.compareTo(srcQty) != 0) {
                            String errMsg5 = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4e0e\u91c7\u8d2d\u8ba2\u5355\u884c\u201c\u6570\u91cf\u201d\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurOrderBillSrcBillValidator_15", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend, errMsg5, ErrorLevel.Error);
                        }
                        boolean isControlQty = (Boolean)data.get("iscontrolqty");
                        BigDecimal baseQty = (BigDecimal)entry.get("afterbaseqty");
                        BigDecimal receiveRateUp = (BigDecimal)data.get("receiverateup");
                        int baseUnitprecision = (Integer)data.get("baseunit_precision");
                        RoundingMode roundingMode = BillQtyAndUnitHelper.getUnitRoundingMode((String)((String)data.get("baseunit_precisionaccount")));
                        BigDecimal receivebaseqtyup = isControlQty ? BigDecimalUtil.getByGrowRate((BigDecimal)baseQty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateUp)).setScale(baseUnitprecision, roundingMode) : baseQty;
                        BigDecimal joinbaseqty = (BigDecimal)data.get("joinbaseqty");
                        if (receivebaseqtyup != null && joinbaseqty != null && receivebaseqtyup.compareTo(joinbaseqty) < 0) {
                            String errMsg6 = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u53d8\u66f4\u540e\u91c7\u8d2d\u8ba2\u5355\u6536\u8d27\u4e0a\u9650\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u201c\u5173\u8054\u6570\u91cf\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BatXPurOrderBillSrcBillValidator_6", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend, errMsg6, ErrorLevel.Error);
                        }
                        BigDecimal baseqty = (BigDecimal)entry.get("afterbaseqty");
                        DynamicObject supplier = (DynamicObject)entry.get("supplier");
                        String validateLevel = valiLevelMap.get(org.getPkValue());
                        Date bizTime = (Date)data.get("biztime");
                        if (!"A".equals(validateLevel) && org != null && supplier != null && bizTime != null && "submit".equals(this.getOperateKey())) {
                            DynamicObject master = material.getDynamicObject("masterid");
                            List<SourceListInfo> sourceList = null;
                            if (master != null) {
                                DynamicObject group;
                                Object masterPkValue = master.getPkValue();
                                String dimenKey = this.getDimenKey((Long)org.getPkValue(), (Long)masterPkValue, 0L, (Long)supplier.getPkValue());
                                sourceList = sourceListInfoMap.get(dimenKey);
                                if (sourceList == null && (group = master.getDynamicObject("group")) != null) {
                                    Long materialGroupId = (Long)group.getPkValue();
                                    dimenKey = this.getDimenKey((Long)org.getPkValue(), 0L, materialGroupId, (Long)supplier.getPkValue());
                                    sourceList = sourceListInfoMap.get(dimenKey);
                                }
                                String validateSource = valiSourceMap.get(org.getPkValue());
                                this.validatePurBatch(extend, i + 1, bizTime, entry, sourceList, validateLevel, validateSource);
                            }
                        }
                        BigDecimal joinpayablebaseqty = (BigDecimal)data.get("joinpayablebaseqty");
                        if (baseqty != null && joinpayablebaseqty != null && baseqty.compareTo(joinpayablebaseqty) < 0) {
                            String errMsg7 = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u53d8\u66f4\u540e\u91c7\u8d2d\u8ba2\u5355\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u201c\u5173\u8054\u9a8c\u6536\u5e94\u4ed8\u6570\u91cf\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BatXPurOrderBillSrcBillValidator_7", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend, errMsg7, ErrorLevel.Error);
                        }
                        boolean isDirectRate = ExchangeTypeEnum.isIndirectRate((Object)((String)data.get("exchangetype")));
                        AmountInfo amountInfo = AmountHelper.getAmount((Boolean)((Boolean)data.get("istax")), (BigDecimal)((BigDecimal)entry.get("afterqty")), (BigDecimal)((BigDecimal)data.get("price")), (BigDecimal)((BigDecimal)data.get("priceandtax")), (BigDecimal)((BigDecimal)data.get("taxrate")), (String)((String)data.get("discounttype")), (BigDecimal)((BigDecimal)data.get("discountrate")), (BigDecimal)((BigDecimal)data.get("exchangerate")), (Integer)((Integer)data.get("settlePricePrecision")), (Integer)((Integer)data.get("settleAmtPrecision")), (Integer)((Integer)data.get("currencyAmtPrecision")), (Boolean)isDirectRate, (AmountPropertyKey)AmountPropertyKey.getInstance());
                        Boolean iscontrolamountup = (Boolean)data.get("iscontrolamountup");
                        BigDecimal amountup = (BigDecimal)data.get("amountup");
                        if (Boolean.FALSE.equals(iscontrolamountup)) {
                            amountup = amountInfo.getAmountAndTax();
                        } else {
                            BigDecimal amountandtax = amountInfo.getAmountAndTax();
                            if (amountup != null && amountandtax != null && amountup.compareTo(amountandtax) < 0) {
                                errMsg2 = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u53d8\u66f4\u540e\u91c7\u8d2d\u8ba2\u5355\u201c\u4e0a\u9650\u91d1\u989d\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u539f\u5355\u636e\u201c\u4ef7\u7a0e\u5408\u8ba1\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BatXPurOrderBillSrcBillValidator_9", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                                this.addMessage(extend, errMsg2, ErrorLevel.Error);
                            }
                        }
                        BigDecimal performamount = (BigDecimal)data.get("performamount");
                        if (amountup != null && performamount != null && amountup.compareTo(performamount) < 0) {
                            errMsg2 = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u53d8\u66f4\u540e\u91c7\u8d2d\u8ba2\u5355\u201c\u4e0a\u9650\u91d1\u989d\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u539f\u5355\u636e\u201c\u5df2\u6267\u884c\u91d1\u989d\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BatXPurOrderBillSrcBillValidator_8", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend, errMsg2, ErrorLevel.Error);
                        }
                        BigDecimal joinAmount = (BigDecimal)data.get("joinamount");
                        if (amountup != null && joinAmount != null && amountup.compareTo(joinAmount) < 0) {
                            String errMsg8 = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u53d8\u66f4\u540e\u91c7\u8d2d\u8ba2\u5355\u201c\u4e0a\u9650\u91d1\u989d\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u539f\u5355\u636e\u201c\u5173\u8054\u91d1\u989d\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BatXPurOrderBillSrcBillValidator_12", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend, errMsg8, ErrorLevel.Error);
                        }
                    } else {
                        errMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u91c7\u8d2d\u8ba2\u5355\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurOrderBillSrcBillValidator_18", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                        this.addMessage(extend, errMsg, ErrorLevel.Error);
                    }
                    BigDecimal afterQty = (BigDecimal)entry.get("afterqty");
                    Map deliverData = (Map)PurOrderDeliverData.get(xsBillEntryId);
                    if (deliverData == null || deliverData.size() <= 0) continue;
                    BigDecimal qty = (BigDecimal)deliverData.get("qty");
                    List planqtys = (List)deliverData.get("planqty");
                    List planreceiveqtys = (List)deliverData.get("planreceiveqty");
                    if (planqtys.size() <= 0 || qty.compareTo(afterQty) <= 0) continue;
                    BigDecimal subQty = qty.subtract(afterQty);
                    for (int j = planqtys.size() - 1; j >= 0; --j) {
                        BigDecimal planQty = (BigDecimal)planqtys.get(j);
                        BigDecimal planreceiveqty = (BigDecimal)planreceiveqtys.get(j);
                        if (subQty.compareTo(BigDecimal.ZERO) <= 0 || (subQty = subQty.subtract(planQty)).compareTo(BigDecimal.ZERO) <= 0 || planreceiveqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                        String errMsg9 = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u53d8\u66f4\u540e\u201c\u8ba1\u5212\u4ea4\u8d27\u6570\u91cf\u201d\u4e3a0\uff0c\u201c\u6536\u8d27\u6570\u91cf\u201d\u5927\u4e8e0\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurOrderBillSrcBillValidator_11", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                        this.addMessage(extend, errMsg9, ErrorLevel.Error);
                        continue block26;
                    }
                }
                allSrcBillIds.addAll(srcBillIds);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25\u3002", (String)"BatXPurOrderBillSrcBillValidator_17", (String)"scmc-pm-opplugin", (Object[])new Object[0]));
        }
    }

    private void validatePurBatch(ExtendedDataEntity extend, int rowIndex, Date bizTime, DynamicObject entry, List<SourceListInfo> sourceListInfoList, String validateLevel, String validateSource) {
        BigDecimal baseQty = (BigDecimal)entry.get("afterbaseqty");
        if (baseQty == null || BigDecimal.ZERO.compareTo(baseQty) == 0) {
            return;
        }
        BigDecimal qty = entry.getBigDecimal("afterqty");
        SourceListInfo sourceListInfo = null;
        if (sourceListInfoList != null && !sourceListInfoList.isEmpty() && bizTime != null) {
            for (SourceListInfo info : sourceListInfoList) {
                Date effectdate = info.getEffectdate();
                Date expirydate = info.getExpirydate();
                if (bizTime == null || bizTime.compareTo(effectdate) < 0 || bizTime.compareTo(expirydate) > 0) continue;
                sourceListInfo = info;
                break;
            }
        }
        if ("A".equals(validateSource) && sourceListInfo != null) {
            String msg;
            BigDecimal sourceListMaxOrderBaseQty = sourceListInfo.getMaxOrderBaseQty();
            BigDecimal sourceListMinOrderBaseQty = sourceListInfo.getMinOrderBaseQty();
            BigDecimal sourceListPackingBaseQty = sourceListInfo.getPackingBaseQty();
            if (sourceListMaxOrderBaseQty.compareTo(BigDecimal.ZERO) != 0 && baseQty.compareTo(sourceListMaxOrderBaseQty) > 0) {
                BigDecimal maxBillQty = this.getDesQty(sourceListMaxOrderBaseQty, qty, baseQty, entry.getDynamicObject("unit"));
                msg = validateLevel.equals("C") ? String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u5927\u4e8e\u8d27\u6e90\u6e05\u5355\u4e2d\u6700\u5927\u8ba2\u5355\u91cf%2$s\uff0c\u65e0\u6cd5\u63d0\u4ea4\u8bf7\u4fee\u6539\u3002", (String)"BatXPurOrderBillSrcBillValidator_25", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowIndex, maxBillQty) : String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u5927\u4e8e\u8d27\u6e90\u6e05\u5355\u4e2d\u6700\u5927\u8ba2\u5355\u91cf%2$s\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BatXPurOrderBillSrcBillValidator_26", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowIndex, maxBillQty);
                this.addPurBatchErrorMsg(extend, msg, validateLevel);
            }
            if (sourceListMinOrderBaseQty.compareTo(BigDecimal.ZERO) != 0 && baseQty.compareTo(sourceListMinOrderBaseQty) < 0) {
                BigDecimal minBillQty = this.getDesQty(sourceListMinOrderBaseQty, qty, baseQty, entry.getDynamicObject("unit"));
                msg = validateLevel.equals("C") ? String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u5c0f\u4e8e\u8d27\u6e90\u6e05\u5355\u4e2d\u6700\u5c0f\u8ba2\u5355\u91cf%2$s\uff0c\u65e0\u6cd5\u63d0\u4ea4\u8bf7\u4fee\u6539\u3002", (String)"BatXPurOrderBillSrcBillValidator_27", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowIndex, minBillQty) : String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u5c0f\u4e8e\u8d27\u6e90\u6e05\u5355\u4e2d\u6700\u5c0f\u8ba2\u5355\u91cf%2$s\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BatXPurOrderBillSrcBillValidator_28", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowIndex, minBillQty);
                this.addPurBatchErrorMsg(extend, msg, validateLevel);
            }
            if (sourceListPackingBaseQty.compareTo(BigDecimal.ZERO) != 0 && !this.isDivideToInt(baseQty, sourceListPackingBaseQty)) {
                BigDecimal packingBillQty = this.getDesQty(sourceListPackingBaseQty, qty, baseQty, entry.getDynamicObject("unit"));
                msg = validateLevel.equals("C") ? String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u4e0d\u7b26\u5408\u8d27\u6e90\u6e05\u5355\u4e2d\u5305\u88c5\u6279\u91cf%2$s\u7684\u6574\u6570\u500d\uff0c\u65e0\u6cd5\u63d0\u4ea4\u8bf7\u4fee\u6539\u3002", (String)"BatXPurOrderBillSrcBillValidator_29", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowIndex, packingBillQty) : String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u4e0d\u7b26\u5408\u8d27\u6e90\u6e05\u5355\u4e2d\u5305\u88c5\u6279\u91cf%2$s\u7684\u6574\u6570\u500d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BatXPurOrderBillSrcBillValidator_30", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowIndex, packingBillQty);
                this.addPurBatchErrorMsg(extend, msg, validateLevel);
            }
        } else {
            String msg;
            DynamicObject material = entry.getDynamicObject("material");
            if (material == null) {
                return;
            }
            BigDecimal matMaxOrderBaseQty = material.getBigDecimal("maxbillbaseqty");
            BigDecimal matMinOrderBaseQty = material.getBigDecimal("minbillbaseqty");
            BigDecimal matPackingBaseQty = material.getBigDecimal("packingbaseqty");
            if (matMaxOrderBaseQty.compareTo(BigDecimal.ZERO) != 0 && baseQty.compareTo(matMaxOrderBaseQty) > 0) {
                BigDecimal maxBillQty = this.getDesQty(matMaxOrderBaseQty, qty, baseQty, entry.getDynamicObject("unit"));
                msg = validateLevel.equals("C") ? String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u5927\u4e8e\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u4e2d\u6700\u5927\u8ba2\u5355\u91cf%2$s\uff0c\u65e0\u6cd5\u63d0\u4ea4\u8bf7\u4fee\u6539\u3002", (String)"BatXPurOrderBillSrcBillValidator_31", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowIndex, maxBillQty) : String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u5927\u4e8e\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u4e2d\u6700\u5927\u8ba2\u5355\u91cf%2$s\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BatXPurOrderBillSrcBillValidator_32", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowIndex, maxBillQty);
                this.addPurBatchErrorMsg(extend, msg, validateLevel);
            }
            if (matMinOrderBaseQty.compareTo(BigDecimal.ZERO) != 0 && baseQty.compareTo(matMinOrderBaseQty) < 0) {
                BigDecimal minBillQty = this.getDesQty(matMinOrderBaseQty, qty, baseQty, entry.getDynamicObject("unit"));
                msg = validateLevel.equals("C") ? String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u5c0f\u4e8e\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u4e2d\u6700\u5c0f\u8ba2\u5355\u91cf%2$s\uff0c\u65e0\u6cd5\u63d0\u4ea4\u8bf7\u4fee\u6539\u3002", (String)"BatXPurOrderBillSrcBillValidator_33", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowIndex, minBillQty) : String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u5c0f\u4e8e\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u4e2d\u6700\u5c0f\u8ba2\u5355\u91cf%2$s\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BatXPurOrderBillSrcBillValidator_34", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowIndex, minBillQty);
                this.addPurBatchErrorMsg(extend, msg, validateLevel);
            }
            if (matPackingBaseQty.compareTo(BigDecimal.ZERO) != 0 && !this.isDivideToInt(baseQty, matPackingBaseQty)) {
                BigDecimal packingBillQty = this.getDesQty(matPackingBaseQty, qty, baseQty, entry.getDynamicObject("unit"));
                msg = validateLevel.equals("C") ? String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u4e0d\u7b26\u5408\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u4e2d\u5305\u88c5\u6279\u91cf%2$s\u7684\u6574\u6570\u500d\uff0c\u65e0\u6cd5\u63d0\u4ea4\u8bf7\u4fee\u6539\u3002", (String)"BatXPurOrderBillSrcBillValidator_35", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowIndex, packingBillQty) : String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u4e0d\u7b26\u5408\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u4e2d\u5305\u88c5\u6279\u91cf%2$s\u7684\u6574\u6570\u500d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BatXPurOrderBillSrcBillValidator_36", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowIndex, packingBillQty);
                this.addPurBatchErrorMsg(extend, msg, validateLevel);
            }
        }
    }

    private Map<String, List<SourceListInfo>> querySourceListInfo(DynamicObject batXBill, Map<Long, Map<String, Object>> purOrderData, Map<Long, String> valiLevelMap, Map<Long, String> valiSourceMap, Set<Long> allSBEntryIds) {
        HashMap<String, List<SourceListInfo>> sourceListInfoMap = new HashMap<String, List<SourceListInfo>>(10);
        if (batXBill == null || purOrderData == null || !"submit".equals(this.getOperateKey())) {
            return sourceListInfoMap;
        }
        if (batXBill == null) {
            return sourceListInfoMap;
        }
        DynamicObject orgDym = batXBill.getDynamicObject("org");
        if (orgDym == null) {
            return sourceListInfoMap;
        }
        Long orgId = (Long)orgDym.getPkValue();
        String validateLevel = valiLevelMap.get(orgId);
        String validateSource = valiSourceMap.get(orgId);
        if ("A".equals(validateLevel) || !"A".equals(validateSource)) {
            return sourceListInfoMap;
        }
        Long supplierId = null;
        DynamicObjectCollection entrys = batXBill.getDynamicObjectCollection("entryentity");
        HashMap groupByDate = new HashMap(10);
        for (DynamicObject dynamicObject : entrys) {
            Object biztimeObj;
            DynamicObject supplier;
            Map<String, Object> map;
            long xSrBillEntryId = dynamicObject.getLong("xsbillentryid");
            if (!allSBEntryIds.contains(xSrBillEntryId) || (map = purOrderData.get(xSrBillEntryId)) == null || (supplier = dynamicObject.getDynamicObject("supplier")) == null) continue;
            if (supplierId == null) {
                supplierId = (Long)supplier.getPkValue();
            }
            if ((biztimeObj = map.get("biztime")) == null) continue;
            Date biztime = (Date)biztimeObj;
            HashMap<String, Set> dateMap = (HashMap<String, Set>)groupByDate.get(biztime);
            if (dateMap == null) {
                dateMap = new HashMap<String, Set>(3);
                dateMap.put("materialIds", new HashSet(10));
                dateMap.put("materialGrpIds", new HashSet(10));
            }
            Set materialIds = (Set)dateMap.get("materialIds");
            Set materialGrpIds = (Set)dateMap.get("materialGrpIds");
            DynamicObject material = dynamicObject.getDynamicObject("material");
            if (material == null) continue;
            DynamicObject master = material.getDynamicObject("masterid");
            if (master != null) {
                materialIds.add((Long)master.getPkValue());
                DynamicObject group = master.getDynamicObject("group");
                if (group != null) {
                    materialGrpIds.add((Long)group.getPkValue());
                }
            }
            dateMap.put("materialIds", materialIds);
            dateMap.put("materialGrpIds", materialGrpIds);
            groupByDate.put(biztime, dateMap);
        }
        for (Map.Entry entry : groupByDate.entrySet()) {
            Map<String, List<SourceListInfo>> queryResult;
            Date bizTime = (Date)entry.getKey();
            Map value = (Map)entry.getValue();
            Set materialIds = (Set)value.get("materialIds");
            Set materialGrpIds = (Set)value.get("materialGrpIds");
            if (bizTime == null || orgId == null || supplierId == null || materialIds == null || materialIds.isEmpty() || (queryResult = this.doQuerySourceList(orgId, supplierId, bizTime, materialIds, materialGrpIds)) == null || queryResult.isEmpty()) continue;
            for (Map.Entry<String, List<SourceListInfo>> entry1 : queryResult.entrySet()) {
                List<SourceListInfo> value1 = entry1.getValue();
                if (value1 == null || value1.isEmpty()) continue;
                String key = entry1.getKey();
                List<SourceListInfo> sourceListInfos = sourceListInfoMap.get(key) == null ? new ArrayList(3) : (List)sourceListInfoMap.get(key);
                sourceListInfos.addAll(value1);
                sourceListInfoMap.put(key, sourceListInfos);
            }
        }
        return sourceListInfoMap;
    }

    private Map<String, List<SourceListInfo>> doQuerySourceList(Long orgId, Long supplierId, Date bizTime, Set<Long> materialIds, Set<Long> materialGroupIds) {
        HashMap<String, List<SourceListInfo>> sourceListInfoMap = new HashMap<String, List<SourceListInfo>>(10);
        QFilter q1 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter q2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        QFilter q3 = new QFilter("org", "=", (Object)orgId);
        QFilter q4 = new QFilter("supplier", "=", (Object)supplierId);
        QFilter q5 = new QFilter("entryentity.effectdate", "<=", (Object)bizTime);
        QFilter q6 = new QFilter("entryentity.expirydate", ">=", (Object)bizTime);
        QFilter q7 = null;
        QFilter q71 = new QFilter("entryentity.type", "=", (Object)SourceListTypeEnum.MATERIAL.getValue());
        QFilter q72 = new QFilter("entryentity.material.masterid", "in", materialIds);
        QFilter q8 = new QFilter("entryentity.frozenstatus", "=", (Object)FrozenStatusEnum.UNFROZEN.getValue());
        if (materialGroupIds.isEmpty()) {
            q7 = q71.and(q72);
        } else {
            QFilter q73 = new QFilter("entryentity.type", "=", (Object)SourceListTypeEnum.MATERIALGROUP.getValue());
            QFilter q74 = new QFilter("entryentity.materialsort", "in", materialGroupIds);
            q7 = q71.and(q72).or(q73.and(q74));
        }
        DataSet query = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_sourcelist", (String)"id,org,supplier,status,enable,entryentity.type type,entryentity.material.masterid material,entryentity.materialsort materialsort,entryentity.effectdate effectdate,entryentity.expirydate expirydate,entryentity.minbillbaseqty minbillbaseqty,entryentity.maxbillbaseqty maxbillbaseqty,entryentity.packingbaseqty packingbaseqty", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6, q7, q8}, null);
        if (query != null && !query.isEmpty()) {
            for (Row row : query) {
                String type = row.getString("type");
                Long materialId = 0L;
                Long materialGroupId = 0L;
                if (SourceListTypeEnum.MATERIAL.getValue().equals(type)) {
                    materialId = row.getLong("material");
                } else if (SourceListTypeEnum.MATERIALGROUP.getValue().equals(type)) {
                    materialGroupId = row.getLong("materialsort");
                }
                Long sourceListOrgId = row.getLong("org");
                Long sourceListSupplierId = row.getLong("supplier");
                BigDecimal minorderbaseqty = row.getBigDecimal("minbillbaseqty");
                BigDecimal maxorderbaseqty = row.getBigDecimal("maxbillbaseqty");
                BigDecimal packingbaseqty = row.getBigDecimal("packingbaseqty");
                Date effectdate = row.getDate("effectdate");
                Date expirydate = row.getDate("expirydate");
                String dimenKey = this.getDimenKey(sourceListOrgId, materialId, materialGroupId, sourceListSupplierId);
                ArrayList<SourceListInfo> sourceListInfos = (ArrayList<SourceListInfo>)sourceListInfoMap.get(dimenKey);
                if (sourceListInfos == null) {
                    sourceListInfos = new ArrayList<SourceListInfo>(5);
                }
                sourceListInfos.add(new SourceListInfo(effectdate, expirydate, minorderbaseqty, maxorderbaseqty, packingbaseqty));
                sourceListInfoMap.put(dimenKey, sourceListInfos);
            }
        }
        return sourceListInfoMap;
    }

    private Map<Long, String> getParamByKey(Set<Long> orgIds, Map<String, Map<String, Object>> allParams, String paramKey, String defValue) {
        HashMap<Long, String> result = new HashMap<Long, String>();
        if (allParams == null || allParams.isEmpty()) {
            orgIds.forEach(orgId -> result.put((Long)orgId, defValue));
            return result;
        }
        for (Map.Entry<String, Map<String, Object>> entry : allParams.entrySet()) {
            Map<String, Object> value = entry.getValue();
            String resultKey = entry.getKey();
            if (value == null || resultKey == null) continue;
            Object paramValueObj = value.get(paramKey);
            String paramValue = paramValueObj instanceof String && StringUtils.isNotBlank((CharSequence)((String)paramValueObj)) ? (String)paramValueObj : defValue;
            result.put(Long.parseLong(resultKey), paramValue);
        }
        return result;
    }

    private String getDimenKey(Long orgId, Long materialId, Long materialGroupId, Long supplierId) {
        StringBuilder sb = new StringBuilder();
        sb.append(orgId).append("_").append(materialId).append("_").append(materialGroupId).append("_").append(supplierId);
        return sb.toString();
    }

    private void addPurBatchErrorMsg(ExtendedDataEntity data, String msg, String valiLevel) {
        ErrorLevel level = ErrorLevel.Error;
        if ("B".equals(valiLevel)) {
            level = ErrorLevel.Warning;
        }
        this.addMessage(data, msg, level);
    }

    private BigDecimal getDesQty(BigDecimal srcBaseQty, BigDecimal qty, BigDecimal baseQty, DynamicObject unit) {
        int precision = unit.get("precision") == null ? 10 : (Integer)unit.get("precision");
        String precisionAccount = (String)unit.get("precisionaccount");
        RoundingMode roundingMode = RoundingMode.HALF_UP;
        if ("3".equals(precisionAccount)) {
            roundingMode = RoundingMode.UP;
        } else if ("2".equals(precisionAccount)) {
            roundingMode = RoundingMode.DOWN;
        }
        BigDecimal desQty = srcBaseQty.multiply(qty).divide(baseQty, precision, roundingMode);
        return desQty;
    }

    private boolean isDivideToInt(BigDecimal qty1, BigDecimal qty2) {
        BigDecimal remainder = qty1.remainder(qty2);
        boolean flag = remainder.compareTo(BigDecimal.ZERO) == 0;
        return flag;
    }
}

