/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.order;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.pm.enums.ChangeTypeEnum;

public class PurOrderBillAllowOverPayValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(PurOrderBillAllowOverPayValidator.class);

    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("receivebaseqtyup");
        preparePropertys.add("baseqty");
        preparePropertys.add("amountup");
        preparePropertys.add("amountandtax");
        preparePropertys.add("ispresent");
        preparePropertys.add("price");
        preparePropertys.add("isallowoverpay");
        preparePropertys.add("entrychangetype");
        return preparePropertys;
    }

    public void validate() {
        block0: for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            boolean isAllowOverPay = bill.getBoolean("isallowoverpay");
            if (isAllowOverPay) continue;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            boolean hasPriceErrorCode = false;
            boolean hasUpQtyOrAmountErrorCode = false;
            if (entrys == null || entrys.size() <= 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                if (hasPriceErrorCode && hasUpQtyOrAmountErrorCode) continue block0;
                String changeType = entry.getString("entrychangetype");
                if (changeType != null && ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
                if (!hasPriceErrorCode) {
                    BigDecimal price = entry.getBigDecimal("price");
                    boolean isPresent = entry.getBoolean("ispresent");
                    if (!isPresent && price != null && BigDecimal.ZERO.compareTo(price) == 0) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u8d60\u54c1\u4e3a\u201c\u5426\u201d\u5e76\u4e14\u5355\u4ef7\u4e3a0\uff0c\u8bf7\u4fee\u6539\u8d85\u989d\u4ed8\u6b3e\u5e94\u8be5\u4e3a\u201c\u662f\u201d\u3002", (String)"PurOrderBillAllowOverPayValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]));
                        hasPriceErrorCode = true;
                    }
                }
                if (hasUpQtyOrAmountErrorCode) continue;
                BigDecimal baseQty = entry.getBigDecimal("baseqty");
                BigDecimal receiveBaseQtyUp = entry.getBigDecimal("receivebaseqtyup");
                BigDecimal amountUp = entry.getBigDecimal("amountup");
                BigDecimal amountAndTax = entry.getBigDecimal("amountandtax");
                if ((baseQty == null || receiveBaseQtyUp == null || receiveBaseQtyUp.compareTo(baseQty) <= 0) && (amountUp == null || amountAndTax == null || amountUp.compareTo(amountAndTax) <= 0)) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u201c\u5141\u8bb8\u8d85\u989d\u4ed8\u6b3e\u201d\u4e3a\u201c\u662f\u201d\uff0c\u7269\u6599\u660e\u7ec6\u6536\u8d27\u4e0a\u9650\u6570\u91cf\u5927\u4e8e\u6570\u91cf\u6216\u8005\u4e0a\u9650\u91d1\u989d\u5927\u4e8e\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"PurOrderBillAllowOverPayValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]));
                hasUpQtyOrAmountErrorCode = true;
            }
        }
    }
}

