/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.order;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scmc.pm.business.pojo.SourceListInfo;
import kd.scmc.pm.enums.ChangeTypeEnum;
import kd.scmc.pm.enums.EnableStatusEnum;
import kd.scmc.pm.enums.FrozenStatusEnum;
import kd.scmc.pm.enums.SourceListTypeEnum;
import kd.scmc.pm.enums.StatusEnum;

public class SouceControlValidator
extends AbstractValidator {
    public void validate() {
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        int length = this.dataEntities.length;
        HashSet<Long> orgIds = new HashSet<Long>(10);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            ExtendedDataEntity data = this.dataEntities[i];
            DynamicObject bill = data.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) continue;
            orgIds.add((Long)org.getPkValue());
        }
        if (orgIds.isEmpty()) {
            return;
        }
        AppParam appParam = new AppParam("/JJVO8XV9MVB", "02", null, Long.valueOf(0L));
        Map map = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)appParam, new ArrayList(orgIds));
        Map<Long, String> valiLevelMap = this.getParamByKey(orgIds, map, "purbatchcontrol", "A");
        Map<Long, String> valiSourceMap = this.getParamByKey(orgIds, map, "batchcontrolsource", "B");
        for (int i = 0; i < length; ++i) {
            ExtendedDataEntity data = this.dataEntities[i];
            DynamicObject bill = data.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObject supplier = bill.getDynamicObject("supplier");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (org == null || entrys == null || entrys.isEmpty() || supplier == null) continue;
            Long orgId = (Long)org.getPkValue();
            String validateLevel = valiLevelMap.get(orgId);
            String valiSource = valiSourceMap.get(orgId);
            Map<String, SourceListInfo> sourceListInfoMap = this.querySourceListInfo(data, validateLevel, valiSource);
            this.validateSourceControlAndPurBatch(data, sourceListInfoMap, validateLevel, valiSource);
        }
    }

    private void validateSourceControlAndPurBatch(ExtendedDataEntity data, Map<String, SourceListInfo> sourceListInfoMap, String validateLevel, String valiSource) {
        DynamicObject bill = data.getDataEntity();
        DynamicObject org = bill.getDynamicObject("org");
        Long orgId = (Long)org.getPkValue();
        DynamicObject supplier = bill.getDynamicObject("supplier");
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (int j = 0; j < entrys.size(); ++j) {
            DynamicObject entry = (DynamicObject)entrys.get(j);
            DynamicObject material = entry.getDynamicObject("material");
            String entryChangeType = entry.getString("entrychangetype");
            if ("C".equals(entryChangeType)) continue;
            SourceListInfo sourceListInfo = null;
            if (material != null) {
                boolean isapprovedsupplier = material.getBoolean("isapprovedsupplier");
                if (!isapprovedsupplier && "A".equals(validateLevel)) continue;
                DynamicObject master = material.getDynamicObject("masterid");
                if (master != null) {
                    DynamicObject group;
                    Object masterPkValue = master.getPkValue();
                    String dimenKey = this.getDimenKey(orgId, (Long)masterPkValue, 0L, (Long)supplier.getPkValue());
                    sourceListInfo = sourceListInfoMap.get(dimenKey);
                    if (sourceListInfo == null && (group = master.getDynamicObject("group")) != null) {
                        Long materialGroupId = (Long)group.getPkValue();
                        dimenKey = this.getDimenKey(orgId, 0L, materialGroupId, (Long)supplier.getPkValue());
                        sourceListInfo = sourceListInfoMap.get(dimenKey);
                    }
                    if (sourceListInfo == null && isapprovedsupplier) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u201c\u7269\u6599\u660e\u7ec6\u201d\u4e0d\u6ee1\u8db3\u201c\u8d27\u6e90\u63a7\u5236\u201d\u3002", (String)"SouceControlValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), j + 1), ErrorLevel.Error);
                    }
                }
            }
            this.validatePurBatch(data, sourceListInfo, entry, j + 1, validateLevel, valiSource);
        }
    }

    private void validatePurBatch(ExtendedDataEntity data, SourceListInfo sourceListInfo, DynamicObject entry, int rowNum, String validateLevel, String valiSource) {
        if ("A".equals(validateLevel)) {
            return;
        }
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        if (baseQty == null || BigDecimal.ZERO.compareTo(baseQty) == 0) {
            return;
        }
        BigDecimal qty = entry.getBigDecimal("qty");
        if ("A".equals(valiSource) && sourceListInfo != null) {
            String msg;
            BigDecimal sourceListMaxOrderBaseQty = sourceListInfo.getMaxOrderBaseQty();
            BigDecimal sourceListMinOrderBaseQty = sourceListInfo.getMinOrderBaseQty();
            BigDecimal sourceListPackingBaseQty = sourceListInfo.getPackingBaseQty();
            if (sourceListMaxOrderBaseQty.compareTo(BigDecimal.ZERO) != 0 && baseQty.compareTo(sourceListMaxOrderBaseQty) > 0) {
                BigDecimal maxBillQty = this.getDesQty(sourceListMaxOrderBaseQty, qty, baseQty, entry.getDynamicObject("unit"));
                msg = validateLevel.equals("C") ? String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u5927\u4e8e\u8d27\u6e90\u6e05\u5355\u4e2d\u6700\u5927\u8ba2\u5355\u91cf%2$s\uff0c\u65e0\u6cd5\u63d0\u4ea4\u8bf7\u4fee\u6539\u3002", (String)"SouceControlValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowNum, maxBillQty) : String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u5927\u4e8e\u8d27\u6e90\u6e05\u5355\u4e2d\u6700\u5927\u8ba2\u5355\u91cf%2$s\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SouceControlValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowNum, maxBillQty);
                this.addPurBatchErrorMsg(data, msg, validateLevel);
            }
            if (sourceListMinOrderBaseQty.compareTo(BigDecimal.ZERO) != 0 && baseQty.compareTo(sourceListMinOrderBaseQty) < 0) {
                BigDecimal minBillQty = this.getDesQty(sourceListMinOrderBaseQty, qty, baseQty, entry.getDynamicObject("unit"));
                msg = validateLevel.equals("C") ? String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u5c0f\u4e8e\u8d27\u6e90\u6e05\u5355\u4e2d\u6700\u5c0f\u8ba2\u5355\u91cf%2$s\uff0c\u65e0\u6cd5\u63d0\u4ea4\u8bf7\u4fee\u6539\u3002", (String)"SouceControlValidator_3", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowNum, minBillQty) : String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u5c0f\u4e8e\u8d27\u6e90\u6e05\u5355\u4e2d\u6700\u5c0f\u8ba2\u5355\u91cf%2$s\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SouceControlValidator_4", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowNum, minBillQty);
                this.addPurBatchErrorMsg(data, msg, validateLevel);
            }
            if (sourceListPackingBaseQty.compareTo(BigDecimal.ZERO) != 0 && !this.isDivideToInt(baseQty, sourceListPackingBaseQty)) {
                BigDecimal packingBillQty = this.getDesQty(sourceListPackingBaseQty, qty, baseQty, entry.getDynamicObject("unit"));
                msg = validateLevel.equals("C") ? String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u4e0d\u7b26\u5408\u8d27\u6e90\u6e05\u5355\u4e2d\u5305\u88c5\u6279\u91cf%2$s\u7684\u6574\u6570\u500d\uff0c\u65e0\u6cd5\u63d0\u4ea4\u8bf7\u4fee\u6539\u3002", (String)"SouceControlValidator_5", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowNum, packingBillQty) : String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u4e0d\u7b26\u5408\u8d27\u6e90\u6e05\u5355\u4e2d\u5305\u88c5\u6279\u91cf%2$s\u7684\u6574\u6570\u500d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SouceControlValidator_6", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowNum, packingBillQty);
                this.addPurBatchErrorMsg(data, msg, validateLevel);
            }
        } else {
            String msg;
            DynamicObject material = entry.getDynamicObject("material");
            if (material == null) {
                return;
            }
            BigDecimal matMaxOrderBaseQty = material.getBigDecimal("maxbillbaseqty");
            BigDecimal matMinOrderBaseQty = material.getBigDecimal("minbillbaseqty");
            BigDecimal matPackingBaseQty = material.getBigDecimal("packingbaseqty");
            if (matMaxOrderBaseQty.compareTo(BigDecimal.ZERO) != 0 && baseQty.compareTo(matMaxOrderBaseQty) > 0) {
                BigDecimal maxBillQty = this.getDesQty(matMaxOrderBaseQty, qty, baseQty, entry.getDynamicObject("unit"));
                msg = validateLevel.equals("C") ? String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u5927\u4e8e\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u4e2d\u6700\u5927\u8ba2\u5355\u91cf%2$s\uff0c\u65e0\u6cd5\u63d0\u4ea4\u8bf7\u4fee\u6539\u3002", (String)"SouceControlValidator_7", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowNum, maxBillQty) : String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u5927\u4e8e\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u4e2d\u6700\u5927\u8ba2\u5355\u91cf%2$s\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SouceControlValidator_8", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowNum, maxBillQty);
                this.addPurBatchErrorMsg(data, msg, validateLevel);
            }
            if (matMinOrderBaseQty.compareTo(BigDecimal.ZERO) != 0 && baseQty.compareTo(matMinOrderBaseQty) < 0) {
                BigDecimal minBillQty = this.getDesQty(matMinOrderBaseQty, qty, baseQty, entry.getDynamicObject("unit"));
                msg = validateLevel.equals("C") ? String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u5c0f\u4e8e\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u4e2d\u6700\u5c0f\u8ba2\u5355\u91cf%2$s\uff0c\u65e0\u6cd5\u63d0\u4ea4\u8bf7\u4fee\u6539\u3002", (String)"SouceControlValidator_9", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowNum, minBillQty) : String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u5c0f\u4e8e\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u4e2d\u6700\u5c0f\u8ba2\u5355\u91cf%2$s\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SouceControlValidator_10", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowNum, minBillQty);
                this.addPurBatchErrorMsg(data, msg, validateLevel);
            }
            if (matPackingBaseQty.compareTo(BigDecimal.ZERO) != 0 && !this.isDivideToInt(baseQty, matPackingBaseQty)) {
                BigDecimal packingBillQty = this.getDesQty(matPackingBaseQty, qty, baseQty, entry.getDynamicObject("unit"));
                msg = validateLevel.equals("C") ? String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u4e0d\u7b26\u5408\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u4e2d\u5305\u88c5\u6279\u91cf%2$s\u7684\u6574\u6570\u500d\uff0c\u65e0\u6cd5\u63d0\u4ea4\u8bf7\u4fee\u6539\u3002", (String)"SouceControlValidator_11", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowNum, packingBillQty) : String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8ba2\u5355\u6570\u91cf\u4e0d\u7b26\u5408\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u4e2d\u5305\u88c5\u6279\u91cf%2$s\u7684\u6574\u6570\u500d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SouceControlValidator_12", (String)"scmc-pm-opplugin", (Object[])new Object[0]), rowNum, packingBillQty);
                this.addPurBatchErrorMsg(data, msg, validateLevel);
            }
        }
    }

    private boolean isDivideToInt(BigDecimal qty1, BigDecimal qty2) {
        BigDecimal remainder = qty1.remainder(qty2);
        boolean flag = remainder.compareTo(BigDecimal.ZERO) == 0;
        return flag;
    }

    private BigDecimal getDesQty(BigDecimal srcBaseQty, BigDecimal qty, BigDecimal baseQty, DynamicObject unit) {
        int precision = unit.get("precision") == null ? 10 : (Integer)unit.get("precision");
        String precisionAccount = (String)unit.get("precisionaccount");
        RoundingMode roundingMode = RoundingMode.HALF_UP;
        if ("3".equals(precisionAccount)) {
            roundingMode = RoundingMode.UP;
        } else if ("2".equals(precisionAccount)) {
            roundingMode = RoundingMode.DOWN;
        }
        BigDecimal desQty = srcBaseQty.multiply(qty).divide(baseQty, precision, roundingMode);
        return desQty;
    }

    private Map<String, SourceListInfo> querySourceListInfo(ExtendedDataEntity data, String validateLevel, String valiSource) {
        HashMap<String, SourceListInfo> sourceListInfoMap = new HashMap<String, SourceListInfo>(10);
        DynamicObject bill = data.getDataEntity();
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject supplier = bill.getDynamicObject("supplier");
        Date bizTime = bill.getDate("biztime");
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        if (org == null || supplier == null || bizTime == null || entrys == null || entrys.isEmpty()) {
            return sourceListInfoMap;
        }
        Long orgId = (Long)org.getPkValue();
        Long supplierId = (Long)supplier.getPkValue();
        ArrayList<Long> materialIds = new ArrayList<Long>(entrys.size());
        ArrayList<Long> materialGroupIds = new ArrayList<Long>(entrys.size());
        for (DynamicObject entry : entrys) {
            DynamicObject master;
            DynamicObject material = entry.getDynamicObject("material");
            String entryChangeType = entry.getString("entrychangetype");
            if (ChangeTypeEnum.CANCEL.getValue().equals(entryChangeType) || material == null || !material.getBoolean("isapprovedsupplier") && ("A".equals(validateLevel) || !"A".equals(valiSource)) || (master = material.getDynamicObject("masterid")) == null) continue;
            materialIds.add((Long)master.getPkValue());
            DynamicObject group = master.getDynamicObject("group");
            if (group == null) continue;
            materialGroupIds.add((Long)group.getPkValue());
        }
        if (!materialIds.isEmpty()) {
            QFilter q1 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
            QFilter q2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
            QFilter q3 = new QFilter("org", "=", (Object)orgId);
            QFilter q4 = new QFilter("supplier", "=", (Object)supplierId);
            QFilter q5 = new QFilter("entryentity.effectdate", "<=", (Object)bizTime);
            QFilter q6 = new QFilter("entryentity.expirydate", ">=", (Object)bizTime);
            QFilter q7 = null;
            QFilter q71 = new QFilter("entryentity.type", "=", (Object)SourceListTypeEnum.MATERIAL.getValue());
            QFilter q72 = new QFilter("entryentity.material.masterid", "in", materialIds);
            QFilter q8 = new QFilter("entryentity.frozenstatus", "=", (Object)FrozenStatusEnum.UNFROZEN.getValue());
            if (materialGroupIds.isEmpty()) {
                q7 = q71.and(q72);
            } else {
                QFilter q73 = new QFilter("entryentity.type", "=", (Object)SourceListTypeEnum.MATERIALGROUP.getValue());
                QFilter q74 = new QFilter("entryentity.materialsort", "in", materialGroupIds);
                q7 = q71.and(q72).or(q73.and(q74));
            }
            DynamicObjectCollection query = QueryServiceHelper.query((String)"pm_sourcelist", (String)"id,org,supplier,status,enable,entryentity.type type,entryentity.material.masterid material,entryentity.materialsort materialsort,entryentity.minbillbaseqty minbillbaseqty,entryentity.maxbillbaseqty maxbillbaseqty,entryentity.packingbaseqty packingbaseqty", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6, q7, q8});
            if (query != null && !query.isEmpty()) {
                for (DynamicObject dyn : query) {
                    String type = dyn.getString("type");
                    Long materialId = 0L;
                    Long materialGroupId = 0L;
                    if (SourceListTypeEnum.MATERIAL.getValue().equals(type)) {
                        materialId = dyn.getLong("material");
                    } else if (SourceListTypeEnum.MATERIALGROUP.getValue().equals(type)) {
                        materialGroupId = dyn.getLong("materialsort");
                    }
                    Long sourceListOrgId = dyn.getLong("org");
                    Long sourceListSupplierId = dyn.getLong("supplier");
                    BigDecimal minorderbaseqty = dyn.getBigDecimal("minbillbaseqty");
                    BigDecimal maxorderbaseqty = dyn.getBigDecimal("maxbillbaseqty");
                    BigDecimal packingbaseqty = dyn.getBigDecimal("packingbaseqty");
                    sourceListInfoMap.put(this.getDimenKey(sourceListOrgId, materialId, materialGroupId, sourceListSupplierId), new SourceListInfo(minorderbaseqty, maxorderbaseqty, packingbaseqty));
                }
            }
        }
        return sourceListInfoMap;
    }

    private String getDimenKey(Long orgId, Long materialId, Long materialGroupId, Long supplierId) {
        StringBuilder sb = new StringBuilder();
        sb.append(orgId).append("_").append(materialId).append("_").append(materialGroupId).append("_").append(supplierId);
        return sb.toString();
    }

    private Map<Long, String> getParamByKey(Set<Long> orgIds, Map<String, Map<String, Object>> allParams, String paramKey, String defValue) {
        HashMap<Long, String> result = new HashMap<Long, String>();
        if (allParams == null || allParams.isEmpty()) {
            orgIds.forEach(orgId -> result.put((Long)orgId, defValue));
            return result;
        }
        for (Map.Entry<String, Map<String, Object>> entry : allParams.entrySet()) {
            Map<String, Object> value = entry.getValue();
            String resultKey = entry.getKey();
            if (value == null || resultKey == null) continue;
            Object paramValueObj = value.get(paramKey);
            String paramValue = paramValueObj instanceof String && StringUtils.isNotBlank((CharSequence)((String)paramValueObj)) ? (String)paramValueObj : defValue;
            result.put(Long.parseLong(resultKey), paramValue);
        }
        return result;
    }

    private void addPurBatchErrorMsg(ExtendedDataEntity data, String msg, String valiLevel) {
        ErrorLevel level = ErrorLevel.Error;
        if ("B".equals(valiLevel)) {
            level = ErrorLevel.Warning;
        }
        this.addMessage(data, msg, level);
    }
}

