/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.order;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.business.helper.PurOrderBillHelper;

public class XSPurOrderBillChangePrePayRateValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<Long> srcBillIds = new HashSet<Long>(10);
        String srcBillEntity = null;
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            String sourceBillEntity = bill.getString("sourcebillentity");
            Long sourceBillId = bill.getLong("sourcebillid");
            if (StringUtils.isBlank(srcBillEntity) && StringUtils.isNotBlank((CharSequence)sourceBillEntity)) {
                srcBillEntity = sourceBillEntity;
            }
            if (sourceBillId == null || sourceBillId == 0L) continue;
            srcBillIds.add(sourceBillId);
        }
        if (StringUtils.isBlank(srcBillEntity) || srcBillIds == null || srcBillIds.isEmpty()) {
            return;
        }
        QFilter idFilter = new QFilter("id", "in", srcBillIds);
        HashMap<Long, BigDecimal> sumPayAmount = new HashMap<Long, BigDecimal>(10);
        HashMap<Long, BigDecimal> srcBillPadiAmountMap = new HashMap<Long, BigDecimal>(10);
        HashMap<Long, Map<String, Object>> srcBillPayEntryMap = new HashMap<Long, Map<String, Object>>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)srcBillEntity, (String)"id,totalallamount,paidallamount,purbillentry_pay.id payentryid,purbillentry_pay.payamount as payamount,purbillentry_pay.payrate payrate,purbillentry_pay.pretimepoint pretimepoint,purbillentry_pay.isprepay isprepay", (QFilter[])new QFilter[]{idFilter}, null);){
            for (Row row : dataSet) {
                Long id = row.getLong("id");
                BigDecimal paidallamount = row.getBigDecimal("paidallamount");
                srcBillPadiAmountMap.put(id, paidallamount);
                Long payentryid = row.getLong("payentryid");
                String pretimepoint = row.getString("pretimepoint");
                BigDecimal payamount = row.getBigDecimal("payamount");
                BigDecimal payrate = row.getBigDecimal("payrate");
                Boolean isprepay = row.getBoolean("isprepay");
                HashMap<String, Comparable<BigDecimal>> map = new HashMap<String, Comparable<BigDecimal>>(3);
                map.put("payrate", payrate);
                map.put("isprepay", isprepay);
                srcBillPayEntryMap.put(payentryid, map);
                if (isprepay == null || !isprepay.booleanValue() || !"B".equals(pretimepoint) && !" ".equals(pretimepoint)) continue;
                BigDecimal sum = sumPayAmount.get(id) == null ? BigDecimal.ZERO : (BigDecimal)sumPayAmount.get(id);
                sum = sum.add(payamount);
                sumPayAmount.put(id, sum);
            }
            sumPayAmount.entrySet().forEach(entry -> this.getOption().setVariableValue(PurOrderBillHelper.getBillPayMountKey((Long)((Long)entry.getKey())), ((BigDecimal)entry.getValue()).toString()));
        }
        if (srcBillPadiAmountMap.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject xbill = dataEntity.getDataEntity();
            Long sourceBillId = xbill.getLong("sourcebillid");
            if (sourceBillId == null || Long.compare(sourceBillId, 0L) == 0) continue;
            this.checkPrePayRateChanged(dataEntity, sourceBillId, srcBillPadiAmountMap, srcBillPayEntryMap);
        }
    }

    private void checkPrePayRateChanged(ExtendedDataEntity dataEntity, Long sourceBillId, Map<Long, BigDecimal> srcBillPadiAmountMap, Map<Long, Map<String, Object>> srcBillPayEntryMap) {
        DynamicObject xbill = dataEntity.getDataEntity();
        BigDecimal xTotalAmount = xbill.getBigDecimal("totalallamount");
        BigDecimal srcPaidAmount = srcBillPadiAmountMap.get(sourceBillId);
        if (xTotalAmount != null && srcPaidAmount != null && xTotalAmount.compareTo(srcPaidAmount) > 0) {
            return;
        }
        DynamicObjectCollection xPayEntrys = xbill.getDynamicObjectCollection("purbillentry_pay");
        if (xPayEntrys != null && !xPayEntrys.isEmpty()) {
            boolean hasIsPrePayEntry = false;
            for (int i = 0; i < xPayEntrys.size(); ++i) {
                DynamicObject xpayEntry = (DynamicObject)xPayEntrys.get(i);
                boolean isPrePay = xpayEntry.getBoolean("isprepay");
                if (!isPrePay) continue;
                hasIsPrePayEntry = true;
                break;
            }
            if (!hasIsPrePayEntry) {
                return;
            }
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\u4ef7\u7a0e\u5408\u8ba1\u5c0f\u4e8e\u7b49\u4e8e\u8ba2\u5355\u5df2\u4ed8\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u4ed8\u6b3e\u8ba1\u5212\u9884\u4ed8\u884c\u7684\u4ed8\u6b3e\u6bd4\u4f8b\u3002", (String)"XSPurOrderBillChangePrePayRateValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), xbill.getString("changebillno"));
            for (int i = 0; i < xPayEntrys.size(); ++i) {
                DynamicObject xpayEntry = (DynamicObject)xPayEntrys.get(i);
                boolean isPrePay = xpayEntry.getBoolean("isprepay");
                if (!isPrePay) continue;
                Long sourceEntryId = xpayEntry.getLong("payentrysrcid");
                if (sourceEntryId == null || sourceEntryId.equals(0L)) {
                    this.addMessage(dataEntity, msg, ErrorLevel.Error);
                    return;
                }
                BigDecimal xPayRate = xpayEntry.getBigDecimal("payrate");
                Map<String, Object> map = srcBillPayEntryMap.get(sourceEntryId);
                if (map == null) {
                    this.addMessage(dataEntity, msg, ErrorLevel.Error);
                    return;
                }
                Object isprepay = map.get("isprepay");
                Object payrate = map.get("payrate");
                if ((!(isprepay instanceof Boolean) || ((Boolean)isprepay).booleanValue()) && (!(payrate instanceof BigDecimal) || xPayRate == null || xPayRate.compareTo((BigDecimal)payrate) == 0)) continue;
                this.addMessage(dataEntity, msg, ErrorLevel.Error);
                return;
            }
        }
    }
}

