/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.plan;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.scmc.pm.enums.ChangeTypeEnum;

public class XPurPlanSubmitValidator
extends AbstractValidator {
    private final BigDecimal ZERO = BigDecimal.ZERO;

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (entrys == null || entrys.size() <= 0) continue;
            for (DynamicObject entry : entrys) {
                BigDecimal baseQty;
                int seq = entry.getInt("seq");
                String entryChangeType = entry.getString("entrychangetype");
                BigDecimal joinBaseQty = entry.getBigDecimal("joinbaseqty");
                if (this.ZERO.compareTo(joinBaseQty) < 0 && ChangeTypeEnum.CANCEL.getValue().equals(entryChangeType)) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u201c\u5173\u8054\u6570\u91cf\u201d\u5927\u4e8e0\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"XPurPlanSubmitValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), seq), ErrorLevel.Error);
                }
                if ((baseQty = entry.getBigDecimal("baseqty")) == null || baseQty.compareTo(joinBaseQty) >= 0 || !ChangeTypeEnum.UPDATE.getValue().equals(entryChangeType)) continue;
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u53d8\u66f4\u540e\u7684\u201c\u6570\u91cf\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u201c\u5173\u8054\u6570\u91cf\u201d\u3002", (String)"XPurPlanSubmitValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), seq), ErrorLevel.Error);
            }
            boolean isAllCancel = true;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject billEntry = (DynamicObject)entrys.get(i);
                if (ChangeTypeEnum.CANCEL.getValue().equals(billEntry.getString("entrychangetype"))) continue;
                isAllCancel = false;
                break;
            }
            if (!isAllCancel) continue;
            this.addMessage(data, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u4e0d\u5141\u8bb8\u5168\u90e8\u53d6\u6d88\u3002", (String)"XPurPlanSubmitValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }
}

