/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.tpl;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AmountDirectionValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(AmountDirectionValidator.class);

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (entrys == null || entrys.size() <= 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                BigDecimal qty = entry.getBigDecimal("qty");
                BigDecimal taxAmount = entry.getBigDecimal("taxamount");
                BigDecimal discountAmount = entry.getBigDecimal("discountamount");
                BigDecimal amount = entry.getBigDecimal("amount");
                BigDecimal amountAndTax = entry.getBigDecimal("amountandtax");
                if (qty == null || taxAmount == null || discountAmount == null || amount == null || amountAndTax == null || qty.compareTo(BigDecimal.ZERO) >= 0 && taxAmount.compareTo(BigDecimal.ZERO) >= 0 && discountAmount.compareTo(BigDecimal.ZERO) >= 0 && amount.compareTo(BigDecimal.ZERO) >= 0 && amountAndTax.compareTo(BigDecimal.ZERO) >= 0 || qty.compareTo(BigDecimal.ZERO) <= 0 && taxAmount.compareTo(BigDecimal.ZERO) <= 0 && discountAmount.compareTo(BigDecimal.ZERO) <= 0 && amount.compareTo(BigDecimal.ZERO) <= 0 && amountAndTax.compareTo(BigDecimal.ZERO) <= 0) continue;
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7b2c%1$s\u884c\u7684\u201c\u6570\u91cf\u3001\u91d1\u989d\u3001\u7a0e\u989d\u3001\u6298\u6263\u989d\u3001\u4ef7\u7a0e\u5408\u8ba1\u201c\u7684\u65b9\u5411\u5fc5\u987b\u4e00\u81f4\u3002", (String)"AmountDirectionValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
            }
        }
    }
}

