/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.tpl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class InvoiceBizTypeValidator
extends AbstractValidator {
    public void validate() {
        String appId = this.getValidateContext().getBillEntityType().getAppId();
        if (this.getDataEntities() == null || this.getDataEntities().length == 0 || appId == null) {
            return;
        }
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        if (appInfo == null) {
            return;
        }
        HashSet<Long> invoiceBizTypeSet = new HashSet<Long>(10);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObject invoiceBizType = bill.getDynamicObject("invoicebiztype");
            if (invoiceBizType == null) continue;
            invoiceBizTypeSet.add((Long)invoiceBizType.getPkValue());
        }
        if (invoiceBizTypeSet.isEmpty()) {
            return;
        }
        String bizCloudId = appInfo.getCloudId();
        QFilter qFilterNmuber = new QFilter("mulbiz.fbasedataid.id", "=", (Object)bizCloudId);
        QFilter qFilterPkValue = new QFilter("id", "in", invoiceBizTypeSet);
        Map invoiceBizTypes = BusinessDataServiceHelper.loadFromCache((String)"bd_invoicebiztype", (String)"id", (QFilter[])new QFilter[]{qFilterNmuber.and(qFilterPkValue)});
        Set<Object> invoiceBizTypeIdSet = invoiceBizTypes == null ? new HashSet() : invoiceBizTypes.keySet();
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObject invoiceBizType = bill.getDynamicObject("invoicebiztype");
            if (invoiceBizType == null) continue;
            Long invoiceBizTypeId = (Long)invoiceBizType.getPkValue();
            if (invoiceBizType == null || invoiceBizTypeIdSet.contains(invoiceBizTypeId)) continue;
            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u522b\u201c%1$s\u201d\u7684\u5e94\u7528\u9886\u57df\u9700\u8981\u5305\u62ec\u201c\u4f9b\u5e94\u94fe\u4e91\u201d\uff0c\u8bf7\u5230\u57fa\u7840\u8d44\u6599\u4e2d\u8c03\u6574\uff0c\u6216\u91cd\u9009\u53d1\u7968\u7c7b\u522b\u3002", (String)"InvoiceBizTypeValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), invoiceBizType.get("number")), ErrorLevel.Error);
        }
    }
}

