/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pmp.validation.price;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.pmp.business.helper.PurStairPriceHelper;

public class PurPriceSubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            boolean istax = bill.getBoolean("istax");
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("priceentryentity");
            if (entries == null || entries.size() <= 0) continue;
            for (DynamicObject entry : entries) {
                BigDecimal maxPrice;
                BigDecimal priceandtax = entry.getBigDecimal("priceandtax");
                BigDecimal price = entry.getBigDecimal("price");
                if (istax) {
                    if (BigDecimal.ZERO.compareTo(priceandtax) == 0) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ef7\u683c\u660e\u7ec6\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\u201c\u542b\u7a0e\u5355\u4ef7\u201d\u3002", (String)"PurPriceSubmitValidator_8", (String)"scmc-pm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    }
                } else if (BigDecimal.ZERO.compareTo(price) == 0) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ef7\u683c\u660e\u7ec6\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\u201c\u5355\u4ef7\u201d\u3002", (String)"PurPriceSubmitValidator_9", (String)"scmc-pm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                }
                BigDecimal priceFloor = entry.getBigDecimal("pricefloor");
                BigDecimal priceCeiling = entry.getBigDecimal("priceceiling");
                if (priceCeiling.compareTo(BigDecimal.ZERO) > 0 && priceFloor.compareTo(priceCeiling) > 0) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%s\u884c\u6700\u9ad8\u9650\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6700\u4f4e\u9650\u4ef7\u3002", (String)"PurPriceSubmitValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                }
                if (priceCeiling.compareTo(BigDecimal.ZERO) > 0 && priceandtax.compareTo(priceCeiling) > 0) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%s\u884c\u542b\u7a0e\u5355\u4ef7\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u6700\u9ad8\u9650\u4ef7\u3002", (String)"PurPriceSubmitValidator_6", (String)"scmc-pm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                }
                if (priceFloor.compareTo(BigDecimal.ZERO) > 0 && priceandtax.compareTo(priceFloor) < 0) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%s\u884c\u542b\u7a0e\u5355\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6700\u4f4e\u9650\u4ef7\u3002", (String)"PurPriceSubmitValidator_7", (String)"scmc-pm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                }
                Date priceEffDate = entry.getDate("priceeffectdate");
                Date priceExpDate = entry.getDate("priceexpirydate");
                if (priceExpDate != null && priceEffDate != null && priceEffDate.after(priceExpDate)) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%s\u884c\u4ef7\u683c\u751f\u6548\u65e5\u671f\u9700\u5c0f\u4e8e\u7b49\u4e8e\u4ef7\u683c\u5931\u6548\u65e5\u671f\u3002", (String)"PurPriceSubmitValidator_3", (String)"scmc-pm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                }
                BigDecimal qtyFrom = entry.getBigDecimal("qtyfrom");
                BigDecimal qtyTo = entry.getBigDecimal("qtyto");
                if (qtyTo.compareTo(BigDecimal.ZERO) != 0 && qtyTo.subtract(qtyFrom).compareTo(BigDecimal.ZERO) < 0) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%s\u884c\u91c7\u8d2d\u6570\u91cf\uff08\u4ece\uff09\u5e94\u5c0f\u4e8e\u91c7\u8d2d\u6570\u91cf\uff08\u81f3\uff09\u3002", (String)"PurPriceSubmitValidator_5", (String)"scmc-pm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                }
                if (!entry.getBoolean("isstairprice")) continue;
                DynamicObjectCollection stairPrices = (DynamicObjectCollection)entry.get("purstairprice");
                BigDecimal minPrice = entry.getBigDecimal("pricefloor");
                int count = PurStairPriceHelper.getCheckStairPrice((BigDecimal)minPrice, (BigDecimal)(maxPrice = entry.getBigDecimal("priceceiling")), (DynamicObjectCollection)stairPrices);
                if (count == 0) continue;
                String msgDetail = PurStairPriceHelper.getDetailMsg((int)count);
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ef7\u683c\u660e\u7ec6\u7684\u9636\u68af\u4ef7\u683c\u5b50\u5206\u5f55\u7ef4\u62a4\u6709\u8bef\uff1a", (String)"SalesPriceSubmitValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), entry.getInt("seq")) + msgDetail;
                this.addMessage(data, msg);
            }
        }
    }
}

