/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pmp.mservice.priceControl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceControlHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceEntityKeyInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.pricecontrol.PriceControlParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.pricecontrol.PriceControlSchemeColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.pricecontrol.PriceControlStrategeColl;
import kd.mpscmm.msbd.pricemodel.business.service.pricecontrol.PriceControlEngine;
import kd.mpscmm.msbd.pricemodel.common.enums.PriceControlLevelEnum;
import kd.scmc.pmp.mservice.api.priceControl.PriceControlService;

public class PriceControlServiceImpl
implements PriceControlService {
    private static final Log log = LogFactory.getLog(PriceControlServiceImpl.class);

    public Map<String, Object> queryMapKeyIgnoreExp(String entityType, Map<String, Object> param) {
        Map<Object, Object> keyResult = new HashMap();
        try {
            PriceControlStrategeColl strategeColl = PriceControlHelper.fetchSchemeFromST((String)entityType, param);
            if (strategeColl == null) {
                String message = ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u9650\u4ef7\u7b56\u7565\u3002", (String)"PriceControlServiceImpl_0", (String)"scmc-pms-mservice", (Object[])new Object[0]);
                keyResult.put("msg", message);
                keyResult.put("success", Boolean.FALSE);
            } else if (strategeColl.getSchemeCollMapping().size() == 0) {
                String message = ResManager.loadKDString((String)"\u9650\u4ef7\u7b56\u7565\u4e2d\u672a\u627e\u5230\u6709\u6548\u7684\u9650\u4ef7\u65b9\u6848\u3002", (String)"PriceControlServiceImpl_1", (String)"scmc-pms-mservice", (Object[])new Object[0]);
                keyResult.put("msg", message);
                keyResult.put("success", Boolean.FALSE);
            } else {
                PriceEntityKeyInfo qccInfo = PriceControlHelper.getQuoteCommonConst((String)entityType, (PriceControlStrategeColl)strategeColl);
                keyResult = PriceControlHelper.getHeaderAndEntryKeysWithFlag((PriceControlStrategeColl)strategeColl, (PriceEntityKeyInfo)qccInfo);
            }
        }
        catch (KDBizException e) {
            keyResult = this.genExceptionResult(e);
        }
        catch (Exception e1) {
            keyResult = this.genExceptionResult(new KDBizException(e1.getMessage()));
        }
        return keyResult;
    }

    public Map<Long, Map<String, Object>> check(Map<Long, List<Map<String, Object>>> propertiesMap, String entityType, Map<String, Object> param) {
        HashMap<Long, Map<String, Object>> allPriceMap = new HashMap<Long, Map<String, Object>>();
        propertiesMap.forEach((orgID, lists) -> {
            try {
                param.put("appnum", "pmp");
                HashMap<String, Object> priceAllMap = new HashMap<String, Object>();
                HashSet priceControlRecord = new HashSet();
                PriceControlStrategeColl strategeColl = PriceControlHelper.fetchSchemeFromST((Long)orgID, (String)entityType, (Map)param);
                if (strategeColl != null && strategeColl.getSchemeCollMapping().size() > 0) {
                    PriceEntityKeyInfo qccInfo = PriceControlHelper.getQuoteCommonConst((String)entityType, (PriceControlStrategeColl)strategeColl);
                    DataSet quoteOriginDataSet = PriceControlHelper.buildQuoteDataSetByMap((List)lists, (String)entityType, (PriceControlStrategeColl)strategeColl, (PriceEntityKeyInfo)qccInfo);
                    for (int k2 = 0; k2 < strategeColl.getPriceControlStrateges().size(); ++k2) {
                        PriceControlSchemeColl schemeColl = strategeColl.getPriceControlSchemeColl(((DynamicObject)strategeColl.getPriceControlStrateges().get(k2)).getPkValue());
                        DataSet schemeOriginDataSet = k2 != strategeColl.getPriceControlStrateges().size() - 1 ? quoteOriginDataSet.copy() : quoteOriginDataSet;
                        PriceControlParam priceProcessParam = new PriceControlParam(schemeOriginDataSet, orgID, qccInfo, entityType, param);
                        try {
                            PriceControlEngine engine = new PriceControlEngine();
                            Set result = engine.start(schemeColl, priceProcessParam);
                            priceControlRecord.addAll(result);
                            continue;
                        }
                        catch (KDBizException e2) {
                            throw e2;
                        }
                        catch (Exception e1) {
                            throw e1;
                        }
                    }
                    HashMap priceControlMap = new HashMap();
                    if (Boolean.TRUE.equals(param.get("isWholeInfo"))) {
                        priceControlRecord.forEach(value -> {
                            String[] recs = value.split("\\$\\$");
                            String id = recs[0];
                            List billControlRecs = priceControlMap.computeIfAbsent(id, s -> new ArrayList());
                            billControlRecs.add(value);
                        });
                    } else {
                        HashMap<String, String> uniqueMap = new HashMap<String, String>();
                        priceControlRecord.forEach(e -> {
                            String level;
                            String[] recs = e.split("\\$\\$");
                            String key = recs[0] + "$$" + recs[1] + "$$" + recs[2];
                            String value = uniqueMap.computeIfPresent(key, (arg_0, arg_1) -> PriceControlServiceImpl.lambda$null$2(level = recs[3], arg_0, arg_1));
                            if (value == null) {
                                uniqueMap.put(key, level);
                            }
                        });
                        uniqueMap.forEach((k, v) -> {
                            String[] recs = k.split("\\$\\$");
                            String id = recs[0];
                            String value = k + "$$" + v;
                            List billControlRecs = priceControlMap.computeIfAbsent(id, s -> new ArrayList());
                            billControlRecs.add(value);
                        });
                    }
                    priceAllMap.put("checkresult", priceControlMap);
                    priceAllMap.put("success", Boolean.TRUE);
                    allPriceMap.put((Long)orgID, (Map<String, Object>)priceAllMap);
                } else {
                    Boolean strictlycontrol = (Boolean)SysParamHelper.getSysParam((String)"0TQ1U=8EFQKR", null, (Long)orgID, (String)"strictlycontrol");
                    if (strictlycontrol.booleanValue()) {
                        String msg = ResManager.loadKDString((String)"\u9650\u4ef7\u4e25\u683c\u63a7\u5236\u53c2\u6570\u542f\u7528\uff0c\u8bf7\u8bbe\u7f6e\u9650\u4ef7\u7b56\u7565\u3002", (String)"PriceControlServiceImpl_2", (String)"scmc-pms-mservice", (Object[])new Object[0]);
                        priceAllMap.put("success", Boolean.FALSE);
                        priceAllMap.put("msg", msg);
                        priceAllMap.put("level", PriceControlLevelEnum.BAN.getValue());
                    } else {
                        priceAllMap.put("success", Boolean.TRUE);
                    }
                    allPriceMap.put((Long)orgID, (Map<String, Object>)priceAllMap);
                }
            }
            catch (KDBizException e3) {
                Map<String, Object> quoteResult = this.genExceptionResult(e3);
                allPriceMap.put((Long)orgID, quoteResult);
            }
            catch (Exception e1) {
                Map<String, Object> quoteResult = this.genExceptionResult(new KDBizException(e1.getMessage()));
                allPriceMap.put((Long)orgID, quoteResult);
            }
        });
        return allPriceMap;
    }

    private Map<String, Object> genExceptionResult(KDBizException e) {
        return this.setFailResult(e);
    }

    private Map<String, Object> setFailResult(KDBizException e) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String msg = ResManager.loadKDString((String)"\u9650\u4ef7\u5f02\u5e38\uff1a%s\u3002", (String)"PriceControlServiceImpl_3", (String)"scmc-pms-mservice", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((String)e.getMessage())) {
            String markMsg = ResManager.loadKDString((String)"\u9650\u4ef7\u5931\u8d25", (String)"PriceControlServiceImpl_4", (String)"scmc-pms-mservice", (Object[])new Object[0]);
            if (!e.getMessage().contains(markMsg)) {
                result.put("msg", String.format(msg, e.getMessage()));
            } else {
                result.put("msg", String.format(msg, e.getMessage().replaceAll(markMsg, "")));
            }
        } else {
            result.put("msg", String.format(msg, ((Object)((Object)e)).getClass().getName()));
        }
        result.put("success", Boolean.FALSE);
        result.put("level", PriceControlLevelEnum.BAN.getValue());
        return result;
    }

    private static /* synthetic */ String lambda$null$2(String level, String s, String o) {
        if (PriceControlLevelEnum.BAN.getValue().equals(o)) {
            return PriceControlLevelEnum.BAN.getValue();
        }
        return level;
    }

    static class KEY {
        private static final String MSG = "msg";
        private static final String SUCCESS = "success";
        private static final String LEVEL = "level";
        private static final String CHECKRESULT = "checkresult";

        KEY() {
        }
    }
}

