/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.business.task;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class CleanQuoteLogTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(CleanQuoteLogTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        int keepMonth = 3;
        if (map != null) {
            log.info("CleanQuoteLogTask's param = " + map);
            if (map.get("keepmonth") != null && map.get("keepmonth") instanceof String) {
                String keepMonthStr = (String)map.get("keepmonth");
                try {
                    keepMonth = Integer.parseInt(keepMonthStr);
                }
                catch (Exception e) {
                    log.info("CleanQuoteLogTask's param require int type ");
                }
            }
        } else {
            log.info("CleanQuoteLogTask's param = ");
        }
        Date dateNow = this.getDateStartTime(TimeServiceHelper.now());
        Instant instant = dateNow.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDate compareDate = localDateTime.toLocalDate().minusMonths(keepMonth);
        java.sql.Date keepStartTime = java.sql.Date.valueOf(compareDate);
        QFilter dateFilter = new QFilter("quoteendtime", "<=", (Object)keepStartTime);
        DeleteServiceHelper.delete((String)"plat_quotelog", (QFilter[])new QFilter[]{dateFilter});
    }

    private Date getDateStartTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = formatter.format(cal.getTime());
        try {
            Date dateNew = formatter.parse(dateStr);
            return dateNew;
        }
        catch (ParseException e) {
            throw new KDBizException(e.getMessage());
        }
    }
}

