/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.common.colsAssist;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.BasedataProp;
import kd.scmc.sbs.business.common.colsAssist.DefaultSelectStrategy;

public class CompositeStrategy
extends DefaultSelectStrategy {
    private List<DefaultSelectStrategy> strategies = new ArrayList<DefaultSelectStrategy>();
    private BiFunction<String, BasedataProp, Set<String>> getNeedColsFunction;

    public CompositeStrategy(List<DefaultSelectStrategy> strategies) {
        this.strategies = strategies;
    }

    @Override
    public boolean filterPro(IDataEntityProperty pro) {
        for (DefaultSelectStrategy strategy : this.strategies) {
            if (strategy.filterPro(pro)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean filterEntryPro(EntryType pro) {
        for (DefaultSelectStrategy strategy : this.strategies) {
            if (strategy.filterEntryPro(pro)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean filterBaseDataPro(BasedataProp pro) {
        for (DefaultSelectStrategy strategy : this.strategies) {
            if (strategy.filterBaseDataPro(pro)) continue;
            return false;
        }
        return true;
    }

    public void setNeedColsFunction(BiFunction<String, BasedataProp, Set<String>> getNeedColsFunction) {
        this.getNeedColsFunction = getNeedColsFunction;
    }

    @Override
    public Set<String> getNeedColsOfBaseData(String baseDataNo) {
        return new HashSet<String>();
    }

    @Override
    public Set<String> getNeedColsOfBaseData(String baseDataNo, BasedataProp basedataProp) {
        Set<String> cols = new HashSet<String>();
        if (this.getNeedColsFunction != null) {
            cols = this.getNeedColsFunction.apply(baseDataNo, basedataProp);
        }
        return cols;
    }
}

