/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.reservation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.paramentity.bizrule.reserve.pojo.ReserveOrBillInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.sbs.business.reservation.ReserveSchemeHander;
import kd.scmc.sbs.business.reservation.model.ReserveArgs;
import kd.scmc.sbs.business.reservation.model.ReserveContext;
import kd.scmc.sbs.business.reservation.model.ReserveSchemeInfo;
import kd.scmc.sbs.business.reservation.singleaction.CreateSrcReserveAction;
import kd.scmc.sbs.business.reservation.singleaction.InitVariableAction;
import kd.scmc.sbs.business.reservation.singleaction.ReserveLogicaUnit;

public class ReserceCreateHelper {
    public static Map<String, Object> getReserceCreateInfos(List<ReserveOrBillInfo> orBillInfos, ReserveSchemeInfo schemeInfo) {
        ReserveArgs<ReserveOrBillInfo> reserveArgs = new ReserveArgs<ReserveOrBillInfo>();
        reserveArgs.setSelectRows(orBillInfos);
        ReserveContext reserveContext = new ReserveContext(reserveArgs, schemeInfo.getColsMap());
        CreateSrcReserveAction srcReserves = new CreateSrcReserveAction(reserveContext);
        ((ReserveLogicaUnit)srcReserves).doAction();
        if (reserveContext.getReserveSrcRealseRows().size() > 0) {
            throw new KDBizException(ReserceCreateHelper.getMsgReserveSchemeInfoError());
        }
        Map<Object, List<Object>> matchInvStock = ReserceCreateHelper.getMatchInvStock(orBillInfos, schemeInfo);
        reserveContext = new ReserveContext(reserveArgs, schemeInfo, matchInvStock);
        InitVariableAction reserveLogicaUnit = new InitVariableAction(reserveContext);
        ((ReserveLogicaUnit)reserveLogicaUnit).doAction();
        reserveContext.setMapHaveReserve(ReserceCreateHelper.getHaveReserveAll(reserveContext.getParamSetting(), reserveContext.getLstOrBillObjs(), ReserceCreateHelper.getReserveRescords(orBillInfos)));
        return ReserceCreateHelper.getOutMapByReserveView(reserveContext);
    }

    private static Map<Object, List<Object>> getMatchInvStock(List<ReserveOrBillInfo> orBillInfos, ReserveSchemeInfo schemeInfo) {
        Set ids = orBillInfos.stream().map(ReserveOrBillInfo::getInterID).collect(Collectors.toSet());
        Set entryIds = orBillInfos.stream().map(ReserveOrBillInfo::getEntryID).collect(Collectors.toSet());
        HashMap<Object, List<Object>> matchResultlst = new HashMap<Object, List<Object>>();
        for (Object id : ids) {
            Map<Object, List<Object>> matchResult = new ReserveSchemeHander(schemeInfo, id).matchInvStock();
            Iterator<Map.Entry<Object, List<Object>>> it = matchResult.entrySet().iterator();
            while (it.hasNext()) {
                if (entryIds.contains(it.next().getKey().toString())) continue;
                it.remove();
            }
            if (ObjectUtils.isEmpty(matchResult)) continue;
            matchResultlst.putAll(matchResult);
        }
        return matchResultlst;
    }

    private static Map<String, Object> getOutMapByReserveView(ReserveContext reserveContext) {
        HashMap<String, Object> reserveViewInfos = new HashMap<String, Object>();
        reserveViewInfos.put("orbilldymicobjs", reserveContext.getLstOrBillObjs());
        reserveViewInfos.put("havingreserveentry", reserveContext.getMapHaveReserve());
        reserveViewInfos.put("invaccinfos", reserveContext.getInvStockInos());
        reserveViewInfos.put("billmatchinvacc", reserveContext.getMatchInvacc());
        reserveViewInfos.put("reserveresult", reserveContext.getResult().getMessage());
        reserveViewInfos.put("reservesuccess", reserveContext.getResult().isSuceese());
        return reserveViewInfos;
    }

    private static String getMsgReserveSchemeInfoError() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7684\u4e0a\u6e38\u5355\u636e\u6709\u505a\u9884\u7559\uff0c\u8bf7\u5148\u624b\u5de5\u91ca\u653e\u9884\u7559\uff0c\u518d\u8fdb\u884c\u9884\u7559\u5904\u7406\u3002", (String)"ReserceCreateHelper_0", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private static List<DynamicObject> getReserveRescords(List<ReserveOrBillInfo> orBillInfos) {
        HashSet demnadEntryIds = new HashSet();
        HashSet formIds = new HashSet();
        orBillInfos.forEach(p -> {
            demnadEntryIds.add(Long.valueOf(p.getEntryID()));
            formIds.add(p.getFormId());
        });
        QFilter demandIdFilter = new QFilter("billentry_id", "in", demnadEntryIds);
        QFilter demandBillTypeFilter = new QFilter("bill_obj", "in", formIds);
        QFilter reserveQtyFilter = new QFilter("base_qty", ">", (Object)0);
        Map reserveRescords = BusinessDataServiceHelper.loadFromCache((String)"msmod_reserve_record", (QFilter[])new QFilter[]{demandIdFilter, demandBillTypeFilter, reserveQtyFilter});
        return new ArrayList<DynamicObject>(reserveRescords.values());
    }

    private static Map<Object, BigDecimal> getHaveReserveAll(Map<String, Object> paramMap, List<DynamicObject> lstOrBillObjs, List<DynamicObject> reserveRescords) {
        HashMap<Object, BigDecimal> mapEntrydHasReserveQty = new HashMap<Object, BigDecimal>();
        if (lstOrBillObjs == null || lstOrBillObjs.isEmpty()) {
            return mapEntrydHasReserveQty;
        }
        String formId = lstOrBillObjs.get(0).getDataEntityType().getName();
        lstOrBillObjs.forEach(p -> {
            String billId = String.valueOf(p.getPkValue());
            DynamicObjectCollection entryObjs = p.getDynamicObjectCollection(String.valueOf(paramMap.get("billentry")));
            entryObjs.forEach(m -> {
                String entryId = String.valueOf(m.getPkValue());
                BigDecimal hasReservedQty = BigDecimal.ZERO;
                BigDecimal hasReservedUnitQty = BigDecimal.ZERO;
                BigDecimal hasReserved2ndQty = BigDecimal.ZERO;
                for (DynamicObject reserve : reserveRescords) {
                    String demandId = reserve.getString("bill_id");
                    String demandEntryId = reserve.getString("billentry_id");
                    String demandFormId = (String)reserve.getDynamicObject("bill_obj").getPkValue();
                    if (!formId.equals(demandFormId) || !billId.equals(demandId) || !entryId.equals(demandEntryId)) continue;
                    hasReservedQty = hasReservedQty.add(reserve.getBigDecimal("base_qty"));
                    hasReservedUnitQty = hasReservedUnitQty.add(reserve.getBigDecimal("qty"));
                    hasReserved2ndQty = hasReserved2ndQty.add(reserve.getBigDecimal("qty2nd"));
                }
                if (hasReservedQty.compareTo(BigDecimal.ZERO) > 0) {
                    mapEntrydHasReserveQty.put(entryId + "," + "reservebaseqty", hasReservedQty);
                }
                if (hasReservedUnitQty.compareTo(BigDecimal.ZERO) > 0) {
                    mapEntrydHasReserveQty.put(entryId + "," + "reserveqty", hasReservedUnitQty);
                }
                if (hasReserved2ndQty.compareTo(BigDecimal.ZERO) > 0) {
                    mapEntrydHasReserveQty.put(entryId + "," + "reserveunit2ndqty", hasReserved2ndQty);
                }
            });
        });
        return mapEntrydHasReserveQty;
    }
}

