/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.reservation.singleaction;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.scmc.sbs.business.reservation.ReserveHelper;
import kd.scmc.sbs.business.reservation.model.ReserveContext;
import kd.scmc.sbs.business.reservation.model.ReserveLinkSelectRow;
import kd.scmc.sbs.business.reservation.model.ReserveLinkSupplyRow;
import kd.scmc.sbs.business.reservation.singleaction.ReserveLogicaUnit;
import kd.scmc.sbs.common.pagemodel.ImInvacc;

public class CheckInvaccAvailableQty
extends ReserveLogicaUnit {
    public CheckInvaccAvailableQty(ReserveContext reserveContext) {
        this.context = reserveContext;
    }

    @Override
    public void doAction() {
        Map<String, BigDecimal> invaccNeedQty = this.getNeedReserveQty();
        ReserveHelper.checkAvailadQtyByAccId(invaccNeedQty);
    }

    private Map<String, BigDecimal> getNeedReserveQty() {
        List<ReserveLinkSelectRow> linkSelectRows = this.context.getLinkSelectRows();
        HashMap<String, BigDecimal> invaccQty = new HashMap<String, BigDecimal>();
        for (ReserveLinkSelectRow reserveLinkSelectRow : linkSelectRows) {
            for (ReserveLinkSupplyRow supplyRow : reserveLinkSelectRow.getSupplyRows()) {
                if (!supplyRow.getSupplyBillInfo().getFormId().equals(ImInvacc.getBalTb())) continue;
                String accId = supplyRow.getSupplyBillInfo().getEntryID();
                String baseKey = accId + "," + "reservebaseqty";
                String unitKey = accId + "," + "reserveqty";
                String unit2ndKey = accId + "," + "reserveunit2ndqty";
                BigDecimal baseQty = invaccQty.computeIfAbsent(baseKey, k -> BigDecimal.ZERO);
                BigDecimal qty = invaccQty.computeIfAbsent(unitKey, k -> BigDecimal.ZERO);
                BigDecimal unit2ndQty = invaccQty.computeIfAbsent(unit2ndKey, k -> BigDecimal.ZERO);
                invaccQty.put(baseKey, baseQty.add(supplyRow.getBaseSupplyQty()));
                invaccQty.put(unitKey, qty.add(supplyRow.getSupplyQty()));
                invaccQty.put(unit2ndKey, unit2ndQty.add(supplyRow.getSupply2ndQty()));
            }
        }
        return invaccQty;
    }
}

