/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.reservation.singleaction;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.ext.scmc.paramentity.bizrule.reserve.pojo.ReserveOrBillInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.sbs.business.reservation.model.BalReserveQtyArgs;
import kd.scmc.sbs.business.reservation.model.ReserveArgs;
import kd.scmc.sbs.business.reservation.model.ReserveContext;
import kd.scmc.sbs.business.reservation.singleaction.ReserveLogicaUnit;
import kd.scmc.sbs.common.pagemodel.ImInvacc;

public class InitVariableAction
extends ReserveLogicaUnit {
    private static final String[] SELECT_FIELD = new String[]{"supplybillid", "supplyformid", "demanbasedunit", "reservebaseqty", "demandunit", "reserveqty", "demandunit2nd", "reserveunit2ndqty"};

    public InitVariableAction(ReserveContext reserveContext) {
        this.context = reserveContext;
        this.reserveOperateResult = reserveContext.getResult();
    }

    private String getMsgCheckInitVariableAction() {
        return ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9884\u7559\u65b9\u6848\u4e2d\u7684\u201c\u9884\u7559\u6761\u4ef6\u201d\u548c\u201c\u5373\u65f6\u5e93\u5b58\u201d\u3002", (String)"InitVariableAction_0", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    @Override
    public void doAction() {
        if (this.reserveOperateResult.isSuceese()) {
            Map<String, Object> paramMap = this.context.getParamSetting();
            ReserveArgs reserveArgs = (ReserveArgs)this.context.getReserveArgs();
            List<ReserveOrBillInfo> orBillInfos = reserveArgs.getSelectRows();
            Map<Object, List<Object>> lstMatchInvacc = this.context.getMatchInvacc();
            String formId = ((ReserveOrBillInfo)orBillInfos.get(0)).getFormId();
            String entryKey = ((ReserveOrBillInfo)orBillInfos.get(0)).getEntryKey();
            List<DynamicObject> lstOrBillObjs = Collections.singletonList(reserveArgs.getRequestBill());
            if (reserveArgs.getRequestBill() == null && (lstOrBillObjs = this.getDemandBillInfos(formId, entryKey, lstMatchInvacc)).size() == 0) {
                this.reserveOperateResult.setSuceese(false);
                this.reserveOperateResult.setMessage(this.getMsgCheckInitVariableAction());
                return;
            }
            this.context.setLstOrBillObjs(lstOrBillObjs);
            List<DynamicObject> reserveRescords = this.getReserveRescords(orBillInfos);
            Map<Object, BigDecimal> mapHaveReserve = this.getHaveReserveAll(paramMap, lstOrBillObjs, reserveRescords);
            this.context.setMapHaveReserve(mapHaveReserve);
            Map<Object, DynamicObject> invStockInos = this.getRealInvStockInfos(lstMatchInvacc);
            this.context.setInvStockInos(invStockInos);
        }
    }

    private Map<Object, BigDecimal> getHaveReserveAll(Map<String, Object> paramMap, List<DynamicObject> lstOrBillObjs, List<DynamicObject> reserveRescords) {
        HashMap<Object, BigDecimal> mapEntrydHasReserveQty = new HashMap<Object, BigDecimal>();
        String formId = lstOrBillObjs.get(0).getDataEntityType().getName();
        lstOrBillObjs.forEach(p -> {
            String billId = String.valueOf(p.getPkValue());
            DynamicObjectCollection entryObjs = p.getDynamicObjectCollection(String.valueOf(paramMap.get("billentry")));
            entryObjs.forEach(m -> {
                String entryId = String.valueOf(m.getPkValue());
                BigDecimal hasReservedQty = BigDecimal.ZERO;
                BigDecimal hasReservedUnitQty = BigDecimal.ZERO;
                BigDecimal hasReserved2ndQty = BigDecimal.ZERO;
                for (DynamicObject reserve : reserveRescords) {
                    String demandId = reserve.getString("demandid");
                    String demandEntryId = reserve.getString("demandentryid");
                    String demandFormId = (String)reserve.getDynamicObject("demandformid").getPkValue();
                    if (!formId.equals(demandFormId) || !billId.equals(demandId) || !entryId.equals(demandEntryId)) continue;
                    hasReservedQty = hasReservedQty.add(reserve.getBigDecimal("reservebaseqty"));
                    hasReservedUnitQty = hasReservedUnitQty.add(reserve.getBigDecimal("reserveqty"));
                    hasReserved2ndQty = hasReserved2ndQty.add(reserve.getBigDecimal("reserveunit2ndqty"));
                }
                if (hasReservedQty.compareTo(BigDecimal.ZERO) > 0) {
                    mapEntrydHasReserveQty.put(entryId + "," + "reservebaseqty", hasReservedQty);
                }
                if (hasReservedUnitQty.compareTo(BigDecimal.ZERO) > 0) {
                    mapEntrydHasReserveQty.put(entryId + "," + "reserveqty", hasReservedUnitQty);
                }
                if (hasReserved2ndQty.compareTo(BigDecimal.ZERO) > 0) {
                    mapEntrydHasReserveQty.put(entryId + "," + "reserveunit2ndqty", hasReserved2ndQty);
                }
            });
        });
        return mapEntrydHasReserveQty;
    }

    private Map<Object, DynamicObject> getRealInvStockInfos(Map<Object, List<Object>> lstMatchInvacc) {
        List<DynamicObject> invStockInos = this.getInvStockInos(lstMatchInvacc);
        ArrayList<Object> invaccIds = new ArrayList<Object>(invStockInos.size());
        for (DynamicObject dyn : invStockInos) {
            invaccIds.add(dyn.getPkValue());
        }
        List<Map<String, Object>> lstReserveInvQty = this.getHasResserveInvaccsByIds(invaccIds);
        for (DynamicObject item : invStockInos) {
            String invccId = String.valueOf(item.getPkValue());
            BigDecimal reserveInvQty = this.getReserveQtyByInvaccId(invccId, lstReserveInvQty, "reservebaseqty");
            this.calAvbQty(item, reserveInvQty, "baseqty", "avbbaseqty");
            BigDecimal reserveInvUnitQty = this.getReserveQtyByInvaccId(invccId, lstReserveInvQty, "reserveqty");
            this.calAvbQty(item, reserveInvUnitQty, "qty", "avbqty");
            BigDecimal reserveInv2ndQty = this.getReserveQtyByInvaccId(invccId, lstReserveInvQty, "reserveunit2ndqty");
            this.calAvbQty(item, reserveInv2ndQty, "qty2nd", "avbqty2nd");
        }
        HashMap<Object, DynamicObject> infosMap = new HashMap<Object, DynamicObject>(invStockInos.size());
        for (DynamicObject info : invStockInos) {
            if (this.isAllZero(info)) continue;
            infosMap.put(info.getPkValue(), info);
        }
        return infosMap;
    }

    private boolean isAllZero(DynamicObject info) {
        return info.getBigDecimal("avbbaseqty").compareTo(BigDecimal.ZERO) == 0 && info.getBigDecimal("avbqty").compareTo(BigDecimal.ZERO) == 0 && info.getBigDecimal("avbqty2nd").compareTo(BigDecimal.ZERO) == 0;
    }

    private void calAvbQty(DynamicObject item, BigDecimal reserveInvQty, String invAccQtyf, String invAccAvbQtyf) {
        if (item.getBigDecimal(invAccQtyf).compareTo(reserveInvQty) > 0) {
            BigDecimal avbBaseQty = item.getBigDecimal(invAccQtyf).subtract(reserveInvQty);
            item.set(invAccAvbQtyf, (Object)avbBaseQty);
        } else {
            item.set(invAccAvbQtyf, (Object)BigDecimal.ZERO);
        }
    }

    private List<DynamicObject> getInvStockInos(Map<Object, List<Object>> lstMatchInvacc) {
        HashSet invaccIds = new HashSet();
        for (Map.Entry<Object, List<Object>> entry : lstMatchInvacc.entrySet()) {
            invaccIds.addAll(entry.getValue());
        }
        DynamicObjectType reservationType = BusinessDataServiceHelper.newDynamicObject((String)ImInvacc.getBalTb()).getDynamicObjectType();
        DynamicObject[] invaccObj = BusinessDataServiceHelper.load((Object[])invaccIds.toArray(), (DynamicObjectType)reservationType);
        return Arrays.asList(invaccObj);
    }

    private List<DynamicObject> getReserveRescords(List<ReserveOrBillInfo> orBillInfos) {
        HashSet demnadEntryIds = new HashSet();
        HashSet formIds = new HashSet();
        orBillInfos.forEach(p -> {
            demnadEntryIds.add(p.getEntryID());
            formIds.add(p.getFormId());
        });
        QFilter demandIdFilter = new QFilter("demandentryid", "in", demnadEntryIds);
        QFilter demandBillTypeFilter = new QFilter("demandformid", "in", formIds);
        QFilter reserveQtyFilter = new QFilter("reservebaseqty", ">", (Object)0);
        Map reserveRescords = BusinessDataServiceHelper.loadFromCache((String)"sbs_reservation", (QFilter[])new QFilter[]{demandIdFilter, demandBillTypeFilter, reserveQtyFilter});
        return new ArrayList<DynamicObject>(reserveRescords.values());
    }

    private List<DynamicObject> getDemandBillInfos(String formId, String entryKey, Map<Object, List<Object>> lstMatchInvacc) {
        HashSet<Object> entryIds = new HashSet<Object>();
        entryIds.addAll(lstMatchInvacc.keySet());
        Map reserveBillinfos = BusinessDataServiceHelper.loadFromCache((String)formId, (QFilter[])new QFilter[]{new QFilter(entryKey + ".id", "in", entryIds)});
        return new ArrayList<DynamicObject>(reserveBillinfos.values());
    }

    private List<QFilter> getFilter(MainEntityType entityType, FilterCondition filterCondition) {
        if (filterCondition == null) {
            return null;
        }
        FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition);
        filterBuilder.buildFilter();
        List list = filterBuilder.getQFilters();
        return list;
    }

    public List<Map<String, Object>> getHasResserveInvaccsByIds(List<Object> invaccIds) {
        Map<Object, BalReserveQtyArgs> lockQtyMap = this.getInvLockQty(invaccIds);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(lockQtyMap.size());
        for (Map.Entry<Object, BalReserveQtyArgs> args : lockQtyMap.entrySet()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            BalReserveQtyArgs reserveQtyArgs = args.getValue();
            map.put("supplybillid", args.getKey());
            map.put("reservebaseqty", reserveQtyArgs.getBaseQty());
            map.put("demanbasedunit", reserveQtyArgs.getBaseQtyUnit());
            map.put("reserveqty", reserveQtyArgs.getQty());
            map.put("demandunit", reserveQtyArgs.getQtyUnit());
            map.put("reserveunit2ndqty", reserveQtyArgs.getQty2nd());
            map.put("demandunit2nd", reserveQtyArgs.getQty2ndUnit());
            list.add(map);
        }
        return list;
    }

    private Map<Object, BalReserveQtyArgs> getInvLockQty(List<Object> invaccIds) {
        DataSet real = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".getInvLockQty"), (String)"im_inv_realbalance", (String)"id,lockbaseqty , lockqty , lockqty2nd,baseunit,unit,unit2nd", (QFilter[])new QFilter("id", "in", invaccIds).toArray(), null);
        HashMap<Object, BalReserveQtyArgs> lockQtyMap = new HashMap<Object, BalReserveQtyArgs>(16);
        while (real.hasNext()) {
            Row row = real.next();
            BalReserveQtyArgs qtyArgs = new BalReserveQtyArgs(row.getBigDecimal("lockbaseqty"), row.getBigDecimal("lockqty"), row.getBigDecimal("lockqty2nd"));
            qtyArgs.setBaseQtyUnit(row.get("baseunit"));
            qtyArgs.setQtyUnit(row.get("unit"));
            qtyArgs.setQty2ndUnit(row.get("unit2nd"));
            lockQtyMap.put(row.get("id"), qtyArgs);
        }
        return lockQtyMap;
    }

    private BigDecimal getReserveQtyByInvaccId(String invaccId, List<Map<String, Object>> lstReserveInvQty, String supplyQtyf) {
        BigDecimal reserveInvQty = BigDecimal.ZERO;
        for (Map<String, Object> p : lstReserveInvQty) {
            if (!p.get("supplybillid").toString().equals(invaccId)) continue;
            BigDecimal add = (BigDecimal)p.get(supplyQtyf);
            if (add == null) {
                add = BigDecimal.ZERO;
            }
            reserveInvQty = reserveInvQty.add(add);
        }
        return reserveInvQty;
    }
}

