/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.reservation.singleaction;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.ext.scmc.paramentity.bizrule.reserve.consts.ReservationEnum;
import kd.bos.ext.scmc.paramentity.bizrule.reserve.pojo.ReserveOrBillInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.sbs.business.reservation.ReserveHelper;
import kd.scmc.sbs.business.reservation.model.ReserveArgs;
import kd.scmc.sbs.business.reservation.model.ReserveContext;
import kd.scmc.sbs.business.reservation.model.ReserveSrcRealseRow;
import kd.scmc.sbs.business.reservation.singleaction.ReserveLogicaUnit;

public class ReleaseLinkAction
extends ReserveLogicaUnit {
    protected Boolean isPositiveRelease;

    public ReleaseLinkAction(ReserveContext reserveContext) {
        this.context = reserveContext;
        this.reserveOperateResult = reserveContext.getResult();
        this.setOption(reserveContext.getOption());
    }

    @Override
    public void doAction() {
        if (this.reserveOperateResult.isSuceese()) {
            List<ReserveSrcRealseRow> reserveSrcRealseRows = this.context.getReserveSrcRealseRows();
            if (reserveSrcRealseRows.isEmpty() || reserveSrcRealseRows.size() == 0) {
                return;
            }
            this.updateRealseQty(reserveSrcRealseRows);
            DynamicObject[] reserveRescords = this.getReserveRescords(reserveSrcRealseRows);
            this.isPositiveRelease = this.context.getParamSetting().get("realsedic").equals("A");
            if (!this.isPositiveRelease.booleanValue() && this.getOption().equals("closerelasereserve") && !this.checkReleaseByBillClose(reserveRescords)) {
                this.reserveOperateResult.setSuceese(false);
                this.reserveOperateResult.setMessage(this.getMsgReleaseLinkActionRecord());
                return;
            }
            this.updateAndSaveReserveQty(reserveRescords, reserveSrcRealseRows);
        }
    }

    private String getMsgReleaseLinkActionRecord() {
        return ResManager.loadKDString((String)"\u5e93\u5b58\u4e0d\u8db3\uff0c\u65e0\u6cd5\u8fd8\u539f\u9884\u7559\u8bb0\u5f55\u3002", (String)"ReleaseLinkAction_0", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private List<DynamicObject> getOperateBillInfos() {
        ReserveArgs reserveArgs = (ReserveArgs)this.context.getReserveArgs();
        List<ReserveOrBillInfo> lstOperateBillInfos = reserveArgs.getSelectRows();
        String formId = ((ReserveOrBillInfo)lstOperateBillInfos.get(0)).getFormId();
        String entryKey = ((ReserveOrBillInfo)lstOperateBillInfos.get(0)).getEntryKey();
        ArrayList billIds = new ArrayList(lstOperateBillInfos.size());
        ArrayList entryIds = new ArrayList(lstOperateBillInfos.size());
        lstOperateBillInfos.forEach(p -> {
            billIds.add(Long.valueOf(p.getInterID()));
            entryIds.add(Long.valueOf(p.getEntryID()));
        });
        QFilter billIdFilter = new QFilter("id", "in", billIds);
        QFilter entryIdFilter = new QFilter(entryKey + ".id", "in", entryIds);
        Map billInfos = BusinessDataServiceHelper.loadFromCache((String)formId, (QFilter[])new QFilter[]{billIdFilter, entryIdFilter});
        return new ArrayList<DynamicObject>(billInfos.values());
    }

    private void updateRealseQty(List<ReserveSrcRealseRow> reserveSrcRealseRows) {
        List<DynamicObject> operateBillInfos = this.getOperateBillInfos();
        Map<String, String> paramMap = this.context.getParamSetting();
        for (ReserveSrcRealseRow srcRealseRow : reserveSrcRealseRows) {
            operateBillInfos.forEach(p -> {
                String billId = String.valueOf(p.getPkValue());
                String entryKey = (String)paramMap.get(ReservationEnum.KEY_ENTRYFILED.getFiled());
                DynamicObjectCollection entryObjs = p.getDynamicObjectCollection(entryKey);
                for (DynamicObject entryObj : entryObjs) {
                    String baseQtyKey = (String)paramMap.get(ReservationEnum.KEY_BASEQTY.getFiled());
                    String entryId = String.valueOf(entryObj.getPkValue());
                    if (!srcRealseRow.getTargetBillId().equals(billId) || !srcRealseRow.getTargetEntryId().equals(entryId)) continue;
                    srcRealseRow.setTargetBaseQty(entryObj.getBigDecimal(baseQtyKey));
                }
            });
        }
    }

    private DynamicObject[] getReserveRescords(List<ReserveSrcRealseRow> srcBillInfos) {
        ArrayList ids = new ArrayList();
        srcBillInfos.forEach(p -> ids.addAll(p.getReserveId()));
        return BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sbs_reservation"));
    }

    private void updateAndSaveReserveQty1(DynamicObject[] reserveRescords, List<ReserveSrcRealseRow> reserveSrcRealseRows) {
        for (ReserveSrcRealseRow realseRow : reserveSrcRealseRows) {
            List<DynamicObject> reservesObj = Arrays.asList(reserveRescords);
            List<DynamicObject> mapHasReserved = reservesObj.stream().filter(records -> records.getString("demandid").equals(realseRow.getSrcBillId()) && records.getString("demandentryid").equals(realseRow.getSrcBillEntryId()) && String.valueOf(records.getDynamicObject("demandformid").getPkValue()).equals(realseRow.getSrcBillFomId())).collect(Collectors.toList());
            Map<String, String> paramsetting = this.context.getParamSetting();
            if (this.isPositiveRelease.booleanValue()) {
                this.positiveUpdateReserveQty(mapHasReserved, realseRow);
                continue;
            }
            this.negativeUpdateReserveQty(mapHasReserved, realseRow);
        }
        SaveServiceHelper.save((DynamicObject[])reserveRescords);
    }

    private void updateAndSaveReserveQty(DynamicObject[] reserveRescords, List<ReserveSrcRealseRow> reserveSrcRealseRows) {
        for (ReserveSrcRealseRow realseRow : reserveSrcRealseRows) {
            List<DynamicObject> reservesObj = Arrays.asList(reserveRescords);
            List<DynamicObject> mapHasReserved = reservesObj.stream().filter(records -> realseRow.getReserveId().contains(String.valueOf(records.getPkValue()))).collect(Collectors.toList());
            if (this.isPositiveRelease.booleanValue()) {
                this.positiveUpdateReserveQty(mapHasReserved, realseRow);
                continue;
            }
            this.negativeUpdateReserveQty(mapHasReserved, realseRow);
        }
        SaveServiceHelper.save((DynamicObject[])reserveRescords);
    }

    private void positiveUpdateReserveQty(List<DynamicObject> mapHasReserved, ReserveSrcRealseRow realseRow) {
        for (DynamicObject reserve : mapHasReserved) {
            BigDecimal reserveSupplyQty = reserve.getBigDecimal("reservebaseqty");
            BigDecimal diffQty = realseRow.getTargetBaseQty().subtract(reserveSupplyQty);
            if (diffQty.compareTo(BigDecimal.ZERO) > 0) {
                reserve.set("reservebaseqty", (Object)BigDecimal.ZERO);
                reserve.set("reservereleaseqty", (Object)reserveSupplyQty);
                realseRow.setTargetBaseQty(diffQty);
                continue;
            }
            reserve.set("reservebaseqty", (Object)reserveSupplyQty.subtract(realseRow.getTargetBaseQty()));
            reserve.set("reservereleaseqty", (Object)realseRow.getTargetBaseQty());
            break;
        }
    }

    private void negativeUpdateReserveQty(List<DynamicObject> mapHasReserved, ReserveSrcRealseRow realseRow) {
        for (DynamicObject reserve : mapHasReserved) {
            BigDecimal reserveSupplyQty = reserve.getBigDecimal("reservebaseqty");
            BigDecimal reserveReleaseQty = reserve.getBigDecimal("reservereleaseqty");
            BigDecimal diffQty = realseRow.getTargetBaseQty().subtract(reserveReleaseQty);
            if (diffQty.compareTo(BigDecimal.ZERO) > 0) {
                reserve.set("reservebaseqty", (Object)reserveSupplyQty.add(reserveReleaseQty));
                reserve.set("reservereleaseqty", (Object)BigDecimal.ZERO);
                realseRow.setTargetBaseQty(diffQty);
                continue;
            }
            reserve.set("reservebaseqty", (Object)reserveSupplyQty.add(realseRow.getTargetBaseQty()));
            reserve.set("reservereleaseqty", (Object)reserveReleaseQty.subtract(realseRow.getTargetBaseQty()));
            break;
        }
    }

    private boolean checkReleaseByBillClose(DynamicObject[] reserveRescords) {
        HashMap<String, BigDecimal> releaseQtyMap = new HashMap<String, BigDecimal>(reserveRescords.length);
        for (DynamicObject p : reserveRescords) {
            String invaccId = p.getString("supplybillid");
            BigDecimal qty = releaseQtyMap.computeIfAbsent(invaccId, k -> BigDecimal.ZERO);
            releaseQtyMap.put(invaccId, qty.add(p.getBigDecimal("reservereleaseqty")));
        }
        return ReserveHelper.isAvailableInvaccQty(releaseQtyMap);
    }
}

