/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.sn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.sbs.business.sn.SNBillConfigHelper;
import kd.scmc.sbs.business.sn.billFiledMapper.BillFieldMapper;

public class InvBillCommonHelper {
    public static Map<String, List<DynamicObject>> parseBillEntryBySerailNumber(Collection<DynamicObject> bills, BillFieldMapper billFieldMapper) {
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>(bills.size() * 2);
        if (bills.isEmpty()) {
            return result;
        }
        String entryKey = billFieldMapper.getBillEntryKey();
        String materialKey = billFieldMapper.getMaterialKey();
        BillFieldMapper subbillFieldMapper = null;
        String subentryKey = null;
        String submaterialKey = null;
        if (billFieldMapper.hasSubEntry()) {
            subbillFieldMapper = billFieldMapper.getSubEntryBillFiledMapper();
            subentryKey = subbillFieldMapper.getBillEntryKey();
            submaterialKey = subbillFieldMapper.getMaterialKey();
        }
        DynamicObjectCollection billentries = null;
        Long billId = null;
        Map<Long, List<DynamicObject>> billSerialConfigs = InvBillCommonHelper.getBillSerialConfigs(bills.toArray(new DynamicObject[bills.size()]));
        for (DynamicObject bill : bills) {
            billId = bill.getLong("id");
            List<DynamicObject> configs = billSerialConfigs.get(billId);
            if (configs == null || configs.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e[{0}]\u672a\u627e\u5230\u53ef\u7528\u7684\u5e8f\u5217\u53f7\u670d\u52a1\u914d\u7f6e\u3002", (String)"InvBillCommonHelper_0", (String)"scmc-sbs-form", (Object[])new Object[]{bill.getString("billno")}));
            }
            List enableConfigs = configs.stream().filter(i -> i.getString("srcbillentry").equals(entryKey)).collect(Collectors.toList());
            if (enableConfigs.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e[{0}]\u672a\u627e\u5230\u53ef\u7528\u7684\u5e8f\u5217\u53f7\u670d\u52a1\u914d\u7f6e\u3002", (String)"InvBillCommonHelper_0", (String)"scmc-sbs-form", (Object[])new Object[]{bill.getString("billno")}));
            }
            if (enableConfigs.size() > 1) {
                ArrayList<String> configStr = new ArrayList<String>(enableConfigs.size());
                for (DynamicObject enableConfig : enableConfigs) {
                    configStr.add(enableConfig.getString("number"));
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e[{0}]\u5b58\u5728\u591a\u4e2a\u53ef\u7528\u7684\u5e8f\u5217\u53f7\u670d\u52a1\u914d\u7f6e\uff1a{1}\uff0c\u8bf7\u5220\u9664\u6216\u7981\u7528\u591a\u4f59\u914d\u7f6e\u3002", (String)"InvBillCommonHelper_1", (String)"scmc-sbs-form", (Object[])new Object[]{bill.getString("billno"), configStr}));
            }
            DynamicObject config = (DynamicObject)enableConfigs.get(0);
            DynamicObject subConfig = null;
            String subMaterialCol = null;
            String subMaterialMasterCol = null;
            String subInvOrgCol = null;
            if (billFieldMapper.hasSubEntry()) {
                subbillFieldMapper = billFieldMapper.getSubEntryBillFiledMapper();
                String subKey = subbillFieldMapper.getBillEntryKey();
                List subEnableConfigs = configs.stream().filter(i -> i.getString("srcbillentry").equals(subKey)).collect(Collectors.toList());
                if (subEnableConfigs.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e[{0}]\u672a\u627e\u5230\u5b50\u5206\u5f55\u53ef\u7528\u7684\u5e8f\u5217\u53f7\u670d\u52a1\u914d\u7f6e\u3002", (String)"InvBillCommonHelper_2", (String)"scmc-sbs-form", (Object[])new Object[]{bill.getString("billno")}));
                }
                if (subEnableConfigs.size() > 1) {
                    ArrayList<String> configStr = new ArrayList<String>(enableConfigs.size());
                    for (DynamicObject enableConfig : enableConfigs) {
                        configStr.add(enableConfig.getString("number"));
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e[{0}]\u5b50\u5206\u5f55\u5b58\u5728\u591a\u4e2a\u53ef\u7528\u7684\u5e8f\u5217\u53f7\u670d\u52a1\u914d\u7f6e\uff1a{1}\uff0c\u8bf7\u5220\u9664\u6216\u7981\u7528\u591a\u4f59\u914d\u7f6e\u3002", (String)"InvBillCommonHelper_3", (String)"scmc-sbs-form", (Object[])new Object[]{bill.getString("billno"), configStr}));
                }
                subConfig = (DynamicObject)subEnableConfigs.get(0);
                subMaterialCol = subConfig.getString("materialcol");
                subMaterialMasterCol = subConfig.getString("materialmastercol");
                subInvOrgCol = InvBillCommonHelper.getOrgCol(subConfig.getDynamicObjectCollection("snmainfentry"));
            }
            String materialCol = config.getString("materialcol");
            String materialMasterCol = config.getString("materialmastercol");
            String invOrgCol = InvBillCommonHelper.getOrgCol(config.getDynamicObjectCollection("snmainfentry"));
            billentries = bill.getDynamicObjectCollection(entryKey);
            ArrayList<DynamicObject> billentryList = new ArrayList<DynamicObject>(billentries.size());
            for (DynamicObject billEntry : billentries) {
                if (InvBillCommonHelper.getMaterialInvInfoEnable(bill, materialCol, materialMasterCol, invOrgCol, billEntry, false, entryKey)) {
                    billentryList.add(billEntry);
                }
                if (!billFieldMapper.hasSubEntry()) continue;
                ArrayList<DynamicObject> subBillentryList = new ArrayList<DynamicObject>(billentries.size());
                DynamicObjectCollection subEntries = billEntry.getDynamicObjectCollection(subentryKey);
                if (subEntries == null || subEntries.isEmpty()) continue;
                for (DynamicObject subEntry : subEntries) {
                    if (!InvBillCommonHelper.getMaterialInvInfoEnable(bill, subMaterialCol, subMaterialMasterCol, subInvOrgCol, subEntry, true, subentryKey)) continue;
                    subBillentryList.add(subEntry);
                }
                if (subBillentryList.isEmpty()) continue;
                String key = billId + "." + subentryKey + "." + submaterialKey;
                List list = (List)result.get(key);
                if (list == null) {
                    result.put(key, subBillentryList);
                    continue;
                }
                list.addAll(subBillentryList);
            }
            if (billentryList.isEmpty()) continue;
            result.put(billId + "." + entryKey + "." + materialKey, billentryList);
        }
        return result;
    }

    private static boolean getMaterialInvInfoEnable(DynamicObject bill, String materialCol, String materialMasterCol, String invOrgCol, DynamicObject entry, boolean isSubEntry, String entryKey) {
        if (materialCol.isEmpty()) {
            return InvBillCommonHelper.getMaterialInvInfoExistByMaterialColAndInvOrgCol(bill, materialMasterCol, invOrgCol, entry, isSubEntry, entryKey);
        }
        DynamicObject materialInvInfo = (DynamicObject)InvBillCommonHelper.getValueByName(bill, entry, materialCol);
        return materialInvInfo.getBoolean("enableserial");
    }

    private static boolean getMaterialInvInfoExistByMaterialColAndInvOrgCol(DynamicObject bill, String materialCol, String invOrgCol, DynamicObject entry, boolean isSubEntry, String entryKey) {
        String materialRealCol = materialCol.substring(materialCol.indexOf(entryKey) + entryKey.length() + 1);
        DynamicObject materialInfo = entry.getDynamicObject(materialRealCol);
        if (materialInfo == null) {
            return false;
        }
        DynamicObject invOrgInfo = (DynamicObject)InvBillCommonHelper.getValueByName(bill, entry, invOrgCol);
        if (invOrgInfo == null) {
            return false;
        }
        return InvBillCommonHelper.getMaterialInvInfoExist(materialInfo.getLong("masterid"), invOrgInfo.getLong("id"));
    }

    public static boolean getMaterialInvInfoExist(Long materialMasterId, Long invOrgId) {
        QFilter qFilter = new QFilter("masterid", "=", (Object)materialMasterId).and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)invOrgId).and("enableserial", "=", (Object)true));
        boolean exists = QueryServiceHelper.exists((String)"bd_materialinventoryinfo", (QFilter[])qFilter.toArray());
        return exists;
    }

    public static String getOrgCol(DynamicObjectCollection snMainColEntry) {
        if (snMainColEntry == null || snMainColEntry.isEmpty()) {
            return "";
        }
        String invOrgCol = "";
        for (DynamicObject object : snMainColEntry) {
            if (!"invorg".equals(object.getString("snmainfcol"))) continue;
            invOrgCol = object.getString("snmainfsrcbillcol");
            break;
        }
        return invOrgCol;
    }

    public static Map<Long, List<DynamicObject>> getBillSerialConfigs(DynamicObject[] bills) {
        HashMap<Long, List<DynamicObject>> configs = new HashMap<Long, List<DynamicObject>>(bills.length);
        String billType = bills[0].getDynamicObjectType().getName();
        Collection<DynamicObject> snBillConfigs = SNBillConfigHelper.getSNBillConfigByBillType(billType);
        for (DynamicObject config : snBillConfigs) {
            for (DynamicObject bill : bills) {
                Long billId = bill.getLong("id");
                boolean dynamicObjectMatchCfg = SNBillConfigHelper.isDynamicObjectMatchCfg(billType, bill, config);
                if (!dynamicObjectMatchCfg) continue;
                List entryConfigs = configs.computeIfAbsent(billId, k -> new ArrayList());
                entryConfigs.add(config);
            }
        }
        return configs;
    }

    public static boolean isMaterialEnableSerial(DynamicObject material) {
        if (material == null) {
            return false;
        }
        return material.getBoolean("enableserial");
    }

    private static Object getValueByName(DynamicObject bill, DynamicObject entry, String colName) {
        if (colName.contains(".")) {
            return entry.get(InvBillCommonHelper.getPureKey(colName));
        }
        return bill.get(colName);
    }

    private static String getPureKey(String currentKey) {
        if (currentKey.lastIndexOf(46) != -1) {
            return currentKey.substring(currentKey.lastIndexOf(46) + 1);
        }
        return currentKey;
    }
}

