/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.sn.biz;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.sbs.business.sn.SNBillConfigHelper;

public class SerialNumberSupOperator {
    private static int SNSET_LIMIT = 1000;
    private static int SNSET_LIMIT_CHECK = 100000;
    private static final String SUPPLEMENT_SELECTS = "entryentity.id as entryid,entryentity.sn as sn,entryentity.note as note,material,entryentity.createorg as createorg,lotnumber,auxpty";
    private static Map<String, String> snStatusENToCN = new HashMap<String, String>(5);

    public static List<String> handleSupple(Long invaccid) {
        if (invaccid == null || invaccid.equals(0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SerialNumberSupOperator_8", (String)"scmc-sbs-form", (Object[])new Object[0]));
        }
        ArrayList<String> errors = new ArrayList<String>(20);
        DynamicObject supRel = QueryServiceHelper.queryOne((String)"sbs_snsupplement", (String)"id,material,invorg,warehouse,location,lotnumber,auxpty", (QFilter[])new QFilter("invaccid", "=", (Object)invaccid).toArray());
        if (supRel != null) {
            long suprelid = supRel.getLong("id");
            Long materialmasterid = supRel.getLong("material");
            Set<String> snUnqctrl = SNBillConfigHelper.getSnUnqctrl();
            try (DataSet serialNumberDataSet = SerialNumberSupOperator.getSuppleSNDataSet(invaccid, materialmasterid, snUnqctrl);){
                Long snmoveTrackId = SerialNumberSupOperator.getSnmoveTrack(invaccid, supRel);
                ArrayList<Object[]> snmainfInsertParams = new ArrayList<Object[]>(SNSET_LIMIT_CHECK);
                ArrayList<Object[]> snmainfUpdateParams = new ArrayList<Object[]>(SNSET_LIMIT_CHECK);
                ArrayList<Object[]> sntrackrelInsertParams = new ArrayList<Object[]>(SNSET_LIMIT_CHECK);
                HashSet<String> snNumberUnqs = new HashSet<String>(SNSET_LIMIT_CHECK);
                for (Row row : serialNumberDataSet) {
                    boolean errorFlag = false;
                    String snnumber = row.getString("sn");
                    Long createorg = row.getLong("createorg");
                    String lotnum = row.getString("lotnumber");
                    Long mainfileid = row.getLong("mainfileid");
                    Long auxpty = row.getLong("auxpty");
                    String note = row.getString("note");
                    String snNumberUnq = SerialNumberSupOperator.buildSnunqstr(snUnqctrl, snnumber, materialmasterid, createorg, lotnum);
                    if (snNumberUnqs.contains(snNumberUnq)) {
                        errorFlag = true;
                        errors.add(String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u201c%s\u201d\u91cd\u590d\u3002", (String)"SerialNumberSupOperator_9", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber));
                    } else {
                        snNumberUnqs.add(snNumberUnq);
                    }
                    if (!SerialNumberSupOperator.isEmpty(mainfileid)) {
                        Long finalaudittrailid = row.getLong("finalaudittrailid");
                        String snstatus = row.getString("snstatus");
                        if (!materialmasterid.equals(row.getLong("mfmaterialid"))) {
                            errorFlag = true;
                            errors.add(String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u201c%s\u201d\u5bf9\u5e94\u7269\u6599\u4e0e\u5355\u636e\u4e0a\u4e0d\u4e00\u81f4\u3002", (String)"SerialNumberSupOperator_10", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber));
                        }
                        if (!"B".equals(snstatus)) {
                            errorFlag = true;
                            errors.add(String.format(ResManager.loadKDString((String)"\u5f15\u7528\u4e86\u9519\u8bef\u72b6\u6001\u7684\u5e8f\u5217\u53f7\uff1a%1$s-%2$s\u3002", (String)"SerialNumberSupOperator_11", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber, snStatusENToCN.get(snstatus)));
                        }
                        if (!SerialNumberSupOperator.isEmpty(finalaudittrailid)) {
                            errorFlag = true;
                            errors.add(String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u201c%s\u201d\u5df2\u88ab\u5176\u5b83\u5e93\u5b58\u8bb0\u5f55\u5f15\u7528,\u8bf7\u5230\u5e8f\u5217\u53f7\u4e3b\u6863\u67e5\u8be2\u5f53\u524d\u4f4d\u7f6e\u3002", (String)"SerialNumberSupOperator_12", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber, snStatusENToCN.get(snstatus)));
                        }
                    }
                    if (errorFlag) continue;
                    Long relid = SNBillConfigHelper.genId("t_bd_snmovetrack_rel");
                    if (SerialNumberSupOperator.isEmpty(mainfileid)) {
                        mainfileid = SNBillConfigHelper.genId("t_bd_snmainfile");
                        Object[] snmainfInsertParam = new Object[]{mainfileid, snnumber, materialmasterid, createorg, lotnum, "B", Boolean.TRUE, "1", invaccid, "sbs_snsupplement", "1", "C", 1, relid, auxpty, note, 1401417099242528768L, mainfileid};
                        snmainfInsertParams.add(snmainfInsertParam);
                    } else {
                        Object[] snmainfUpdateParam = new Object[]{relid, note, mainfileid};
                        snmainfUpdateParams.add(snmainfUpdateParam);
                    }
                    Object[] sntrackrelInsertParam = new Object[]{relid, mainfileid, snmoveTrackId};
                    sntrackrelInsertParams.add(sntrackrelInsertParam);
                }
                if (errors.isEmpty()) {
                    if (snmainfInsertParams.size() > 0) {
                        String snmainfInsertSql = "insert into t_bd_snmainfile(fid,fnumber,fmaterialid,finvorgid,flotnumber,fsnstatus,fisimport,fsbillinvfluctuation,fbillid,fsourcebilltype,fenable,fstatus,fincreaseinvcounter,ffinalaudittrailid,fauxptyid,fcomment,fmasterfiletypeid,fmasterid) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                        SerialNumberSupOperator.batchDoSqlParams(snmainfInsertParams, snmainfInsertSql);
                    }
                    if (snmainfUpdateParams.size() > 0) {
                        String snmainfUpdateSql = "update t_bd_snmainfile set ffinalaudittrailid = ?, fcomment = ? where fid = ?";
                        SerialNumberSupOperator.batchDoSqlParams(snmainfUpdateParams, snmainfUpdateSql);
                    }
                    if (sntrackrelInsertParams.size() > 0) {
                        String sntrackrelInsertSql = "insert into t_bd_snmovetrack_rel(fid,fsnmainfileid,ftrackid) values(?,?,?)";
                        SerialNumberSupOperator.batchDoSqlParams(sntrackrelInsertParams, sntrackrelInsertSql);
                    }
                    String suppleEntryUpdateSql = "update t_sbs_snsupplement_e set fishandle = '1' where fid = ?";
                    DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)suppleEntryUpdateSql, (Object[])new Object[]{suprelid});
                }
            }
        }
        return errors;
    }

    private static void batchDoSqlParams(List<Object[]> params, String snmainfInsertSql) {
        List<Object[]> insertList;
        for (int i = 0; i < params.size() / SNSET_LIMIT; ++i) {
            insertList = params.subList(i * SNSET_LIMIT, (i + 1) * SNSET_LIMIT);
            SerialNumberSupOperator.executeBatchSql(insertList, snmainfInsertSql);
        }
        if (params.size() % SNSET_LIMIT != 0) {
            insertList = params.subList(params.size() / SNSET_LIMIT * SNSET_LIMIT, params.size());
            SerialNumberSupOperator.executeBatchSql(insertList, snmainfInsertSql);
        }
    }

    private static Long getSnmoveTrack(Long invaccid, DynamicObject supRel) {
        DynamicObject snmoveTrack = QueryServiceHelper.queryOne((String)"bd_snmovetrack", (String)"id as trackid", (QFilter[])new QFilter("billid", "=", (Object)invaccid).and("nowinvaccid", "=", (Object)invaccid).toArray());
        if (snmoveTrack == null) {
            String sntrackInsertSql = "insert into t_bd_snmovetrack(fid,fsnmainfileid,fbillstatus,fbillid,fbllentityid,fkeeporgid,fwarehouseid,flocationid,finlotnum,fincreaseinvcounter,fbalancetype,fnowinvaccid,fauditdate) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
            Object[] sntrackInsertParam = new Object[13];
            Long snmoveTrackId = DB.genLongId((String)"t_bd_snmovetrack");
            sntrackInsertParam[0] = snmoveTrackId;
            sntrackInsertParam[1] = 0;
            sntrackInsertParam[2] = "C";
            sntrackInsertParam[3] = invaccid;
            sntrackInsertParam[4] = "sbs_snsupplement";
            sntrackInsertParam[5] = supRel.getLong("invorg");
            sntrackInsertParam[6] = supRel.getLong("warehouse");
            sntrackInsertParam[7] = supRel.getLong("location");
            sntrackInsertParam[8] = supRel.getString("lotnumber");
            sntrackInsertParam[9] = 1;
            sntrackInsertParam[10] = "im_inv_realbalance";
            sntrackInsertParam[11] = invaccid;
            sntrackInsertParam[12] = new Date();
            DB.execute((DBRoute)DBRoute.basedata, (String)sntrackInsertSql, (Object[])sntrackInsertParam);
            return snmoveTrackId;
        }
        return snmoveTrack.getLong("trackid");
    }

    private static DataSet getSuppleSNDataSet(Long invaccid, Long materialmasterid, Set<String> snUnqctrl) {
        DataSet snSuppleDataSet = QueryServiceHelper.queryDataSet((String)SerialNumberSupOperator.class.getName(), (String)"sbs_snsupplement", (String)SUPPLEMENT_SELECTS, (QFilter[])new QFilter("invaccid", "=", (Object)invaccid).and("entryentity.ishandle", "=", (Object)Boolean.FALSE).toArray(), (String)"");
        int counts = snSuppleDataSet.copy().count("entryid", false);
        if (counts == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u3002", (String)"SerialNumberSupOperator_13", (String)"scmc-sbs-form", (Object[])new Object[0]), SNSET_LIMIT));
        }
        if (counts > SNSET_LIMIT_CHECK) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u5355\u6b21\u5904\u7406\u7684\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7%d,\u8bf7\u5206\u6279\u5904\u7406\u3002", (String)"SerialNumberSupOperator_14", (String)"scmc-sbs-form", (Object[])new Object[0]), SNSET_LIMIT));
        }
        HashSet snumbers = new HashSet(SNSET_LIMIT_CHECK);
        try (DataSet copyDataSet = snSuppleDataSet.copy().select("sn");){
            copyDataSet.forEach(row -> snumbers.add(row.getString("sn")));
        }
        SqlBuilder snmainFileSqlBuilder = new SqlBuilder();
        snmainFileSqlBuilder.append("select ts.fid as mainfileid,ts.fnumber as mfsnnumber, ts.fmaterialid as mfmaterialid,ts.finvorgid as mfinvorg,ts.flotnumber as mflotnumber", new Object[0]).append(",ts.ffinalaudittrailid as finalaudittrailid,ts.foccupybillid as occupybillid,ts.fsnstatus as snstatus", new Object[0]).append(",tsm_f.fkeeporgid as cur_orgid,tsm_f.fwarehouseid as cur_warehouseid,tsm_f.flocationid as cur_locationid", new Object[0]).append(" from t_bd_snmainfile ts", new Object[0]).append(" left join t_bd_snmovetrack_rel tsr", new Object[0]).append(" on ts.ffinalaudittrailid = tsr.fid", new Object[0]).append(" left join t_bd_snmovetrack tsm_f", new Object[0]).append(" on tsr.ftrackid = tsm_f.fid", new Object[0]).append(" where ", new Object[0]).appendIn("ts.fnumber", snumbers.toArray()).append(" and fmasterfiletypeid = ?", new Object[]{1401417099242528768L});
        if (snUnqctrl.contains("2")) {
            snmainFileSqlBuilder.append(" and ts.fmaterialid = ?", new Object[]{materialmasterid});
        }
        DataSet snMainFileDataSet = DB.queryDataSet((String)SerialNumberSupOperator.class.getName(), (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)snmainFileSqlBuilder);
        JoinDataSet tempDataSet = snSuppleDataSet.leftJoin(snMainFileDataSet).on("sn", "mfsnnumber");
        for (String unqctrl : snUnqctrl) {
            if (unqctrl.equals("2")) {
                tempDataSet = tempDataSet.on("material", "mfmaterialid");
            }
            if (unqctrl.equals("1")) {
                tempDataSet = tempDataSet.on("createorg", "mfinvorg");
            }
            if (!unqctrl.equals("3")) continue;
            tempDataSet = tempDataSet.on("lotnumber", "mflotnumber");
        }
        snSuppleDataSet = tempDataSet.select(snSuppleDataSet.getRowMeta().getFieldNames(), snMainFileDataSet.getRowMeta().getFieldNames()).finish().filter("sn is not null");
        return snSuppleDataSet;
    }

    private static String buildSnunqstr(Set<String> unqctrl, String snnumber, Long materialmasterid, Long invorgid, String lotnum) {
        StringBuilder unqstrbuilder = new StringBuilder(snnumber);
        if (unqctrl.contains("2")) {
            unqstrbuilder.append('.').append(materialmasterid);
        }
        if (unqctrl.contains("1")) {
            unqstrbuilder.append('.').append(invorgid);
        }
        if (unqctrl.contains("3")) {
            unqstrbuilder.append('.').append(lotnum);
        }
        return unqstrbuilder.toString();
    }

    private static void executeBatchSql(List<Object[]> params, String sql) {
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, params);
    }

    private static boolean isEmpty(Long id) {
        return id == null || id.equals(0L);
    }

    public static List<String> handleSuppleDelete(Long snMainId, Long relId, Long invaccId) {
        if (invaccId == null || invaccId.equals(0L) || snMainId == null || snMainId.equals(0L) || relId == null || relId.equals(0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SerialNumberSupOperator_8", (String)"scmc-sbs-form", (Object[])new Object[0]));
        }
        ArrayList<String> errors = new ArrayList<String>(20);
        StringBuilder sql = new StringBuilder();
        Long billid = 0L;
        String sourcebilltype = "";
        String snNumber = "";
        Object invorg = null;
        sql.append("select t.ffinalaudittrailid as finalaudittrailid,t.fbillid as billid,t.foccupybillid as occupybillid,").append("t.fsourcebilltype as sourcebilltype,t.fnumber as number,t.finvorgid as invorg,").append(" t.fsnstatus as snstatus,trk.fbillid as trkbllid,trk.fbllentityid as trkbllentityid").append(" from t_bd_snmovetrack trk join t_bd_snmovetrack_rel r").append(" on trk.fid = r.ftrackid").append(" join t_bd_snmainfile t on r.fsnmainfileid = t.fid and r.fid = t.ffinalaudittrailid").append(" where t.fid = ?");
        DataSet isDleteRelDataSet = DB.queryDataSet((String)SerialNumberSupOperator.class.getName(), (DBRoute)DBRoute.of((String)"sys"), (String)sql.toString(), (Object[])new Object[]{snMainId});
        while (isDleteRelDataSet.hasNext()) {
            Row row = isDleteRelDataSet.next();
            Long finalaudittrailid = row.getLong("finalaudittrailid");
            Long occupybillid = row.getLong("occupybillid");
            Object snstatus = row.get("snstatus");
            billid = row.getLong("billid");
            sourcebilltype = row.getString("sourcebilltype");
            Long trkbillid = row.getLong("trkbllid");
            Object trkbillentityid = row.get("trkbllentityid");
            snNumber = row.getString("number");
            invorg = row.get("invorg");
            if (!trkbillid.equals(invaccId) && !"sbs_snsupplement".equals(trkbillentityid)) {
                errors.add(ResManager.loadKDString((String)"\u4e0d\u662f\u8865\u5f55\u65b0\u589e\u8f68\u8ff9\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"SerialNumberSupOperator_15", (String)"scmc-sbs-form", (Object[])new Object[0]));
            }
            if (!finalaudittrailid.equals(relId)) {
                errors.add(ResManager.loadKDString((String)"\u8865\u5f55\u5e8f\u5217\u53f7\u8f68\u8ff9\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"SerialNumberSupOperator_0", (String)"scmc-sbs-form", (Object[])new Object[0]));
            }
            if (occupybillid == 0L && "B".equals(snstatus)) continue;
            errors.add(ResManager.loadKDString((String)"\u8865\u5f55\u5e8f\u5217\u53f7\u5df2\u88ab\u5360\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"SerialNumberSupOperator_1", (String)"scmc-sbs-form", (Object[])new Object[0]));
        }
        if (errors.isEmpty()) {
            String deleteSnRelSql = "delete from t_bd_snmovetrack_rel where fid = ?";
            DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)deleteSnRelSql, (Object[])new Object[]{relId});
            StringBuilder isDleteSnMainSql = new StringBuilder();
            isDleteSnMainSql.append("select count(1) as all_count from t_bd_snmainfile tbs ").append(" join t_bd_snmovetrack_rel tbsr on tbs.fid = tbsr.fsnmainfileid ").append(" join t_bd_snmovetrack tbm on tbsr.ftrackid = tbm.fid ").append(" where tbs.fid = ").append(snMainId);
            DataSet isDleteSnMainDataSet = DB.queryDataSet((String)SerialNumberSupOperator.class.getName(), (DBRoute)DBRoute.of((String)"sys"), (String)isDleteSnMainSql.toString());
            Long all_count = 0L;
            while (isDleteSnMainDataSet.hasNext()) {
                Row row = isDleteSnMainDataSet.next();
                all_count = row.getLong("all_count");
            }
            if (all_count == 0L && billid.equals(invaccId) && "sbs_snsupplement".equals(sourcebilltype)) {
                String deleteSnMainSql = "delete from t_bd_snmainfile where fid = ?";
                DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)deleteSnMainSql, (Object[])new Object[]{snMainId});
            } else {
                ArrayList<Object[]> snmainfUpdateParams = new ArrayList<Object[]>(SNSET_LIMIT);
                Object[] snmainfUpdateParam = new Object[]{0, snMainId};
                snmainfUpdateParams.add(snmainfUpdateParam);
                String upDateSnSql = "update t_bd_snmainfile set ffinalaudittrailid = ? where fid = ?";
                SerialNumberSupOperator.executeBatchSql(snmainfUpdateParams, upDateSnSql);
            }
            DynamicObject snsupplement = BusinessDataServiceHelper.loadSingle((String)"sbs_snsupplement", (String)"id", (QFilter[])new QFilter[]{new QFilter("invaccid", "=", (Object)invaccId)});
            long snSupplementId = snsupplement.getLong("id");
            StringBuilder snSuppDeleSql = new StringBuilder();
            snSuppDeleSql.append("delete from t_sbs_snsupplement_e where fid =").append(snSupplementId).append(" and fsn = '").append(snNumber).append("' and fcreateorg = ").append(invorg);
            DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)snSuppDeleSql.toString());
        }
        return errors;
    }

    static {
        snStatusENToCN.put("A", ResManager.loadKDString((String)"\u5f85\u5165\u5e93", (String)"SerialNumberSupOperator_3", (String)"scmc-sbs-form", (Object[])new Object[0]));
        snStatusENToCN.put("B", ResManager.loadKDString((String)"\u5728\u5e93", (String)"SerialNumberSupOperator_4", (String)"scmc-sbs-form", (Object[])new Object[0]));
        snStatusENToCN.put("C", ResManager.loadKDString((String)"\u5f85\u51fa\u5e93", (String)"SerialNumberSupOperator_5", (String)"scmc-sbs-form", (Object[])new Object[0]));
        snStatusENToCN.put("D", ResManager.loadKDString((String)"\u51fa\u5e93", (String)"SerialNumberSupOperator_6", (String)"scmc-sbs-form", (Object[])new Object[0]));
        snStatusENToCN.put("E", ResManager.loadKDString((String)"\u8c03\u62e8\u5728\u9014", (String)"SerialNumberSupOperator_7", (String)"scmc-sbs-form", (Object[])new Object[0]));
    }
}

