/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.sn.biz;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.sbs.business.sn.SNBillConfigHelper;
import kd.scmc.sbs.business.sn.ValidateInfoLogger;
import kd.scmc.sbs.business.sn.mainfile.SNMainFileStatusValidateHelper;
import kd.scmc.sbs.business.sn.relation.BillSNRelationHelper;
import kd.scmc.sbs.common.model.sn.InvCounterEntity;

public class SerialNumberValidator {
    private static String TRKVAL_PRE = "tkv_";
    private static String TRK_PRE = "tk_";
    private static int CHECK_SNRANGE_LIMIT = 2000;
    private static int HANDLE_QTY_LIMIT = 100000;
    private static String DIM_PRE = "dim";
    private boolean dynamicObjectMode = false;
    private DynamicObject cfg;
    private List<Long> billIds;
    private String operate;
    private Map<String, Set<Long>> hasHandleBillMap;
    private Set<Long> hasHandleBillIds;
    private Set<Long> handleBillIds;
    private DynamicObject billObj;
    private ValidateInfoLogger validateInfo;
    private Long masterfiletypeid;
    private String billtype;
    private String entrytype;
    private String entrypath;
    private String entrypathId;
    private String seqcol;
    private String materialcol;
    private String materialmastercol;
    private String invorgcol;
    private String lotnumcol;
    private String snbaseqtycol;
    private int allbaseqty = 0;
    private Map<String, Object> opeAttrMap;
    private Map<String, String> trackValMaps;
    private Map<String, Map<String, String>> trackValNames;
    private Map<String, String> trackMaps;
    private Map<String, Map<String, String>> trackNames;
    private Set<String> snUnqctrl;
    private Map<Integer, Map<String, Object>> dims;
    private Map<Long, DynamicObject> billentriesMap;
    private Map<Long, Boolean> isOutputRequestMaps = new HashMap<Long, Boolean>();

    public static SerialNumberValidator build(DynamicObject cfg, List<Long> billIds, String operate, Map<String, Set<Long>> hasHandleBillMap, ValidateInfoLogger validateInfo) {
        return new SerialNumberValidator(cfg, billIds, operate, hasHandleBillMap, validateInfo);
    }

    public static SerialNumberValidator buildBySingleDynamicObject(DynamicObject cfg, DynamicObject billObj, String operate, Map<String, Set<Long>> hasHandleBillMap, ValidateInfoLogger validateInfo) {
        return new SerialNumberValidator(cfg, billObj, operate, hasHandleBillMap, validateInfo);
    }

    private SerialNumberValidator(DynamicObject cfg, List<Long> billIds, String operate, Map<String, Set<Long>> hasHandleBillMap, ValidateInfoLogger validateInfo) {
        this.cfg = cfg;
        this.billIds = billIds;
        this.operate = operate;
        this.hasHandleBillMap = hasHandleBillMap;
        this.validateInfo = validateInfo;
        this.buildValidator();
    }

    private SerialNumberValidator(DynamicObject cfg, DynamicObject billObj, String operate, Map<String, Set<Long>> hasHandleBillMap, ValidateInfoLogger validateInfo) {
        this.cfg = cfg;
        this.billIds = Collections.singletonList((Long)billObj.getPkValue());
        this.operate = operate;
        this.hasHandleBillMap = hasHandleBillMap;
        this.validateInfo = validateInfo;
        this.dynamicObjectMode = true;
        this.billObj = billObj;
        this.buildValidator();
    }

    private void buildValidator() {
        this.masterfiletypeid = this.cfg.getDynamicObject("masterfiletype").getLong("id");
        this.billtype = this.cfg.getDynamicObject("srcbillobj").getString("number");
        this.entrytype = this.cfg.getString("srcbillentry");
        this.entrypath = SNBillConfigHelper.getEntryPath(this.billtype, this.entrytype);
        this.entrypathId = this.entrypath + ".id";
        this.opeAttrMap = SNBillConfigHelper.getCfgOpeAttrMap(this.cfg, this.operate);
        this.seqcol = this.entrypath + ".seq";
        this.materialcol = SNBillConfigHelper.getMaterialCol(this.cfg);
        this.materialmastercol = SNBillConfigHelper.getMaterialMasterCol(this.cfg);
        if (StringUtils.isNotEmpty((String)this.materialcol) && StringUtils.isEmpty((String)this.materialmastercol)) {
            this.materialmastercol = this.materialcol + ".masterid";
        }
        this.invorgcol = SNBillConfigHelper.getInvOrgSrcCol(this.cfg);
        this.lotnumcol = SNBillConfigHelper.getLotNumSrcCol(this.cfg);
        this.snbaseqtycol = SNBillConfigHelper.getSnBaseqtyCol(this.cfg);
        this.hasHandleBillIds = this.hasHandleBillMap.getOrDefault(this.entrytype, new HashSet(this.billIds.size()));
        this.handleBillIds = new HashSet<Long>(this.billIds);
        this.handleBillIds.removeAll(this.hasHandleBillIds);
        if (this.handleBillIds.isEmpty()) {
            this.billentriesMap = Collections.emptyMap();
            return;
        }
        this.trackValMaps = SNBillConfigHelper.getSNTrackValMaps(this.cfg);
        this.trackValNames = SNBillConfigHelper.getSNTrackValColNames(this.cfg);
        this.trackMaps = SNBillConfigHelper.getSNTrackMaps(this.cfg);
        this.trackNames = SNBillConfigHelper.getSNTrackColNames(this.cfg);
        this.snUnqctrl = SNBillConfigHelper.getSnUnqctrl();
        this.dims = SNBillConfigHelper.getSndims();
        String billSelectProps = this.buildBillSelectProps();
        DynamicObjectCollection billentries = null;
        if (this.dynamicObjectMode) {
            billentries = this.buildBillentriesFromSingleDynamicObj(billSelectProps);
        } else {
            QFilter filter = this.buildBillFilter();
            billentries = QueryServiceHelper.query((String)this.billtype, (String)billSelectProps, (QFilter[])filter.toArray());
        }
        this.billentriesMap = new HashMap<Long, DynamicObject>(billentries.size());
        if (billentries != null && billentries.size() > 0) {
            this.handleBillIds.clear();
            for (DynamicObject billentry : billentries) {
                Long billId = billentry.getLong("id");
                Long entryId = billentry.getLong(this.entrypathId);
                this.allbaseqty += Math.abs(billentry.getInt(this.snbaseqtycol));
                boolean enableSerial = false;
                if (StringUtils.isNotEmpty((String)this.materialcol)) {
                    Long materialInvId = billentry.getLong(this.materialcol);
                    DynamicObject materialInvInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)materialInvId, (String)"bd_materialinventoryinfo", (String)"enableserial");
                    if (materialInvInfo != null) {
                        enableSerial = materialInvInfo.getBoolean("enableserial");
                    }
                } else {
                    long invOrgId;
                    Long materialMasterId = billentry.getLong(this.materialmastercol);
                    DynamicObject materialInvInfo = SNBillConfigHelper.getMaterialInvInfo(materialMasterId, invOrgId = billentry.getLong(this.invorgcol));
                    if (materialInvInfo != null) {
                        enableSerial = materialInvInfo.getBoolean("enableserial");
                    }
                }
                if (!enableSerial) continue;
                this.hasHandleBillIds.add(billId);
                this.handleBillIds.add(billId);
                this.billentriesMap.put(entryId, billentry);
            }
            if (!this.hasHandleBillMap.containsKey(this.entrytype)) {
                this.hasHandleBillMap.put(this.entrytype, this.hasHandleBillIds);
            }
        }
    }

    private QFilter buildBillFilter() {
        QFilter cfgFilter;
        QFilter filter = new QFilter("id", "in", this.handleBillIds);
        if (StringUtils.isNotEmpty((String)this.materialcol)) {
            filter.and(this.materialcol + ".enableserial", "=", (Object)Boolean.TRUE);
        }
        if ((cfgFilter = SNBillConfigHelper.parseBillFilter(this.cfg.getString("billfilter"), this.billtype)) != null) {
            filter.and(cfgFilter);
        }
        return filter;
    }

    private Set<String> getBillDynamicCols() {
        HashSet<String> selectSourceCols = new HashSet<String>(this.trackValMaps.size() + 6 + this.trackMaps.size());
        selectSourceCols.add(this.seqcol);
        if (StringUtils.isNotEmpty((String)this.materialcol)) {
            selectSourceCols.add(this.materialcol);
        }
        selectSourceCols.add(this.invorgcol);
        if (!this.lotnumcol.isEmpty()) {
            selectSourceCols.add(this.lotnumcol);
        }
        selectSourceCols.add(this.snbaseqtycol);
        if (this.trackValMaps.size() > 0) {
            selectSourceCols.addAll(this.trackValMaps.values());
        }
        selectSourceCols.addAll(this.trackMaps.values());
        if ("im_saloutbill".equals(this.billtype) || "im_purinbill".equals(this.billtype)) {
            selectSourceCols.add("isinitbill");
        }
        return selectSourceCols;
    }

    private String buildBillSelectProps() {
        StringBuilder selectPropsBuilder = new StringBuilder("id");
        selectPropsBuilder.append(',').append(this.entrypathId);
        Set<String> selectSourceCols = this.getBillDynamicCols();
        selectPropsBuilder.append(',').append(String.join((CharSequence)",", selectSourceCols));
        if (StringUtils.isNotEmpty((String)this.materialmastercol)) {
            selectPropsBuilder.append(',').append(this.materialmastercol);
        }
        if (StringUtils.isNotEmpty((String)this.materialcol)) {
            selectPropsBuilder.append(',').append(this.materialcol).append('.').append("isoutputrequest as isoutputrequest");
        }
        return selectPropsBuilder.toString();
    }

    public void validateExec() {
        Throwable throwable;
        DataSet serialNumberDataSet;
        List snServicesList;
        if (this.billentriesMap.isEmpty()) {
            return;
        }
        if (this.allbaseqty > HANDLE_QTY_LIMIT) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u5355\u6b21\u5904\u7406\u7684\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7%d,\u8bf7\u5206\u6279\u5904\u7406\u3002", (String)"SerialNumberValidator_0", (String)"scmc-sbs-form", (Object[])new Object[0]), HANDLE_QTY_LIMIT));
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.billtype);
        EntityType entrytypeObj = (EntityType)mainEntityType.getAllEntities().get(this.entrytype);
        if (entrytypeObj != null) {
            String entryName = entrytypeObj.getDisplayName().getLocaleValue();
            this.validateInfo.putEntryDisplayName(this.entrytype, entryName);
        }
        if ((snServicesList = (List)this.opeAttrMap.get("snservices")).contains("1")) {
            serialNumberDataSet = this.getBillSNDataSet(true);
            throwable = null;
            try {
                this.validateSNDataSubmit(serialNumberDataSet);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (serialNumberDataSet != null) {
                    if (throwable != null) {
                        try {
                            serialNumberDataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        serialNumberDataSet.close();
                    }
                }
            }
        }
        if (snServicesList.contains("4")) {
            serialNumberDataSet = this.getBillSNDataSet(false);
            throwable = null;
            try {
                this.validateSNDataUnaudit(serialNumberDataSet);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (serialNumberDataSet != null) {
                    if (throwable != null) {
                        try {
                            serialNumberDataSet.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        serialNumberDataSet.close();
                    }
                }
            }
        }
    }

    private DataSet getBillSNDataSet(Boolean issubmit) {
        Serializable serializable;
        DynamicObjectCollection materialInvInfos;
        RowMeta billentryRowMeta = new RowMeta(new Field[]{new Field("billentryid", (DataType)DataType.LongType), new Field("materialmasterid", (DataType)DataType.LongType), new Field("materialid", (DataType)DataType.LongType), new Field("invorgid", (DataType)DataType.LongType), new Field("lotnum", (DataType)DataType.StringType), new Field("entrylineseq", (DataType)DataType.IntegerType)});
        DataSetBuilder billentryDsBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(billentryRowMeta);
        HashSet<Long> materialmasterids = new HashSet<Long>(this.billentriesMap.size());
        HashSet<Long> materialids = new HashSet<Long>(this.billentriesMap.size());
        for (DynamicObject dynamicObject : this.billentriesMap.values()) {
            Long billentryid = dynamicObject.getLong(this.entrypathId);
            Long invorgid = dynamicObject.getLong(this.invorgcol);
            Object materialmasterid = null;
            Long materialid = null;
            if (StringUtils.isNotEmpty((String)this.materialmastercol)) {
                materialmasterid = dynamicObject.getLong(this.materialmastercol);
                materialid = StringUtils.isEmpty((String)this.materialcol) ? SNBillConfigHelper.getMaterialInvInfoId((Long)materialmasterid, invorgid) : Long.valueOf(dynamicObject.getLong(this.materialcol));
            } else {
                materialid = dynamicObject.getLong(this.materialcol);
                materialmasterid = SNBillConfigHelper.getMaterialMasterId(materialid);
            }
            Integer entrylineseq = dynamicObject.getInt(this.seqcol);
            String lotnum = null;
            lotnum = !this.lotnumcol.isEmpty() ? dynamicObject.getString(this.lotnumcol) : null;
            if (lotnum == null || lotnum.isEmpty()) {
                lotnum = " ";
            }
            materialmasterids.add((Long)materialmasterid);
            if (materialid.equals(0L)) {
                this.isOutputRequestMaps.put((Long)materialmasterid, false);
            } else {
                materialids.add(materialid);
            }
            billentryDsBuilder.append(new Object[]{billentryid, materialmasterid, materialid, invorgid, lotnum, entrylineseq});
        }
        if (!materialids.isEmpty() && (materialInvInfos = QueryServiceHelper.query((String)"bd_materialinventoryinfo", (String)"id,masterid,isoutputrequest", (QFilter[])new QFilter[]{new QFilter("id", "in", materialids)})) != null && !materialInvInfos.isEmpty()) {
            for (DynamicObject materialInvInfo : materialInvInfos) {
                this.isOutputRequestMaps.put(materialInvInfo.getLong("masterid"), materialInvInfo.getBoolean("isoutputrequest"));
            }
        }
        DataSet billentryDataSet = billentryDsBuilder.build();
        List<String> list = Arrays.asList("billtype", "billid", "entrykey", "entryid", "srcbilltype", "srcbillid", "srcentrykey", "srcentryid", "srcisreq", "snnumber", "snrelentryid", "handlestatus");
        ArrayList<String> billSnRelationDimCols = new ArrayList<String>(this.dims.size() + 1);
        ArrayList<String> billSnRelationCols = new ArrayList<String>(list.size() + this.dims.size());
        billSnRelationCols.addAll(list);
        if (!this.dims.isEmpty()) {
            for (Integer dimseq : this.dims.keySet()) {
                billSnRelationDimCols.add(DIM_PRE + dimseq);
            }
        }
        billSnRelationCols.addAll(billSnRelationDimCols);
        DataSet billSnRelationDataSet = BillSNRelationHelper.getBillEntrySNRelationDataSet(this.handleBillIds, this.billtype, this.entrytype, this.dims);
        DataSet billSnRelWithMatDataSet = billSnRelationDataSet.join(billentryDataSet).on("entryid", "billentryid").select(billSnRelationCols.toArray(new String[billSnRelationCols.size()]), new String[]{"materialmasterid", "materialid", "invorgid", "lotnum", "entrylineseq", "case when sninvorg is null or sninvorg = 0 then invorgid else sninvorg end sninvorg"}).finish().filter("entrylineseq is not null");
        HashSet snumbers = new HashSet(CHECK_SNRANGE_LIMIT);
        HashMap dimnumbersMap = new HashMap(this.dims.size());
        if (issubmit.booleanValue()) {
            Integer i = 1;
            while (i <= this.dims.size()) {
                dimnumbersMap.put(i, new HashSet(CHECK_SNRANGE_LIMIT));
                serializable = i;
                Integer n = i = Integer.valueOf(i + 1);
            }
        }
        if (this.allbaseqty <= CHECK_SNRANGE_LIMIT) {
            billSnRelationDimCols.add("snnumber");
            DataSet copyDataSet = billSnRelWithMatDataSet.copy().select(billSnRelationDimCols.toArray(new String[billSnRelationDimCols.size()]));
            serializable = null;
            try {
                copyDataSet.forEach(row -> {
                    snumbers.add(row.getString("snnumber"));
                    if (issubmit.booleanValue()) {
                        for (Map.Entry<Integer, Map<String, Object>> dim : this.dims.entrySet()) {
                            Integer seq = dim.getKey();
                            String dimkey = DIM_PRE + seq;
                            String dimnum = row.getString(dimkey);
                            if (dimnum == null || dimnum.isEmpty()) continue;
                            ((Set)dimnumbersMap.get(seq)).add(row.getString(dimkey));
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                if (copyDataSet != null) {
                    if (serializable != null) {
                        try {
                            copyDataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                    } else {
                        copyDataSet.close();
                    }
                }
            }
        }
        SqlBuilder snmainFileSqlBuilder = new SqlBuilder();
        snmainFileSqlBuilder.append("select ts.fid as mainfileid,ts.fnumber as mfsnnumber, ts.fmaterialid as mfmaterialid,ts.finvorgid as mfinvorg,ts.flotnumber as mflotnumber", new Object[0]).append(",ts.ffinalaudittrailid as finalaudittrailid,ts.foccupybillid as occupybillid,ts.foccupybilltype as occupybilltype", new Object[0]).append(",ts.foccupybillentryid as occupybillentryid,ts.foccupybillentrytype as occupybillentrytype,ts.fsnstatus as snstatus", new Object[0]);
        if (this.trackValMaps.size() > 0) {
            String trkvalSelectProps = this.buildSnTrackSelectProps("tsm_f.", this.trackValMaps.keySet(), TRKVAL_PRE);
            snmainFileSqlBuilder.append(trkvalSelectProps, new Object[0]).append(" from t_bd_snmainfile ts", new Object[0]).append(" left join t_bd_snmovetrack_rel tsr", new Object[0]).append(" on ts.ffinalaudittrailid = tsr.fid", new Object[0]).append(" left join t_bd_snmovetrack tsm_f", new Object[0]).append(" on tsr.ftrackid = tsm_f.fid", new Object[0]);
        } else {
            snmainFileSqlBuilder.append(" from t_bd_snmainfile ts", new Object[0]);
        }
        snmainFileSqlBuilder.append(" where ", new Object[0]).append("ts.fmasterfiletypeid = ?", new Object[]{this.masterfiletypeid});
        if (this.allbaseqty <= CHECK_SNRANGE_LIMIT && snumbers.size() > 0) {
            snmainFileSqlBuilder.append(" and ", new Object[0]);
            snmainFileSqlBuilder.appendIn("ts.fnumber", snumbers.toArray());
        }
        if (this.snUnqctrl.contains("2")) {
            snmainFileSqlBuilder.append(" and ", new Object[0]);
            snmainFileSqlBuilder.appendIn("ts.fmaterialid", materialmasterids.toArray());
        }
        DataSet snMainFileDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)snmainFileSqlBuilder);
        JoinDataSet tempDataSet = billSnRelWithMatDataSet.leftJoin(snMainFileDataSet).on("snnumber", "mfsnnumber");
        for (String string : this.snUnqctrl) {
            if (string.equals("2")) {
                tempDataSet = tempDataSet.on("materialmasterid", "mfmaterialid");
            }
            if (string.equals("1")) {
                tempDataSet = tempDataSet.on("sninvorg", "mfinvorg");
            }
            if (!string.equals("3")) continue;
            tempDataSet = tempDataSet.on("lotnum", "mflotnumber");
        }
        billSnRelWithMatDataSet = tempDataSet.select(billSnRelWithMatDataSet.getRowMeta().getFieldNames(), snMainFileDataSet.getRowMeta().getFieldNames()).finish().filter("snnumber is not null");
        if (!issubmit.booleanValue()) {
            return billSnRelWithMatDataSet;
        }
        for (Map.Entry entry : this.dims.entrySet()) {
            Integer seq = (Integer)entry.getKey();
            String dimkey = DIM_PRE + seq;
            Map dimval = (Map)entry.getValue();
            Long dimid = (Long)dimval.get("id");
            Set dimUnqctrls = (Set)dimval.get("sncheckrange");
            StringBuilder dimSelects = new StringBuilder("id as mfid").append(dimkey).append(",material as mfmaterialid").append(dimkey).append(",invorg as mfinvorg").append(dimkey).append(",lotnumber as mflotnumber").append(dimkey).append(",sndimentity.sndimnumber as mfnumber").append(dimkey);
            QFilter dimFilter = new QFilter("sndimentity.sndimitem", "=", (Object)dimid);
            dimFilter.and("masterfiletype", "=", (Object)this.masterfiletypeid);
            Set dimnums = (Set)dimnumbersMap.get(seq);
            if (dimUnqctrls.contains("2")) {
                dimFilter.and("material", "in", materialmasterids);
            }
            if (this.allbaseqty <= CHECK_SNRANGE_LIMIT && dimnums.size() > 0) {
                dimFilter.and("sndimentity.sndimnumber", "in", (Object)dimnums);
            }
            DataSet dimmainfDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_snmainfile", (String)dimSelects.toString(), (QFilter[])dimFilter.toArray(), (String)"");
            JoinDataSet dimtempDataSet = billSnRelWithMatDataSet.leftJoin(dimmainfDataSet).on(dimkey, "mfnumber" + dimkey);
            for (String unqctrl : dimUnqctrls) {
                if (unqctrl.equals("2")) {
                    dimtempDataSet = dimtempDataSet.on("materialmasterid", "mfmaterialid" + dimkey);
                }
                if (unqctrl.equals("1")) {
                    dimtempDataSet = dimtempDataSet.on("invorgid", "mfinvorg" + dimkey);
                }
                if (!unqctrl.equals("3")) continue;
                dimtempDataSet = dimtempDataSet.on("lotnum", "mflotnumber" + dimkey);
            }
            billSnRelWithMatDataSet = dimtempDataSet.select(billSnRelWithMatDataSet.getRowMeta().getFieldNames(), new String[]{"mfid" + dimkey}).finish();
        }
        SqlBuilder snmoveTrackSqlBuilder = new SqlBuilder();
        snmoveTrackSqlBuilder.append("select r.fid as relid,r.fsnmainfileid as his_snmainfile,t.fbillid as his_billid,t.fbillentryid as his_billentryid,t.fbillstatus as his_billstatus,", new Object[0]).append("t.fincreaseinvcounter as his_increaseinvcounter,t.fsubstractinvcounter as his_substractinvcounter,t.ftraincreaseinvcounter as his_traincreaseinvcounter,t.ftrasubstractinvcounter as his_trasubstractinvcounter", new Object[0]);
        if (this.trackMaps.size() > 0) {
            String string = this.buildSnTrackSelectProps("t.", this.trackMaps.keySet(), TRK_PRE);
            snmoveTrackSqlBuilder.append(string, new Object[0]);
        }
        snmoveTrackSqlBuilder.append(" from t_bd_snmovetrack t join t_bd_snmovetrack_rel r on t.fid = r.ftrackid where ", new Object[0]).appendIn("t.fbillid", this.handleBillIds.toArray()).append(" and t.fsnmainfileid = 0", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)snmoveTrackSqlBuilder);
        billSnRelWithMatDataSet = billSnRelWithMatDataSet.leftJoin(dataSet).on("mainfileid", "his_snmainfile").on("billid", "his_billid").on("entryid", "his_billentryid").select(billSnRelWithMatDataSet.getRowMeta().getFieldNames(), dataSet.getRowMeta().getFieldNames()).finish();
        DataSet materialInvDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_materialinventoryinfo", (String)"id,sngentimepoint", (QFilter[])new QFilter("masterid", "in", materialmasterids).and("enableserial", "=", (Object)Boolean.TRUE).toArray(), (String)"");
        DataSet result = billSnRelWithMatDataSet.leftJoin(materialInvDataSet).on("materialid", "id").select(billSnRelWithMatDataSet.getRowMeta().getFieldNames(), new String[]{"sngentimepoint"}).finish();
        return result.orderBy(new String[]{"billid", "entryid"});
    }

    private String buildSnTrackSelectProps(String tablepre, Set<String> cols, String colpre) {
        StringBuilder propsBuilder = new StringBuilder();
        Map fieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_snmovetrack").getAllFields();
        cols.forEach(col -> {
            String dbCol = ((IDataEntityProperty)fieldTypes.get(col)).getAlias();
            propsBuilder.append(',').append(tablepre).append(dbCol).append(" as ").append(colpre).append((String)col);
        });
        return propsBuilder.toString();
    }

    private void validateSNDataSubmit(DataSet serialNumberDataSet) {
        Long billid;
        InvCounterEntity invCounter = SNBillConfigHelper.getInvCounterEntity(this.opeAttrMap);
        int increaseinvcounter = invCounter.getInvIncrease();
        int substractinvcounter = invCounter.getInvSubstract();
        int traincreaseinvcounter = invCounter.getTransInvIncrease();
        int trasubstractinvcounter = invCounter.getTransInvSubstract();
        Map<Long, List<BFRow>> sourceBills = this.getSourceBills();
        Map<Long, Set<String>> snnumberEntryMap = this.initSnnumberEntryMap();
        boolean allowsplit = this.cfg.getBoolean("allowsplit");
        Map<Long, Map<Long, String>> oldRelSeqEntries = this.getHisSNrels();
        HashSet<String> snNumberUnqs = new HashSet<String>(2000);
        HashMap<Long, Integer> entrySNCounter = new HashMap<Long, Integer>(2000);
        HashMap dimNumberUnqsMap = new HashMap(this.dims.size());
        HashMap<String, Set> dimUnqCtrls = new HashMap<String, Set>(this.dims.size());
        if (!this.dims.isEmpty()) {
            for (Map.Entry<Integer, Map<String, Object>> entry : this.dims.entrySet()) {
                Integer seq = entry.getKey();
                String dimkey = DIM_PRE + seq;
                Map<String, Object> dimval = entry.getValue();
                Set checkranges = (Set)dimval.get("sncheckrange");
                dimUnqCtrls.put(dimkey, checkranges);
                dimNumberUnqsMap.put(dimkey, new HashSet(2000));
            }
        }
        for (Row row : serialNumberDataSet) {
            Map<Long, String> oldRelSeqs;
            String snnumber = row.getString("snnumber");
            Integer lineseq = row.getInteger("entrylineseq");
            billid = row.getLong("billid");
            String entrykey = row.getString("entrykey");
            Long entryid = row.getLong("entryid");
            Long materialmasterid = row.getLong("materialmasterid");
            Long invorgid = row.getLong("sninvorg");
            if (SerialNumberValidator.isEmpty(invorgid)) {
                invorgid = row.getLong("invorgid");
            }
            String lotnum = row.getString("lotnum");
            Long mainFileId = row.getLong("mainfileid");
            Long finalaudittrailid = row.getLong("finalaudittrailid");
            Long relid = row.getLong("relid");
            String handlestatus = row.getString("handlestatus");
            Map<String, Object> snDataSetRow = this.getSerialNumDataSetRowToMap(row);
            String snNumberUnq = this.buildSnunqstr(this.snUnqctrl, snnumber, materialmasterid, invorgid, lotnum);
            if (snNumberUnqs.contains(snNumberUnq)) {
                this.validateInfo.putBillEntryInfo(billid, entrykey, lineseq, String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u201c%s\u201d\u91cd\u590d\u3002", (String)"SerialNumberValidator_1", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber));
            } else {
                snNumberUnqs.add(snNumberUnq);
            }
            if (!SerialNumberValidator.isEmpty(mainFileId)) {
                if (!materialmasterid.equals(row.getLong("mfmaterialid"))) {
                    this.validateInfo.putBillEntryInfo(billid, entrykey, lineseq, String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u201c%s\u201d\u5bf9\u5e94\u7269\u6599\u4e0e\u5355\u636e\u4e0a\u4e0d\u4e00\u81f4\u3002", (String)"SerialNumberValidator_2", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber));
                }
            } else {
                for (Map.Entry dimUnqCtrlEntry : dimUnqCtrls.entrySet()) {
                    Long dimsnid;
                    String dimkey = (String)dimUnqCtrlEntry.getKey();
                    Set dimUnqctrl = (Set)dimUnqCtrlEntry.getValue();
                    String dimnumber = row.getString(dimkey);
                    if (dimnumber == null || dimnumber.isEmpty()) continue;
                    String dimNumberUnq = this.buildSnunqstr(dimUnqctrl, dimnumber, materialmasterid, invorgid, lotnum);
                    Set dimNumberUnqs = (Set)dimNumberUnqsMap.get(dimkey);
                    if (dimNumberUnqs.contains(dimNumberUnq)) {
                        this.validateInfo.putBillEntryInfo(billid, entrykey, lineseq, String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u201c%1$s\u201d\u7684\u7ef4\u5ea6\u201c%2$s\u201d\u5728\u672c\u6279\u5355\u636e\u4e2d\u503c\u91cd\u590d\u3002", (String)"SerialNumberValidator_3", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber, dimnumber));
                    } else {
                        dimNumberUnqs.add(dimNumberUnq);
                    }
                    if (allowsplit && "B".equals(handlestatus) || SerialNumberValidator.isEmpty(dimsnid = row.getLong("mfid" + dimkey))) continue;
                    this.validateInfo.putBillEntryInfo(billid, entrykey, lineseq, String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u201c%s\u201d\u7684\u7ef4\u5ea6\u201c%2$s\u201d\u5df2\u7ecf\u5b58\u5728\u4e8e\u7cfb\u7edf\u3002", (String)"SerialNumberValidator_4", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber, dimnumber));
                }
            }
            if (!allowsplit || !"B".equals(handlestatus)) {
                SNMainFileStatusValidateHelper.validateSNStatusBySubmit(snDataSetRow, this.opeAttrMap, this.validateInfo);
                if (!SerialNumberValidator.isEmpty(relid) && !SerialNumberValidator.isEmpty(finalaudittrailid) && relid < finalaudittrailid) {
                    int his_increaseinvcounter = row.getInteger("his_increaseinvcounter");
                    int his_substractinvcounter = row.getInteger("his_substractinvcounter");
                    int his_traincreaseinvcounter = row.getInteger("his_traincreaseinvcounter");
                    int his_trasubstractinvcounter = row.getInteger("his_trasubstractinvcounter");
                    if (his_increaseinvcounter != increaseinvcounter || his_substractinvcounter != substractinvcounter || his_traincreaseinvcounter != traincreaseinvcounter || his_trasubstractinvcounter != trasubstractinvcounter) {
                        this.validateInfo.putBillEntryInfo(billid, entrykey, lineseq, String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u201c%s\u201d\u72b6\u6001\u8ba1\u6570\u89c4\u5219\u4e0e\u4e0a\u4e00\u6b21\u5ba1\u6838\u65f6\u4e0d\u4e00\u81f4\u3002", (String)"SerialNumberValidator_5", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber));
                    }
                    this.validateOldTrackColBySubmit(row);
                }
                this.validateTrackColBySubmit(row, finalaudittrailid, relid);
            }
            if (!oldRelSeqEntries.isEmpty() && !SerialNumberValidator.isEmpty(relid) && (oldRelSeqs = oldRelSeqEntries.get(entryid)) != null) {
                oldRelSeqs.remove(relid);
            }
            entrySNCounter.compute(entryid, (k, v) -> {
                if (v == null) {
                    v = 0;
                }
                v = v + 1;
                return v;
            });
            if (sourceBills.isEmpty() || !StringUtils.isNotEmpty((String)snnumber)) continue;
            snnumberEntryMap.get(entryid).add(snnumber);
        }
        if (!sourceBills.isEmpty()) {
            this.validateSNFromSourceBill(snnumberEntryMap, sourceBills);
        }
        for (Map.Entry<Number, Map<String, Object>> entry : this.billentriesMap.entrySet()) {
            Long entryid = (Long)entry.getKey();
            DynamicObject billentry = (DynamicObject)entry.getValue();
            billid = billentry.getLong("id");
            Integer lineseq = billentry.getInt(this.seqcol);
            BigDecimal baseqty = billentry.getBigDecimal(this.snbaseqtycol);
            Integer snnumberCount = (Integer)entrySNCounter.get(entryid);
            if (baseqty == null || baseqty.compareTo(BigDecimal.ZERO) == 0) {
                this.validateInfo.putBillEntryInfo(billid, this.entrytype, lineseq, ResManager.loadKDString((String)"\u672a\u5f55\u5165\u57fa\u672c\u6570\u91cf\u3002", (String)"SerialNumberValidator_6", (String)"scmc-sbs-form", (Object[])new Object[0]));
            } else if (baseqty.compareTo(new BigDecimal(baseqty.intValue())) != 0) {
                this.validateInfo.putBillEntryInfo(billid, this.entrytype, lineseq, ResManager.loadKDString((String)"\u57fa\u672c\u6570\u91cf\u4e0d\u5141\u8bb8\u4e3a\u5c0f\u6570\u3002", (String)"SerialNumberValidator_7", (String)"scmc-sbs-form", (Object[])new Object[0]));
            }
            this.validateSNMustInput(billentry, snnumberCount, baseqty);
            Map<Long, String> oldRelSeqs = oldRelSeqEntries.get(entryid);
            if (oldRelSeqs == null || oldRelSeqs.size() <= 0) continue;
            int index = 1;
            StringBuilder lacksns = new StringBuilder();
            for (String snumber : oldRelSeqs.values()) {
                if (index > 5) {
                    lacksns.append("...");
                    break;
                }
                if (index != 1) {
                    lacksns.append(',');
                }
                lacksns.append(snumber);
                ++index;
            }
            this.validateInfo.putBillEntryInfo(billid, this.entrytype, lineseq, String.format(ResManager.loadKDString((String)"\u91cd\u63d0\u4ea4\u7f3a\u5c11\u4e86\u4ee5\u4e0b\u5e8f\u5217\u53f7\u6216\u66f4\u6539\u4e86\u5176\u7269\u6599:%s\u3002", (String)"SerialNumberValidator_8", (String)"scmc-sbs-form", (Object[])new Object[0]), lacksns.toString()));
        }
    }

    private void validateSNFromSourceBill(Map<Long, Set<String>> snnumberEntryMap, Map<Long, List<BFRow>> sourceBills) {
        Map<Object, Object> sourceBillEntrySnMap = new HashMap();
        HashSet<Long> sourceBillId = new HashSet<Long>(1);
        HashSet<Long> sourceEntryId = new HashSet<Long>(4);
        HashMap<Long, Set<Long>> entryIdMapping = new HashMap<Long, Set<Long>>();
        HashSet<Long> set = null;
        for (Map.Entry<Long, List<BFRow>> source : sourceBills.entrySet()) {
            List<BFRow> value = source.getValue();
            for (BFRow row : value) {
                BFRowId id = row.getId();
                BFRowId sId = row.getSId();
                Long entryId = id.getEntryId();
                if (!snnumberEntryMap.containsKey(entryId)) continue;
                sourceBillId.add(sId.getBillId());
                sourceEntryId.add(sId.getEntryId());
                if (entryIdMapping.containsKey(entryId)) {
                    ((Set)entryIdMapping.get(entryId)).add(sId.getEntryId());
                    continue;
                }
                set = new HashSet<Long>();
                set.add(sId.getEntryId());
                entryIdMapping.put(entryId, set);
            }
        }
        sourceBillEntrySnMap = this.getSourceBillEntrySnList(sourceBillId, sourceEntryId, entryIdMapping);
        if (!sourceBillEntrySnMap.isEmpty()) {
            HashSet sourceEntryNumber = null;
            for (Map.Entry<Long, DynamicObject> entry : this.billentriesMap.entrySet()) {
                Long entryId = entry.getKey();
                if (!snnumberEntryMap.containsKey(entryId) || snnumberEntryMap.get(entryId).isEmpty()) continue;
                Set<String> entrySNnumber = snnumberEntryMap.get(entryId);
                sourceEntryNumber = new HashSet();
                for (Long item : (Set)entryIdMapping.get(entryId)) {
                    if (!sourceBillEntrySnMap.containsKey(item)) continue;
                    sourceEntryNumber.addAll((Collection)sourceBillEntrySnMap.get(item));
                }
                if (sourceEntryNumber.isEmpty()) continue;
                entrySNnumber.removeAll(sourceEntryNumber);
                if (entrySNnumber.size() == 0) continue;
                DynamicObject billEntry = entry.getValue();
                Long billid = billEntry.getLong("id");
                Integer lineseq = billEntry.getInt(this.seqcol);
                for (String number : entrySNnumber) {
                    this.validateInfo.putBillEntryInfo(billid, this.entrytype, lineseq, String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u201c%1$s\u201d\u4e0d\u5728\u6765\u6e90\u5355\u636e\u4e2d\u3002", (String)"SerialNumberValidator_9", (String)"scmc-sbs-form", (Object[])new Object[0]), number));
                }
            }
        }
    }

    private Map<Long, Set<String>> getSourceBillEntrySnList(Set<Long> billIds, Set<Long> entryIds, Map<Long, Set<Long>> entryIdMapping) {
        QFilter[] filter = new QFilter("billid", "in", billIds).and("entryid", "in", entryIds).and("entryentity.snnumber", "is not null", null).toArray();
        DynamicObjectCollection snnumbers = QueryServiceHelper.query((String)"sbs_billsnrelation", (String)"entryid, entryentity.snnumber number ", (QFilter[])filter);
        Map<Long, List<DynamicObject>> fentryIdMaps = snnumbers.stream().collect(Collectors.groupingBy(i -> (Long)i.get("entryid")));
        HashMap<Long, Set<String>> result = new HashMap<Long, Set<String>>(fentryIdMaps.size());
        for (Map.Entry<Long, List<DynamicObject>> obj : fentryIdMaps.entrySet()) {
            Set numbers = obj.getValue().stream().map(i -> (String)i.get("number")).collect(Collectors.toSet());
            result.put(obj.getKey(), numbers);
        }
        return result;
    }

    private Map<Long, List<BFRow>> getSourceBills() {
        return BFTrackerServiceHelper.findDirtSourceBills((String)this.billtype, (Long[])this.billIds.toArray(new Long[1]));
    }

    private Map<Long, Set<String>> initSnnumberEntryMap() {
        HashMap<Long, Set<String>> result = new HashMap<Long, Set<String>>(this.billentriesMap.size());
        for (Map.Entry<Long, DynamicObject> id : this.billentriesMap.entrySet()) {
            result.put(id.getKey(), new HashSet());
        }
        return result;
    }

    private void validateTrackColBySubmit(Row row, Long finalaudittrailid, Long relid) {
        if (this.trackValMaps.isEmpty()) {
            return;
        }
        if (SerialNumberValidator.isEmpty(finalaudittrailid)) {
            return;
        }
        if (!SerialNumberValidator.isEmpty(relid) && relid < finalaudittrailid) {
            return;
        }
        String snnumber = row.getString("snnumber");
        Integer lineseq = row.getInteger("entrylineseq");
        Long billid = row.getLong("billid");
        String entrykey = row.getString("entrykey");
        Long entryid = row.getLong("entryid");
        for (Map.Entry<String, String> valEntry : this.trackValMaps.entrySet()) {
            String tgrcol = valEntry.getKey();
            String srccol = valEntry.getValue();
            Object tgrval = SerialNumberValidator.getFormatValue(row.get(TRKVAL_PRE + tgrcol));
            Object srcval = SerialNumberValidator.getFormatValue(this.billentriesMap.get(entryid).get(srccol));
            if (srcval.equals(tgrval)) continue;
            Map<String, String> nameEntry = this.trackValNames.get(tgrcol);
            this.validateInfo.putBillEntryInfo(billid, entrykey, lineseq, String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u201c%1$s\u201d\uff1a\u5f53\u524d\u8f68\u8ff9\u4e0a\u201c%2$s\u201d\u4e0e\u5355\u636e\u4e0a\u201c%3$s\u201d\u7684\u503c\u4e0d\u4e00\u81f4\u3002", (String)"SerialNumberValidator_10", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber, nameEntry.get("sntrkvalcolno"), nameEntry.get("sntrkvalsrcbillcolno")));
        }
    }

    private void validateOldTrackColBySubmit(Row row) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"bd_snmovetrack");
        String snnumber = row.getString("snnumber");
        Integer lineseq = row.getInteger("entrylineseq");
        Long billid = row.getLong("billid");
        String entrykey = row.getString("entrykey");
        Long entryid = row.getLong("entryid");
        for (Map.Entry<String, String> entry : this.trackMaps.entrySet()) {
            IDataEntityProperty prop;
            String tgrcol = entry.getKey();
            String srccol = entry.getValue();
            Object tgrval = SerialNumberValidator.getFormatValue(row.get(TRK_PRE + tgrcol));
            Object srcval = SerialNumberValidator.getFormatValue(this.billentriesMap.get(entryid).get(srccol));
            if (srcval.equals(tgrval)) continue;
            Map<String, String> nameEntry = this.trackNames.get(tgrcol);
            String snTrackColNo = nameEntry.get("sntrackcolno");
            if (!StringUtils.isBlank((String)tgrcol) && (prop = entityType.findProperty(tgrcol)) != null) {
                snTrackColNo = prop.getDisplayName().getLocaleValue();
            }
            this.validateInfo.putBillEntryInfo(billid, entrykey, lineseq, String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u201c%1$s\u201d\uff1a\u201c%2$s\u201d\u4e0e\u5e8f\u5217\u53f7\u4e3b\u6863\u4e2d\u7684\u8bb0\u5f55\u4e0d\u4e00\u81f4\u3002", (String)"SerialNumberValidator_11", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber, snTrackColNo));
        }
    }

    private void validateSNMustInput(DynamicObject billentry, Integer snnumberCount, BigDecimal baseqty) {
        if (snnumberCount == null || snnumberCount.equals(0)) {
            boolean ismustinput = true;
            boolean isoutputrequest = this.isOutputRequestMaps.get(billentry.getLong(this.materialmastercol));
            boolean isreqbill = (Boolean)this.opeAttrMap.get("snreqbill");
            boolean allowempty = (Boolean)this.opeAttrMap.get("allowempty");
            boolean isinitbill = "im_saloutbill".equals(this.billtype) || "im_purinbill".equals(this.billtype) ? billentry.getBoolean("isinitbill") : false;
            if (isinitbill) {
                ismustinput = false;
            } else if (isreqbill) {
                ismustinput = false;
            } else if (isoutputrequest) {
                ismustinput = true;
            } else {
                boolean bl = ismustinput = !allowempty;
            }
            if (ismustinput) {
                this.validateInfo.putBillEntryInfo(billentry.getLong("id"), this.entrytype, billentry.getInt(this.seqcol), ResManager.loadKDString((String)"\u672a\u5f55\u5165\u5e8f\u5217\u53f7\u3002", (String)"SerialNumberValidator_12", (String)"scmc-sbs-form", (Object[])new Object[0]));
            }
        } else if (!snnumberCount.equals(Math.abs(baseqty.intValue()))) {
            this.validateInfo.putBillEntryInfo(billentry.getLong("id"), this.entrytype, billentry.getInt(this.seqcol), ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u6570\u91cf[{0}]\u548c\u7269\u6599\u6570\u91cf[{1}]\u4e0d\u4e00\u81f4\u3002", (String)"SBS-E-472278", (String)"scmc-sbs-form", (Object[])new Object[]{snnumberCount, Math.abs(baseqty.intValue())}));
        }
    }

    private Map<String, Object> getSerialNumDataSetRowToMap(Row row) {
        HashMap<String, Object> map = new HashMap<String, Object>(11);
        map.put("billtype", this.billtype);
        map.put("entrykey", row.getString("entrykey"));
        map.put("billid", row.getLong("billid"));
        map.put("entryid", row.getLong("entryid"));
        map.put("lineseq", row.getInteger("entrylineseq"));
        map.put("mainfileid", row.getLong("mainfileid"));
        map.put("snnumber", row.getString("snnumber"));
        map.put("snstatus", row.getString("snstatus"));
        map.put("sngentimepoint", row.getString("sngentimepoint"));
        map.put("occupybillid", row.getLong("occupybillid"));
        map.put("occupybillentryid", row.getLong("occupybillentryid"));
        map.put("srcbillid", row.getLong("srcbillid"));
        map.put("srcentryid", row.getLong("srcentryid"));
        map.put("srcisreq", row.getBoolean("srcisreq"));
        return map;
    }

    private String buildSnunqstr(Set<String> unqctrl, String snnumber, Long materialmasterid, Long invorgid, String lotnum) {
        StringBuilder unqstrbuilder = new StringBuilder(snnumber);
        if (unqctrl.contains("2")) {
            unqstrbuilder.append('.').append(materialmasterid);
        }
        if (unqctrl.contains("1")) {
            unqstrbuilder.append('.').append(invorgid);
        }
        if (unqctrl.contains("3")) {
            unqstrbuilder.append('.').append(lotnum);
        }
        return unqstrbuilder.toString();
    }

    private Map<Long, Map<Long, String>> getHisSNrels() {
        SqlBuilder oldSeqSqlBuilder = new SqlBuilder();
        oldSeqSqlBuilder.append("select r.fid as relid,m.fnumber as snnumber,t.fbillentryid as billentryid", new Object[0]).append(" from t_bd_snmovetrack t join t_bd_snmovetrack_rel r on t.fid = r.ftrackid", new Object[0]).append(" join t_bd_snmainfile m on r.fsnmainfileid = m.fid where ", new Object[0]).appendIn("t.fbillid", this.handleBillIds.toArray()).append(" and t.fbillentrytype = ?", new Object[]{this.entrytype});
        HashMap<Long, Map<Long, String>> oldRelSeqEntries = new HashMap<Long, Map<Long, String>>(this.billentriesMap.size());
        try (DataSet oldSeqDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)oldSeqSqlBuilder);){
            for (Row row : oldSeqDataSet) {
                Long billentryid = row.getLong("billentryid");
                Long relid = row.getLong("relid");
                String snnumber = row.getString("snnumber");
                Map oldRelSeqs = oldRelSeqEntries.getOrDefault(billentryid, new HashMap(20));
                oldRelSeqs.put(relid, snnumber);
                if (oldRelSeqEntries.containsKey(billentryid)) continue;
                oldRelSeqEntries.put(billentryid, oldRelSeqs);
            }
        }
        return oldRelSeqEntries;
    }

    private void validateSNDataUnaudit(DataSet serialNumberDataSet) {
        boolean allowsplit = this.cfg.getBoolean("allowsplit");
        for (Row row : serialNumberDataSet) {
            String billtype = row.getString("billtype");
            String snnumber = row.getString("snnumber");
            Integer lineseq = row.getInteger("entrylineseq");
            Long billid = row.getLong("billid");
            Long entryid = row.getLong("entryid");
            String entrykey = row.getString("entrykey");
            Long occupybillid = row.getLong("occupybillid");
            Long occupybillentryid = row.getLong("occupybillentryid");
            String handlestatus = row.getString("handlestatus");
            if (allowsplit && !"B".equals(handlestatus) || !this.checkOccupymove(billid, billtype, entryid, entrykey, occupybillid, occupybillentryid).booleanValue()) continue;
            this.validateInfo.putBillEntryInfo(billid, entrykey, lineseq, String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u201c%s\u201d:\u5df2\u88ab\u5176\u5b83\u5355\u636e\u5360\u7528\u3002", (String)"SerialNumberValidator_14", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber));
        }
    }

    private Boolean checkOccupymove(Long billId, String billtype, Long entryId, String entrykey, Long occupybillid, Long occupybillentryid) {
        List upNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)billtype, (String)entrykey, (Long[])new Long[]{billId}, (Long[])new Long[]{entryId}, null);
        if (upNodes == null || upNodes.isEmpty()) {
            boolean isreqbill = (Boolean)this.opeAttrMap.get("snreqbill");
            Boolean occupymove = (Boolean)this.opeAttrMap.get("occupymove");
            if (isreqbill) {
                if (occupymove.booleanValue()) {
                    if (!SerialNumberValidator.isEmpty(occupybillid) && !billId.equals(occupybillid)) {
                        return true;
                    }
                    if (!SerialNumberValidator.isEmpty(occupybillentryid) && !entryId.equals(occupybillentryid)) {
                        return true;
                    }
                }
            } else if (!SerialNumberValidator.isEmpty(occupybillid) || !SerialNumberValidator.isEmpty(occupybillentryid)) {
                return true;
            }
            return false;
        }
        ArrayList<Long> sourceBillId = new ArrayList<Long>();
        ArrayList<Long> sourceBillEntryId = new ArrayList<Long>();
        if (!upNodes.isEmpty()) {
            this.getAllSourceId(((BFRowLinkUpNode)upNodes.get(0)).getSNodes(), sourceBillId, sourceBillEntryId);
            if (sourceBillId.isEmpty() || sourceBillEntryId.isEmpty()) {
                if (!SerialNumberValidator.isEmpty(occupybillid) && !billId.equals(occupybillid)) {
                    return true;
                }
                if (!SerialNumberValidator.isEmpty(occupybillentryid) && !billId.equals(occupybillentryid)) {
                    return true;
                }
            } else {
                sourceBillId.add(billId);
                sourceBillEntryId.add(entryId);
                if (!SerialNumberValidator.isEmpty(occupybillid) && !sourceBillId.contains(occupybillid)) {
                    return true;
                }
                if (!SerialNumberValidator.isEmpty(occupybillentryid) && !sourceBillEntryId.contains(occupybillentryid)) {
                    return true;
                }
            }
        }
        return false;
    }

    private void getAllSourceId(Map<BFRowId, BFRowLinkUpNode> nodes, List<Long> sourceBillId, List<Long> sourceBillEntryId) {
        if (nodes.isEmpty()) {
            return;
        }
        for (Map.Entry<BFRowId, BFRowLinkUpNode> node : nodes.entrySet()) {
            BFRowId key = node.getKey();
            sourceBillId.add(key.getBillId());
            sourceBillEntryId.add(key.getEntryId());
            if (node.getValue().getSNodes().size() <= 0) continue;
            this.getAllSourceId(node.getValue().getSNodes(), sourceBillId, sourceBillEntryId);
        }
    }

    private static boolean isEmpty(Long id) {
        return id == null || id.equals(0L);
    }

    private DynamicObjectCollection buildBillentriesFromSingleDynamicObj(String billSelectProps) {
        DynamicObjectCollection billentries = QueryServiceHelper.query((String)this.billtype, (String)billSelectProps, (QFilter[])new QFilter("id", "=", (Object)-1).toArray());
        String[] entrypathNodes = this.entrypath.split("\\.");
        if (entrypathNodes.length == 1) {
            for (DynamicObject entryObj : this.billObj.getDynamicObjectCollection(this.entrytype)) {
                this.fillDynamicValToBillentries(billentries, this.billObj, entryObj, null);
            }
        } else {
            for (DynamicObject entryObj : this.billObj.getDynamicObjectCollection(entrypathNodes[0])) {
                for (DynamicObject subentryObj : entryObj.getDynamicObjectCollection(entrypathNodes[1])) {
                    this.fillDynamicValToBillentries(billentries, this.billObj, entryObj, subentryObj);
                }
            }
        }
        return billentries;
    }

    private void fillDynamicValToBillentries(DynamicObjectCollection billentries, DynamicObject billObj, DynamicObject entryObj, DynamicObject subentryObj) {
        DynamicObject material;
        Object materialObj = null;
        if (StringUtils.isNotEmpty((String)this.materialcol)) {
            materialObj = SerialNumberValidator.getDynamicVal(billObj, entryObj, subentryObj, this.materialcol, false);
        } else {
            if (subentryObj != null) {
                entryObj = subentryObj;
            }
            DynamicObject materialMasterInfo = (DynamicObject)SerialNumberValidator.getValueByName(billObj, entryObj, this.materialmastercol, true);
            DynamicObject invOrgInfo = (DynamicObject)SerialNumberValidator.getValueByName(billObj, entryObj, this.invorgcol, false);
            materialObj = SNBillConfigHelper.getMaterialInvInfo(materialMasterInfo.getLong("masterid"), invOrgInfo.getLong("id"));
        }
        if (materialObj != null && (material = (DynamicObject)materialObj).getBoolean("enableserial")) {
            DynamicObject billentry = billentries.addNew();
            billentry.set("id", billObj.get("id"));
            billentry.set(this.entrypathId, SerialNumberValidator.getDynamicVal(billObj, entryObj, subentryObj, this.entrypathId, true));
            for (String col : this.getBillDynamicCols()) {
                billentry.set(col, SerialNumberValidator.getDynamicVal(billObj, entryObj, subentryObj, col, true));
            }
            if (StringUtils.isNotEmpty((String)this.materialmastercol)) {
                billentry.set(this.materialmastercol, (Object)material.getDynamicObject("masterid").getLong("id"));
            }
        }
    }

    private static Object getValueByName(DynamicObject bill, DynamicObject entry, String colName, boolean isMaterialMasterCol) {
        if (colName.contains(".")) {
            return entry.get(SerialNumberValidator.getPureKey(colName, isMaterialMasterCol));
        }
        return bill.get(colName);
    }

    private static String getPureKey(String currentKey, boolean isMaterialMasterCol) {
        if (StringUtils.isNotEmpty((String)currentKey) && currentKey.lastIndexOf(46) != -1 && !isMaterialMasterCol) {
            return currentKey.substring(currentKey.lastIndexOf(46) + 1);
        }
        if (StringUtils.isNotEmpty((String)currentKey) && currentKey.lastIndexOf(46) != -1 && isMaterialMasterCol) {
            String[] split = currentKey.split("\\.");
            if ("masterid".equals(split[split.length - 1])) {
                return split[split.length - 2] + "." + split[split.length - 1];
            }
            return split[split.length - 1];
        }
        return currentKey;
    }

    private static Object getDynamicVal(DynamicObject billObj, DynamicObject entryObj, DynamicObject subentryObj, String attrpath, boolean getDynamicObjectId) {
        String[] attrpathNodes = attrpath.split("\\.");
        Object dynamicVal = null;
        switch (attrpathNodes.length) {
            case 1: {
                dynamicVal = billObj.get(attrpathNodes[0]);
                break;
            }
            case 2: {
                dynamicVal = entryObj.get(attrpathNodes[1]);
                break;
            }
            case 3: {
                dynamicVal = subentryObj.get(attrpathNodes[2]);
                break;
            }
            default: {
                dynamicVal = null;
            }
        }
        if (dynamicVal == null) {
            return null;
        }
        if (dynamicVal instanceof DynamicObject && getDynamicObjectId) {
            return ((DynamicObject)dynamicVal).getLong("id");
        }
        return dynamicVal;
    }

    private static Object getFormatValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (Timestamp.class.isInstance(value)) {
            return String.valueOf(((Timestamp)value).getTime());
        }
        return value;
    }
}

