/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.sn.mainfile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scmc.sbs.business.sn.ValidateInfoLogger;

public class SNMainFileStatusValidateHelper {
    private static Map<String, String> snStatusENToCN = new HashMap<String, String>(5);

    public static void validateSNStatusBySubmit(Map<String, Object> snDataSetRow, Map<String, Object> opeAttrMap, ValidateInfoLogger validateInfo) {
        SNMainFileStatusValidateHelper.checkOccupySNStatus(snDataSetRow, opeAttrMap, validateInfo);
        Long mainFileId = (Long)snDataSetRow.get("mainfileid");
        if (SNMainFileStatusValidateHelper.isEmpty(mainFileId)) {
            SNMainFileStatusValidateHelper.checkNewSnNumberStatus(snDataSetRow, opeAttrMap, validateInfo);
        } else {
            SNMainFileStatusValidateHelper.checkExistSnNumberStatus(snDataSetRow, opeAttrMap, validateInfo);
        }
    }

    private static void checkOccupySNStatus(Map<String, Object> snDataSetRow, Map<String, Object> opeAttrMap, ValidateInfoLogger validateInfo) {
        String billtype = (String)snDataSetRow.get("billtype");
        Long billid = (Long)snDataSetRow.get("billid");
        Long entryid = (Long)snDataSetRow.get("entryid");
        String entrykey = (String)snDataSetRow.get("entrykey");
        Integer lineseq = (Integer)snDataSetRow.get("lineseq");
        String snnumber = (String)snDataSetRow.get("snnumber");
        String snstatus = (String)snDataSetRow.get("snstatus");
        String snStatusCN = snStatusENToCN.get(snstatus);
        Long occupybillid = (Long)snDataSetRow.get("occupybillid");
        Long occupybillentryid = (Long)snDataSetRow.get("occupybillentryid");
        if (!(SNMainFileStatusValidateHelper.isEmpty(occupybillid) && SNMainFileStatusValidateHelper.isEmpty(occupybillentryid) || !SNMainFileStatusValidateHelper.checkOccupyMove(billid, billtype, entryid, entrykey, occupybillid, occupybillentryid))) {
            validateInfo.putBillEntryInfo(billid, entrykey, lineseq, String.format(ResManager.loadKDString((String)"\u5f15\u7528\u4e86\u5df2\u88ab\u5176\u4ed6\u5355\u636e\u5f15\u7528\u7684\u5e8f\u5217\u53f7\uff1a%1$s-%2$s\u3002", (String)"SNMainFileStatusValidateHelper_5", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber, snStatusCN));
        }
    }

    public static boolean checkOccupyMove(Long billId, String billtype, Long entryId, String entrykey, Long occupybillid, Long occupybillentryid) {
        List upNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)billtype, (String)entrykey, (Long[])new Long[]{billId}, (Long[])new Long[]{entryId}, null);
        if (upNodes == null || upNodes.isEmpty()) {
            return !billId.equals(occupybillid) || !entryId.equals(occupybillentryid);
        }
        ArrayList<Long> sourceBillId = new ArrayList<Long>();
        ArrayList<Long> sourceBillEntryId = new ArrayList<Long>();
        for (BFRowLinkUpNode upNode : upNodes) {
            SNMainFileStatusValidateHelper.getAllSourceId(upNode.getSNodes(), sourceBillId, sourceBillEntryId);
        }
        if (sourceBillId.isEmpty() || sourceBillEntryId.isEmpty()) {
            if (!SNMainFileStatusValidateHelper.isEmpty(occupybillid) && !billId.equals(occupybillid)) {
                return true;
            }
            if (!SNMainFileStatusValidateHelper.isEmpty(occupybillentryid) && !billId.equals(occupybillentryid)) {
                return true;
            }
        } else {
            sourceBillId.add(billId);
            sourceBillEntryId.add(entryId);
            if (!SNMainFileStatusValidateHelper.isEmpty(occupybillid) && !sourceBillId.contains(occupybillid)) {
                return true;
            }
            if (!SNMainFileStatusValidateHelper.isEmpty(occupybillentryid) && !sourceBillEntryId.contains(occupybillentryid)) {
                return true;
            }
        }
        return false;
    }

    private static void getAllSourceId(Map<BFRowId, BFRowLinkUpNode> nodes, List<Long> sourceBillId, List<Long> sourceBillEntryId) {
        if (nodes.isEmpty()) {
            return;
        }
        for (Map.Entry<BFRowId, BFRowLinkUpNode> node : nodes.entrySet()) {
            BFRowId key = node.getKey();
            sourceBillId.add(key.getBillId());
            sourceBillEntryId.add(key.getEntryId());
            if (node.getValue().getSNodes().size() <= 0) continue;
            SNMainFileStatusValidateHelper.getAllSourceId(node.getValue().getSNodes(), sourceBillId, sourceBillEntryId);
        }
    }

    private static void checkNewSnNumberStatus(Map<String, Object> snDataSetRow, Map<String, Object> opeAttrMap, ValidateInfoLogger validateInfo) {
        Long billid = (Long)snDataSetRow.get("billid");
        String entrykey = (String)snDataSetRow.get("entrykey");
        Integer lineseq = (Integer)snDataSetRow.get("lineseq");
        String snnumber = (String)snDataSetRow.get("snnumber");
        Boolean gensn = (Boolean)opeAttrMap.get("gensn");
        if (!gensn.booleanValue()) {
            validateInfo.putBillEntryInfo(billid, entrykey, lineseq, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u5e8f\u5217\u53f7\u4e3b\u6863\u4e0d\u5b58\u5728\uff0c\u5f53\u524d\u5355\u636e\u914d\u7f6e\u4e0d\u5141\u8bb8\u751f\u6210\u5e8f\u5217\u53f7\u3002", (String)"SNMainFileStatusValidateHelper_6", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber));
        }
        String invflu = (String)opeAttrMap.get("invflu");
        String sngenpoint = (String)snDataSetRow.get("sngentimepoint");
        if (invflu.equals("1")) {
            if (sngenpoint.equals("1")) {
                validateInfo.putBillEntryInfo(billid, entrykey, lineseq, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u5e8f\u5217\u53f7\u4e3b\u6863\u4e0d\u5b58\u5728\uff0c\u6b64\u7269\u6599\u5fc5\u987b\u9884\u5148\u751f\u6210\u5e8f\u5217\u53f7\uff0c\u8bf7\u68c0\u67e5\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u3002", (String)"SNMainFileStatusValidateHelper_7", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber));
            }
            if (sngenpoint.equals("3")) {
                validateInfo.putBillEntryInfo(billid, entrykey, lineseq, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u5e8f\u5217\u53f7\u4e3b\u6863\u4e0d\u5b58\u5728\uff0c\u6b64\u7269\u6599\u4ec5\u51fa\u5e93\u65f6\u751f\u6210\u5e8f\u5217\u53f7\uff0c\u8bf7\u68c0\u67e5\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u3002", (String)"SNMainFileStatusValidateHelper_9", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber));
            }
        } else if (invflu.equals("2") || invflu.equals("3")) {
            if (sngenpoint.equals("1")) {
                validateInfo.putBillEntryInfo(billid, entrykey, lineseq, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u5e8f\u5217\u53f7\u4e3b\u6863\u4e0d\u5b58\u5728\uff0c\u6b64\u7269\u6599\u5fc5\u987b\u9884\u5148\u751f\u6210\u5e8f\u5217\u53f7\uff0c\u8bf7\u68c0\u67e5\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u3002", (String)"SNMainFileStatusValidateHelper_7", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber));
            }
            if (sngenpoint.equals("2")) {
                validateInfo.putBillEntryInfo(billid, entrykey, lineseq, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u5e8f\u5217\u53f7\u4e3b\u6863\u4e0d\u5b58\u5728\uff0c\u6b64\u7269\u6599\u4ec5\u5165\u5e93\u65f6\u751f\u6210\u5e8f\u5217\u53f7\uff0c\u8bf7\u68c0\u67e5\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u3002", (String)"SNMainFileStatusValidateHelper_10", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber));
            }
        }
    }

    private static void checkExistSnNumberStatus(Map<String, Object> snDataSetRow, Map<String, Object> opeAttrMap, ValidateInfoLogger validateInfo) {
        Long billid = (Long)snDataSetRow.get("billid");
        String entrykey = (String)snDataSetRow.get("entrykey");
        Integer lineseq = (Integer)snDataSetRow.get("lineseq");
        String snnumber = (String)snDataSetRow.get("snnumber");
        String snstatus = (String)snDataSetRow.get("snstatus");
        String snStatusCN = snStatusENToCN.get(snstatus);
        Set allowStatus = (Set)opeAttrMap.get("snstatus");
        if (!allowStatus.contains(snstatus)) {
            validateInfo.putBillEntryInfo(billid, entrykey, lineseq, String.format(ResManager.loadKDString((String)"\u5f15\u7528\u4e86\u9519\u8bef\u72b6\u6001\u7684\u5e8f\u5217\u53f7\uff1a%1$s-%2$s\u3002", (String)"SNMainFileStatusValidateHelper_8", (String)"scmc-sbs-form", (Object[])new Object[0]), snnumber, snStatusCN));
        }
    }

    private static boolean isEmpty(Long id) {
        return id == null || id.equals(0L);
    }

    static {
        snStatusENToCN.put("A", ResManager.loadKDString((String)"\u5f85\u5165\u5e93", (String)"SNMainFileStatusValidateHelper_0", (String)"scmc-sbs-form", (Object[])new Object[0]));
        snStatusENToCN.put("B", ResManager.loadKDString((String)"\u5728\u5e93", (String)"SNMainFileStatusValidateHelper_1", (String)"scmc-sbs-form", (Object[])new Object[0]));
        snStatusENToCN.put("C", ResManager.loadKDString((String)"\u5f85\u51fa\u5e93", (String)"SNMainFileStatusValidateHelper_2", (String)"scmc-sbs-form", (Object[])new Object[0]));
        snStatusENToCN.put("D", ResManager.loadKDString((String)"\u51fa\u5e93", (String)"SNMainFileStatusValidateHelper_3", (String)"scmc-sbs-form", (Object[])new Object[0]));
        snStatusENToCN.put("E", ResManager.loadKDString((String)"\u8c03\u62e8\u5728\u9014", (String)"SNMainFileStatusValidateHelper_4", (String)"scmc-sbs-form", (Object[])new Object[0]));
    }
}

