/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formlugin.reservation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.scmc.sbs.business.common.colsAssist.IColsSelectStrategy;
import kd.scmc.sbs.business.common.colsAssist.MetaHelper;
import kd.scmc.sbs.business.common.colsAssist.NoLowerAttrStategy;
import kd.scmc.sbs.business.common.colsAssist.SelectParams;
import kd.scmc.sbs.common.util.ColsTreeUtil;
import kd.scmc.sbs.common.util.FormUtil;
import kd.scmc.sbs.common.util.MultiLangUtils;
import org.apache.commons.lang3.StringUtils;

public class ReserveColMapEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String[] BILL_COLS = new String[]{"requirebillcol", "requirebillcolno", "reservebillcol", "reservebillcolno"};

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "reservebill": {
                this.reserveBillChanged(e);
                break;
            }
            case "requirebill": {
                this.requireBillChanged(e);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initDefaultCols();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        super.closedCallBack(e);
        switch (key = e.getActionId()) {
            case "requirebillcol": {
                this.callBack4RequireBillCol(e);
                break;
            }
            case "reservebillcol": {
                this.callBack4ReserveBillCol(e);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        this.bindColsMap();
        this.getModel().setDataChanged(false);
    }

    private void bindColsMap() {
        String colsMap = this.getModel().getDataEntity().getString("colmap");
        JSONObject entry = null;
        if (StringUtils.isNotBlank((CharSequence)colsMap)) {
            entry = JSON.parseObject((String)colsMap);
        }
        this.batchSetEntry("colsmap", entry);
    }

    private void batchSetEntry(String entryName, JSONObject entry) {
        IDataModel model = this.getModel();
        model.deleteEntryData(entryName);
        if (entry == null) {
            return;
        }
        Set cols = entry.keySet();
        JSONArray colValues = null;
        int[] indexs = null;
        int size = 0;
        for (String col : cols) {
            if ("reservebillcol".equals(col) || "requirebillcol".equals(col)) continue;
            colValues = entry.getJSONArray(col);
            size = colValues.size();
            if (indexs == null) {
                indexs = model.batchCreateNewEntryRow(entryName, size);
            }
            for (int i = 0; i < size; ++i) {
                String bill;
                String key = String.valueOf(colValues.get(i));
                model.setValue(col, (Object)key, indexs[i]);
                if ("reservebillcolno".equals(col)) {
                    bill = ((DynamicObject)model.getValue("reservebill")).getString("number");
                    model.setValue("reservebillcol", (Object)MultiLangUtils.getEntityKeyWithLang(bill, key), indexs[i]);
                }
                if (!"requirebillcolno".equals(col)) continue;
                bill = ((DynamicObject)model.getValue("requirebill")).getString("number");
                model.setValue("requirebillcol", (Object)MultiLangUtils.getEntityKeyWithLang(bill, key), indexs[i]);
            }
        }
    }

    private void callBack4ReserveBillCol(ClosedCallBackEvent e) {
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        this.handleValues(data, "reservebillcol", "reservebillcolno");
    }

    private void callBack4RequireBillCol(ClosedCallBackEvent e) {
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        this.handleValues(data, "requirebillcol", "requirebillcolno");
    }

    private void handleValues(JSONArray data, String col, String colNo) {
        IDataModel model = this.getModel();
        Set<String> exsistSortCols = this.getExsistCols(colNo);
        JSONObject info = null;
        for (int i = 0; i < data.size(); ++i) {
            info = data.getJSONObject(i);
            if (exsistSortCols.contains(info.getString("id"))) continue;
            int index = 0;
            index = i == 0 ? this.getModel().getEntryCurrentRowIndex("colsmap") : model.createNewEntryRow("colsmap");
            model.setValue(colNo, (Object)info.getString("id"), index);
            model.setValue(col, (Object)info.getString("text"), index);
        }
    }

    private Set<String> getExsistCols(String colNo) {
        HashSet<String> sortCols = new HashSet<String>();
        DynamicObjectCollection sortList = this.getModel().getEntryEntity("colsmap");
        for (DynamicObject row : sortList) {
            sortCols.add(row.getString(colNo));
        }
        return sortCols;
    }

    private void requireBillChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount("colsmap");
        for (int i = 0; i < count; ++i) {
            model.setValue("requirebillcol", null, i);
            model.setValue("requirebillcolno", null, i);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": {
                this.beforeSave(e);
                break;
            }
        }
    }

    private void beforeSave(BeforeDoOperationEventArgs e) {
        IDataModel model = this.getModel();
        String colMap = this.parse2Json(BILL_COLS);
        model.setValue("colmap", (Object)colMap);
    }

    private String parse2Json(String[] colsName) {
        int len = colsName.length;
        if (len == 0) {
            return null;
        }
        DynamicObjectCollection rows = this.getModel().getEntryEntity("colsmap");
        if (rows.isEmpty()) {
            return null;
        }
        JSONObject json = new JSONObject(colsName.length);
        JSONArray values = null;
        for (String col : colsName) {
            values = new JSONArray(rows.size());
            for (DynamicObject row : rows) {
                values.add((Object)row.getString(col));
            }
            json.put(col, (Object)values);
        }
        return json.toJSONString();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "requirebillcol": {
                this.clickRequireBillCol(evt, key);
                break;
            }
            case "reservebillcol": {
                this.clickReserveBillCol(evt, key);
                break;
            }
        }
    }

    private void clickReserveBillCol(EventObject evt, String key) {
        DynamicObject reserveBill = FormUtil.getAndCheckF7Value(this.getModel(), "reservebill");
        String number = reserveBill.getString("number");
        this.showColsTreePage(number, key);
    }

    private void showColsTreePage(String entityNumber, String key) {
        SelectParams params = new SelectParams();
        MetaHelper metaHelper = new MetaHelper((IColsSelectStrategy)new NoLowerAttrStategy(), entityNumber);
        String jsonTree = metaHelper.buildTree2JSON();
        params.setJsonTree(jsonTree);
        FormShowParameter fp = FormUtil.readyColsTreePage(params, new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(fp);
    }

    private void clickRequireBillCol(EventObject evt, String key) {
        DynamicObject requireBill = FormUtil.getAndCheckF7Value(this.getModel(), "requirebill");
        String number = requireBill.getString("number");
        this.showColsTreePage(number, key);
    }

    private void reserveBillChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount("colsmap");
        for (int i = 0; i < count; ++i) {
            model.setValue("reservebillcol", null, i);
            model.setValue("reservebillcolno", null, i);
        }
    }

    private void initDefaultCols() {
        this.getModel().setValue("reservebill", (Object)"sbs_reservation");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"requirebillcol", "reservebillcol"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
    }
}

