/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formlugin.reservation;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.scmc.sbs.business.reservation.ReserveHelper;

public class RserveSTSelectPlugin
extends AbstractFormPlugin {
    private static final String KEY_reservescheme = "reservescheme";
    private static final String KEY_btnok = "btnok";
    private static final String KEY_mainorg = "mainorg";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_btnok});
    }

    private static String getMsgCheckSchemePlan() {
        return ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u9884\u7559\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u9884\u7559\u65b9\u6848\u8bbe\u7f6e\u3002", (String)"RserveSTSelectPlugin_0", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter fp = e.getFormShowParameter();
        String formId = fp.getParentFormId();
        Long org = (Long)fp.getCustomParam(KEY_mainorg);
        List<DynamicObject> scheme = ReserveHelper.getUnAutoScheme(org, formId);
        if (scheme.size() > 0 && ReserveAggregateHelper.isAggregate()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u603b\u91cf\u9884\u7559\uff0c\u8bf7\u4f7f\u7528\u65b0\u9884\u7559\u529f\u80fd\u3002", (String)"RserveSTSelectPlugin_2", (String)"scmc-sbs-form", (Object[])new Object[0]));
        }
        if (scheme == null || scheme.size() == 0) {
            throw new KDBizException(RserveSTSelectPlugin.getMsgCheckSchemePlan());
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initSchemeItem();
    }

    private static String getMsgReserveSchemeNotOp() {
        return ResManager.loadKDString((String)"\u672a\u9009\u62e9\u9884\u7559\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u505a\u9884\u7559\u64cd\u4f5c\u3002", (String)"RserveSTSelectPlugin_1", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(KEY_btnok)) {
            Object shemeId = this.getModel().getValue(KEY_reservescheme);
            if (ObjectUtils.isEmpty((Object)shemeId)) {
                this.getView().showErrorNotification(RserveSTSelectPlugin.getMsgReserveSchemeNotOp());
                return;
            }
            this.returnData(shemeId);
        }
    }

    private void returnData(Object schemeId) {
        String entryKey = (String)this.getView().getFormShowParameter().getCustomParam("settingparam");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(KEY_reservescheme, String.valueOf(schemeId));
        map.put("settingparam", entryKey);
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    private void initSchemeItem() {
        FormShowParameter fp = this.getView().getFormShowParameter();
        String formId = fp.getParentFormId();
        Number org = (Number)fp.getCustomParam(KEY_mainorg);
        List<DynamicObject> scheme = ReserveHelper.getUnAutoScheme(org.longValue(), formId);
        if (scheme == null || scheme.isEmpty()) {
            return;
        }
        ArrayList<ComboItem> entryItems = new ArrayList<ComboItem>(scheme.size());
        for (DynamicObject dynamicObject : scheme) {
            ComboItem item = new ComboItem(new LocaleString(String.format("%s\u3010%s\u3011", dynamicObject.getString("name"), dynamicObject.getString("number"))), dynamicObject.get("id").toString());
            entryItems.add(item);
        }
        this.setItemData(KEY_reservescheme, entryItems);
    }

    private void setItemData(String key, List<ComboItem> ParamItems) {
        if (ParamItems.size() > 0) {
            ComboEdit combo = (ComboEdit)this.getControl(key);
            combo.setComboItems(ParamItems);
            this.getModel().setValue(key, (Object)ParamItems.get(0).getValue());
        }
    }
}

