/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formplugin.balanceinv;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;

public class SplitRuleEditPlugin
extends AbstractFormPlugin {
    public static final String[] DEFAULT_FIELDS = new String[]{"invorg", "advicetype", "demandkind", "demandbilltype", "supplytype", "biztype", "supplyorg", "supplyowner"};

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"fieldname"});
    }

    public void click(EventObject evt) {
        String clickKey;
        switch (clickKey = ((Control)evt.getSource()).getKey()) {
            case "fieldname": {
                this.fieldNameClick(evt);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject srcEntity = (DynamicObject)this.getModel().getValue("srcentity");
        MainEntityType srcEntityType = MetadataServiceHelper.getDataEntityType((String)((String)srcEntity.get("id")));
        for (String fieldKey : DEFAULT_FIELDS) {
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            IDataEntityProperty property = srcEntityType.findProperty(fieldKey);
            String entryName = srcEntityType.findProperty("entryentity").getDisplayName().getLocaleValue();
            String fieldName = property.getDisplayName().getLocaleValue();
            this.getModel().setValue("fieldname", (Object)(entryName + "." + fieldName), rowIndex);
            this.getModel().setValue("fieldkey", (Object)fieldKey, rowIndex);
            this.getModel().setValue("sysfield", (Object)true, rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"fieldname"});
        }
    }

    private void fieldNameClick(EventObject evt) {
        DynamicObject srcEntity = (DynamicObject)this.getModel().getValue("srcentity");
        MainEntityType srcEntityType = MetadataServiceHelper.getDataEntityType((String)((String)srcEntity.get("id")));
        PropTreeBuildOption ops = new PropTreeBuildOption();
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)srcEntityType, (PropTreeBuildOption)ops);
        Iterator iterator = srcBillNode.getChildren().iterator();
        TreeNode entryNode = null;
        while (iterator.hasNext()) {
            TreeNode next = (TreeNode)iterator.next();
            if (next.getId().equals("billhead")) {
                iterator.remove();
            }
            if (!next.getId().equals("entryentity")) continue;
            entryNode = next;
        }
        HashSet<String> removeFields = new HashSet<String>();
        removeFields.addAll(Arrays.asList("baseunit", "previousbaseqty", "demandbaseqty", "matchbaseqty", "supplyunit", "matchqty", "supplyunit2nd", "matchqty2nd", "srcsupplybaseqty", "demandbillid", "demandentryid", "supplybillid", "supplybillentryid", "extrainfonum", "extrainfo", "level", "demandownertype", "demandowner", "supplybillno", "supplybilldate", "supplybillseq", "supplytypelevel", "supplymateriel", "supplydetaillevel", "supplyauxpty", "invadvice", "invadviceseq"));
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : entries) {
            removeFields.add(entry.getString("fieldkey").replace("entryentity.", ""));
        }
        if (entryNode != null) {
            List entryNodeChildren = entryNode.getChildren();
            Iterator nodeIterator = entryNodeChildren.iterator();
            while (nodeIterator.hasNext()) {
                TreeNode entryNodeChild = (TreeNode)nodeIterator.next();
                List entryFieldNodes = entryNodeChild.getChildren();
                if (entryFieldNodes != null && !entryFieldNodes.isEmpty()) {
                    entryNodeChild.setChildren(null);
                }
                if (!removeFields.contains(entryNodeChild.getId())) continue;
                nodeIterator.remove();
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fieldname"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "fieldname": {
                this.fieldNameCallBack(closedCallBackEvent);
                break;
            }
        }
    }

    private void fieldNameCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String fieldKey = (String)closedCallBackEvent.getReturnData();
        DynamicObject srcEntity = (DynamicObject)this.getModel().getValue("srcentity");
        MainEntityType srcEntityType = MetadataServiceHelper.getDataEntityType((String)((String)srcEntity.get("id")));
        if (StringUtils.isEmpty((String)fieldKey) || "entryentity".equals(fieldKey) || srcEntityType.getName().equals(fieldKey)) {
            return;
        }
        IDataEntityProperty property = srcEntityType.findProperty(fieldKey);
        String entryName = srcEntityType.findProperty("entryentity").getDisplayName().getLocaleValue();
        String fieldName = property.getDisplayName().getLocaleValue();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.getModel().setValue("fieldname", (Object)(entryName + "." + fieldName), rowIndex);
        this.getModel().setValue("fieldkey", (Object)fieldKey, rowIndex);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "fieldname": {
                this.fieldNameChanged(e);
                break;
            }
        }
    }

    private void fieldNameChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        Object fieldName = this.getModel().getValue("fieldname", rowIndex);
        if (ObjectUtils.isEmpty((Object)fieldName)) {
            this.getModel().setValue("fieldkey", null, rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("deleteentry".equals(operateKey)) {
            EntryGrid control = (EntryGrid)this.getControl("entryentity");
            StringBuilder errorMsgBuilder = new StringBuilder();
            int[] selectRows = control.getSelectRows();
            if (selectRows.length > 0) {
                for (int selectRow : selectRows) {
                    if (!((Boolean)this.getModel().getValue("sysfield", selectRow)).booleanValue()) continue;
                    if (errorMsgBuilder.length() > 0) {
                        errorMsgBuilder.append(ResManager.loadKDString((String)"\u3001", (String)"BalanceInvSchemeSaveValidator_6", (String)"scmc-sbs-form", (Object[])new Object[0]));
                    }
                    errorMsgBuilder.append(selectRow + 1);
                }
                if (errorMsgBuilder.length() > 0) {
                    String message = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7cfb\u7edf\u9ed8\u8ba4\u7684\u5206\u5355\u89c4\u5219\u5b57\u6bb5\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"SplitRuleEditPlugin_0", (String)"scmc-sbs-form", (Object[])new Object[]{errorMsgBuilder.toString()});
                    this.getView().showTipNotification(message);
                    args.setCancel(true);
                }
            }
        }
    }
}

