/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formplugin.sn;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.scmc.sbs.business.sn.SNBillConfigHelper;
import kd.scmc.sbs.lang.SNLang;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class BillSNRelationEditPlugin
extends AbstractBasePlugIn
implements EntryGridBindDataListener {
    public static final String OP_BATCH_GENERATE = "batchgenerate";
    public static final String OP_SELECT_SN = "selectsn";
    public static final String OP_CLEAR = "clear";
    public static final String OP_EXPORT = "export";
    public static final String LAYOUTTYPE_CHECK = "check";
    public static final String LAYOUTTYPE_ENTER = "enter";
    private static Log logger = LogFactory.getLog(BillSNRelationEditPlugin.class);
    private static String DIM_PRE = "dim";
    private Map<Integer, Map<String, Object>> dims;
    private Set<String> dimcols;
    private static final String NEED_QUERY_MAINFILE_SNNUMBER = "needQueryMainFile";

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
        this.dims = SNBillConfigHelper.getSndims();
        this.dimcols = new HashSet<String>(this.dims.size());
        for (Map<String, Object> dimval : this.dims.values()) {
            String relcolumn = (String)dimval.get("relcolumn");
            this.dimcols.add(relcolumn);
        }
        this.setButtonView();
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        IDataModel model = this.getModel();
        Object pkValue = model.getDataEntity().getPkValue();
        if (pkValue == null || pkValue.equals(0L)) {
            model.setValue("billid", customParams.get("billid"));
            model.setValue("billtype", customParams.get("billtype"));
            model.setValue("entrykey", customParams.get("entrykey"));
            model.setValue("entryid", customParams.get("entryid"));
        }
        this.setBillEntryInfoFromParam();
        this.specialBillHandle((String)customParams.get("billtype"));
    }

    private void setButtonView() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)status)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"save", OP_BATCH_GENERATE, OP_SELECT_SN, "add", "reduce", "advconbaritemap1"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"entryentity"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{OP_EXPORT});
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entryName = e.getEntryProp().getName();
        if ("entryentity".equals(entryName)) {
            RowDataEntity[] rows;
            for (RowDataEntity row : rows = e.getRowDataEntities()) {
                int rowIndex = row.getRowIndex();
                Object invorg = customParams.get("invorg");
                this.getModel().setValue("invorg", invorg, rowIndex);
            }
        }
    }

    public void specialBillHandle(String billType) {
        IFormView view = this.getView();
        switch (billType) {
            case "im_transinbill": {
                view.setVisible(Boolean.valueOf(false), new String[]{OP_BATCH_GENERATE, "add"});
                this.deleteEntryRow();
                break;
            }
        }
        DynamicObjectCollection entryentity = view.getModel().getEntryEntity("entryentity");
        if (entryentity != null) {
            boolean hasHandleEntry = false;
            for (DynamicObject entry : entryentity) {
                String handlestatus = entry.getString("handlestatus");
                if (!"B".equals(handlestatus)) continue;
                hasHandleEntry = true;
                break;
            }
            if (hasHandleEntry) {
                view.setVisible(Boolean.valueOf(false), new String[]{"advconbaritemap1"});
            }
        }
    }

    public void afterLoadData(EventObject e) {
        this.setBillEntryInfoFromParam();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.specialBillHandle((String)customParams.get("billtype"));
    }

    private void setBillEntryInfoFromParam() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object materialId = customParams.get("material");
        DynamicObject materialObj = BusinessDataServiceHelper.loadSingle(materialId, (String)"bd_materialinventoryinfo", (String)"id,name,nubmer");
        this.getModel().setValue("material", (Object)materialObj);
        this.getModel().setValue("unit", customParams.get("unit"));
        this.getModel().setValue("qty", customParams.get("qty"));
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        switch (operateKey = e.getOperateKey()) {
            case "batchgenerate": {
                Map batchGenMap = this.getView().getFormShowParameter().getCustomParams();
                Integer paramQty = (Integer)batchGenMap.get("qty");
                int size = this.getModel().getEntryEntity("entryentity").size() - this.getBlankEntryIndex().size();
                int maxGenerateQty = paramQty - size;
                if (maxGenerateQty <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5f55\u5165\u5e8f\u5217\u53f7\u6570\u91cf\u5df2\u7b49\u4e8e\u6216\u8d85\u8fc7\u5206\u5f55\u57fa\u672c\u6570\u91cf\uff0c\u65e0\u6cd5\u6279\u91cf\u751f\u6210\u5e8f\u5217\u53f7\u3002", (String)"BillSNRelationEditPlugin_0", (String)"scmc-sbs-form", (Object[])new Object[0]));
                    break;
                }
                HashMap<String, Object> maps = new HashMap<String, Object>(batchGenMap);
                maps.put("qty", maxGenerateQty);
                this.showModalPage("sbs_batchcreatesn", maps);
                break;
            }
            case "selectsn": {
                Map selectSnMap = this.getView().getFormShowParameter().getCustomParams();
                this.showModalPage("sbs_selectedsn", selectSnMap);
                break;
            }
            case "clear": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u6e05\u7a7a\u5df2\u586b\uff1f", (String)"BillSNRelationEditPlugin_1", (String)"scmc-sbs-form", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(OP_CLEAR, (IFormPlugin)this));
                break;
            }
            case "export": {
                this.exportExcel();
                this.getView().showSuccessNotification(SNLang.exportSuccess());
                break;
            }
        }
    }

    private void exportExcel() {
        String billFormId = "im_serialnumimpttpl";
        Long templateId = Long.valueOf("802615422636752896");
        try {
            FormView formView = (FormView)this.getView();
            String routeAppId = formView.getFormShowParameter().getServiceAppId();
            String url = this.export(routeAppId, billFormId, templateId);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.getView().download(url);
                this.getView().sendFormAction(this.getView());
            }
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private String export(String routeAppId, String formId, Long template) throws IOException {
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        ExportWriterFormat format = this.getExportWriterFormatAndWriteHead(wb, sheet, styles, routeAppId, formId, template, null);
        if (format == null) {
            return null;
        }
        int currRowIndex = sheet.getLastRowNum();
        int rowIndex = currRowIndex + 1;
        DynamicObjectCollection pageDataList = this.getModel().getEntryEntity("entryentity");
        ArrayList<DynamicObject> exportList = new ArrayList<DynamicObject>(pageDataList.size());
        for (DynamicObject rowData : pageDataList) {
            DynamicObject exportRow = BusinessDataServiceHelper.newDynamicObject((String)"im_serialnumimpttpl");
            exportRow.set("serialnumber", rowData.get("snnumber"));
            exportRow.set("serialcomment", rowData.get("remark"));
            exportList.add(exportRow);
        }
        String json = SerializationUtils.toJsonString(exportList);
        JSONArray billArr = JSONArray.parseArray((String)json);
        String fileName = SNLang.exportFileName(new Date());
        for (int i = 0; i < billArr.size(); ++i) {
            JSONObject bill = billArr.getJSONObject(i);
            int offset = ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONObject)bill, (int)rowIndex, (ExportWriterFormat)format, (boolean)false, (String)fileName, (boolean)true);
            if (offset > 1) {
                rowIndex += offset;
                continue;
            }
            ++rowIndex;
        }
        return this.writeFile(wb, fileName);
    }

    private ExportWriterFormat getExportWriterFormatAndWriteHead(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, String routeAppId, Object formId, Object template, Object extendData) {
        ExportWriterFormat format = null;
        String exportJSon = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)routeAppId, (String)"MetadataService", (String)"getExportWriter", (Object[])new Object[]{formId, template, "", extendData});
        if (!StringUtils.isEmpty((CharSequence)exportJSon) && exportJSon.startsWith("[")) {
            List formatArr = JSONArray.parseArray((String)exportJSon, ExportWriterFormat.class);
            if (formatArr != null && formatArr.size() > 0) {
                format = (ExportWriterFormat)formatArr.get(0);
            }
        } else {
            format = (ExportWriterFormat)JSONObject.parseObject((String)exportJSon, ExportWriterFormat.class);
        }
        ExportWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (ExportWriterFormat)format);
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(SXSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        String url = "";
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
        return url;
    }

    private void showModalPage(String page, Map<String, Object> param) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(page);
        if (param != null) {
            showParameter.getCustomParams().putAll(param);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, page));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callbackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        switch (callbackId) {
            case "clear": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.getModel().deleteEntryData("entryentity");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "sbs_batchcreatesn": {
                this.closedBatchCreateSNCallback(e);
                break;
            }
            case "sbs_selectedsn": {
                this.closedSelectedSN(e);
                break;
            }
        }
    }

    private void closedSelectedSN(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        IDataModel model = this.getModel();
        if (returnData instanceof Map) {
            Map snData = (Map)returnData;
            if (snData.size() == 0) {
                return;
            }
            model.getDataEntity(true);
            model.beginInit();
            LinkedHashMap<String, Map<String, Object>> handSnData = new LinkedHashMap<String, Map<String, Object>>(1000);
            for (Map.Entry entry : snData.entrySet()) {
                handSnData.put((String)entry.getKey(), (Map<String, Object>)entry.getValue());
                if (handSnData.size() != 1000) continue;
                this.batchCreateLine(snData, handSnData);
            }
            if (handSnData.size() > 0) {
                this.batchCreateLine(snData, handSnData);
            }
            model.endInit();
            this.getView().updateView();
        }
    }

    private void batchCreateLine(Map<String, Map<String, Object>> snData, Map<String, Map<String, Object>> handleSnData) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        List<Integer> canFillLineIndexs = this.getCanFillLineIndexs(snData.size());
        int i = 0;
        for (Map.Entry<String, Map<String, Object>> entry : handleSnData.entrySet()) {
            int line = canFillLineIndexs.get(i);
            model.setValue("snnumber", (Object)entry.getKey(), line);
            Map<String, Object> attrs = entry.getValue();
            model.setValue("invorg", attrs.get("invorg"), line);
            model.setValue("snmainfileid", attrs.get("snmainfileid"), line);
            for (Map.Entry<Integer, Map<String, Object>> dim : this.dims.entrySet()) {
                Integer seq = dim.getKey();
                String dimkey = DIM_PRE + seq;
                Map<String, Object> dimval = dim.getValue();
                String relcolumn = (String)dimval.get("relcolumn");
                model.setValue(relcolumn, attrs.get(dimkey), line);
                view.setEnable(Boolean.FALSE, line, new String[]{relcolumn});
            }
            ++i;
        }
        handleSnData.clear();
    }

    private void closedBatchCreateSNCallback(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object object = e.getReturnData();
        if (object != null && "sbs_batchcreatesn".equals(actionId) && object instanceof Map) {
            IFormView mainView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            Map returnParam = (Map)object;
            int seq = mainView.getModel().getEntryCurrentRowIndex("billentry") + 1;
            int afterentitySeq = mainView.getModel().getEntryCurrentRowIndex("afterentity") + 1;
            returnParam.put("seq", seq);
            returnParam.put("afterentitySeq", afterentitySeq);
            String typeName = mainView.getModel().getDataEntityType().getName();
            if ("im_adjustbill".equals(typeName) || "im_assembbill".equals(typeName) || "im_disassemblebill".equals(typeName)) {
                returnParam.put("subentryfield", "afterentity");
            }
            returnParam.put("material", this.getModel().getValue("material"));
            DynamicObject mainEntity = mainView.getModel().getDataEntity(true);
            long time1 = System.currentTimeMillis();
            List snNums = (List)kd.bos.servicehelper.DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"LotCodeRuleService", (String)"getSnCodeNum", (Object[])new Object[]{mainEntity, returnParam});
            long time2 = System.currentTimeMillis();
            int snNumsSize = snNums.size();
            logger.info(snNumsSize + "\u4e2a\u5e8f\u5217\u53f7\u751f\u6210\u7684\u65f6\u95f4\uff1a" + (time2 - time1) + "ms");
            this.getModel().getDataEntity(true);
            this.getModel().beginInit();
            Object invorg = returnParam.get("invorg");
            List<Integer> canFillLineIndexs = this.getCanFillLineIndexs(snNumsSize);
            int i = 0;
            for (String snNum : snNums) {
                this.getModel().setValue("snnumber", (Object)snNum, canFillLineIndexs.get(i).intValue());
                this.getModel().setValue("invorg", invorg, canFillLineIndexs.get(i).intValue());
                ++i;
            }
            this.getModel().endInit();
            this.getView().updateView();
        }
    }

    public List<Integer> getBlankEntryIndex() {
        LinkedList<Integer> blankEntryIndexs = new LinkedList<Integer>();
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : entries) {
            String number = entry.getString("snnumber");
            if (number != null && !number.trim().equals("")) continue;
            blankEntryIndexs.add(entry.getInt("seq") - 1);
        }
        return blankEntryIndexs;
    }

    private List<Integer> getCanFillLineIndexs(int size) {
        List<Integer> blankList = this.getBlankEntryIndex();
        int createLine = size - blankList.size();
        if (createLine > 0) {
            int[] rows;
            for (int row : rows = this.getView().getModel().batchCreateNewEntryRow("entryentity", createLine)) {
                blankList.add(row);
            }
        }
        return blankList;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": {
                this.beforeDoSave(e);
                break;
            }
        }
    }

    private void beforeDoSave(BeforeDoOperationEventArgs e) {
        this.deleteEntryRow();
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] rowIndexs;
        super.beforeDeleteRow(e);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        for (int index : rowIndexs = e.getRowIndexs()) {
            DynamicObject entry = (DynamicObject)entrys.get(index);
            String handlestatus = entry.getString("handlestatus");
            if (!"B".equals(handlestatus)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u72b6\u6001\u4e3a\u5df2\u5904\u7406\u7684\u5206\u5f55\u3002", (String)"BillSNRelationEditPlugin_2", (String)"scmc-sbs-form", (Object[])new Object[0]));
            e.setCancel(true);
            break;
        }
    }

    private void deleteEntryRow() {
        List<Integer> noDataRows = this.getBlankEntryIndex();
        if (noDataRows.size() == 0) {
            return;
        }
        int[] rows = new int[noDataRows.size()];
        for (int j = 0; j < rows.length; ++j) {
            rows[j] = noDataRows.get(j);
        }
        this.getModel().deleteEntryRows("entryentity", rows);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        ChangeData[] valueSet = e.getChangeSet();
        int index = valueSet[0].getRowIndex();
        switch (propName = e.getProperty().getName()) {
            case "snnumber": {
                this.relSpace(propName, index);
                this.changeSNNumber(e);
                break;
            }
        }
        if (this.dimcols.contains(propName)) {
            this.relSpace(propName, index);
        }
    }

    private void changeSNNumber(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        this.getModel().setValue("snmainfileid", null, rowIndex);
        if (newValue == null || newValue.toString().trim().equals("")) {
            this.putToNeedQueryMainFile(rowIndex, null);
        } else {
            this.putToNeedQueryMainFile(rowIndex, newValue.toString());
        }
    }

    private void putToNeedQueryMainFile(Integer rowIndex, String snnumber) {
        String needQueryMainFileJson = this.getPageCache().get(NEED_QUERY_MAINFILE_SNNUMBER);
        Map<String, Integer> map = null;
        map = needQueryMainFileJson == null || needQueryMainFileJson.trim().equals("") ? new HashMap<String, Integer>() : (Map)SerializationUtils.fromJsonString((String)needQueryMainFileJson, Map.class);
        if (snnumber == null) {
            map.remove(snnumber);
        } else {
            map.put(snnumber, rowIndex);
        }
        needQueryMainFileJson = SerializationUtils.toJsonString(map);
        this.getPageCache().put(NEED_QUERY_MAINFILE_SNNUMBER, needQueryMainFileJson);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List entities = e.getRows();
        IFormView view = this.getView();
        entities.forEach(entry -> {
            int rowIndex = entry.getRowIndex();
            DynamicObject entryObj = entry.getDataEntity();
            DynamicObject snmainfileid = entryObj.getDynamicObject("snmainfileid");
            String handlestatus = entryObj.getString("handlestatus");
            if (snmainfileid != null || "B".equals(handlestatus)) {
                view.setEnable(Boolean.FALSE, rowIndex, this.dimcols.toArray(new String[0]));
            }
            if ("B".equals(handlestatus)) {
                view.setEnable(Boolean.FALSE, rowIndex, new String[]{"snnumber", "remark"});
            }
        });
    }

    private void relSpace(String key, int index) {
        IDataModel model = this.getModel();
        DynamicObject dynamicObject = model.getEntryRowEntity("entryentity", index);
        String currentValue = dynamicObject.getString(key);
        if (currentValue != null) {
            currentValue = currentValue.replaceAll("\u3000", " ").trim();
            model.beginInit();
            model.setValue(key, (Object)currentValue, index);
            model.endInit();
        }
    }
}

