/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formplugin.sn;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.mvc.form.FormView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.scmc.sbs.business.sn.SNBillConfigHelper;
import kd.scmc.sbs.lang.SNLang;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CheckSNNumberEditPlugin
extends AbstractFormPlugin {
    private static String DIM_PRE = "dim";
    private Map<Integer, Map<String, Object>> dims = SNBillConfigHelper.getSndims();
    public static final String OP_EXPORT = "export";
    public static final Log logger = LogFactory.getLog(CheckSNNumberEditPlugin.class);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        FormShowParameter parameter;
        EntryAp entryAp;
        super.loadCustomControlMetas(e);
        if (!this.dims.isEmpty() && (entryAp = this.createDynamicEntryAp(parameter = (FormShowParameter)e.getSource())) != null) {
            HashMap<String, String> mapEntry = new HashMap<String, String>(2);
            mapEntry.put("id", "entryentity");
            mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
            e.getItems().add(mapEntry);
        }
    }

    private EntryAp createDynamicEntryAp(FormShowParameter parameter) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)parameter.getFormId());
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        formMeta.bindEntityMetadata(entityMetadata);
        EntryAp entryAp = null;
        for (ControlAp ap : formMeta.getItems()) {
            if (!StringUtils.equals((CharSequence)ap.getKey(), (CharSequence)"entryentity")) continue;
            entryAp = (EntryAp)ap;
            break;
        }
        if (entryAp != null) {
            List entryItems = entryAp.getItems();
            for (Map.Entry<Integer, Map<String, Object>> dim : this.dims.entrySet()) {
                Integer seq = dim.getKey();
                String dimkey = DIM_PRE + seq;
                Map<String, Object> dimval = dim.getValue();
                String name = (String)dimval.get("name");
                EntryFieldAp fieldAp = new EntryFieldAp();
                fieldAp.setId(dimkey);
                fieldAp.setKey(dimkey);
                fieldAp.setName(new LocaleString(name));
                fieldAp.setFireUpdEvt(true);
                TextField field = new TextField();
                field.setId(dimkey);
                field.setKey(dimkey);
                field.setName(new LocaleString(name));
                fieldAp.setField((Field)field);
                entryItems.add(fieldAp);
            }
        }
        return entryAp;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        if (this.dims.isEmpty()) {
            super.getEntityType(e);
            return;
        }
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetas", exp.getMessage()), new Object[0]);
        }
        for (Map.Entry<Integer, Map<String, Object>> dim : this.dims.entrySet()) {
            Integer seq = dim.getKey();
            String dimkey = DIM_PRE + seq;
            Map<String, Object> dimval = dim.getValue();
            String name = (String)dimval.get("name");
            this.registDynamicProps(newMainType, dimkey, name);
        }
        e.setNewEntityType(newMainType);
    }

    private void registDynamicProps(MainEntityType newMainType, String dimkey, String name) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("entryentity");
        TextProp textProp = new TextProp();
        textProp.setName(dimkey);
        textProp.setDisplayName(new LocaleString(name));
        textProp.setDbIgnore(true);
        textProp.setAlias("");
        entryType.registerSimpleProperty((DynamicSimpleProperty)textProp);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object materialId = customParams.get("material");
        if (materialId != null) {
            DynamicObject materialObj = BusinessDataServiceHelper.loadSingle(materialId, (String)"bd_materialinventoryinfo", (String)"id,name,nubmer");
            model.setValue("materiel", (Object)materialObj);
        }
        model.setValue("unit", customParams.get("unit"));
        model.setValue("qty", customParams.get("qty"));
        this.getView().getModel().clearNoDataRow();
        Object relationId = customParams.get("billsnrelationid");
        if (relationId == null || relationId.equals(0L)) {
            return;
        }
        DynamicObject billsnRelation = BusinessDataServiceHelper.loadSingle(relationId, (String)"sbs_billsnrelation");
        if (billsnRelation == null) {
            return;
        }
        DynamicObjectCollection billsnRelationEntries = billsnRelation.getDynamicObjectCollection("entryentity");
        int billsnRelationEntriesLength = billsnRelationEntries.size();
        if (billsnRelationEntriesLength == 0) {
            return;
        }
        model.deleteEntryData("entryentity");
        int[] batchCreateNewEntryRow = model.batchCreateNewEntryRow("entryentity", billsnRelationEntriesLength);
        int i = 0;
        for (DynamicObject billsnRelationEntry : billsnRelationEntries) {
            int index = batchCreateNewEntryRow[i];
            model.setValue("sn", (Object)billsnRelationEntry.getString("snnumber"), index);
            model.setValue("snmainfileid", billsnRelationEntry.get("snmainfileid"), index);
            model.setValue("invorg", billsnRelationEntry.get("invorg"), index);
            model.setValue("note", billsnRelationEntry.get("remark"), index);
            model.setValue("handlestatus", billsnRelationEntry.get("handlestatus"), index);
            if (!this.dims.isEmpty()) {
                for (Map.Entry<Integer, Map<String, Object>> dim : this.dims.entrySet()) {
                    Integer seq = dim.getKey();
                    String dimkey = DIM_PRE + seq;
                    Map<String, Object> dimval = dim.getValue();
                    model.setValue(dimkey, billsnRelationEntry.get((String)dimval.get("relcolumn")), index);
                }
            }
            ++i;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String op;
        switch (op = e.getOperateKey()) {
            case "export": {
                this.exportExcel();
                this.getView().showSuccessNotification(SNLang.exportSuccess());
                break;
            }
        }
    }

    private void exportExcel() {
        String billFormId = "im_serialnumimpttpl";
        Long templateId = Long.valueOf("802615422636752896");
        try {
            FormView formView = (FormView)this.getView();
            String routeAppId = formView.getFormShowParameter().getServiceAppId();
            String url = this.export(routeAppId, billFormId, templateId);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.getView().download(url);
                this.getView().sendFormAction(this.getView());
            }
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private ExportWriterFormat getExportWriterFormatAndWriteHead(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, String routeAppId, Object formId, Object template, Object extendData) {
        ExportWriterFormat format = null;
        String exportJSon = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)routeAppId, (String)"MetadataService", (String)"getExportWriter", (Object[])new Object[]{formId, template, "", extendData});
        if (!StringUtils.isEmpty((CharSequence)exportJSon) && exportJSon.startsWith("[")) {
            List formatArr = JSONArray.parseArray((String)exportJSon, ExportWriterFormat.class);
            if (formatArr != null && formatArr.size() > 0) {
                format = (ExportWriterFormat)formatArr.get(0);
            }
        } else {
            format = (ExportWriterFormat)JSONObject.parseObject((String)exportJSon, ExportWriterFormat.class);
        }
        ExportWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (ExportWriterFormat)format);
        return format;
    }

    private String export(String routeAppId, String formId, Long template) throws IOException {
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        ExportWriterFormat format = this.getExportWriterFormatAndWriteHead(wb, sheet, styles, routeAppId, formId, template, null);
        if (format == null) {
            return null;
        }
        int currRowIndex = sheet.getLastRowNum();
        int rowIndex = currRowIndex + 1;
        DynamicObjectCollection pageDataList = this.getModel().getEntryEntity("entryentity");
        ArrayList<DynamicObject> exportList = new ArrayList<DynamicObject>(pageDataList.size());
        for (DynamicObject rowData : pageDataList) {
            DynamicObject exportRow = BusinessDataServiceHelper.newDynamicObject((String)"im_serialnumimpttpl");
            exportRow.set("serialnumber", rowData.get("sn"));
            exportRow.set("serialcomment", rowData.get("note"));
            exportList.add(exportRow);
        }
        String json = SerializationUtils.toJsonString(exportList);
        JSONArray billArr = JSONArray.parseArray((String)json);
        String fileName = SNLang.exportFileName(new Date());
        for (int i = 0; i < billArr.size(); ++i) {
            JSONObject bill = billArr.getJSONObject(i);
            int offset = ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONObject)bill, (int)rowIndex, (ExportWriterFormat)format, (boolean)false, (String)fileName, (boolean)true);
            if (offset > 1) {
                rowIndex += offset;
                continue;
            }
            ++rowIndex;
        }
        return this.writeFile(wb, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(SXSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        String url = "";
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
        return url;
    }
}

