/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formplugin.sn;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.sbs.business.common.colsAssist.CompositeStrategy;
import kd.scmc.sbs.business.common.colsAssist.EntryNodeStrategy;
import kd.scmc.sbs.business.common.colsAssist.EntryStrategy;
import kd.scmc.sbs.business.common.colsAssist.FilterStrategy;
import kd.scmc.sbs.business.common.colsAssist.IColsSelectStrategy;
import kd.scmc.sbs.business.common.colsAssist.MetaHelper;
import kd.scmc.sbs.business.common.colsAssist.SelectParams;
import kd.scmc.sbs.business.common.colsAssist.SimpleStrategy;
import kd.scmc.sbs.business.common.colsAssist.TypeSelectStategy;
import kd.scmc.sbs.common.consts.SNBillConfigConsts;
import kd.scmc.sbs.common.util.ColsTreeUtil;
import kd.scmc.sbs.common.util.FormUtil;
import kd.scmc.sbs.formplugin.sn.FieldFormTranslator;

public class SNBillConfigEditPlugin
extends AbstractBasePlugIn {
    private static final String SRCBILLENTRYCB = "srcbillentryCB";
    private static final String MATERIALCB = "materialCB";
    private static final String MATERIALMASTERCB = "materialMasterCB";
    private static final String SNBASEQTYCB = "snbaseqtyCB";
    private static final String SNMAINF_COLCB = "snmainfColCB";
    private static final String SNMAINFSRC_COLCB = "snmainfsrcbillColCB";
    private static final String SNTRACK_COLCB = "sntrackColCB";
    private static final String SNTRACKSRC_COLCB = "sntracksrcbillColCB";
    private static final String SNTRKVAL_COLCB = "sntrkvalColCB";
    private static final String SNTRKVALSRC_COLCB = "sntrkvalsrcbillColCB";
    private static final String INPUTSNREL_COLCB = "inputsnrelColCB";
    private static final String INPUTSNMOVETRACK_COLCB = "inputsnmovetrackColCB";
    private static final String INPUTSNMAINFILE_COLCB = "inputsnmainfileColCB";
    public static final String INVORGCB = "invorgCB";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setCols4FilterGridAndOpe();
        this.bindBillFilterInfo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnable();
    }

    private void setCols4FilterGridAndOpe() {
        IFormView view = this.getView();
        FilterGrid filterGrid = (FilterGrid)view.getControl("billfiltergrid");
        ComboEdit operate = (ComboEdit)view.getControl("operate");
        MainEntityType entityType = this.getSourceBillMainEntityType();
        if (entityType == null) {
            filterGrid.setFilterColumns(Collections.emptyList());
            operate.setComboItems(Collections.emptyList());
        } else {
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType, true);
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(cols);
            List ops = EntityMetadataCache.getDataEntityOperate((String)entityType.getName());
            ArrayList<ComboItem> operationItems = new ArrayList<ComboItem>(10);
            for (Map op : ops) {
                String opType = (String)op.get("type");
                if (!OperationTypeCache.isEntityOperation((String)opType)) continue;
                operationItems.add(new ComboItem(LocaleString.fromMap((Map)((Map)op.get("name"))), (String)op.get("key")));
            }
            operate.setComboItems(operationItems);
        }
        view.updateView("billfiltergrid");
    }

    private void bindBillFilterInfo() {
        String billFilterStr = this.getModel().getDataEntity().getString("billfilter");
        FilterCondition condition = null;
        condition = StringUtils.isBlank((CharSequence)billFilterStr) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)billFilterStr, FilterCondition.class);
        FilterGrid filterGrid = (FilterGrid)this.getControl("billfiltergrid");
        filterGrid.SetValue(condition);
    }

    private MainEntityType getSourceBillMainEntityType() {
        IDataModel model = this.getModel();
        DynamicObject sourceBill = model.getDataEntity().getDynamicObject("srcbillobj");
        if (sourceBill == null) {
            return null;
        }
        String metaDataNo = sourceBill.getString("number");
        try {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)metaDataNo);
            return mainEntityType;
        }
        catch (KDException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void setEnable() {
        Boolean isPreset = this.getModel().getDataEntity().getBoolean("ispreset");
        if (isPreset.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"conentpanel"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"srcbillentry", "materialcol", "snbaseqtycol", "snmainfcolno", "snmainfsrcbillcolno", "sntrackcolno", "sntracksrcbillcolno", "sntrkvalcolno", "sntrkvalsrcbillcolno", "materialmastercol", "invorgcol", "billsnrelationcolname", "snmovetrackrelcolname", "snmainfilecolname", "updatemainfile", "updateway"});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "srcbillentry": {
                this.clickSrcBillEntry(evt);
                break;
            }
            case "materialcol": 
            case "snbaseqtycol": 
            case "materialmastercol": 
            case "invorgcol": {
                this.clickCtrlCol(evt, key);
                break;
            }
            case "snmainfcolno": 
            case "sntrackcolno": 
            case "sntrkvalcolno": 
            case "billsnrelationcolname": 
            case "snmovetrackrelcolname": 
            case "snmainfilecolname": {
                this.clickTargetObjCol(evt, key);
                break;
            }
            case "snmainfsrcbillcolno": 
            case "sntracksrcbillcolno": 
            case "sntrkvalsrcbillcolno": {
                this.clickSourceObjCol(evt, key);
                break;
            }
        }
    }

    private void changeUpdateMainFile(PropertyChangedArgs evt, String key) {
        IDataModel model = this.getModel();
        ChangeData changeData = evt.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        Boolean value = (Boolean)model.getValue("updatemainfile");
        String msg = this.checkSelectEnable(model, "snmovetrackrelcolname", rowIndex);
        if (value.booleanValue() && StringUtils.isNotEmpty((CharSequence)msg)) {
            model.beginInit();
            model.setDataChanged(false);
            model.setValue("updatemainfile", (Object)"0", rowIndex);
            model.endInit();
            this.getView().updateView("updatemainfile", rowIndex);
            this.getView().showTipNotification(msg);
            return;
        }
        if (!value.booleanValue()) {
            model.setValue("snmainfilecolname", null, rowIndex);
            model.setValue("snmainfilecol", null, rowIndex);
            model.setValue("updateway", null, rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"snmainfilecol", "snmainfilecolname", "updateway"});
        } else {
            this.setDefaultUpdateWayValue(model, rowIndex);
        }
        this.getView().updateView("inputsnentity", rowIndex);
    }

    private void setDefaultUpdateWayValue(IDataModel model, int rowIndex) {
        Boolean isDecimal = this.getColType(model, rowIndex);
        if (isDecimal.booleanValue()) {
            String updateWay = (String)model.getValue("updateway");
            if (StringUtils.isEmpty((CharSequence)updateWay) || !"3".equals(updateWay)) {
                model.setValue("updateway", (Object)"2", rowIndex);
            }
        } else {
            model.setValue("updateway", (Object)"1", rowIndex);
        }
    }

    private String checkSelectEnable(IDataModel model, String key, int rowIndex) {
        String msg = "";
        String relationCol = (String)model.getValue("billsnrelationcol", rowIndex);
        String moveTrackRelCol = (String)model.getValue("snmovetrackrelcolname", rowIndex);
        Boolean updateMainFile = (Boolean)model.getValue("updatemainfile", rowIndex);
        switch (key) {
            case "updateway": {
                if (updateMainFile.booleanValue()) break;
                msg = ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u542f\u201c\u66f4\u65b0\u5230\u4e3b\u6863\u201d\u9009\u9879\u3002", (String)"SNBillConfigEditPlugin_10", (String)"scmc-sbs-form", (Object[])new Object[0]);
                break;
            }
            case "updatemainfile": {
                if (StringUtils.isEmpty((CharSequence)relationCol)) {
                    msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u636e\u5e8f\u5217\u53f7\u5173\u8054\u8868\u5b57\u6bb5\u3002", (String)"SNBillConfigEditPlugin_9", (String)"scmc-sbs-form", (Object[])new Object[0]);
                    break;
                }
                if (StringUtils.isEmpty((CharSequence)moveTrackRelCol)) {
                    msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e8f\u5217\u53f7\u8f68\u8ff9\u5173\u8054\u8868\u5b57\u6bb5\u3002", (String)"SNBillConfigEditPlugin_11", (String)"scmc-sbs-form", (Object[])new Object[0]);
                    break;
                }
                if (updateMainFile.booleanValue()) break;
                msg = ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u542f\u201c\u66f4\u65b0\u5230\u4e3b\u6863\u201d\u9009\u9879\u3002", (String)"SNBillConfigEditPlugin_10", (String)"scmc-sbs-form", (Object[])new Object[0]);
                break;
            }
            case "snmovetrackrelcolname": {
                if (!StringUtils.isEmpty((CharSequence)relationCol)) break;
                msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u636e\u5e8f\u5217\u53f7\u5173\u8054\u8868\u5b57\u6bb5\u3002", (String)"SNBillConfigEditPlugin_9", (String)"scmc-sbs-form", (Object[])new Object[0]);
                break;
            }
        }
        return msg;
    }

    private Boolean getColType(IDataModel model, int rowIndex) {
        String type = this.getLayoutType();
        String relationCol = (String)model.getValue("billsnrelationcol", rowIndex);
        String[] splitCols = relationCol.split("\\.");
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)type).getAllFields().get(splitCols[splitCols.length - 1]);
        return iDataEntityProperty instanceof DecimalProp;
    }

    private void clickSrcBillEntry(EventObject evt) {
        IDataModel model = this.getModel();
        String sourcebilltype = this.checkSourcebilltype(model);
        if (sourcebilltype == null) {
            return;
        }
        this.showColsTreePage(sourcebilltype, new EntryStrategy(), SRCBILLENTRYCB, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u4f53", (String)"SNBillConfigEditPlugin_0", (String)"scmc-sbs-form", (Object[])new Object[0]));
    }

    private void clickCtrlCol(EventObject evt, String key) {
        IDataModel model = this.getModel();
        String sourcebilltype = this.checkSourcebilltype(model);
        if (sourcebilltype == null) {
            return;
        }
        String sourceBillEntry = this.checkSourceBillEntry(model);
        if (sourceBillEntry == null) {
            return;
        }
        MainEntityType billTplEntityType = EntityMetadataCache.getDataEntityType((String)"im_billtpl");
        IDataEntityProperty property = null;
        String colCBName = null;
        switch (key) {
            case "materialcol": {
                property = billTplEntityType.findProperty("material");
                colCBName = MATERIALCB;
                break;
            }
            case "materialmastercol": {
                property = billTplEntityType.findProperty("material");
                colCBName = MATERIALMASTERCB;
                break;
            }
            case "snbaseqtycol": {
                property = billTplEntityType.findProperty("baseqty");
                colCBName = SNBASEQTYCB;
                break;
            }
            case "invorgcol": {
                property = billTplEntityType.findProperty("org");
                colCBName = INVORGCB;
                break;
            }
        }
        TypeSelectStategy typeSelectStategy = new TypeSelectStategy(property, false);
        boolean includeHeadField = false;
        if ("invorgcol".equals(key)) {
            includeHeadField = true;
        }
        EntryNodeStrategy entrynodeStategy = new EntryNodeStrategy(Collections.singletonList(sourceBillEntry), includeHeadField);
        CompositeStrategy compStrategy = new CompositeStrategy(Arrays.asList(typeSelectStategy, entrynodeStategy));
        if ("materialmastercol".equals(key)) {
            compStrategy.setNeedColsFunction((baseDataNo, basedataProp) -> {
                HashSet<String> cols = new HashSet<String>();
                if (basedataProp instanceof MaterielProp) {
                    cols.add("masterid");
                }
                return cols;
            });
        }
        this.showColsTreePage(sourcebilltype, compStrategy, colCBName, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5", (String)"SNBillConfigEditPlugin_1", (String)"scmc-sbs-form", (Object[])new Object[0]));
    }

    private void clickTargetObjCol(EventObject evt, String key) {
        String entryName = null;
        String colName = null;
        String colCBName = null;
        String targetObj = null;
        String msg = null;
        switch (key) {
            case "snmainfcolno": {
                entryName = "snmainfentry";
                colName = "snmainfcol";
                colCBName = SNMAINF_COLCB;
                targetObj = "bd_snmainfile";
                break;
            }
            case "sntrackcolno": {
                entryName = "sntrackentry";
                colName = "sntrackcol";
                colCBName = SNTRACK_COLCB;
                targetObj = "bd_snmovetrack";
                break;
            }
            case "sntrkvalcolno": {
                entryName = "sntrkvalentry";
                colName = "sntrkvalcol";
                colCBName = SNTRKVAL_COLCB;
                targetObj = "bd_snmovetrack";
                break;
            }
            case "billsnrelationcolname": {
                entryName = "inputsnentity";
                colName = "billsnrelationcol";
                colCBName = INPUTSNREL_COLCB;
                targetObj = "sbs_billsnrelation";
                DynamicObject entryLayout = this.getModel().getDataEntity().getDynamicObject("enterlayout");
                if (entryLayout == null) break;
                targetObj = entryLayout.getString("id");
                break;
            }
            case "snmovetrackrelcolname": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("inputsnentity");
                int[] rowIndexes = entryGrid.getSelectRows();
                msg = this.checkSelectEnable(this.getModel(), "snmovetrackrelcolname", rowIndexes[0]);
                if (!StringUtils.isEmpty((CharSequence)msg)) {
                    this.getView().showTipNotification(msg);
                    return;
                }
                entryName = "inputsnentity";
                colName = "snmovetrackrelcol";
                colCBName = INPUTSNMOVETRACK_COLCB;
                targetObj = "bd_snmovetrack_rel";
                break;
            }
            case "snmainfilecolname": {
                EntryGrid entryGrid2 = (EntryGrid)this.getView().getControl("inputsnentity");
                int[] rowIndexes2 = entryGrid2.getSelectRows();
                msg = this.checkSelectEnable(this.getModel(), "updatemainfile", rowIndexes2[0]);
                if (!StringUtils.isEmpty((CharSequence)msg)) {
                    this.getView().showTipNotification(msg);
                    return;
                }
                entryName = "inputsnentity";
                colName = "snmainfilecol";
                colCBName = INPUTSNMAINFILE_COLCB;
                targetObj = "bd_snmainfile";
                break;
            }
            default: {
                return;
            }
        }
        ArrayList<String> existCols = new ArrayList<String>(16);
        DynamicObjectCollection colsMap = this.getModel().getEntryEntity(entryName);
        for (DynamicObject colMap : colsMap) {
            String targetObjCol = colMap.getString(colName);
            if (!StringUtils.isNotEmpty((CharSequence)targetObjCol)) continue;
            existCols.add(targetObjCol);
        }
        if ("bd_snmainfile".equals(targetObj)) {
            existCols.add("moveentry");
            existCols.add("sndimentity");
            existCols.addAll(SNBillConfigConsts.SNMAINFILE_FIXCOLS);
        } else if ("bd_snmovetrack".equals(targetObj)) {
            existCols.addAll(SNBillConfigConsts.SNMOVETRACK_FIXCOLS);
        } else if ("billsnrelationcolname".equals(key)) {
            existCols.addAll(SNBillConfigConsts.BILLRELATION_FIXCOLS);
        }
        FilterStrategy filterStrategy = new FilterStrategy(existCols);
        TypeSelectStategy typeSelectStategy = null;
        if ("snmainfilecolname".equals(key) || "snmovetrackrelcolname".equals(key)) {
            String layoutType;
            MainEntityType dataEntityType;
            IDataEntityProperty property;
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("inputsnentity");
            int[] rowIndexes = entryGrid.getSelectRows();
            String relationCol = (String)this.getModel().getValue("billsnrelationcol", rowIndexes[0]);
            String[] props = relationCol.split("\\.");
            if (props.length > 1) {
                relationCol = props[props.length - 1];
            }
            if ((property = (dataEntityType = EntityMetadataCache.getDataEntityType((String)(layoutType = this.getLayoutType()))).findProperty(relationCol)) != null) {
                typeSelectStategy = new TypeSelectStategy(property);
            }
        }
        CompositeStrategy compositeStrategy = null;
        compositeStrategy = typeSelectStategy != null ? new CompositeStrategy(Arrays.asList(typeSelectStategy, filterStrategy)) : new CompositeStrategy(Collections.singletonList(filterStrategy));
        this.showColsTreePage(targetObj, compositeStrategy, colCBName, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5", (String)"SNBillConfigEditPlugin_1", (String)"scmc-sbs-form", (Object[])new Object[0]));
    }

    private String getLayoutType() {
        DynamicObject value = (DynamicObject)this.getModel().getValue("enterlayout");
        String layoutType = "sbs_billsnrelation";
        if (value != null) {
            layoutType = value.getString("id");
        }
        return layoutType;
    }

    private void clickSourceObjCol(EventObject evt, String key) {
        String targetObjtype = null;
        String entryName = null;
        String targetColName = null;
        String srcColCBName = null;
        switch (key) {
            case "snmainfsrcbillcolno": {
                targetObjtype = "bd_snmainfile";
                entryName = "snmainfentry";
                targetColName = "snmainfcol";
                srcColCBName = SNMAINFSRC_COLCB;
                break;
            }
            case "sntracksrcbillcolno": {
                targetObjtype = "bd_snmovetrack";
                entryName = "sntrackentry";
                targetColName = "sntrackcol";
                srcColCBName = SNTRACKSRC_COLCB;
                break;
            }
            case "sntrkvalsrcbillcolno": {
                targetObjtype = "bd_snmovetrack";
                entryName = "sntrkvalentry";
                targetColName = "sntrkvalcol";
                srcColCBName = SNTRKVALSRC_COLCB;
                break;
            }
            default: {
                return;
            }
        }
        IDataModel model = this.getModel();
        String sourcebilltype = null;
        String sourceBillEntry = null;
        sourcebilltype = this.checkSourcebilltype(model);
        if (sourcebilltype == null) {
            return;
        }
        sourceBillEntry = this.checkSourceBillEntry(model);
        if (sourceBillEntry == null) {
            return;
        }
        int index = model.getEntryCurrentRowIndex(entryName);
        String prop = (String)model.getValue(targetColName, index);
        if (StringUtils.isEmpty((CharSequence)prop)) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u884c\u76ee\u6807\u4e1a\u52a1\u5bf9\u8c61\u5b9e\u4f53\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u4e1a\u52a1\u5bf9\u8c61\u5b9e\u4f53\u540d\u79f0\u3002", (String)"SNBillConfigEditPlugin_2", (String)"scmc-sbs-form", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)targetObjtype);
        String[] props = prop.split("\\.");
        if (props.length > 1) {
            prop = props[props.length - 1];
        }
        IDataEntityProperty property = dataEntityType.findProperty(prop);
        String caption = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c%s\u201d\u7684\u6620\u5c04\u5b57\u6bb5\u3002", (String)"SNBillConfigEditPlugin_3", (String)"scmc-sbs-form", (Object[])new Object[0]), property.getDisplayName().getLocaleValue());
        TypeSelectStategy typeSelectStategy = new TypeSelectStategy(property);
        EntryNodeStrategy entrynodeStategy = new EntryNodeStrategy(Collections.singletonList(sourceBillEntry), true);
        CompositeStrategy compStrategy = new CompositeStrategy(Arrays.asList(typeSelectStategy, entrynodeStategy));
        this.showColsTreePage(sourcebilltype, compStrategy, srcColCBName, caption);
    }

    private String checkSourcebilltype(IDataModel model) {
        DynamicObject sourceBill = (DynamicObject)model.getValue("srcbillobj");
        if (sourceBill == null) {
            String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6765\u6e90\u5355\u636e\u3002", (String)"SNBillConfigEditPlugin_4", (String)"scmc-sbs-form", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return null;
        }
        return sourceBill.getString("number");
    }

    private String checkSourceBillEntry(IDataModel model) {
        String sourceBillEntry = model.getDataEntity().getString("srcbillentry");
        if (sourceBillEntry == null || sourceBillEntry.isEmpty()) {
            String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6765\u6e90\u5355\u636e\u4f53\u3002", (String)"SNBillConfigEditPlugin_5", (String)"scmc-sbs-form", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return null;
        }
        return sourceBillEntry;
    }

    private void showColsTreePage(String entityNumber, IColsSelectStrategy strategy, String key, String caption) {
        IColsSelectStrategy selectStrategy = strategy;
        if (selectStrategy == null) {
            selectStrategy = new SimpleStrategy();
        }
        SelectParams params = new SelectParams();
        MetaHelper metaHelper = new MetaHelper(selectStrategy, entityNumber);
        String jsonTree = metaHelper.buildTree2JSON();
        params.setJsonTree(jsonTree);
        FormShowParameter fp = FormUtil.readyColsTreePage(params, new CloseCallBack((IFormPlugin)this, key));
        if (StringUtils.isNotEmpty((CharSequence)caption)) {
            fp.setCaption(caption);
        }
        this.getView().showForm(fp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        switch (actionId = e.getActionId()) {
            case "srcbillentryCB": 
            case "materialCB": 
            case "snbaseqtyCB": 
            case "materialMasterCB": 
            case "invorgCB": {
                this.objCloseCallBack(e, actionId);
                break;
            }
            case "snmainfColCB": 
            case "sntrackColCB": 
            case "sntrkvalColCB": 
            case "snmainfsrcbillColCB": 
            case "sntracksrcbillColCB": 
            case "sntrkvalsrcbillColCB": 
            case "inputsnrelColCB": 
            case "inputsnmovetrackColCB": 
            case "inputsnmainfileColCB": {
                this.objColCloseCallBack(e, actionId);
                break;
            }
        }
    }

    private void objCloseCallBack(ClosedCallBackEvent e, String actionId) {
        MainEntityType meta;
        String col = null;
        String colName = null;
        boolean valProp = false;
        boolean valDBCol = false;
        switch (actionId) {
            case "srcbillentryCB": {
                col = "srcbillentry";
                colName = "srcbillentryname";
                break;
            }
            case "materialCB": {
                col = "materialcol";
                colName = null;
                valProp = true;
                valDBCol = true;
                break;
            }
            case "snbaseqtyCB": {
                col = "snbaseqtycol";
                colName = null;
                valProp = true;
                valDBCol = true;
                break;
            }
            case "materialMasterCB": {
                col = "materialmastercol";
                colName = null;
                valProp = true;
                break;
            }
            case "invorgCB": {
                col = "invorgcol";
                colName = null;
                valProp = true;
                valDBCol = true;
                break;
            }
            default: {
                return;
            }
        }
        IDataModel model = this.getModel();
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject info = data.getJSONObject(0);
        String id = info.getString("id");
        boolean isMatInfo = "materialcol".equals(col);
        boolean isMat = "materialmastercol".equals(col);
        String colText = info.getString("text");
        if (valProp && this.checkChooseEntity(id)) {
            if (isMatInfo) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u7ed1\u5b9a\u7684\u4e1a\u52a1\u653f\u7b56\u4e0d\u4e3a\u7269\u6599\u5e93\u5b58\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SBS-E-331058", (String)"scmc-sbs-form", (Object[])new Object[]{colText}));
            } else if (isMat) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u7ed1\u5b9a\u7684\u4e1a\u52a1\u653f\u7b56\u4e0d\u4e3a\u7269\u6599\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SBS-E-122173", (String)"scmc-sbs-form", (Object[])new Object[]{colText}));
            }
            return;
        }
        if (valDBCol && !this.checkDatabaseCol(meta = this.getSourceBillMainEntityType(), id)) {
            return;
        }
        if (isMatInfo) {
            if (!this.checkMaterialInfoProp(id)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u7ed1\u5b9a\u7684\u4e1a\u52a1\u653f\u7b56\u4e0d\u4e3a\u7269\u6599\u5e93\u5b58\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SBS-E-331058", (String)"scmc-sbs-form", (Object[])new Object[]{colText}));
                return;
            }
            model.setValue("materialmastercol", null);
        } else if (isMat) {
            if (!this.checkMaterialProp(id)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u7ed1\u5b9a\u7684\u4e1a\u52a1\u653f\u7b56\u4e0d\u4e3a\u7269\u6599\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SBS-E-122173", (String)"scmc-sbs-form", (Object[])new Object[]{colText}));
                return;
            }
            model.setValue("materialcol", null);
        }
        model.setValue(col, (Object)id);
        if (colName != null) {
            model.setValue(colName, (Object)info.getString("text"));
        }
    }

    private boolean checkMaterialProp(String id) {
        String[] sp;
        DynamicObject srcObj = (DynamicObject)this.getModel().getValue("srcbillobj");
        if (srcObj == null) {
            return false;
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)srcObj.getString("number"));
        BasedataProp matProp = (BasedataProp)mainEntityType.findProperty((sp = id.split("\\."))[sp.length - 1]);
        return matProp == null || "bd_material".equals(matProp.getBaseEntityId());
    }

    private boolean checkMaterialInfoProp(String id) {
        String[] sp;
        DynamicObject srcObj = (DynamicObject)this.getModel().getValue("srcbillobj");
        if (srcObj == null) {
            return false;
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)srcObj.getString("number"));
        BasedataProp matProp = (BasedataProp)mainEntityType.findProperty((sp = id.split("\\."))[sp.length - 1]);
        return matProp == null || "bd_materialinventoryinfo".equals(matProp.getBaseEntityId());
    }

    private void objColCloseCallBack(ClosedCallBackEvent e, String actionId) {
        MainEntityType meta;
        String entryName = null;
        String colNo = null;
        String col = null;
        String clrColNo = null;
        String clrCol = null;
        boolean valSrcEntry = false;
        switch (actionId) {
            case "snmainfColCB": {
                entryName = "snmainfentry";
                colNo = "snmainfcolno";
                col = "snmainfcol";
                clrColNo = "snmainfsrcbillcolno";
                clrCol = "snmainfsrcbillcol";
                meta = EntityMetadataCache.getDataEntityType((String)"bd_snmainfile");
                break;
            }
            case "sntrackColCB": {
                entryName = "sntrackentry";
                colNo = "sntrackcolno";
                col = "sntrackcol";
                clrColNo = "sntracksrcbillcolno";
                clrCol = "sntracksrcbillcol";
                meta = EntityMetadataCache.getDataEntityType((String)"bd_snmovetrack");
                break;
            }
            case "sntrkvalColCB": {
                entryName = "sntrkvalentry";
                colNo = "sntrkvalcolno";
                col = "sntrkvalcol";
                clrColNo = "sntrkvalsrcbillcolno";
                clrCol = "sntrkvalsrcbillcol";
                meta = EntityMetadataCache.getDataEntityType((String)"bd_snmovetrack");
                break;
            }
            case "snmainfsrcbillColCB": {
                entryName = "snmainfentry";
                colNo = "snmainfsrcbillcolno";
                col = "snmainfsrcbillcol";
                valSrcEntry = true;
                meta = this.getSourceBillMainEntityType();
                break;
            }
            case "sntracksrcbillColCB": {
                entryName = "sntrackentry";
                colNo = "sntracksrcbillcolno";
                col = "sntracksrcbillcol";
                valSrcEntry = true;
                meta = this.getSourceBillMainEntityType();
                break;
            }
            case "sntrkvalsrcbillColCB": {
                entryName = "sntrkvalentry";
                colNo = "sntrkvalsrcbillcolno";
                col = "sntrkvalsrcbillcol";
                valSrcEntry = true;
                meta = this.getSourceBillMainEntityType();
                break;
            }
            case "inputsnrelColCB": {
                entryName = "inputsnentity";
                colNo = "billsnrelationcolname";
                col = "billsnrelationcol";
                String layoutType = this.getLayoutType();
                meta = EntityMetadataCache.getDataEntityType((String)layoutType);
                break;
            }
            case "inputsnmovetrackColCB": {
                entryName = "inputsnentity";
                colNo = "snmovetrackrelcolname";
                col = "snmovetrackrelcol";
                meta = EntityMetadataCache.getDataEntityType((String)"bd_snmovetrack_rel");
                break;
            }
            case "inputsnmainfileColCB": {
                entryName = "inputsnentity";
                colNo = "snmainfilecolname";
                col = "snmainfilecol";
                meta = EntityMetadataCache.getDataEntityType((String)"bd_snmainfile");
                break;
            }
            default: {
                return;
            }
        }
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex(entryName);
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject info = data.getJSONObject(0);
        String id = info.getString("id");
        if (valSrcEntry) {
            String sourceBillEntry = model.getDataEntity().getString("srcbillentry");
            String[] props = id.split("\\.");
            if (props.length >= 2 ? !sourceBillEntry.equals(props[props.length - 2]) : this.checkChooseEntity(id)) {
                return;
            }
        }
        if (!this.checkDatabaseCol(meta, id)) {
            return;
        }
        model.beginInit();
        model.setValue(col, (Object)id, index);
        model.setValue(colNo, (Object)info.getString("text"), index);
        if (clrColNo != null) {
            model.setValue(clrColNo, null, index);
        }
        if (clrCol != null) {
            model.setValue(clrCol, null, index);
        }
        Boolean updateMainFile = (Boolean)model.getValue("updatemainfile");
        if ("billsnrelationcolname".equals(colNo) && updateMainFile.booleanValue()) {
            this.setDefaultUpdateWayValue(model, index);
        }
        model.endInit();
        this.getView().updateView(entryName, index);
    }

    private boolean checkChooseEntity(String prop) {
        MainEntityType meta = this.getSourceBillMainEntityType();
        if (meta != null) {
            return meta.getAllEntities().containsKey(prop);
        }
        return true;
    }

    private boolean checkDatabaseCol(MainEntityType meta, String id) {
        IDataEntityProperty prop;
        if (meta == null) {
            return false;
        }
        String[] keys = id.split("\\.");
        if (keys.length >= 2) {
            String entry = keys[keys.length - 2];
            String key = keys[keys.length - 1];
            prop = (IDataEntityProperty)((EntityType)meta.getAllEntities().get(entry)).getFields().get(key);
        } else {
            prop = (IDataEntityProperty)meta.getAllFields().get(id);
        }
        String dbCol = prop.getAlias();
        if (dbCol == null || dbCol.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u6570\u636e\u5e93\u5b57\u6bb5\u540d\u4e3a\u7a7a\u7684\u5b57\u6bb5\u3002", (String)"SNBillConfigEditPlugin_6", (String)"scmc-sbs-form", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "updateway": {
                this.changeUpdateWay(e);
                break;
            }
            case "updatemainfile": {
                this.changeUpdateMainFile(e, key);
                break;
            }
            case "enterlayout": {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("enterlayout", (IFormPlugin)this);
                ChangeData[] changeSet = e.getChangeSet();
                Object oldLayOut = changeSet[0].getOldValue();
                if (oldLayOut != null) {
                    this.getView().getPageCache().put("oldLayout", ((DynamicObject)oldLayOut).getString("id"));
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f55\u5165\u5e8f\u5217\u53f7\u9875\u9762\u4fee\u6539\u540e\uff0c\u5f55\u5165\u5e8f\u5217\u53f7\u6620\u5c04\u5c06\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"SNBillConfigEditPlugin_8", (String)"scmc-sbs-form", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                break;
            }
            case "snreqbill": {
                this.changeSnReqBill();
                break;
            }
            case "srcbillobj": 
            case "srcbillentry": {
                this.changeSourceBill(e, key);
                break;
            }
            case "snmainfcolno": 
            case "sntrackcolno": 
            case "sntrkvalcolno": 
            case "snmainfsrcbillcolno": 
            case "sntracksrcbillcolno": 
            case "sntrkvalsrcbillcolno": 
            case "billsnrelationcolname": 
            case "snmovetrackrelcolname": 
            case "snmainfilecolname": {
                this.changeTargetObjCol(e, key);
            }
        }
    }

    private void changeUpdateWay(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        String newValue = (String)changeSet[0].getNewValue();
        String oldValue = (String)changeSet[0].getOldValue();
        String msg = "";
        if (StringUtils.isNotEmpty((CharSequence)newValue) && !this.getColType(model, rowIndex).booleanValue()) {
            if (!"1".equals(newValue)) {
                msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6570\u636e\u9009\u62e9\u7684\u5355\u636e\u5e8f\u5217\u53f7\u5173\u8054\u8868\u5b57\u6bb5\u4e3a\u975e\u6570\u503c\u7c7b\u578b\uff0c\u8d4b\u503c\u65b9\u5f0f\u4e0d\u80fd\u4e3a'\u7d2f\u52a0'\u6216'\u7d2f\u51cf'\u3002", (String)"SNBillConfigEditPlugin_16", (String)"scmc-sbs-form", (Object[])new Object[]{rowIndex + 1});
            }
        } else if ("1".equals(newValue)) {
            msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6570\u636e\u9009\u62e9\u7684\u5355\u636e\u5e8f\u5217\u53f7\u5173\u8054\u8868\u5b57\u6bb5\u4e3a\u6570\u503c\u7c7b\u578b\uff0c\u8d4b\u503c\u65b9\u5f0f\u4e0d\u80fd\u4e3a'\u8986\u76d6'\u3002", (String)"SNBillConfigEditPlugin_15", (String)"scmc-sbs-form", (Object[])new Object[]{rowIndex + 1});
        }
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            model.setValue("updateway", (Object)oldValue, rowIndex);
            this.getView().showTipNotification(msg);
        }
        this.getView().updateView("updateway", rowIndex);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String backId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        switch (backId) {
            case "enterlayout": {
                if (result.equals((Object)MessageBoxResult.Yes)) {
                    this.getModel().deleteEntryData("inputsnentity");
                } else {
                    String oldLayout = this.getView().getPageCache().get("oldLayout");
                    this.getModel().beginInit();
                    this.getModel().setValue("enterlayout", (Object)(StringUtils.isEmpty((CharSequence)oldLayout) ? null : oldLayout));
                    this.getModel().endInit();
                    this.getView().updateView("enterlayout");
                }
                this.getView().getPageCache().remove("oldLayout");
                break;
            }
        }
    }

    private void changeSnReqBill() {
        Boolean value = (Boolean)this.getModel().getValue("snreqbill");
        if (!value.booleanValue()) {
            this.getModel().setValue("occupymove", (Object)true);
        }
    }

    private void changeTargetObjCol(PropertyChangedArgs e, String key) {
        String entryName = null;
        String tarCol = null;
        String srcColNo = null;
        String srcCol = null;
        String mainFileColNo = null;
        String mainFileCol = null;
        switch (key) {
            case "snmainfcolno": {
                entryName = "snmainfentry";
                tarCol = "snmainfcol";
                srcColNo = "snmainfsrcbillcolno";
                srcCol = "snmainfsrcbillcol";
                break;
            }
            case "sntrackcolno": {
                entryName = "sntrackentry";
                tarCol = "sntrackcol";
                srcColNo = "sntracksrcbillcolno";
                srcCol = "sntracksrcbillcol";
                break;
            }
            case "sntrkvalcolno": {
                entryName = "sntrkvalentry";
                tarCol = "sntrkvalcol";
                srcColNo = "sntrkvalsrcbillcolno";
                srcCol = "sntrkvalsrcbillcol";
                break;
            }
            case "snmainfsrcbillcolno": {
                entryName = "snmainfentry";
                tarCol = "snmainfsrcbillcol";
                break;
            }
            case "sntracksrcbillcolno": {
                entryName = "sntrackentry";
                tarCol = "sntracksrcbillcol";
                break;
            }
            case "sntrkvalsrcbillcolno": {
                entryName = "sntrkvalentry";
                tarCol = "sntrkvalsrcbillcol";
                break;
            }
            case "billsnrelationcolname": {
                entryName = "inputsnentity";
                tarCol = "billsnrelationcol";
                srcColNo = "snmovetrackrelcolname";
                srcCol = "snmovetrackrelcol";
                mainFileColNo = "snmainfilecolname";
                mainFileCol = "snmainfilecol";
                break;
            }
            case "snmovetrackrelcolname": {
                entryName = "inputsnentity";
                tarCol = "snmovetrackrelcol";
                srcColNo = "snmovetrackrelcolname";
                srcCol = "snmovetrackrelcol";
                break;
            }
            case "snmainfilecolname": {
                entryName = "inputsnentity";
                tarCol = "snmainfilecol";
            }
        }
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        model.beginInit();
        for (ChangeData changeData : changeSet) {
            int rowIndex = changeData.getRowIndex();
            model.setValue(tarCol, null, rowIndex);
            if (srcColNo != null) {
                model.setValue(srcColNo, null, rowIndex);
            }
            if (srcCol != null) {
                model.setValue(srcCol, null, rowIndex);
            }
            if (mainFileColNo != null) {
                model.setValue(mainFileColNo, null, rowIndex);
            }
            if (mainFileCol == null) continue;
            model.setValue(mainFileCol, null, rowIndex);
        }
        model.endInit();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryName);
        int[] rowIndexes = entryGrid.getSelectRows();
        this.getView().updateView(entryName, rowIndexes[0]);
    }

    private void changeSourceBill(PropertyChangedArgs e, String key) {
        int i;
        IDataModel model = this.getModel();
        model.beginInit();
        if ("srcbillobj".equals(key)) {
            model.setValue("srcbillentry", null);
            model.setValue("srcbillentryname", null);
            DynamicObjectCollection operateEntries = model.getEntryEntity("operateentry");
            if (!operateEntries.isEmpty()) {
                for (int i2 = 0; i2 < operateEntries.size(); ++i2) {
                    model.setValue("operate", null, i2);
                }
            }
            FilterGrid filterGrid = (FilterGrid)this.getControl("billfiltergrid");
            filterGrid.SetValue(new FilterCondition());
            model.setValue("billfilter", (Object)"");
            this.setCols4FilterGridAndOpe();
        }
        if ("srcbillentry".equals(key)) {
            model.setValue("srcbillentryname", null);
        }
        model.setValue("materialcol", null);
        model.setValue("materialmastercol", null);
        model.setValue("snbaseqtycol", null);
        DynamicObjectCollection snmainfEntries = model.getEntryEntity("snmainfentry");
        DynamicObjectCollection sntrackEntries = model.getEntryEntity("sntrackentry");
        DynamicObjectCollection sntrkvalEntries = model.getEntryEntity("sntrkvalentry");
        if (!snmainfEntries.isEmpty()) {
            for (i = 0; i < snmainfEntries.size(); ++i) {
                model.setValue("snmainfsrcbillcolno", null, i);
                model.setValue("snmainfsrcbillcol", null, i);
            }
        }
        if (!sntrackEntries.isEmpty()) {
            for (i = 0; i < sntrackEntries.size(); ++i) {
                model.setValue("sntracksrcbillcolno", null, i);
                model.setValue("sntracksrcbillcol", null, i);
            }
        }
        if (!sntrkvalEntries.isEmpty()) {
            for (i = 0; i < sntrkvalEntries.size(); ++i) {
                model.setValue("sntrkvalsrcbillcolno", null, i);
                model.setValue("sntrkvalsrcbillcol", null, i);
            }
        }
        model.endInit();
        this.getView().updateView();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": {
                this.beforeSave(e);
                break;
            }
        }
    }

    private void beforeSave(BeforeDoOperationEventArgs e) {
        IDataModel model = this.getModel();
        String billFilterInfo = this.parseBillFilterInfo();
        model.setValue("billfilter", (Object)billFilterInfo);
        if (model.getValue("enterlayout") == null) {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"sbs_billsnrelation")});
            model.beginInit();
            model.setValue("enterlayout", (Object)object);
            model.endInit();
            this.getView().updateView("enterlayout");
        }
    }

    private String parseBillFilterInfo() {
        FilterGrid grid = (FilterGrid)this.getControl("billfiltergrid");
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        return jsonStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        FieldFormTranslator translator = FieldFormTranslator.create(this.getModel());
        String billEntity = null;
        DynamicObject srcObj = (DynamicObject)this.getModel().getValue("srcbillobj");
        if (srcObj != null) {
            billEntity = srcObj.getString("number");
        }
        if (billEntity != null) {
            IDataEntityProperty prop;
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billEntity);
            String entryKey = (String)this.getModel().getValue("srcbillentry");
            if (entryKey != null && (prop = entityType.findProperty(entryKey)) != null) {
                this.getModel().setValue("srcbillentryname", (Object)prop.getDisplayName().getLocaleValue());
            }
        }
        try {
            translator.entryToEntryTranslate("snmainfentry", "bd_snmainfile", "snmainfcol", "snmainfcolno");
            translator.entryToEntryTranslate("snmainfentry", billEntity, "snmainfsrcbillcol", "snmainfsrcbillcolno");
            translator.entryToEntryTranslate("sntrackentry", "bd_snmovetrack", "sntrackcol", "sntrackcolno");
            translator.entryToEntryTranslate("sntrackentry", billEntity, "sntracksrcbillcol", "sntracksrcbillcolno");
            translator.entryToEntryTranslate("sntrkvalentry", "bd_snmovetrack", "sntrkvalcol", "sntrkvalcolno");
            translator.entryToEntryTranslate("sntrkvalentry", billEntity, "sntrkvalsrcbillcol", "sntrkvalsrcbillcolno");
            translator.entryToEntryTranslate("inputsnentity", "sbs_billsnrelation", "billsnrelationcol", "billsnrelationcolname");
            translator.entryToEntryTranslate("inputsnentity", "bd_snmovetrack_rel", "snmovetrackrelcol", "snmovetrackrelcolname");
            translator.entryToEntryTranslate("inputsnentity", "bd_snmainfile", "snmainfilecol", "snmainfilecolname");
        }
        catch (Exception exception) {
            this.getView().showErrorNotification(exception.getMessage());
        }
        finally {
            this.getModel().setDataChanged(false);
        }
    }
}

