/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formplugin.sn;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.scmc.sbs.business.common.colsAssist.CompositeStrategy;
import kd.scmc.sbs.business.common.colsAssist.EntryNodeStrategy;
import kd.scmc.sbs.business.common.colsAssist.FilterStrategy;
import kd.scmc.sbs.business.common.colsAssist.IColsSelectStrategy;
import kd.scmc.sbs.business.common.colsAssist.MetaHelper;
import kd.scmc.sbs.business.common.colsAssist.SelectParams;
import kd.scmc.sbs.business.common.colsAssist.SimpleStrategy;
import kd.scmc.sbs.business.common.colsAssist.TypeSelectStategy;
import kd.scmc.sbs.common.consts.SNBillConfigConsts;
import kd.scmc.sbs.common.util.ColsTreeUtil;
import kd.scmc.sbs.common.util.FormUtil;

public class SNRelExtConfigEditPlugin
extends AbstractBasePlugIn {
    private static final String DESTCOLCB = "destColCB";
    private static final String BILLSNCOLCB = "billSNColCB";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnable();
    }

    private void setEnable() {
        IFormView view = this.getView();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Boolean isPreset = dataEntity.getBoolean("ispreset");
        if (isPreset.booleanValue()) {
            view.setEnable(Boolean.FALSE, new String[]{"desttable"});
            view.setEnable(Boolean.FALSE, new String[]{"destcol"});
            view.setEnable(Boolean.FALSE, new String[]{"billsncol"});
        } else {
            view.setEnable(Boolean.TRUE, new String[]{"desttable"});
            view.setEnable(Boolean.TRUE, new String[]{"destcol"});
            view.setEnable(Boolean.TRUE, new String[]{"billsncol"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"billsncol", "destcol"});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "destcol": {
                this.clickDestCol(evt);
                break;
            }
            case "billsncol": {
                this.clickBillSNCol(evt);
                break;
            }
        }
    }

    private void clickDestCol(EventObject evt) {
        IDataModel model = this.getModel();
        String desttable = (String)model.getValue("desttable");
        ArrayList<String> excludeCols = new ArrayList<String>(16);
        if ("bd_snmainfile".equals(desttable)) {
            excludeCols.add("moveentry");
            excludeCols.add("sndimentity");
            excludeCols.add("invorg");
            excludeCols.add("lotnumber");
            excludeCols.addAll(SNBillConfigConsts.SNMAINFILE_FIXCOLS);
        } else if ("bd_snmovetrack_rel".equals(desttable)) {
            excludeCols.addAll(SNBillConfigConsts.SNMOVETRACKREL_FIXCOLS);
        }
        this.showColsTreePage(desttable, new FilterStrategy(excludeCols), DESTCOLCB, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5", (String)"SNRelExtConfigEditPlugin_0", (String)"scmc-sbs-form", (Object[])new Object[0]));
    }

    private void clickBillSNCol(EventObject evt) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String destcol = (String)model.getValue("destcol");
        if (StringUtils.isBlank((CharSequence)destcol)) {
            String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u8868\u5b57\u6bb5\u3002", (String)"SNRelExtConfigEditPlugin_1", (String)"scmc-sbs-form", (Object[])new Object[0]);
            view.showTipNotification(message);
            return;
        }
        String desttable = (String)model.getValue("desttable");
        MainEntityType destTableType = EntityMetadataCache.getDataEntityType((String)desttable);
        IDataEntityProperty destProp = destTableType.findProperty(destcol);
        ArrayList<String> excludeCols = new ArrayList<String>(5);
        excludeCols.add("snnumber");
        excludeCols.add("invorg");
        excludeCols.add("seq");
        excludeCols.add("snmainfileid");
        excludeCols.add("handlestatus");
        TypeSelectStategy typeSelectStategy = new TypeSelectStategy(destProp);
        EntryNodeStrategy entrynodeStategy = new EntryNodeStrategy(Collections.singletonList("entryentity"), false);
        FilterStrategy filterStrategy = new FilterStrategy(excludeCols);
        CompositeStrategy compStrategy = new CompositeStrategy(Arrays.asList(typeSelectStategy, entrynodeStategy, filterStrategy));
        this.showColsTreePage("sbs_billsnrelation", compStrategy, BILLSNCOLCB, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5", (String)"SNRelExtConfigEditPlugin_0", (String)"scmc-sbs-form", (Object[])new Object[0]));
    }

    private void showColsTreePage(String entityNumber, IColsSelectStrategy strategy, String key, String caption) {
        IColsSelectStrategy selectStrategy = strategy;
        if (selectStrategy == null) {
            selectStrategy = new SimpleStrategy();
        }
        SelectParams params = new SelectParams();
        MetaHelper metaHelper = new MetaHelper(selectStrategy, entityNumber);
        String jsonTree = metaHelper.buildTree2JSON();
        params.setJsonTree(jsonTree);
        FormShowParameter fp = FormUtil.readyColsTreePage(params, new CloseCallBack((IFormPlugin)this, key));
        if (StringUtils.isNotEmpty((CharSequence)caption)) {
            fp.setCaption(caption);
        }
        this.getView().showForm(fp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        switch (actionId = e.getActionId()) {
            case "destColCB": 
            case "billSNColCB": {
                this.objColCloseCallBack(e, actionId);
                break;
            }
        }
    }

    private void objColCloseCallBack(ClosedCallBackEvent e, String actionId) {
        MainEntityType meta;
        IDataModel model = this.getModel();
        String col = null;
        switch (actionId) {
            case "destColCB": {
                String desttable = (String)model.getValue("desttable");
                meta = EntityMetadataCache.getDataEntityType((String)desttable);
                col = "destcol";
                break;
            }
            case "billSNColCB": {
                meta = EntityMetadataCache.getDataEntityType((String)"sbs_billsnrelation");
                col = "billsncol";
                break;
            }
            default: {
                return;
            }
        }
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject info = data.getJSONObject(0);
        String id = info.getString("id");
        if (meta.getAllEntities().containsKey(id)) {
            return;
        }
        if (!this.checkDatabaseCol(meta, id)) {
            return;
        }
        model.setValue(col, (Object)id);
    }

    private boolean checkDatabaseCol(MainEntityType meta, String id) {
        IDataEntityProperty prop;
        if (meta == null) {
            return false;
        }
        String[] keys = id.split("\\.");
        if (keys.length >= 2) {
            String entry = keys[keys.length - 2];
            String key = keys[keys.length - 1];
            prop = (IDataEntityProperty)((EntityType)meta.getAllEntities().get(entry)).getFields().get(key);
        } else {
            prop = (IDataEntityProperty)meta.getAllFields().get(id);
        }
        String dbCol = prop.getAlias();
        if (dbCol == null || dbCol.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u6570\u636e\u5e93\u5b57\u6bb5\u540d\u4e3a\u7a7a\u7684\u5b57\u6bb5\u3002", (String)"SNRelExtConfigEditPlugin_2", (String)"scmc-sbs-form", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        switch (key = e.getProperty().getName()) {
            case "desttable": {
                this.changeDestTable(model, changeSet);
                break;
            }
            case "destcol": {
                this.changeDestCol(model);
            }
        }
    }

    private void changeDestTable(IDataModel model, ChangeData[] changeSet) {
        model.beginInit();
        model.setValue("destcol", null);
        model.setValue("billsncol", null);
        model.endInit();
        this.getView().updateView();
    }

    private void changeDestCol(IDataModel model) {
        model.beginInit();
        model.setValue("billsncol", null);
        model.endInit();
        this.getView().updateView();
    }
}

