/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formplugin.sn;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.sbs.business.sn.SNBillConfigHelper;
import kd.scmc.sbs.common.consts.SNMainFileStatusAssistantConsts;
import kd.scmc.sbs.common.util.FormUtil;
import kd.sdk.scmc.sbs.extpoint.ISbsSelectSNExpand;
import org.apache.commons.lang3.StringUtils;

public class SelectedSNPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static String DIM_PRE = "dim";
    private Map<Integer, Map<String, Object>> dims = SNBillConfigHelper.getSndims();
    private static boolean DEFCURORG_OUTBILL = false;
    private static int MAX_SELECT_RECORDS = 5000;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"query", "cancel", "confirm"});
        FormUtil.addF7Listener(this, "snstatushead", "org");
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        FormShowParameter parameter;
        EntryAp entryAp;
        super.loadCustomControlMetas(e);
        if (!this.dims.isEmpty() && (entryAp = this.createDynamicEntryAp(parameter = (FormShowParameter)e.getSource())) != null) {
            HashMap<String, String> mapEntry = new HashMap<String, String>(2);
            mapEntry.put("id", "entryentity");
            mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
            e.getItems().add(mapEntry);
        }
    }

    private EntryAp createDynamicEntryAp(FormShowParameter parameter) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)parameter.getFormId());
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        formMeta.bindEntityMetadata(entityMetadata);
        EntryAp entryAp = null;
        for (ControlAp ap : formMeta.getItems()) {
            if (!StringUtils.equals((CharSequence)ap.getKey(), (CharSequence)"entryentity")) continue;
            entryAp = (EntryAp)ap;
            break;
        }
        if (entryAp != null) {
            List entryItems = entryAp.getItems();
            for (Map.Entry<Integer, Map<String, Object>> dim : this.dims.entrySet()) {
                Integer seq = dim.getKey();
                String dimkey = DIM_PRE + seq;
                Map<String, Object> dimval = dim.getValue();
                String name = (String)dimval.get("name");
                EntryFieldAp fieldAp = new EntryFieldAp();
                fieldAp.setId(dimkey);
                fieldAp.setKey(dimkey);
                fieldAp.setName(new LocaleString(name));
                fieldAp.setFireUpdEvt(true);
                TextField field = new TextField();
                field.setId(dimkey);
                field.setKey(dimkey);
                field.setName(new LocaleString(name));
                fieldAp.setField((Field)field);
                entryItems.add(fieldAp);
            }
        }
        return entryAp;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        if (this.dims.isEmpty()) {
            super.getEntityType(e);
            return;
        }
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetas", exp.getMessage()), new Object[0]);
        }
        for (Map.Entry<Integer, Map<String, Object>> dim : this.dims.entrySet()) {
            Integer seq = dim.getKey();
            String dimkey = DIM_PRE + seq;
            Map<String, Object> dimval = dim.getValue();
            String name = (String)dimval.get("name");
            this.registDynamicProps(newMainType, dimkey, name);
        }
        e.setNewEntityType(newMainType);
    }

    private void registDynamicProps(MainEntityType newMainType, String dimkey, String name) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("entryentity");
        TextProp textProp = new TextProp();
        textProp.setName(dimkey);
        textProp.setDisplayName(new LocaleString(name));
        textProp.setDbIgnore(true);
        textProp.setAlias("");
        entryType.registerSimpleProperty((DynamicSimpleProperty)textProp);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String billtype = (String)customParams.get("billtype");
        if ("sbs_snsupplement".equals(billtype)) {
            this.handleInfo();
        } else {
            Long billid = (Long)customParams.get("billid");
            String entrytype = (String)customParams.get("entrykey");
            DynamicObject cfg = SNBillConfigHelper.getSNBillConfigByBillId(billtype, entrytype, billid);
            Set<String> allowsnstatus = SelectedSNPlugin.getSNBillCfgSntatus(cfg);
            String invflu = null;
            long mastertypeid = 1401417099242528768L;
            if (cfg != null) {
                invflu = cfg.getString("invflu");
                mastertypeid = cfg.getDynamicObject("masterfiletype").getLong("id");
            }
            this.setDefaultSnstatus(allowsnstatus);
            this.handleBillInfo(invflu, mastertypeid);
        }
    }

    private void handleInfo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object invorg = customParams.get("invorg");
        DynamicObject org = BusinessDataServiceHelper.loadSingle(invorg, (String)"bos_org");
        this.getModel().setValue("org", (Object)org);
        this.getModel().setValue("snstatushead", (Object)SNMainFileStatusAssistantConsts.SN_STATUS_IN_INV_ID);
        this.getView().setEnable(Boolean.FALSE, new String[]{"snstatushead"});
        this.getPageCache().put("org", invorg.toString());
        this.getPageCache().put("mastertypeid", String.valueOf(1401417099242528768L));
    }

    private void setDefaultSnstatus(Set<String> allowsnstatus) {
        IDataModel model = this.getModel();
        model.setValue("allowsnstatus", (Object)StringUtils.join(allowsnstatus, (char)','));
    }

    private void handleBillInfo(String invflu, long mastertypeid) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        IDataModel model = this.getModel();
        Object orgid = customParams.get("invorg");
        Object warehous = customParams.get("curwarehous");
        Object location = customParams.get("curlocation");
        Object lotNumber = customParams.get("lotnumber");
        if ("2".equals(invflu) || "3".equals(invflu)) {
            model.setValue("curwarehous", warehous);
            model.setValue("curlocation", location);
        }
        if (orgid != null) {
            if (DEFCURORG_OUTBILL && ("2".equals(invflu) || "3".equals(invflu))) {
                model.setValue("bizorg", orgid);
            } else {
                model.setValue("org", orgid);
            }
            this.getPageCache().put("org", orgid.toString());
        }
        model.setValue("lotnumberhead", lotNumber);
        this.getPageCache().put("mastertypeid", String.valueOf(mastertypeid));
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control c = (Control)e.getSource();
        switch (key = c.getKey()) {
            case "query": {
                this.getModel().deleteEntryData("entryentity");
                this.querySnMainAndTrack();
                break;
            }
            case "cancel": {
                this.getView().close();
                break;
            }
            case "confirm": {
                this.returnSelectedResult();
                break;
            }
        }
    }

    private void querySnMainAndTrack() {
        DynamicObject snstatus;
        DynamicObject curlocation;
        DynamicObject curwarehous;
        DynamicObject curbizorg;
        String snTo;
        String snFrom;
        IFormView view = this.getView();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object form = customParams.get("formId");
        StringBuilder filter = new StringBuilder();
        StringBuilder sql = new StringBuilder();
        if ("sbs_snsupplement".equals(form)) {
            filter.append(" t.ffinalaudittrailid = 0 and ");
        }
        filter.append(" t.foccupybillid = 0 ");
        filter.append(" and t.fmasterfiletypeid = ").append(this.getPageCache().get("mastertypeid"));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null && !org.getPkValue().equals(0L)) {
            filter.append(" and t.finvorgid = ").append(org.getPkValue());
        }
        Object materialId = customParams.get("material");
        if ("sbs_snsupplement".equals(form)) {
            filter.append(" and t.fmaterialid = ").append(materialId);
        } else if (materialId != null) {
            DynamicObject materialObj = BusinessDataServiceHelper.loadSingle(materialId, (String)"bd_materialinventoryinfo", (String)"id,name,nubmer,masterid");
            long masterid_id = materialObj.getLong("masterid_id");
            filter.append(" and t.fmaterialid = ").append(masterid_id);
        }
        String lotnumberhead = (String)this.getModel().getValue("lotnumberhead");
        if (!lotnumberhead.isEmpty()) {
            filter.append(" and t.flotnumber = ").append("'").append(lotnumberhead).append("'");
        }
        if (!(snFrom = (String)this.getModel().getValue("snfrom")).isEmpty()) {
            filter.append(" and t.fnumber >= ").append("'").append(snFrom).append("'");
        }
        if (!(snTo = (String)this.getModel().getValue("snto")).isEmpty()) {
            filter.append(" and t.fnumber <= ").append("'").append(snTo).append("'");
        }
        if ((curbizorg = (DynamicObject)this.getModel().getValue("bizorg")) != null && !curbizorg.getPkValue().equals(0L)) {
            filter.append(" and t2.fkeeporgid = ").append(curbizorg.getPkValue());
        }
        if ((curwarehous = (DynamicObject)this.getModel().getValue("curwarehous")) != null && !curwarehous.getPkValue().equals(0L)) {
            filter.append(" and t2.fwarehouseid = ").append(curwarehous.getPkValue());
        }
        if ((curlocation = (DynamicObject)this.getModel().getValue("curlocation")) != null && !curlocation.getPkValue().equals(0L)) {
            filter.append(" and t2.flocationid = ").append(curlocation.getPkValue());
        }
        if ((snstatus = (DynamicObject)this.getModel().getValue("snstatushead")) != null) {
            String status = SNMainFileStatusAssistantConsts.transferSnStatus(snstatus.getString("number"));
            filter.append(" and t.fsnstatus = ").append("'").append(status).append("'");
        } else {
            String allowsnstatusStr = (String)this.getModel().getValue("allowsnstatus");
            String[] allowsnstatus = allowsnstatusStr.split(",");
            if (allowsnstatus.length > 0) {
                filter.append(" and t.fsnstatus in(");
                int index = 0;
                for (String allowstatus : allowsnstatus) {
                    if (index > 0) {
                        filter.append(',');
                    }
                    filter.append('\'').append(allowstatus).append('\'');
                    ++index;
                }
                filter.append(")");
            }
        }
        String expandFilter = this.getExpandWhere(view);
        if (expandFilter != null && !expandFilter.isEmpty()) {
            filter.append(expandFilter);
        }
        List<Map<String, String>> selectMaps = this.getExpandSelectMaps(view);
        StringBuilder dimpropsql = new StringBuilder();
        StringBuilder dimtablesql = new StringBuilder();
        if (!this.dims.isEmpty()) {
            for (Map.Entry<Integer, Map<String, Object>> dim : this.dims.entrySet()) {
                Integer seq = dim.getKey();
                Map<String, Object> dimval = dim.getValue();
                Long id = (Long)dimval.get("id");
                dimpropsql.append(",d").append(seq).append(".fsndimnumber as ").append(DIM_PRE).append(seq);
                dimtablesql.append(" left join t_bd_sndimensionentry d").append(seq).append(" on d").append(seq).append(".fid=t.fid and d").append(seq).append(".fsndimitem = ").append(id);
            }
        }
        sql.append("select top ").append(MAX_SELECT_RECORDS).append(" t.fid as snmainfileid,t.finvorgid,t.fnumber,t.fmaterialid,t.flotnumber,t.fsnstatus,t.fbillid,t2.fkeeporgid,t2.fwarehouseid,t2.flocationid");
        int extSelectIndex = 1;
        for (Map<String, String> selectMap : selectMaps) {
            Iterator<Map<String, String>> entity = selectMap.get("entity");
            String tablePre = "t.";
            if ("bd_snmovetrack".equals(entity)) {
                tablePre = "t2.";
            }
            String selectcol = selectMap.get("selectcol");
            sql.append(',').append(tablePre).append(selectcol).append(" as ext").append(extSelectIndex);
            ++extSelectIndex;
        }
        sql.append((CharSequence)dimpropsql).append(" from t_bd_snmainfile t ").append("left join t_bd_snmovetrack_rel r on t.ffinalaudittrailid = r.fid ").append("left join t_bd_snmovetrack t2 on r.ftrackid = t2.fid ").append((CharSequence)dimtablesql).append(" where").append((CharSequence)filter);
        DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"sys"), (String)sql.toString());
        if (dataSet.hasNext()) {
            model.deleteEntryData("entryentity");
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("snmainfileid", new Object[0]);
            vs.addField("invorg", new Object[0]);
            vs.addField("serialnum", new Object[0]);
            vs.addField("snmaterial", new Object[0]);
            vs.addField("lotnum", new Object[0]);
            vs.addField("curbizorg", new Object[0]);
            vs.addField("snumstatus", new Object[0]);
            vs.addField("whouse", new Object[0]);
            vs.addField("locations", new Object[0]);
            for (Integer seq : this.dims.keySet()) {
                String dimkey = DIM_PRE + seq;
                vs.addField(dimkey, new Object[0]);
            }
            for (Map<String, String> selectMap : selectMaps) {
                String returncol = selectMap.get("returncol");
                vs.addField(returncol, new Object[0]);
            }
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Object[] rowitems = new Object[9 + this.dims.size() + selectMaps.size()];
                rowitems[0] = row.getLong("snmainfileid");
                rowitems[1] = row.getLong("finvorgid");
                rowitems[2] = row.getString("fnumber");
                rowitems[3] = row.getLong("fmaterialid");
                rowitems[4] = row.getString("flotnumber");
                rowitems[5] = row.getLong("fkeeporgid");
                rowitems[6] = row.getString("fsnstatus");
                rowitems[7] = row.getLong("fwarehouseid");
                rowitems[8] = row.getLong("flocationid");
                int i = 9;
                for (Integer seq : this.dims.keySet()) {
                    String dimkey = DIM_PRE + seq;
                    rowitems[i] = row.getString(dimkey);
                    ++i;
                }
                for (int j = 1; j <= selectMaps.size(); ++j) {
                    String extcol = "ext" + j;
                    rowitems[i] = row.get(extcol);
                    ++i;
                }
                vs.addRow(rowitems);
            }
            model.batchCreateNewEntryRow("entryentity", vs);
            model.endInit();
            this.getView().updateView("entryentity");
            if (vs.getCount() >= MAX_SELECT_RECORDS) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u6b21\u67e5\u8be2\u7684\u8bb0\u5f55\u8fc7\u591a,\u53ea\u8fd4\u56de\u524d%d\u6761\u7ed3\u679c\u3002", (String)"SelectedSNPlugin_2", (String)"scmc-sbs-form", (Object[])new Object[0]), MAX_SELECT_RECORDS));
            }
        }
    }

    private void returnSelectedResult() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        int pageRow = entryGrid.getEntryData().getStartIndex();
        if (selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u5206\u5f55\u3002", (String)"SelectedSNPlugin_1", (String)"scmc-sbs-form", (Object[])new Object[0]));
        }
        LinkedHashMap snAttrMap = new LinkedHashMap(selectRows.length);
        DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
        for (int selectRow : selectRows) {
            DynamicObject dynamicObjects = dataEntitys[selectRow - pageRow];
            String sn = dynamicObjects.getString("serialnum");
            Long invorg = dynamicObjects.getDynamicObject("invorg").getLong("id");
            HashMap<String, Object> attrs = new HashMap<String, Object>(1 + this.dims.size());
            attrs.put("invorg", invorg);
            attrs.put("snmainfileid", dynamicObjects.getLong("snmainfileid"));
            for (Integer seq : this.dims.keySet()) {
                String dimkey = DIM_PRE + seq;
                String dimnum = dynamicObjects.getString(dimkey);
                attrs.put(dimkey, dimnum);
            }
            snAttrMap.put(sn, attrs);
        }
        this.getView().returnDataToParent(snAttrMap);
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        switch (key) {
            case "snfrom": {
                this.handleSnFromChangeEvent(newValue);
                break;
            }
            case "snto": {
                this.handleSnToChangeEvent(newValue, oldValue);
                break;
            }
        }
    }

    private void handleSnToChangeEvent(Object newValue, Object oldValue) {
        if (!ObjectUtils.isEmpty((Object)newValue)) {
            String[] lotNumberToValueStrs = ((String)newValue).trim().split("\\s+");
            if (lotNumberToValueStrs.length > 1) {
                this.getModel().setValue("snto", oldValue);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u81f3\u4e0d\u80fd\u586b\u5165\u591a\u4e2a\u4ee5\u7a7a\u683c\u5206\u5f00\u7684\u503c\u3002", (String)"SelectedSNPlugin_3", (String)"scmc-sbs-form", (Object[])new Object[0]));
            } else {
                this.getModel().setValue("snto", (Object)((String)newValue).trim());
            }
        }
    }

    private void handleSnFromChangeEvent(Object newValue) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            this.getModel().setValue("snto", null);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"snto"});
        } else {
            String updateNewValue = ((String)newValue).trim();
            String[] froms = updateNewValue.split("\\s+");
            if (froms.length > 1) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"snto"});
                this.getModel().setValue("snto", null);
                StringBuilder result = new StringBuilder();
                for (int i = 0; i <= froms.length - 1; ++i) {
                    result.append(froms[i]);
                    result.append(" ");
                }
                this.getModel().setValue("snfrom", (Object)result.toString());
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"snto"});
                this.getModel().setValue("snfrom", (Object)updateNewValue);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "snstatushead": {
                this.beforeSelectSNStatus(e);
                break;
            }
        }
    }

    private void beforeSelectSNStatus(BeforeF7SelectEvent e) {
        String[] allowsnstatus;
        HashSet<Long> invStatus = new HashSet<Long>(5);
        String allowsnstatusStr = (String)this.getModel().getValue("allowsnstatus");
        String[] stringArray = allowsnstatus = allowsnstatusStr.split(",");
        int n = stringArray.length;
        block14: for (int i = 0; i < n; ++i) {
            String status;
            switch (status = stringArray[i]) {
                case "A": {
                    invStatus.add(SNMainFileStatusAssistantConsts.SN_STATUS_PENDING_IN_INV_ID);
                    continue block14;
                }
                case "C": {
                    invStatus.add(SNMainFileStatusAssistantConsts.SN_STATUS_PENDING_OUT_INV_ID);
                    continue block14;
                }
                case "B": {
                    invStatus.add(SNMainFileStatusAssistantConsts.SN_STATUS_IN_INV_ID);
                    continue block14;
                }
                case "D": {
                    invStatus.add(SNMainFileStatusAssistantConsts.SN_STATUS_OUT_INV_ID);
                    continue block14;
                }
                case "E": {
                    invStatus.add(SNMainFileStatusAssistantConsts.SN_STATUS_TRANS_OUT_INV_ID);
                }
            }
        }
        QFilter filter = new QFilter("id", "in", invStatus);
        ListFilterParameter listFilterParameter = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter();
        listFilterParameter.setFilter(filter);
    }

    private static Set<String> getSNBillCfgSntatus(DynamicObject cfg) {
        if (cfg != null) {
            Set<String> snstatus = SNBillConfigHelper.getSnstatus(cfg);
            return snstatus;
        }
        return Collections.emptySet();
    }

    private List<Map<String, String>> getExpandSelectMaps(IFormView view) {
        PluginProxy pluginProxy = PluginProxy.create(ISbsSelectSNExpand.class, (String)"SCMC_SBS_SELECTSN_QUERY");
        ArrayList<Map<String, String>> allSelectMaps = new ArrayList<Map<String, String>>();
        pluginProxy.callReplace(p -> {
            List selectMap = p.getExpandSelectMaps(view);
            allSelectMaps.addAll(selectMap);
            return selectMap;
        });
        return allSelectMaps;
    }

    private String getExpandWhere(IFormView view) {
        PluginProxy pluginProxy = PluginProxy.create(ISbsSelectSNExpand.class, (String)"SCMC_SBS_SELECTSN_QUERY");
        StringBuilder filterBuilder = new StringBuilder();
        pluginProxy.callReplace(p -> {
            String filter = p.getExpandWhere(view);
            if (filter != null && !filter.trim().isEmpty()) {
                filterBuilder.append(" and (").append(filter).append(')');
            }
            return filter;
        });
        String mergeFilter = filterBuilder.toString().replaceAll("bd_snmainfile.", "t.").replaceAll("bd_snmovetrack.", "t2.");
        return mergeFilter;
    }
}

