/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formplugin.sn;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class SupplementSnEditPlugin
extends AbstractBillPlugIn {
    private static final int BATCH_VALUE = 1000;
    public static final String OP_BATCH_GENERATE = "batchgenerate";
    public static final String OP_SELECT_SN = "selectsn";
    public static final String OP_IMPORT_SN = "importsn";
    public static final String OP_CLEAR = "clear";
    public static final String OP_SAVE = "save";
    private static Log logger = LogFactory.getLog(SupplementSnEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getControl("advcontoolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Set<Long> snMainId = this.initAndLoadData();
        Object invaccid = customParams.get("invaccid");
        Object invorg = customParams.get("invorg");
        Object warehouse = customParams.get("warehouseid");
        Object location = customParams.get("locationid");
        Object material = customParams.get("material");
        Object unit = customParams.get("unitid");
        Object value = customParams.get("qty");
        Object lotnum = customParams.get("lotnum");
        Object auxpty = customParams.get("auxpty");
        long qty = this.typeConverSion(value);
        long supplementqty = qty - (long)snMainId.size();
        this.getModel().setValue("invaccid", invaccid);
        this.getModel().setValue("invorg", invorg);
        this.getModel().setValue("warehouse", warehouse);
        this.getModel().setValue("location", location);
        this.getModel().setValue("material", material);
        this.getModel().setValue("unit", unit);
        this.getModel().setValue("baseqty", (Object)qty);
        this.getModel().setValue("snqty", (Object)snMainId.size());
        this.getModel().setValue("supplementqty", (Object)supplementqty);
        this.getModel().setValue("createorg", invorg);
        this.getModel().setValue("lotnumber", lotnum);
        this.getModel().setValue("auxpty", auxpty);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object qtyBefore = customParams.get("qty");
        long qty = this.typeConverSion(qtyBefore);
        Set<Long> snMainId = this.initAndLoadData();
        long supplementQty = qty - (long)snMainId.size();
        this.getModel().setValue("snqty", (Object)snMainId.size());
        this.getModel().setValue("supplementqty", (Object)supplementQty);
        this.getModel().setValue("baseqty", (Object)qty);
        this.getModel().setDataChanged(false);
    }

    private Long typeConverSion(Object value) {
        long qty = 0L;
        if (value instanceof Long) {
            qty = (Long)value;
        } else if (value != null) {
            qty = Long.parseLong(value.toString());
        }
        return qty;
    }

    private Set<Long> initAndLoadData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object id = customParams.get("invaccid");
        StringBuilder sql = new StringBuilder();
        sql.append("select t.fid from t_bd_snmovetrack trk join t_bd_snmovetrack_rel r").append(" on trk.fid = r.ftrackid").append(" join t_bd_snmainfile t on r.fsnmainfileid = t.fid and r.fid = t.ffinalaudittrailid").append(" where trk.fnowinvaccid = ").append(id);
        DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"sys"), (String)sql.toString());
        HashSet<Long> snMainId = new HashSet<Long>(1024);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long fid = row.getLong("fid");
            snMainId.add(fid);
        }
        return snMainId;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("deleterow".equals(key)) {
            EntryGrid lineTypeEntryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectedRows = lineTypeEntryGrid.getEntryState().getSelectedRows();
            if (selectedRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"SupplementSnEditPlugin_0", (String)"scmc-sbs-form", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection row = this.getModel().getEntryEntity("entryentity");
            StringBuilder errorInfo = new StringBuilder();
            LinkedList<Integer> delRowIdxList = new LinkedList<Integer>();
            for (int selectedRowIdx : selectedRows) {
                boolean isHandle = ((DynamicObject)row.get(selectedRowIdx)).getBoolean("ishandle");
                String sn = ((DynamicObject)row.get(selectedRowIdx)).getString("sn");
                if (isHandle) {
                    errorInfo.append(sn);
                    errorInfo.append(':');
                    errorInfo.append(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u5220\u9664\u7684\u6570\u636e\u4e3a\u5df2\u5173\u8054\u4e3b\u6863\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"SupplementSnEditPlugin_1", (String)"scmc-sbs-form", (Object[])new Object[0]));
                    continue;
                }
                delRowIdxList.add(selectedRowIdx);
            }
            if (errorInfo.length() > 0) {
                this.getView().showTipNotification(errorInfo.toString());
            }
            if (delRowIdxList.size() > 0) {
                this.getModel().deleteEntryRows("entryentity", delRowIdxList.stream().mapToInt(item -> item).toArray());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "save": {
                this.getView().updateView();
                break;
            }
            case "batchgenerate": {
                this.getModel().setDataChanged(true);
                Map batchGenMap = this.getView().getFormShowParameter().getCustomParams();
                long baseQty = ((BigDecimal)this.getModel().getValue("baseqty")).longValue();
                DynamicObject material = (DynamicObject)this.getModel().getValue("material");
                Object materialPkValue = material.getPkValue();
                long supplementqty = ((BigDecimal)this.getModel().getValue("snqty")).longValue();
                long maxGenerateQty = baseQty - supplementqty;
                if (maxGenerateQty <= 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5f55\u5165\u5e8f\u5217\u53f7\u6570\u91cf\u5df2\u7b49\u4e8e\u6216\u8d85\u8fc7\u5206\u5f55\u57fa\u672c\u6570\u91cf\uff0c\u65e0\u6cd5\u6279\u91cf\u751f\u6210\u5e8f\u5217\u53f7\u3002", (String)"SupplementSnEditPlugin_2", (String)"scmc-sbs-form", (Object[])new Object[0]));
                } else {
                    HashMap<String, Object> maps = new HashMap<String, Object>(batchGenMap);
                    maps.put("qty", maxGenerateQty);
                    maps.put("material", materialPkValue);
                    this.showModalPage("sbs_batchcreatesn", maps);
                }
                this.getModel().setDataChanged(true);
                break;
            }
            case "selectsn": {
                Map selectSnMap = this.getView().getFormShowParameter().getCustomParams();
                this.showModalPage("sbs_selectedsn", selectSnMap);
                break;
            }
            case "importsn": {
                Map importSnMap = this.getView().getFormShowParameter().getCustomParams();
                this.showModalPage("sbs_importsn", importSnMap);
                break;
            }
            case "clear": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u6e05\u9664\u5df2\u586b\uff1f", (String)"SupplementSnEditPlugin_3", (String)"scmc-sbs-form", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(OP_CLEAR, (IFormPlugin)this));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callbackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        ArrayList<Integer> row = new ArrayList<Integer>(entryentity.size());
        switch (callbackId) {
            case "clear": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    for (int i = 0; i < entryentity.size(); ++i) {
                        Boolean isHandle = (Boolean)((DynamicObject)entryentity.get(i)).get("ishandle");
                        if (isHandle.booleanValue()) continue;
                        row.add(i);
                    }
                }
                this.getModel().deleteEntryRows("entryentity", row.stream().mapToInt(item -> item).toArray());
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entryName = e.getEntryProp().getName();
        if ("entryentity".equals(entryName)) {
            RowDataEntity[] rows;
            for (RowDataEntity row : rows = e.getRowDataEntities()) {
                int rowIndex = row.getRowIndex();
                Object invorg = customParams.get("invorg");
                this.getModel().setValue("createorg", invorg, rowIndex);
            }
        }
    }

    private void showModalPage(String page, Map<String, Object> param) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(page);
        if (param != null) {
            showParameter.getCustomParams().putAll(param);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, page));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public List<Integer> getBlankEntryIndex() {
        LinkedList<Integer> blankEntryIndexs = new LinkedList<Integer>();
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : entries) {
            String number = entry.getString("sn");
            if (number != null && !number.trim().equals("")) continue;
            blankEntryIndexs.add(entry.getInt("seq") - 1);
        }
        return blankEntryIndexs;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "sbs_batchcreatesn": {
                this.closedBatchCreateSNCallback(e);
                this.getModel().setDataChanged(true);
                break;
            }
            case "sbs_selectedsn": {
                this.closedSelectedSN(e);
                break;
            }
            case "sbs_importsn": {
                this.closedImportedSN(e);
                break;
            }
        }
    }

    private void closedImportedSN(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        IDataModel model = this.getModel();
        if (returnData instanceof DataSet) {
            DataSet snData = (DataSet)returnData;
            model.getDataEntity(true);
            model.beginInit();
            LinkedHashMap map = new LinkedHashMap(1024);
            Integer key = 1;
            while (snData.hasNext()) {
                Row next = snData.next();
                HashMap<String, Object> rowMap = new HashMap<String, Object>(4);
                String sn = next.getString("sn");
                Long invorg = next.getLong("invorg");
                String note = next.getString("note");
                rowMap.put("sn", sn);
                rowMap.put("invorg", invorg);
                rowMap.put("note", note);
                map.put(key, rowMap);
                Integer n = key;
                Integer n2 = key = Integer.valueOf(key + 1);
            }
            LinkedHashMap<Integer, Map<String, Object>> handSnData = new LinkedHashMap<Integer, Map<String, Object>>(1024);
            for (Map.Entry entry : map.entrySet()) {
                handSnData.put((Integer)entry.getKey(), (Map<String, Object>)entry.getValue());
                if (handSnData.size() != 1000) continue;
                this.batchImportCreateLine(handSnData);
            }
            if (handSnData.size() > 0) {
                this.batchImportCreateLine(handSnData);
            }
            model.endInit();
            this.getView().updateView();
        }
    }

    private void batchImportCreateLine(Map<Integer, Map<String, Object>> handleSnData) {
        IDataModel model = this.getModel();
        List<Integer> canFillLineIndexs = this.getCanFillLineIndexs(handleSnData.size());
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        int i = 0;
        for (Map.Entry<Integer, Map<String, Object>> entry : handleSnData.entrySet()) {
            int line = canFillLineIndexs.get(i);
            Map<String, Object> attrs = entry.getValue();
            Object org = attrs.get("invorg") == null ? customParams.get("invorg") : attrs.get("invorg");
            model.setValue("sn", attrs.get("sn"), line);
            model.setValue("createorg", org, line);
            model.setValue("note", attrs.get("note"), line);
            ++i;
        }
        handleSnData.clear();
    }

    private void closedSelectedSN(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        IDataModel model = this.getModel();
        if (returnData instanceof Map) {
            Map snData = (Map)returnData;
            if (snData.size() == 0) {
                return;
            }
            model.getDataEntity(true);
            model.beginInit();
            LinkedHashMap<String, Map<String, Object>> handSnData = new LinkedHashMap<String, Map<String, Object>>(1000);
            for (Map.Entry entry : snData.entrySet()) {
                handSnData.put((String)entry.getKey(), (Map<String, Object>)entry.getValue());
                if (handSnData.size() != 1000) continue;
                this.batchCreateLine(handSnData);
            }
            if (handSnData.size() > 0) {
                this.batchCreateLine(handSnData);
            }
            model.endInit();
            this.getView().updateView();
        }
    }

    private void batchCreateLine(Map<String, Map<String, Object>> handleSnData) {
        IDataModel model = this.getModel();
        List<Integer> canFillLineIndexs = this.getCanFillLineIndexs(handleSnData.size());
        int i = 0;
        for (Map.Entry<String, Map<String, Object>> entry : handleSnData.entrySet()) {
            int line = canFillLineIndexs.get(i);
            model.setValue("sn", (Object)entry.getKey(), line);
            Map<String, Object> attrs = entry.getValue();
            model.setValue("createorg", attrs.get("invorg"), line);
            ++i;
        }
        handleSnData.clear();
    }

    private void closedBatchCreateSNCallback(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object object = e.getReturnData();
        if (object != null && "sbs_batchcreatesn".equals(actionId) && object instanceof Map) {
            IFormView mainView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            Map returnParam = (Map)object;
            int seq = mainView.getModel().getEntryCurrentRowIndex("entryentity");
            returnParam.put("seq", seq);
            returnParam.put("material", this.getModel().getValue("material"));
            DynamicObject mainEntity = mainView.getModel().getDataEntity(true);
            long time1 = System.currentTimeMillis();
            List snNums = (List)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"LotCodeRuleService", (String)"getSnCodeNum", (Object[])new Object[]{mainEntity, returnParam});
            long time2 = System.currentTimeMillis();
            int snNumsSize = snNums.size();
            logger.info(snNumsSize + "\u4e2a\u5e8f\u5217\u53f7\u751f\u6210\u7684\u65f6\u95f4\uff1a" + (time2 - time1) + "ms");
            this.getModel().getDataEntity(true);
            this.getModel().beginInit();
            Object invorg = returnParam.get("invorg");
            List<Integer> canFillLineIndexs = this.getCanFillLineIndexs(snNumsSize);
            int i = 0;
            for (String snNum : snNums) {
                this.getModel().setValue("sn", (Object)snNum, canFillLineIndexs.get(i).intValue());
                this.getModel().setValue("createorg", invorg, canFillLineIndexs.get(i).intValue());
                ++i;
            }
            this.getModel().endInit();
            this.getView().updateView();
        }
    }

    private List<Integer> getCanFillLineIndexs(int size) {
        List<Integer> blankList = this.getBlankEntryIndex();
        int createLine = size - blankList.size();
        if (createLine > 0) {
            int[] rows;
            for (int row : rows = this.getView().getModel().batchCreateNewEntryRow("entryentity", createLine)) {
                blankList.add(row);
            }
        }
        return blankList;
    }
}

