/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.mservice;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.scmc.paramentity.bizrule.reserve.pojo.ReserveOrBillInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.ReserveRecordHandler;
import kd.scmc.sbs.business.reservation.ReserceCreateHelper;
import kd.scmc.sbs.business.reservation.ReserveHandler;
import kd.scmc.sbs.business.reservation.ReserveHelper;
import kd.scmc.sbs.business.reservation.ReserveSchemeHander;
import kd.scmc.sbs.business.reservation.model.ReserveArgs;
import kd.scmc.sbs.business.reservation.model.ReserveLinkSelectRow;
import kd.scmc.sbs.business.reservation.model.ReserveOperateResult;
import kd.scmc.sbs.business.reservation.model.ReserveSchemeInfo;
import kd.scmc.sbs.mservice.api.ReserveService;
import org.apache.commons.lang3.StringUtils;

public class ReserveServiceImpl
implements ReserveService {
    private static final Log logger = LogFactory.getLog(ReserveServiceImpl.class);

    @Override
    public Map<String, Object> getReserceCreateInfos(List<ReserveOrBillInfo> orBillInfos, ReserveSchemeInfo schemeInfo) {
        return ReserceCreateHelper.getReserceCreateInfos(orBillInfos, schemeInfo);
    }

    @Override
    public ReserveOperateResult onReserveViewCreating(List<ReserveLinkSelectRow> releaseLinkArg) {
        ReserveOperateResult result = null;
        if (releaseLinkArg == null || releaseLinkArg.size() == 0) {
            result = new ReserveOperateResult();
            result.setSuceese(false);
            return result;
        }
        ReserveHandler engine = new ReserveHandler();
        ReserveArgs<ReserveLinkSelectRow> selectRowReserveArgs = new ReserveArgs<ReserveLinkSelectRow>();
        selectRowReserveArgs.setSelectRows(releaseLinkArg);
        result = engine.onReserveViewCreating(selectRowReserveArgs);
        return result;
    }

    private Map<Object, Object> getBillSchemeMap(String billName, Map<Object, DynamicObject> billInfoMap) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)billName);
        String mainOrg = type.getMainOrg();
        HashMap orgSchemes = new HashMap();
        Long schemeId = null;
        Long orgId = null;
        HashMap<Object, Object> schemes = new HashMap<Object, Object>(billInfoMap.size());
        for (Map.Entry<Object, DynamicObject> entry : billInfoMap.entrySet()) {
            orgId = entry.getValue().getDynamicObject(mainOrg).getLong("id");
            schemeId = (Long)orgSchemes.get(orgId);
            if (schemeId == null && (schemeId = ReserveHelper.getAutoScheme(orgId, billName)) == null) continue;
            schemes.put(entry.getKey(), schemeId);
        }
        return schemes;
    }

    private Map<Object, ReserveSchemeInfo> getSchemeInfos(Object[] pks) {
        Map schemeInfos = BusinessDataServiceHelper.loadFromCache((Object[])pks, (String)"sbs_reserve_st");
        HashMap<Object, ReserveSchemeInfo> reserveSchemeInfo = new HashMap<Object, ReserveSchemeInfo>(schemeInfos.size());
        for (Map.Entry schemeInfo : schemeInfos.entrySet()) {
            reserveSchemeInfo.put(schemeInfo.getKey(), new ReserveSchemeInfo((DynamicObject)schemeInfo.getValue()));
        }
        return reserveSchemeInfo;
    }

    @Override
    public OperationResult autoReserveByIds(String billName, List<Object> ids) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)billName);
        String mainOrg = type.getMainOrg();
        Set<Object> noReservedIds = ReserveHelper.filterNoReserveRecordByBillIds(ids);
        if (noReservedIds.isEmpty()) {
            return new OperationResult();
        }
        QFilter fs = new QFilter("id", "in", noReservedIds);
        Map billInfoMap = BusinessDataServiceHelper.loadFromCache((String)billName, (String)mainOrg, (QFilter[])fs.toArray());
        return this.autoReserve(this.getBillSchemeMap(billName, billInfoMap), null);
    }

    @Override
    public OperationResult autoReserveByDynamicObject(String billName, DynamicObject requestBill) {
        Set<Object> noReservedIds = ReserveHelper.filterNoReserveRecordByBillIds(Collections.singletonList(requestBill.getLong("id")));
        if (noReservedIds.isEmpty()) {
            return new OperationResult();
        }
        HashMap<Object, DynamicObject> billInfoMap = new HashMap<Object, DynamicObject>(8);
        billInfoMap.put(requestBill.getLong("id"), requestBill);
        return this.autoReserve(this.getBillSchemeMap(billName, billInfoMap), requestBill);
    }

    private OperationResult autoReserve(Map<Object, Object> groupBills, DynamicObject requestBill) {
        OperationResult result = new OperationResult();
        Map<Object, ReserveSchemeInfo> schemeInfos = this.getSchemeInfos(groupBills.values().toArray());
        if (schemeInfos.size() > 0 && ReserveAggregateHelper.isAggregate()) {
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u603b\u91cf\u9884\u7559\uff0c\u8bf7\u4f7f\u7528\u65b0\u9884\u7559\u529f\u80fd\u3002", (String)"ReserveServiceImpl_2", (String)"scmc-sbs-form", (Object[])new Object[0]));
            return result;
        }
        OperationResult tempResult = null;
        ReserveSchemeInfo scheme = null;
        for (Map.Entry<Object, Object> bill : groupBills.entrySet()) {
            scheme = schemeInfos.get(bill.getValue());
            if (scheme == null) continue;
            Map<Object, List<Object>> matchResult = requestBill == null ? new ReserveSchemeHander(scheme, bill.getKey()).matchInvStock() : new ReserveSchemeHander(scheme, bill.getKey()).matchInvStockForNoSave(requestBill);
            tempResult = this.doOnAutoReserve(matchResult, scheme, requestBill);
            if (!tempResult.isSuccess()) {
                return tempResult;
            }
            result.setSuccess(tempResult.isSuccess());
            result.setMessage(this.mergeMsg(result.getMessage(), tempResult.getMessage()));
        }
        return result;
    }

    private String mergeMsg(String msg1, String msg2) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg1})) {
            sb.append(msg1).append(',');
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg2})) {
            sb.append(msg2).append(',');
        }
        return sb.toString();
    }

    private static String getMsgReserveServiceFailOp() {
        return ResManager.loadKDString((String)"\u9884\u7559\u91ca\u653e\u64cd\u4f5c\u5931\u8d25\u3002", (String)"ReserveServiceImpl_0", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    @Override
    public OperationResult doReleaseReserve4Close(String billName, String opName, String ids) {
        logger.info("\u8fdb\u5165\u9884\u7559\u65b9\u6cd5doReleaseReserve4Close");
        OperationResult result = new OperationResult();
        if (StringUtils.isBlank((CharSequence)ids)) {
            return result;
        }
        try {
            Long[] idArr = (Long[])JSON.parseObject((String)ids, Long[].class);
            QFilter qFilter = new QFilter("bill_obj", "=", (Object)billName).and(new QFilter("bill_id", "in", (Object)idArr));
            ThreadCache.put((Object)"ReserveOpType", (Object)"terminalrelease");
            this.releaseRecordByFilter(opName, qFilter);
            logger.info("doReleaseReserve4Close\u9884\u7559\u65b9\u6cd5\u6210\u529f");
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setMessage(ReserveServiceImpl.getMsgReserveServiceFailOp() + e.getMessage());
        }
        return result;
    }

    private void releaseRecordByFilter(String opName, QFilter qFilter) {
        DataSet reserveRecord = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ":doReleaseReserve4Close"), (String)"msmod_reserve_record", (String)"id,bill_id,bill_obj,billentry_id,base_qty,qty,qty2nd,billentry_seq,bal_obj,bal_id,aggregateid,bill_no", (QFilter[])qFilter.toArray(), null);
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"msmod_release_record");
        ArrayList<DynamicObject> releaseList = new ArrayList<DynamicObject>(16);
        while (reserveRecord.hasNext()) {
            Row next = reserveRecord.next();
            DynamicObject obj = (DynamicObject)dt.createInstance();
            obj.set("reserve_record", next.get("id"));
            obj.set("bill_obj", next.get("bill_obj"));
            obj.set("entryid", next.get("billentry_id"));
            obj.set("billid", next.get("bill_id"));
            obj.set("base_qty", next.get("base_qty"));
            obj.set("qty", next.get("qty"));
            obj.set("qty2nd", next.get("qty2nd"));
            obj.set("op", (Object)opName);
            obj.set("release_type", (Object)"remove");
            obj.set("billno", (Object)next.getString("bill_no"));
            obj.set("balid", next.get("bal_id"));
            obj.set("balobj", next.get("bal_obj"));
            obj.set("aggregateid", (Object)next.getLong("aggregateid"));
            releaseList.add(obj);
        }
        ThreadCache.put((Object)"ReserveOpName", (Object)opName);
        ReserveRecordHandler.reserveReleaseQty(releaseList);
    }

    @Override
    public OperationResult doReleaseReserveByEntryIds(String billName, String opName, String entryIds) {
        OperationResult result = new OperationResult();
        if (StringUtils.isBlank((CharSequence)entryIds)) {
            return result;
        }
        try (TXHandle tx = TX.requiresNew((String)"doReleaseReserveByEntryIds");){
            try {
                Long[] idArr = (Long[])JSON.parseObject((String)entryIds, Long[].class);
                QFilter qFilter = new QFilter("bill_obj", "=", (Object)billName).and(new QFilter("billentry_id", "in", (Object)idArr));
                ThreadCache.put((Object)"ReserveOpName", (Object)"rowclose");
                ThreadCache.put((Object)"ReserveOpType", (Object)"terminalrelease");
                this.releaseRecordByFilter(opName, qFilter);
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(false);
                result.setMessage(ReserveServiceImpl.getMsgReserveServiceFailOp() + e.getMessage());
            }
        }
        return result;
    }

    private static String getMsgReserveServiceReverseFailOp() {
        return ResManager.loadKDString((String)"\u9884\u7559\u91ca\u653e\u53cd\u5411\u64cd\u4f5c\u5931\u8d25\u3002", (String)"ReserveServiceImpl_1", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    @Override
    public OperationResult unDoReleaseReserveByEntryIds(String billName, String opName, String ids) {
        OperationResult result = new OperationResult();
        if (StringUtils.isBlank((CharSequence)ids)) {
            return result;
        }
        try (TXHandle tx = TX.requiresNew((String)"doReleaseReserveByEntryIds");){
            try {
                Long[] idArr = (Long[])JSON.parseObject((String)ids, Long[].class);
                QFilter filter = new QFilter("op", "=", (Object)opName);
                filter.and(new QFilter("entryid", "in", (Object)idArr));
                filter.and(new QFilter("bill_obj", "=", (Object)billName));
                DynamicObject[] releaseRecords = BusinessDataServiceHelper.load((String)"msmod_release_record", (String)"reserve_record,base_qty,qty,qty2nd,release_type,creater,create_date,bill_obj,billid,billno,entryid,balobj,balid,aggregateid", (QFilter[])filter.toArray());
                ThreadCache.put((Object)"ReserveOpName", (Object)"rowunclose");
                ThreadCache.put((Object)"ReserveOpType", (Object)"unterminalrelease");
                ReserveRecordHandler.unDoReserveReleaseQty(Arrays.asList(releaseRecords));
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(false);
                result.setMessage(ReserveServiceImpl.getMsgReserveServiceReverseFailOp() + e.getMessage());
            }
        }
        return result;
    }

    @Override
    public OperationResult unDoReleaseReserve4Close(String billName, String opName, String ids) {
        logger.info("\u8fdb\u5165\u91ca\u653e\u9884\u7559\u65b9\u6cd5unDoReleaseReserve4Close");
        OperationResult result = new OperationResult();
        if (StringUtils.isBlank((CharSequence)ids)) {
            return result;
        }
        Long[] idArr = (Long[])JSON.parseObject((String)ids, Long[].class);
        QFilter filter = new QFilter("op", "=", (Object)opName);
        filter.and(new QFilter("billid", "in", (Object)idArr));
        filter.and(new QFilter("bill_obj", "=", (Object)billName));
        DynamicObject[] releaseRecords = BusinessDataServiceHelper.load((String)"msmod_release_record", (String)"reserve_record,base_qty,qty,qty2nd,release_type,creater,create_date,bill_obj,billid,billno,entryid,balobj,balid,aggregateid", (QFilter[])filter.toArray());
        logger.info("\u67e5\u8be2\u9884\u7559\u6570\u636e");
        ThreadCache.put((Object)"ReserveOpName", (Object)opName);
        ThreadCache.put((Object)"ReserveOpType", (Object)"unterminalrelease");
        ReserveRecordHandler.unDoReserveReleaseQty(Arrays.asList(releaseRecords));
        logger.info("\u53cd\u91ca\u653e\u6210\u529f");
        return result;
    }

    @Override
    public OperationResult releaseReserveLinkByClose(List<ReserveOrBillInfo> releaseLinkArg, Map<String, Object> paramSetting) {
        OperationResult result = new OperationResult();
        if (releaseLinkArg == null || releaseLinkArg.size() == 0) {
            result.setSuccess(false);
            return result;
        }
        ReserveHandler engine = new ReserveHandler();
        ReserveArgs<ReserveOrBillInfo> realseBillInfos = new ReserveArgs<ReserveOrBillInfo>();
        realseBillInfos.setSelectRows(releaseLinkArg);
        ReserveOperateResult reserveOperateResult = engine.onReleaseByClose(realseBillInfos, paramSetting);
        result.setSuccess(reserveOperateResult.isSuceese());
        result.setMessage(reserveOperateResult.getMessage());
        return result;
    }

    @Override
    public void unAutoReserve(String billName, List<Object> ids) {
        HashSet<Object> idSet = new HashSet<Object>(ids.size());
        idSet.addAll(ids);
        try (TXHandle tx = TX.requiresNew((String)"ReserveServiceImpl-sbs-unAutoReserve");){
            try {
                ReserveRecordHandler.batchReserveRemoveByBillId(idSet);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                tx.markRollback();
            }
        }
    }

    private OperationResult doOnAutoReserve(Map<Object, List<Object>> lstMatchInvacc, ReserveSchemeInfo schemeInfo, DynamicObject requestBill) {
        Map<String, String> colsMap = schemeInfo.getColsMap();
        ArrayList<ReserveOrBillInfo> realseBillInfos = new ArrayList<ReserveOrBillInfo>(lstMatchInvacc.size());
        for (Map.Entry<Object, List<Object>> entry : lstMatchInvacc.entrySet()) {
            String entryId = String.valueOf(entry.getKey());
            ReserveOrBillInfo reserveOrBillInfo = new ReserveOrBillInfo();
            reserveOrBillInfo.setEntryID(entryId);
            reserveOrBillInfo.setFormId(schemeInfo.getRequireBillName());
            reserveOrBillInfo.setEntryKey(colsMap.get("billentry"));
            realseBillInfos.add(reserveOrBillInfo);
        }
        ReserveHandler engine = new ReserveHandler();
        ReserveArgs<ReserveOrBillInfo> reserveArgs = new ReserveArgs<ReserveOrBillInfo>();
        reserveArgs.setSelectRows(realseBillInfos);
        reserveArgs.setRequestBill(requestBill);
        OperationResult result = new OperationResult();
        ReserveOperateResult reserveOperateResult = engine.doOnAutoReserveCreating(lstMatchInvacc, reserveArgs, schemeInfo);
        result.setSuccess(reserveOperateResult.isSuceese());
        result.setMessage(reserveOperateResult.getMessage());
        return result;
    }
}

