/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.mservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.KdtxRequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.constant.GlobalSessionType;
import kd.bos.kdtx.sdk.context.DtxContext;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.scmc.sbs.business.sn.SNBillConfigHelper;
import kd.scmc.sbs.business.sn.ValidateInfoLogger;
import kd.scmc.sbs.business.sn.biz.SerialNumberDeleteValidator;
import kd.scmc.sbs.business.sn.biz.SerialNumberDeletor;
import kd.scmc.sbs.business.sn.biz.SerialNumberOperator;
import kd.scmc.sbs.business.sn.biz.SerialNumberSupOperator;
import kd.scmc.sbs.business.sn.biz.SerialNumberValidator;
import kd.scmc.sbs.business.sn.relation.BillSNRelationHelper;
import kd.scmc.sbs.mservice.api.SerialNumberService;

public class SerialNumberServiceImpl
implements SerialNumberService {
    private static final String SCMC_SN_SERVICE = "scmc_sn_service";
    private static final String HANDLE_SAVE_SERIAL_NUMBER = "handleSerialNumber";
    private static final String RESULT = "result";

    @Override
    public Map<Long, List<String>> validateSNByBillOperate(String billtype, String operate, List<Long> billIds) {
        this.checkParams(billtype, billIds, operate);
        ValidateInfoLogger validateInfo = new ValidateInfoLogger();
        switch (operate) {
            case "delete": {
                SerialNumberDeleteValidator.validateBillDel(billIds, billtype, validateInfo);
                break;
            }
            default: {
                Collection<DynamicObject> cfgs = SNBillConfigHelper.getSNBillConfig(billtype);
                boolean cfgRepeat = false;
                Map<String, Set<String>> billCfgsMap = SNBillConfigHelper.getBillCfgsMatchMap(billtype, cfgs, billIds);
                for (Map.Entry<String, Set<String>> billCfgsEntry : billCfgsMap.entrySet()) {
                    Set<String> cfgSet = billCfgsEntry.getValue();
                    if (cfgSet.size() <= 1) continue;
                    cfgRepeat = true;
                    String ident = billCfgsEntry.getKey();
                    String[] identArray = ident.split("\\.");
                    String entrykey = identArray[0];
                    Long billid = Long.valueOf(identArray[1]);
                    validateInfo.putBillEntryInfo(billid, entrykey, 0, String.format(ResManager.loadKDString((String)"\u540c\u65f6\u5339\u914d\u4e86\u591a\u4e2a\u5e8f\u5217\u53f7\u670d\u52a1\u914d\u7f6e\uff1a%s\u3002", (String)"SerialNumberServiceImpl_0", (String)"scmc-sbs-form", (Object[])new Object[0]), cfgSet.toString()));
                }
                if (cfgRepeat) {
                    return validateInfo.getValidateInfo();
                }
                HashMap<String, Set<Long>> hasHandleBillMap = new HashMap<String, Set<Long>>(2);
                for (DynamicObject cfg : cfgs) {
                    SerialNumberValidator.build(cfg, billIds, operate, hasHandleBillMap, validateInfo).validateExec();
                }
            }
        }
        return validateInfo.getValidateInfo();
    }

    @Override
    public Map<Long, List<String>> validateSNBySingleBillOperate(String billtype, String operate, DynamicObject billObj) {
        Long billid = (Long)billObj.getPkValue();
        ValidateInfoLogger validateInfo = new ValidateInfoLogger();
        switch (operate) {
            case "delete": {
                SerialNumberDeleteValidator.validateBillDel(Collections.singletonList((Long)billObj.getPkValue()), billtype, validateInfo);
                break;
            }
            default: {
                Collection<DynamicObject> cfgs = SNBillConfigHelper.getSNBillConfig(billtype);
                boolean cfgRepeat = false;
                HashMap<String, Set> billCfgsMap = new HashMap<String, Set>(2);
                HashSet<DynamicObject> matchCfgs = new HashSet<DynamicObject>(cfgs.size());
                for (DynamicObject dynamicObject : cfgs) {
                    if (!SNBillConfigHelper.isDynamicObjectMatchCfg(billtype, billObj, dynamicObject)) continue;
                    String entrykey = dynamicObject.getString("srcbillentry");
                    Set cfgSet = billCfgsMap.getOrDefault(entrykey, new HashSet(3));
                    cfgSet.add(dynamicObject.getString("number"));
                    if (!billCfgsMap.containsKey(entrykey)) {
                        billCfgsMap.put(entrykey, cfgSet);
                    }
                    matchCfgs.add(dynamicObject);
                }
                for (Map.Entry entry : billCfgsMap.entrySet()) {
                    Set cfgSet = (Set)entry.getValue();
                    if (cfgSet.size() <= 1) continue;
                    cfgRepeat = true;
                    String entrykey = (String)entry.getKey();
                    validateInfo.putBillEntryInfo(billid, entrykey, 0, String.format(ResManager.loadKDString((String)"\u540c\u65f6\u5339\u914d\u4e86\u591a\u4e2a\u5e8f\u5217\u53f7\u670d\u52a1\u914d\u7f6e\uff1a%s\u3002", (String)"SerialNumberServiceImpl_0", (String)"scmc-sbs-form", (Object[])new Object[0]), cfgSet.toString()));
                }
                if (cfgRepeat) {
                    return validateInfo.getValidateInfo();
                }
                HashMap<String, Set<Long>> hasHandleBillMap = new HashMap<String, Set<Long>>(2);
                for (DynamicObject cfg : matchCfgs) {
                    SerialNumberValidator.buildBySingleDynamicObject(cfg, billObj, operate, hasHandleBillMap, validateInfo).validateExec();
                }
            }
        }
        return validateInfo.getValidateInfo();
    }

    @Override
    public Map<Long, List<String>> validateSNByBillDelEntry(String billtype, String operate, List<Long> billIds, List<Object> keepEntryIds) {
        this.checkParams(billtype, billIds, operate);
        ValidateInfoLogger validateInfo = new ValidateInfoLogger();
        SerialNumberDeleteValidator.validateEntryDel(billIds, billtype, operate, keepEntryIds, validateInfo);
        return validateInfo.getValidateInfo();
    }

    @Override
    public Map<String, Object> handleSNByBillOperate(String billtype, String operate, List<Long> billIds) {
        this.checkParams(billtype, billIds, operate);
        switch (operate) {
            case "delete": {
                if (TX.inTX()) {
                    CommonParam param = new CommonParam();
                    param.put((Object)"billtype", (Object)billtype);
                    param.put((Object)"newbillIds", new HashSet<Long>(billIds));
                    param.put((Object)"flag", (Object)"1");
                    BillSNRelationHelper.doRegisterDelTX(param);
                    break;
                }
                SerialNumberDeletor.execDeleteByBills(billtype, new HashSet<Long>(billIds));
                break;
            }
            default: {
                List<DynamicObject> cfgs = this.getSortCfgs(SNBillConfigHelper.getSNBillConfig(billtype), operate);
                ArrayList<SerialNumberOperator> operators = new ArrayList<SerialNumberOperator>(cfgs.size());
                HashMap<String, Set<Long>> hasHandleBillMap = new HashMap<String, Set<Long>>(2);
                for (DynamicObject dynamicObject : cfgs) {
                    operators.add(SerialNumberOperator.build(dynamicObject, billIds, operate, hasHandleBillMap));
                }
                Throwable throwable = null;
                try (TXHandle txHandle = TX.requiresNew();){
                    try {
                        for (SerialNumberOperator operator : operators) {
                            operator.operateExec();
                        }
                    }
                    catch (Exception e) {
                        txHandle.markRollback();
                        throw e;
                    }
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                for (SerialNumberOperator serialNumberOperator : operators) {
                    serialNumberOperator.updateBillSnRelStatus();
                }
            }
        }
        return this.buildSuccessResultMap();
    }

    private List<DynamicObject> getSortCfgs(Collection<DynamicObject> cfgs, String operate) {
        ArrayList<DynamicObject> sortCfgs = new ArrayList<DynamicObject>(cfgs.size());
        ArrayList<DynamicObject> addCfgs = new ArrayList<DynamicObject>(cfgs.size());
        ArrayList<DynamicObject> subCfgs = new ArrayList<DynamicObject>(cfgs.size());
        for (DynamicObject cfg : cfgs) {
            if ("1".equals(cfg.getString("invflu"))) {
                addCfgs.add(cfg);
                continue;
            }
            subCfgs.add(cfg);
        }
        if ("unaudit".equals(operate)) {
            sortCfgs.addAll(addCfgs);
            sortCfgs.addAll(subCfgs);
        } else {
            sortCfgs.addAll(subCfgs);
            sortCfgs.addAll(addCfgs);
        }
        return sortCfgs;
    }

    @Override
    public Map<String, Object> handleSNOperateByKDTX(String billtype, String operate, List<Long> billIds) {
        this.checkParams(billtype, billIds, operate);
        switch (operate) {
            case "delete": {
                SerialNumberDeletor.execDeleteByBills(billtype, new HashSet<Long>(billIds));
                break;
            }
            default: {
                List<DynamicObject> cfgs = this.getSortCfgs(SNBillConfigHelper.getSNBillConfig(billtype), operate);
                HashMap<String, Set<Long>> hasHandleBillMap = new HashMap<String, Set<Long>>(2);
                ArrayList<SerialNumberOperator> operators = new ArrayList<SerialNumberOperator>(cfgs.size());
                for (DynamicObject cfg : cfgs) {
                    operators.add(SerialNumberOperator.build(cfg, billIds, operate, hasHandleBillMap));
                }
                for (SerialNumberOperator operator : operators) {
                    operator.operateExec();
                }
                ECSession session = (ECSession)DtxContext.getDtxSession();
                if (session == null || StringUtils.isEmpty((String)KdtxRequestContext.get().getXid()) || !SCMC_SN_SERVICE.equals(session.getScenesCode())) {
                    ECGlobalSession.begin((String)SCMC_SN_SERVICE, (DBRoute)DBRoute.of((String)"scm"), (GlobalSessionType)GlobalSessionType.COMBINATION);
                }
                ECGlobalSession.setBusinessType((String)HANDLE_SAVE_SERIAL_NUMBER);
                ArrayList<String> businessInfoList = new ArrayList<String>(billIds.size());
                for (Long billId : billIds) {
                    businessInfoList.add(billtype + "#" + ((Object)billId).toString());
                }
                ECGlobalSession.setBusinessInfo(businessInfoList);
                ECGlobalSession.setAsync((boolean)false);
                CommonParam param = new CommonParam();
                param.put((Object)"operators", operators);
                ECGlobalSession.register((String)"scmc", (String)"sbs", (String)"UpdateSnRelationService", (Param)param, (String)"updateSnRelation", businessInfoList);
            }
        }
        return this.buildSuccessResultMap();
    }

    @Override
    public Set<String> getSNServiceProperties(String billtype) {
        HashSet<String> props = new HashSet<String>(20);
        Collection<DynamicObject> cfgs = SNBillConfigHelper.getSNBillConfig(billtype);
        for (DynamicObject cfg : cfgs) {
            Object entry2;
            QFilter cfgFilter = SNBillConfigHelper.parseBillFilter(cfg.getString("billfilter"), billtype);
            if (cfgFilter != null) {
                props.add(this.getPostPurePropname(cfgFilter.getProperty()));
                List nests = cfgFilter.getNests(true);
                for (QFilter.QFilterNest net : nests) {
                    QFilter netFilter = net.getFilter();
                    props.add(this.getPostPurePropname(netFilter.getProperty()));
                }
            }
            props.add(this.getPrePurePropname(SNBillConfigHelper.getSnBaseqtyCol(cfg)));
            props.add(this.getPrePurePropname(SNBillConfigHelper.getMaterialCol(cfg)));
            DynamicObjectCollection snmainfentries = cfg.getDynamicObjectCollection("snmainfentry");
            for (Object entry2 : snmainfentries) {
                props.add(this.getPrePurePropname(entry2.getString("snmainfsrcbillcol")));
            }
            DynamicObjectCollection sntrackentries = cfg.getDynamicObjectCollection("sntrackentry");
            entry2 = sntrackentries.iterator();
            while (entry2.hasNext()) {
                DynamicObject entry3 = (DynamicObject)entry2.next();
                props.add(this.getPrePurePropname(entry3.getString("sntracksrcbillcol")));
            }
            DynamicObjectCollection sntrkvalentries = cfg.getDynamicObjectCollection("sntrkvalentry");
            for (DynamicObject entry4 : sntrkvalentries) {
                props.add(this.getPrePurePropname(entry4.getString("sntrkvalsrcbillcol")));
            }
        }
        if ("im_saloutbill".equals(billtype) || "im_purinbill".equals(billtype)) {
            props.add("isinitbill");
        }
        return props;
    }

    private String getPrePurePropname(String propname) {
        return propname.replaceFirst("[a-z\\.]+\\.", "");
    }

    private String getPostPurePropname(String propname) {
        return propname.replaceFirst("\\.[a-z\\.]+", "");
    }

    private Map<String, Object> buildSuccessResultMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(RESULT, Boolean.TRUE);
        return result;
    }

    private void checkParams(String billType, List<Long> billIds, String operate) {
        if (billType == null || billType.isEmpty() || billIds == null || billIds.isEmpty() || operate == null || operate.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SerialNumberServiceImpl_1", (String)"scmc-sbs-form", (Object[])new Object[0]));
        }
    }

    @Override
    public List<String> handleSNBySupple(Long invaccid) {
        return SerialNumberSupOperator.handleSupple(invaccid);
    }

    @Override
    public List<String> handleSNBySuppleDelete(Long snMainId, Long relId, Long invaccId) {
        if (invaccId == null || invaccId.equals(0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SerialNumberServiceImpl_1", (String)"scmc-sbs-form", (Object[])new Object[0]));
        }
        return SerialNumberSupOperator.handleSuppleDelete(snMainId, relId, invaccId);
    }
}

