/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.util.BalQuery;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class SnInvaccRelRestoreServiceImpl
implements IUpgradeService {
    private static String balanceTable = "im_inv_realbalance";
    private static List<String> balCols = Arrays.asList("id", "baseqty");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String formid;
        UpgradeResult result = new UpgradeResult();
        String notRelSql = "select m.fbllentityid,m.fbillid,m.fbillentryid from t_bd_snmovetrack m " + "where fnowinvaccid = 0 " + "and fbalancetype = '" + balanceTable + "' " + "and fsnmainfileid = 0 " + "and fincreaseinvcounter > 0 " + "and fbillstatus = 'C'";
        HashMap<String, Map> allNotRelDatas = new HashMap<String, Map>();
        try (DataSet notRelDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.basedata, (String)notRelSql);){
            for (Row row : notRelDataSet) {
                formid = row.getString("fbllentityid");
                Long billid = row.getLong("fbillid");
                Long entryid = row.getLong("fbillentryid");
                Map notRelBills = allNotRelDatas.getOrDefault(formid, new HashMap());
                Set notRelEntires = notRelBills.getOrDefault(billid, new HashSet());
                notRelEntires.add(entryid);
                if (!notRelBills.containsKey(billid)) {
                    notRelBills.put(billid, notRelEntires);
                }
                if (allNotRelDatas.containsKey(formid)) continue;
                allNotRelDatas.put(formid, notRelBills);
            }
        }
        if (!allNotRelDatas.isEmpty()) {
            String updateSql = "update t_bd_snmovetrack set fnowinvaccid = ? where fbllentityid = ? and fbillid = ? and fbillentryid = ?";
            ArrayList<Object[]> updateParams = new ArrayList<Object[]>(1000);
            for (Map.Entry allNotRelEntries : allNotRelDatas.entrySet()) {
                formid = (String)allNotRelEntries.getKey();
                Map notRelBills = (Map)allNotRelEntries.getValue();
                DataSet balDataSet = BalQuery.getBalUpdatedInfo4SerialNo((String)balanceTable, (String)formid, notRelBills.keySet(), balCols).filter("baseqty > 0");
                Throwable throwable = null;
                try {
                    for (Row row : balDataSet) {
                        Long billid = row.getLong("billid");
                        Long entryid = row.getLong("entryid");
                        Set notRelEntires = notRelBills.getOrDefault(billid, Collections.emptySet());
                        if (!notRelEntires.contains(entryid)) continue;
                        Long invaccid = row.getLong("id");
                        Object[] updateParam = new Object[]{invaccid, formid, billid, entryid};
                        updateParams.add(updateParam);
                        if (updateParams.size() != 1000) continue;
                        SnInvaccRelRestoreServiceImpl.executeBatchSql(updateParams, updateSql);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (balDataSet == null) continue;
                    if (throwable != null) {
                        try {
                            balDataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    balDataSet.close();
                }
            }
            if (updateParams.size() > 0) {
                SnInvaccRelRestoreServiceImpl.executeBatchSql(updateParams, updateSql);
            }
        }
        result.setSuccess(true);
        return result;
    }

    private static void executeBatchSql(List<Object[]> params, String sql) {
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, params);
        params.clear();
    }
}

