/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.opplugin.balanceinv;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.sbs.validator.balanceinv.InvSupplyPolicySaveValidator;

public class InvSupplyPolicySaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("invtypeentry");
        e.getFieldKeys().add("isinvtypecal");
        e.getFieldKeys().add("invstatusentry");
        e.getFieldKeys().add("isstatuscal");
        e.getFieldKeys().add("invstatuspriority");
        e.getFieldKeys().add("priority");
        e.getFieldKeys().add("supplypriority");
        e.getFieldKeys().add("warehousesetup");
        e.getFieldKeys().add("warehouseentry");
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("location");
        e.getFieldKeys().add("isalllocation");
        e.getFieldKeys().add("warehouseinvorg");
        e.getFieldKeys().add("seq");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new InvSupplyPolicySaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            this.sortByPriority(dataEntity);
            this.handleRepeatLocation(dataEntity);
            this.handleCaLField(dataEntity);
        }
    }

    private void handleRepeatLocation(DynamicObject dataEntity) {
        boolean allLocation;
        DynamicObjectCollection whEntity = dataEntity.getDynamicObjectCollection("warehouseentry");
        HashMap<String, Integer> remainMap = new HashMap<String, Integer>(whEntity.size());
        for (DynamicObject entry : whEntity) {
            allLocation = entry.getBoolean("isalllocation");
            if (!allLocation) continue;
            DynamicObject invOrg = entry.getDynamicObject("warehouseinvorg");
            DynamicObject warehouse = entry.getDynamicObject("warehouse");
            String key = invOrg.getPkValue().toString() + warehouse.getPkValue().toString();
            if (remainMap.containsKey(key)) continue;
            remainMap.put(key, entry.getInt("seq"));
        }
        Iterator iterator = whEntity.iterator();
        while (iterator.hasNext()) {
            DynamicObject entry;
            entry = (DynamicObject)iterator.next();
            allLocation = entry.getBoolean("isalllocation");
            DynamicObject location = entry.getDynamicObject("location");
            if (!allLocation && location == null) continue;
            DynamicObject invOrg = entry.getDynamicObject("warehouseinvorg");
            DynamicObject warehouse = entry.getDynamicObject("warehouse");
            String key = String.valueOf(invOrg.getPkValue()) + warehouse.getPkValue();
            if (!remainMap.containsKey(key) || entry.get("seq").equals(remainMap.get(key))) continue;
            iterator.remove();
        }
        String whSetBtn = dataEntity.getString("warehousesetup");
        if (!"2".equals(whSetBtn)) {
            return;
        }
        if (!whEntity.isEmpty()) {
            whEntity.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    int priority1 = o1.getInt("supplypriority");
                    int priority2 = o2.getInt("supplypriority");
                    return priority1 - priority2;
                }
            });
        }
        for (int i = 0; i < whEntity.size(); ++i) {
            DynamicObject entryDy = (DynamicObject)whEntity.get(i);
            entryDy.set("seq", (Object)(i + 1));
        }
    }

    private void sortByPriority(DynamicObject dataEntity) {
        DynamicObjectCollection orgEntity = dataEntity.getDynamicObjectCollection("orgentity");
        if (!orgEntity.isEmpty()) {
            orgEntity.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    int priority1 = o1.getInt("priority");
                    int priority2 = o2.getInt("priority");
                    return priority1 - priority2;
                }
            });
        }
    }

    private void handleCaLField(DynamicObject dataEntity) {
        DynamicObjectCollection invTypeEntry;
        DynamicObjectCollection invStatusEntity = dataEntity.getDynamicObjectCollection("invstatusentry");
        if (!invStatusEntity.isEmpty()) {
            for (DynamicObject invStatus : invStatusEntity) {
                invStatus.set("isstatuscal", (Object)"1");
            }
        }
        if (!(invTypeEntry = dataEntity.getDynamicObjectCollection("invtypeentry")).isEmpty()) {
            for (DynamicObject invType : invTypeEntry) {
                invType.set("isinvtypecal", (Object)"1");
            }
        }
    }
}

