/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.opplugin.sn;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.sbs.lang.SNLang;

public class BillSNRelationSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            HashSet<String> snnumbers = new HashSet<String>();
            StringBuilder stringBuilder = new StringBuilder();
            DynamicObject billSnRelation = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entryentity = billSnRelation.getDynamicObjectCollection("entryentity");
            int size = entryentity.size();
            int qty = billSnRelation.getInt("qty");
            if (size != 0 && size > qty) {
                stringBuilder.append(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u6570\u91cf[{0}]\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7269\u6599\u6570\u91cf[{1}]\u3002", (String)"SBS-W-027536", (String)"scmc-sbs-form", (Object[])new Object[]{size, qty})).append("\n");
            }
            for (DynamicObject entry : entryentity) {
                String snnumber = entry.getString("snnumber");
                if (snnumbers.contains(snnumber)) {
                    stringBuilder.append(SNLang.theSNLineIsRepeat(entry.getInt("seq"), snnumber)).append("\n");
                    continue;
                }
                snnumbers.add(snnumber);
            }
            String erroMessage = stringBuilder.toString();
            if (erroMessage == null || "".equals(erroMessage.trim())) continue;
            this.addErrorMessage(extendedDataEntity, erroMessage);
        }
    }
}

