/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.validator.balanceinv;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;

public class InvSupplyPolicySaveValidator
extends AbstractValidator {
    private static final String SIGN1 = "1";
    private static final String SIGN2 = "2";

    public void validate() {
        Map<Object, Set<Object>> invOrgToWhMapping = this.cacheWarehouseSetup();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.checkInvOrgEntry(dataEntity);
            this.checkWarehouseSetup(dataEntity, invOrgToWhMapping);
            this.checkInvStatusEntry(dataEntity);
            this.checkInvTypeEntry(dataEntity);
        }
    }

    private Map<Object, Set<Object>> cacheWarehouseSetup() {
        HashSet<Object> whInvOrgs = new HashSet<Object>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObjectCollection warehouseEntry = entity.getDynamicObjectCollection("warehouseentry");
            for (int i = 0; i < warehouseEntry.size(); ++i) {
                DynamicObject entry = (DynamicObject)warehouseEntry.get(i);
                DynamicObject whOrg = entry.getDynamicObject("warehouseinvorg");
                if (whOrg == null) continue;
                whInvOrgs.add(whOrg.getPkValue());
            }
        }
        QFilter qFilter = new QFilter("org", "in", whInvOrgs).and("startstatus", "=", (Object)"B");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_invstart", (String)"org.id,warehouse.id", (QFilter[])qFilter.toArray(), null);
        HashMap<Object, Set<Object>> invOrgToWhMapping = new HashMap<Object, Set<Object>>(16);
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            Object orgId = next.get("org.id");
            Object whId = next.get("warehouse.id");
            Set whSet = invOrgToWhMapping.computeIfAbsent(orgId, key -> new HashSet());
            whSet.add(whId);
        }
        return invOrgToWhMapping;
    }

    private void checkInvTypeEntry(ExtendedDataEntity dataEntity) {
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObjectCollection invTypeEntry = entity.getDynamicObjectCollection("invtypeentry");
        HashSet<Object> types = new HashSet<Object>(invTypeEntry.size());
        for (int i = 0; i < invTypeEntry.size(); ++i) {
            DynamicObject entry = (DynamicObject)invTypeEntry.get(i);
            DynamicObject invType = entry.getDynamicObject("invtype");
            if (invType == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7c7b\u578b\u8bbe\u7f6e\u5206\u5f55\u7b2c%s\u884c\u5e93\u5b58\u7c7b\u578b\u4e3a\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvSupplyPolicySaveValidator_11", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1));
                continue;
            }
            if (types.add(invType.getPkValue())) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7c7b\u578b\u8bbe\u7f6e\u5206\u5f55\u7b2c%s\u884c\u5e93\u5b58\u7c7b\u578b\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvSupplyPolicySaveValidator_10", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1));
        }
        if (CollectionUtils.isEmpty((Collection)invTypeEntry)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5e93\u5b58\u7c7b\u578b\u8bbe\u7f6e\u5fc5\u987b\u6709\u4e00\u884c\u3002", (String)"InvSupplyPolicySaveValidator_0", (String)"scmc-sbs-form", (Object[])new Object[0]));
        }
    }

    private void checkInvOrgEntry(ExtendedDataEntity dataEntity) {
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObjectCollection orgEntry = entity.getDynamicObjectCollection("orgentity");
        HashSet<Object> priorities = new HashSet<Object>(orgEntry.size());
        HashSet<Object> orgSet = new HashSet<Object>(orgEntry.size());
        for (int i = 0; i < orgEntry.size(); ++i) {
            Object priority;
            DynamicObject entry = (DynamicObject)orgEntry.get(i);
            if (entry == null) continue;
            if (entry.get("invorg") == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8bbe\u7f6e\u7b2c%s\u884c\u201c\u5e93\u5b58\u7ec4\u7ec7\u201d\u4e3a\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvSupplyPolicySaveValidator_8", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1));
                continue;
            }
            if (entry.get("priority") == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8bbe\u7f6e\u7b2c%s\u884c\u201c\u4f9b\u8d27\u4f18\u5148\u7ea7\u201d\u4e3a\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvSupplyPolicySaveValidator_7", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1));
                continue;
            }
            Object pkValue = ((DynamicObject)entry.get("invorg")).getPkValue();
            if (!orgSet.add(pkValue)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8bbe\u7f6e\u7b2c%s\u884c\u201c\u5e93\u5b58\u7ec4\u7ec7\u201d\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvSupplyPolicySaveValidator_30", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1));
            }
            if (priorities.add(priority = entry.get("priority"))) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8bbe\u7f6e\u5206\u5f55\u7b2c%s\u884c\u201c\u4f9b\u8d27\u4f18\u5148\u7ea7\u201d\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvSupplyPolicySaveValidator_6", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1));
        }
    }

    private void checkInvStatusEntry(ExtendedDataEntity dataEntity) {
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObjectCollection invStatusEntry = entity.getDynamicObjectCollection("invstatusentry");
        HashSet<Object> statuses = new HashSet<Object>(invStatusEntry.size());
        HashSet<Object> invStatusPriority = new HashSet<Object>(invStatusEntry.size());
        for (int i = 0; i < invStatusEntry.size(); ++i) {
            Object priority;
            DynamicObject entry = (DynamicObject)invStatusEntry.get(i);
            DynamicObject invStatus = entry.getDynamicObject("invstatus");
            if (invStatus == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u72b6\u6001\u8bbe\u7f6e\u7b2c%s\u884c\u5e93\u5b58\u72b6\u6001\u4e3a\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvSupplyPolicySaveValidator_26", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1));
                continue;
            }
            if (!statuses.add(invStatus.getPkValue())) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u72b6\u6001\u8bbe\u7f6e\u5206\u5f55\u7b2c%s\u884c\u201c\u5e93\u5b58\u72b6\u6001\u201d\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvSupplyPolicySaveValidator_5", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1));
            }
            if ((priority = entry.get("invstatuspriority")) != null && !invStatusPriority.add(priority)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u72b6\u6001\u8bbe\u7f6e\u5206\u5f55\u7b2c%s\u884c\u201c\u4f9b\u8d27\u4f18\u5148\u7ea7\u201d\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvSupplyPolicySaveValidator_27", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1));
            }
            if (entry.get("invstatuspriority") != null) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u72b6\u6001\u8bbe\u7f6e\u7b2c%s\u884c\u4f9b\u8d27\u4f18\u5148\u7ea7\u4e3a\u5fc5\u586b\u3002", (String)"InvSupplyPolicySaveValidator_18", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1));
        }
        if (CollectionUtils.isEmpty((Collection)invStatusEntry)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5e93\u5b58\u72b6\u6001\u8bbe\u7f6e\u5fc5\u987b\u6709\u4e00\u884c\u3002", (String)"InvSupplyPolicySaveValidator_1", (String)"scmc-sbs-form", (Object[])new Object[0]));
        }
    }

    private void checkWarehouseSetup(ExtendedDataEntity dataEntity, Map<Object, Set<Object>> invOrgToWhMapping) {
        DynamicObject entity = dataEntity.getDataEntity();
        String whSetupGroup = entity.getString("warehousesetup");
        DynamicObjectCollection warehouseEntry = entity.getDynamicObjectCollection("warehouseentry");
        this.checkWhSetupGroup(dataEntity, whSetupGroup, warehouseEntry);
        if (warehouseEntry == null) {
            return;
        }
        this.checkOrgAndWhRelation(dataEntity, warehouseEntry, entity);
        this.checkWhAndLocation(dataEntity, warehouseEntry, invOrgToWhMapping);
    }

    private void checkWhAndLocation(ExtendedDataEntity dataEntity, DynamicObjectCollection warehouseEntry, Map<Object, Set<Object>> invOrgToWhMapping) {
        HashSet<String> whValidateKeySet = new HashSet<String>();
        HashSet<String> locationValidateKeySet = new HashSet<String>();
        for (int i = 0; i < warehouseEntry.size(); ++i) {
            DynamicObject warehouse;
            DynamicObject entry = (DynamicObject)warehouseEntry.get(i);
            DynamicObject whOrg = entry.getDynamicObject("warehouseinvorg");
            if (whOrg == null || (warehouse = entry.getDynamicObject("warehouse")) == null) continue;
            Set<Object> whIds = invOrgToWhMapping.get(whOrg.getPkValue());
            if (whIds.isEmpty() || !whIds.contains(warehouse.getPkValue())) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u7b2c%1$s\u884c\uff0c\u4ed3\u5e93\u201c%2$s\u201d\u4e0d\u662f\u5e93\u5b58\u7ec4\u7ec7\u201c%3$s\u201d\u4e0b\u542f\u7528\u5e93\u5b58\u7684\u4ed3\u5e93\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvSupplyPolicySaveValidator_28", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1, warehouse.getLocaleString("name").getLocaleValue(), whOrg.getLocaleString("name").getLocaleValue()));
                continue;
            }
            DynamicObject location = entry.getDynamicObject("location");
            boolean allLocation = entry.getBoolean("isalllocation");
            boolean open = warehouse.getBoolean("isopenlocation");
            if (!open && allLocation) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u7b2c%1$s\u884c\uff0c\u4ed3\u5e93\u201c%2$s\u201d\u672a\u542f\u7528\u4ed3\u4f4d\u7ba1\u7406\uff0c\u4e0d\u80fd\u5f00\u542f\u5168\u90e8\u4ed3\u4f4d\u3002", (String)"InvSupplyPolicySaveValidator_20", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1, warehouse.getLocaleString("name").getLocaleValue()));
                continue;
            }
            if (!open && location != null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u7b2c%1$s\u884c\uff0c\u4ed3\u5e93\u201c%2$s\u201d\u672a\u542f\u7528\u4ed3\u4f4d\u7ba1\u7406\uff0c\u4e0d\u80fd\u7ef4\u62a4\u4ed3\u4f4d\u3002", (String)"InvSupplyPolicySaveValidator_21", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1, warehouse.getLocaleString("name").getLocaleValue()));
                continue;
            }
            if (allLocation && location != null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u7b2c%1$s\u884c\uff0c\u5f00\u542f\u5168\u90e8\u4ed3\u4f4d\u65f6\uff0c\u4e0d\u80fd\u7ef4\u62a4\u4ed3\u4f4d\u3002", (String)"InvSupplyPolicySaveValidator_19", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1, warehouse.getLocaleString("name").getLocaleValue()));
                continue;
            }
            if (open && !allLocation && location == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ed3\u5e93\u8bbe\u7f6e\u201d\u7b2c%s\u884c\u7684\u4ed3\u4f4d\u3002", (String)"InvSupplyPolicySaveValidator_4", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1));
                continue;
            }
            String whValidateKey = whOrg.getPkValue().toString() + warehouse.getPkValue().toString();
            if (!open && !whValidateKeySet.add(whValidateKey)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u7b2c%1$s\u884c\uff0c\u5e93\u5b58\u7ec4\u7ec7+\u4ed3\u5e93\u7ec4\u5408\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvSupplyPolicySaveValidator_22", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1, warehouse.getLocaleString("name").getLocaleValue()));
                continue;
            }
            if (location == null) continue;
            String locationValidateKey = whOrg.getPkValue().toString() + warehouse.getPkValue().toString() + location.getPkValue().toString();
            if (!locationValidateKeySet.add(locationValidateKey)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u7b2c%1$s\u884c\uff0c\u5e93\u5b58\u7ec4\u7ec7+\u4ed3\u5e93+\u4ed3\u4f4d\u7ec4\u5408\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvSupplyPolicySaveValidator_23", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1));
                continue;
            }
            DynamicObjectCollection whLocationEntry = warehouse.getDynamicObjectCollection("entryentity");
            if (whLocationEntry == null || whLocationEntry.isEmpty()) continue;
            boolean flag = false;
            for (DynamicObject locationEntry : whLocationEntry) {
                DynamicObject whLocation = locationEntry.getDynamicObject("location");
                if (whLocation == null || !whLocation.getPkValue().equals(location.getPkValue())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u7b2c%1$s\u884c\uff0c\u4ed3\u4f4d\u201c%2$s\u201d\u4e0d\u662f\u4ed3\u5e93\u201c%3$s\u201d\u5173\u8054\u7684\u4ed3\u4f4d,\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvSupplyPolicySaveValidator_16", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1, location.getLocaleString("name").getLocaleValue(), warehouse.getLocaleString("name").getLocaleValue()));
        }
    }

    private void checkOrgAndWhRelation(ExtendedDataEntity dataEntity, DynamicObjectCollection warehouseEntry, DynamicObject entity) {
        DynamicObjectCollection orgEntry = entity.getDynamicObjectCollection("orgentity");
        HashSet<Object> invOrgs = new HashSet<Object>(orgEntry.size());
        for (DynamicObject row : orgEntry) {
            DynamicObject invOrg = row.getDynamicObject("invorg");
            if (invOrg == null) continue;
            invOrgs.add(invOrg.getPkValue());
        }
        for (int i = 0; i < warehouseEntry.size(); ++i) {
            DynamicObject entry = (DynamicObject)warehouseEntry.get(i);
            DynamicObject whOrg = entry.getDynamicObject("warehouseinvorg");
            if (whOrg == null || invOrgs.contains(whOrg.getPkValue())) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u7b2c%s\u884c\u201c\u5e93\u5b58\u7ec4\u7ec7\u201d\u5fc5\u987b\u4e3a\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u5e93\u5b58\u7ec4\u7ec7\u8303\u56f4\u5185\u7684\u503c\u3002", (String)"InvSupplyPolicySaveValidator_14", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1));
        }
    }

    private void checkWhSetupGroup(ExtendedDataEntity dataEntity, String whSetupGroup, DynamicObjectCollection warehouseEntry) {
        if (SIGN1.equals(whSetupGroup)) {
            if (warehouseEntry != null && warehouseEntry.size() > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u4e3a\u5168\u90e8\u4ed3\u5e93\u65f6\uff0c\u5206\u5f55\u4e0d\u5141\u8bb8\u6709\u503c\u3002", (String)"InvSupplyPolicySaveValidator_12", (String)"scmc-sbs-form", (Object[])new Object[0]));
            }
            return;
        }
        if (warehouseEntry == null || warehouseEntry.isEmpty()) {
            if (SIGN2.equals(whSetupGroup)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u4e3a\u53c2\u4e0e\u8fd0\u7b97\u4ed3\u5e93\u65f6\uff0c\u5fc5\u987b\u6709\u4e00\u884c\u5206\u5f55\u3002", (String)"InvSupplyPolicySaveValidator_2", (String)"scmc-sbs-form", (Object[])new Object[0]));
            } else {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u4e3a\u4e0d\u53c2\u4e0e\u8fd0\u7b97\u4ed3\u5e93\u65f6\uff0c\u5fc5\u987b\u6709\u4e00\u884c\u5206\u5f55\u3002", (String)"InvSupplyPolicySaveValidator_3", (String)"scmc-sbs-form", (Object[])new Object[0]));
            }
            return;
        }
        HashSet<Object> prioritySet = new HashSet<Object>(warehouseEntry.size());
        for (int i = 0; i < warehouseEntry.size(); ++i) {
            DynamicObject entry = (DynamicObject)warehouseEntry.get(i);
            Object whInvOrg = entry.get("warehouseinvorg");
            Object wh = entry.get("warehouse");
            Object supplyPriority = entry.get("supplypriority");
            if (whInvOrg == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ed3\u5e93\u8bbe\u7f6e\u201d\u7b2c%s\u884c\uff1a\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"InvSupplyPolicySaveValidator_13", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1));
            }
            if (wh == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ed3\u5e93\u8bbe\u7f6e\u201d\u7b2c%s\u884c\u7684\u4ed3\u5e93\u3002", (String)"InvSupplyPolicySaveValidator_24", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1));
            }
            if (supplyPriority == null && SIGN2.equals(whSetupGroup)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ed3\u5e93\u8bbe\u7f6e\u201d\u7b2c%s\u884c\u7684\u4f9b\u8d27\u4f18\u5148\u7ea7\u3002", (String)"InvSupplyPolicySaveValidator_25", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1));
            }
            if (supplyPriority == null || prioritySet.add(supplyPriority)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u4ed3\u5e93\u8bbe\u7f6e\u201d\u7b2c%s\u884c\uff1a\u4f9b\u8d27\u4f18\u5148\u7ea7\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvSupplyPolicySaveValidator_29", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1));
        }
    }
}

