/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.validator.balanceinv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class SupplyRelationSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        StringBuilder errorSeqSb = new StringBuilder();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject supplyRelation = dataEntity.getDataEntity();
            DynamicObjectCollection entries = supplyRelation.getDynamicObjectCollection("entryentity");
            HashMap<Integer, List> matchOrderSeqMap = new HashMap<Integer, List>();
            HashMap<Long, List> supplyOrgSeqMap = new HashMap<Long, List>();
            String dot = ResManager.loadKDString((String)"\u3001", (String)"SupplyRelationSaveValidator_0", (String)"scmc-sbs-form", (Object[])new Object[0]);
            for (DynamicObject entry : entries) {
                DynamicObject supplyOrg = entry.getDynamicObject("supplyorgunit");
                if (entry.get("supplyorder") != null) {
                    matchOrderSeqMap.putIfAbsent(entry.getInt("supplyorder"), new ArrayList());
                    ((List)matchOrderSeqMap.get(entry.getInt("supplyorder"))).add(entry.getString("seq"));
                }
                if (supplyOrg == null) continue;
                supplyOrgSeqMap.putIfAbsent(supplyOrg.getLong("id"), new ArrayList());
                ((List)supplyOrgSeqMap.get(supplyOrg.getLong("id"))).add(entry.getString("seq"));
            }
            matchOrderSeqMap.forEach((order, seqList) -> {
                if (seqList.size() > 1) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u4f9b\u5e94\u4f18\u5148\u7ea7\u4e0d\u80fd\u76f8\u540c\u3002", (String)"SupplyRelationSaveValidator_2", (String)"scmc-sbs-form", (Object[])new Object[0]), String.join((CharSequence)dot, seqList)));
                }
            });
            supplyOrgSeqMap.forEach((orgId, seqList) -> {
                if (seqList.size() > 1) {
                    for (String seq : seqList) {
                        if (errorSeqSb.length() > 0) {
                            errorSeqSb.append(dot);
                        }
                        errorSeqSb.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c", (String)"SupplyRelationSaveValidator_3", (String)"scmc-sbs-form", (Object[])new Object[0]), seq));
                    }
                    errorSeqSb.append(ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u76f8\u540c,\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"SupplyRelationSaveValidator_4", (String)"scmc-sbs-form", (Object[])new Object[0]));
                    this.addErrorMessage(dataEntity, errorSeqSb.toString());
                    errorSeqSb.setLength(0);
                }
            });
        }
    }
}

