/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.marketpulse.business.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.sdk.util.KHttpClientUtils;
import kd.scmc.scmdi.marketpulse.business.ApiClientParams;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyAbnormalInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyBusinessInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyChattelInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyHistoryNameInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyIllegalInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyPledgeInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyPunishInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanySimpleCancelInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.item.CompanyAbnormalItem;
import kd.scmc.scmdi.marketpulse.common.vo.info.item.CompanyBusinessInfoItem;
import kd.scmc.scmdi.marketpulse.common.vo.info.item.CompanyChattelInfoItem;
import kd.scmc.scmdi.marketpulse.common.vo.info.item.CompanyHistoryNameInfoItem;
import kd.scmc.scmdi.marketpulse.common.vo.info.item.CompanyIllegalInfoItem;
import kd.scmc.scmdi.marketpulse.common.vo.info.item.CompanyPledgeInfoItem;
import kd.scmc.scmdi.marketpulse.common.vo.info.item.CompanyPunishInfoItem;
import kd.scmc.scmdi.marketpulse.common.vo.info.item.CompanySimpleCancelInfoItem;
import org.apache.commons.lang3.StringUtils;

public class BusinessInfoServiceHelper {
    private static final Log logger = LogFactory.getLog(BusinessInfoServiceHelper.class);
    public static final String ERRCODE = "errcode";
    public static final String STATUS = "status";
    public static final String SUCCESS = "success";
    public static final String DATA = "data";
    public static final String OK = "ok";
    static String DAMIAN_URL = "https://bj2-api.kingdee.com";

    public static CompanyBusinessInfo getBusinessInfoByName(ApiClientParams apiClientParams, String companyName) {
        String url = DAMIAN_URL + "/kddi/company/getCompanyByName?client_id=" + apiClientParams.getClientId() + "&client_secret=" + apiClientParams.getClientSecret();
        Map<String, Object> body = BusinessInfoServiceHelper.getBody(apiClientParams);
        body.put("company_name", companyName);
        JSONArray data = BusinessInfoServiceHelper.getDataByUrl(body, url);
        List companyBusinessInfoItems = JSON.parseArray((String)data.toJSONString(), CompanyBusinessInfoItem.class);
        CompanyBusinessInfo companyBusinessInfo = new CompanyBusinessInfo();
        companyBusinessInfo.setBaseData(companyBusinessInfoItems);
        return companyBusinessInfo;
    }

    private static Map<String, Object> getBody(ApiClientParams apiClientParams) {
        HashMap<String, Object> body = new HashMap<String, Object>(4);
        body.put("client_company_id", apiClientParams.getClientCompanyId());
        body.put("client_company_name", apiClientParams.getClientCompanyName());
        return body;
    }

    public static CompanyHistoryNameInfo getCompanyHistoryName(ApiClientParams apiClientParams, String companyId) {
        String url = BusinessInfoServiceHelper.getUrl(apiClientParams, "/company/getCompanyHistoryName");
        Map<String, Object> body = BusinessInfoServiceHelper.getBody(apiClientParams);
        body.put("company_id", companyId);
        JSONArray data = BusinessInfoServiceHelper.getDataByUrl(body, url);
        CompanyHistoryNameInfo companyHistoryNameInfo = new CompanyHistoryNameInfo();
        List companyHistoryNameInfoItems = JSON.parseArray((String)data.toJSONString(), CompanyHistoryNameInfoItem.class);
        companyHistoryNameInfo.setBaseData(companyHistoryNameInfoItems);
        return companyHistoryNameInfo;
    }

    public static String getUrl(ApiClientParams apiClientParams, String uri) {
        return DAMIAN_URL + "/kddi" + uri + "?client_id=" + apiClientParams.getClientId() + "&client_secret=" + apiClientParams.getClientSecret();
    }

    public static CompanyAbnormalInfo getCompanyAbnormal(ApiClientParams apiClientParams, String companyId) {
        JSONArray data = BusinessInfoServiceHelper.getRiskResult(companyId, apiClientParams, "/company/getCompanyAbnormal");
        List companyAllowInfos = JSON.parseArray((String)data.toJSONString(), CompanyAbnormalItem.class);
        CompanyAbnormalInfo companyAbnormalInfo = new CompanyAbnormalInfo();
        companyAbnormalInfo.setBaseData(companyAllowInfos);
        return companyAbnormalInfo;
    }

    public static CompanyChattelInfo getCompanyChattel(ApiClientParams apiClientParams, String companyId) {
        JSONArray data = BusinessInfoServiceHelper.getRiskResult(companyId, apiClientParams, "/company/getCompanyChattel");
        CompanyChattelInfo companyChattelInfo = new CompanyChattelInfo();
        List companyChattelInfoItems = JSON.parseArray((String)data.toJSONString(), CompanyChattelInfoItem.class);
        companyChattelInfo.setBaseData(companyChattelInfoItems);
        return companyChattelInfo;
    }

    private static Map<String, Object> getBodyWithCompanyId(String companyId, ApiClientParams apiClientParams) {
        Map<String, Object> body = BusinessInfoServiceHelper.getBody(apiClientParams);
        body.put("company_id", companyId);
        return body;
    }

    public static CompanyIllegalInfo getCompanyIllegal(ApiClientParams apiClientParams, String companyId) {
        JSONArray data = BusinessInfoServiceHelper.getRiskResult(companyId, apiClientParams, "/company/getCompanyIllegal");
        CompanyIllegalInfo companyIllegalInfo = new CompanyIllegalInfo();
        List companyIllegalInfoItems = JSON.parseArray((String)data.toJSONString(), CompanyIllegalInfoItem.class);
        companyIllegalInfo.setBaseData(companyIllegalInfoItems);
        return companyIllegalInfo;
    }

    public static CompanyPledgeInfo getCompanyPledge(ApiClientParams apiClientParams, String companyId) {
        JSONArray data = BusinessInfoServiceHelper.getRiskResult(companyId, apiClientParams, "/company/getCompanyPledge");
        CompanyPledgeInfo companyPledgeInfo = new CompanyPledgeInfo();
        List companyPledgeInfoItems = JSON.parseArray((String)data.toJSONString(), CompanyPledgeInfoItem.class);
        companyPledgeInfo.setBaseData(companyPledgeInfoItems);
        return companyPledgeInfo;
    }

    public static CompanyPunishInfo getCompanyPunish(ApiClientParams apiClientParams, String companyId) {
        JSONArray data = BusinessInfoServiceHelper.getRiskResult(companyId, apiClientParams, "/company/getCompanyPunish");
        CompanyPunishInfo companyPunishInfo = new CompanyPunishInfo();
        List companyPunishInfoItems = JSON.parseArray((String)data.toJSONString(), CompanyPunishInfoItem.class);
        companyPunishInfo.setBaseData(companyPunishInfoItems);
        return companyPunishInfo;
    }

    public static CompanySimpleCancelInfo getCompanySimpleCancel(ApiClientParams apiClientParams, String companyId) {
        JSONArray data = BusinessInfoServiceHelper.getRiskResult(companyId, apiClientParams, "/company/getCompanySimpleCancel");
        CompanySimpleCancelInfo companySimpleCancelInfo = new CompanySimpleCancelInfo();
        List companySimpleCancelInfoItems = JSON.parseArray((String)data.toJSONString(), CompanySimpleCancelInfoItem.class);
        companySimpleCancelInfo.setBaseData(companySimpleCancelInfoItems);
        return companySimpleCancelInfo;
    }

    private static JSONArray getRiskResult(String companyId, ApiClientParams apiClientParams, String uri) {
        Map<String, Object> body = BusinessInfoServiceHelper.getBodyWithCompanyId(companyId, apiClientParams);
        String url = BusinessInfoServiceHelper.getUrl(apiClientParams, uri);
        return BusinessInfoServiceHelper.getDataByUrl(body, url);
    }

    private static JSONArray getDataByUrl(Map<String, Object> body, String url) {
        JSONObject result;
        Map<String, String> header = BusinessInfoServiceHelper.getHeader();
        try {
            String resultStr = KHttpClientUtils.postAppJson((String)url, header, body);
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                logger.info("\u8c03\u7528\u63a5\u53e3\u5730\u5740\uff1a" + url.split("\\?")[0], (Object)("\u8c03\u7528\u63a5\u53e3\u53c2\u6570:" + body.toString()));
                return new JSONArray();
            }
            result = JSONObject.parseObject((String)resultStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (OK.equals(result.get((Object)STATUS)) || SUCCESS.equals(result.get((Object)STATUS))) {
            return result.getJSONArray(DATA) == null ? new JSONArray() : result.getJSONArray(DATA);
        }
        if (result.get((Object)ERRCODE) != null) {
            logger.info(result.toString());
            throw new RuntimeException(result.getString("description_cn"));
        }
        return new JSONArray();
    }

    private static Map<String, String> getHeader() {
        HashMap<String, String> header = new HashMap<String, String>(4);
        header.put("Connection", "keep-alive");
        header.put("Content-Type", "application/json");
        return header;
    }
}

