/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.marketpulse.business.helper;

import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.IDataEntityBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.servicehelper.MetadataServiceHelper;

public class EntityCacheHelper {
    public static final String ENTITY_CACHE = "entity_cache";

    public static void savePcEntityToPageCache(IFormView pageView, DynamicObject pcEntity) {
        String cacheString = pcEntity == null ? null : EntityCacheHelper.serializeFromEntityToString(pcEntity);
        pageView.getPageCache().putBigObject(ENTITY_CACHE, cacheString);
    }

    public static String serializeFromEntityToString(DynamicObject dynamicObject) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(false);
        option.setIncludeCollectionProperty(true);
        option.setIncludeDataEntityState(true);
        option.setIncludeType(true);
        option.setDataEntityBinder(new IDataEntityBinder(){

            public boolean isSerializProperty(IDataEntityProperty prop, DataEntitySerializerOption option) {
                if (prop instanceof DynamicLocaleProperty) {
                    return true;
                }
                return prop instanceof MulBasedataProp || super.isSerializProperty(prop, option);
            }
        });
        return DataEntitySerializer.serializerToString((Object)dynamicObject, (DataEntitySerializerOption)option);
    }

    public static DynamicObject getPcEntityFromCache(IFormView view, String pcEntityKey) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)pcEntityKey);
        return EntityCacheHelper.getPcEntityFromCache(view, dataEntityType);
    }

    private static DynamicObject getPcEntityFromCache(IFormView view, MainEntityType dataEntityType) {
        IPageCache mainPageCache = view.getPageCache();
        return EntityCacheHelper.getPcEntityFromCache(mainPageCache, dataEntityType);
    }

    private static DynamicObject getPcEntityFromCache(IPageCache cache, MainEntityType dataEntityType) {
        String pcEntityCacheStr = cache.getBigObject(ENTITY_CACHE);
        if (StringUtils.isEmpty((CharSequence)pcEntityCacheStr)) {
            return null;
        }
        DynamicObject dynamicObject = EntityCacheHelper.deserializeFromStringToEntity(pcEntityCacheStr, (IDataEntityType)dataEntityType);
        return dynamicObject;
    }

    public static DynamicObject deserializeFromStringToEntity(String string, IDataEntityType dataEntityType) {
        DynamicObject dyn = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)string, (IDataEntityType)dataEntityType);
        BusinessDataReader.loadRefence((Object[])new DynamicObject[]{dyn}, (IDataEntityType)dataEntityType);
        return dyn;
    }
}

